/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LocationObject;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;

public class DefaultNodeComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof DefaultMutableTreeNode && o2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)o1;
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)o2;
            if (this.isLocationNode(node1.getUserObject()) && this.isLocationNode(node2.getUserObject())) {
                return -1;
            }
            if (this.isLocationNode(node1.getUserObject()) && !this.isLocationNode(node2.getUserObject())) {
                return -1;
            }
            if (!this.isLocationNode(node1.getUserObject()) && this.isLocationNode(node2.getUserObject())) {
                return 1;
            }
            if (node1.getUserObject() != null && node2.getUserObject() != null) {
                if (this.isTempGroup(node1.getUserObject()) || this.isDefaultGroup(node1.getUserObject())) {
                    return -1;
                }
                if (this.isTempGroup(node2.getUserObject()) || this.isDefaultGroup(node2.getUserObject())) {
                    return 1;
                }
                return this.stringCompare(node1.getUserObject().toString(), node2.getUserObject().toString(), false);
            }
        }
        return this.stringCompare(o1.toString(), o2.toString(), true);
    }

    private int stringCompare(String source, String target, boolean isCaseSensitive) {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        if ("en".equalsIgnoreCase(language)) {
            if (isCaseSensitive) {
                return source.compareTo(target);
            }
            return source.compareToIgnoreCase(target);
        }
        Collator collator = Collator.getInstance();
        if (isCaseSensitive) {
            collator.setStrength(2);
        } else {
            collator.setStrength(1);
        }
        return collator.compare(source, target);
    }

    private boolean isTempGroup(Object userObject) {
        if (userObject == null || !(userObject instanceof GroupObject)) {
            return false;
        }
        return ((GroupObject)userObject).isTemp();
    }

    private boolean isDefaultGroup(Object userObject) {
        if (userObject == null || !(userObject instanceof GroupObject)) {
            return false;
        }
        return ((GroupObject)userObject).isDefaultGroup();
    }

    private boolean isLocationNode(Object userObject) {
        return userObject != null && userObject instanceof LocationObject;
    }
}

