/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.util.DateTimeManager;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateTextField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField monthField = new JTextField();
    private JTextField dayField = new JTextField();
    private JTextField yearField = new JTextField();
    private JTextField hourField = new JTextField();
    private JTextField minuteField = new JTextField();
    private JTextField secondField = new JTextField();
    private JLabel dot1 = new JLabel("/");
    private JLabel dot2 = new JLabel("/");
    private JLabel dot3 = new JLabel(":");
    private JLabel dot4 = new JLabel(":");
    private JTextField[] order = new JTextField[3];
    private boolean bFlagDspHMS = true;
    private HashMap<String, JTextField> map = new HashMap();

    public DateTextField() {
        this(true);
    }

    public DateTextField(boolean bLimitedYears) {
        this.map.put("dd", this.dayField);
        this.map.put("MM", this.monthField);
        this.map.put("yyyy", this.yearField);
        this.monthField.setDocument(new NumberPlainDocument(12L));
        this.dayField.setDocument(new NumberPlainDocument(31L));
        this.yearField.setDocument(new NumberPlainDocument(bLimitedYears ? 2020L : 9999L));
        this.hourField.setDocument(new NumberPlainDocument(23L));
        this.minuteField.setDocument(new NumberPlainDocument(59L));
        this.secondField.setDocument(new NumberPlainDocument(59L));
        this.monthField.setHorizontalAlignment(4);
        this.dayField.setHorizontalAlignment(4);
        this.yearField.setHorizontalAlignment(4);
        this.hourField.setHorizontalAlignment(4);
        this.minuteField.setHorizontalAlignment(4);
        this.secondField.setHorizontalAlignment(4);
        this.setLayout(null);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.dayField);
        this.add(this.dot1);
        this.add(this.monthField);
        this.add(this.dot2);
        this.add(this.yearField);
        this.add(this.hourField);
        this.add(this.dot3);
        this.add(this.minuteField);
        this.add(this.dot4);
        this.add(this.secondField);
        String dateFormat = DateTimeManager.getDateFormat();
        String[] elements = dateFormat.split("/");
        this.order[0] = this.map.get(elements[0]);
        this.order[1] = this.map.get(elements[1]);
        this.order[2] = this.map.get(elements[2]);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.dayField.setToolTipText(text);
        this.monthField.setToolTipText(text);
        this.yearField.setToolTipText(text);
        this.hourField.setToolTipText(text);
        this.minuteField.setToolTipText(text);
        this.secondField.setToolTipText(text);
    }

    @Override
    public void setBounds(int a, int b, int c, int d) {
        super.setBounds(a, b, c, d);
        int w = c;
        int ss = w / 7 - 5;
        int x = 2;
        int ssy = ss;
        if (!this.bFlagDspHMS) {
            ss = w / 4 - 1;
        }
        if (this.order[0] == this.yearField) {
            this.order[0].setBounds(x, 2, ss + ssy, this.getHeight() - 4);
            x += ss + ssy;
        } else {
            this.order[0].setBounds(x, 2, ss, this.getHeight() - 4);
            x += ss;
        }
        this.dot1.setBounds(x, 2, 5, this.getHeight() - 4);
        x += 5;
        this.order[0].setBorder(null);
        if (this.order[1] == this.yearField) {
            this.order[1].setBounds(x, 2, ss + ssy, this.getHeight() - 4);
            x += ss + ssy;
        } else {
            this.order[1].setBounds(x, 2, ss, this.getHeight() - 4);
            x += ss;
        }
        this.dot2.setBounds(x, 2, 5, this.getHeight() - 4);
        x += 5;
        this.order[1].setBorder(null);
        if (this.order[2] == this.yearField) {
            this.order[2].setBounds(x, 2, ss + ssy, this.getHeight() - 4);
            x += ss + ssy;
        } else {
            this.order[2].setBounds(x, 2, ss, this.getHeight() - 4);
            x += ss;
        }
        this.order[2].setBorder(null);
        if (this.bFlagDspHMS) {
            this.hourField.setBounds(x += 5, 2, ss, this.getHeight() - 4);
            this.dot3.setBounds(x += ss, 2, 5, this.getHeight() - 4);
            this.hourField.setBorder(null);
            this.minuteField.setBounds(x += 5, 2, ss, this.getHeight() - 4);
            this.dot4.setBounds(x += ss, 2, 5, this.getHeight() - 4);
            this.minuteField.setBorder(null);
            this.secondField.setBounds(x += 5, 2, ss, this.getHeight() - 4);
            this.secondField.setBorder(null);
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public String getText() {
        this.normalize();
        String text = null;
        if (this.bFlagDspHMS) {
            text = this.order[0].getText().trim() + "/" + this.order[1].getText().trim() + "/" + this.order[2].getText().trim() + " " + this.hourField.getText().trim() + ":" + this.minuteField.getText().trim() + ":" + this.secondField.getText().trim();
        } else {
            text = this.order[0].getText().trim() + "/" + this.order[1].getText().trim() + "/" + this.order[2].getText().trim();
            if (text.equals("//")) {
                return "";
            }
        }
        return text;
    }

    public void setText(String text) {
        String token;
        if (text == null) {
            return;
        }
        if (text.length() == 0) {
            this.dayField.setText("");
            this.monthField.setText("");
            this.yearField.setText("");
            if (this.bFlagDspHMS) {
                this.hourField.setText("");
                this.minuteField.setText("");
                this.secondField.setText("");
            }
            return;
        }
        int spIndex = text.indexOf(" ");
        int index = 0;
        StringTokenizer tokens = new StringTokenizer(text.substring(0, spIndex), "/");
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            this.order[index++].setText(token);
        }
        if (this.bFlagDspHMS) {
            tokens = new StringTokenizer(text.substring(spIndex + 1), ":");
            index = 0;
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                switch (index++) {
                    case 0: {
                        this.hourField.setText(token);
                        break;
                    }
                    case 1: {
                        this.minuteField.setText(token);
                        break;
                    }
                    case 2: {
                        this.secondField.setText(token);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.dayField.setEnabled(enable);
        this.monthField.setEnabled(enable);
        this.yearField.setEnabled(enable);
        if (this.bFlagDspHMS) {
            this.hourField.setEnabled(enable);
            this.minuteField.setEnabled(enable);
            this.secondField.setEnabled(enable);
        }
        if (enable) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.setBorder(BorderFactory.createBevelBorder(1, Color.gray, Color.gray));
        }
    }

    @Override
    public void setBackground(Color newBackground) {
        super.setBackground(newBackground);
        if (this.monthField != null) {
            this.monthField.setBackground(newBackground);
        }
        if (this.dayField != null) {
            this.dayField.setBackground(newBackground);
        }
        if (this.yearField != null) {
            this.yearField.setBackground(newBackground);
        }
        if (this.hourField != null) {
            this.hourField.setBackground(newBackground);
        }
        if (this.minuteField != null) {
            this.minuteField.setBackground(newBackground);
        }
        if (this.secondField != null) {
            this.secondField.setBackground(newBackground);
        }
    }

    public boolean isValid(boolean lengthNeedGreatThanZero) {
        JTextField[] fields = new JTextField[]{this.monthField, this.dayField, this.yearField, this.hourField, this.minuteField, this.secondField};
        for (int i = 0; i < fields.length; ++i) {
            if (this.isValid(fields[i], lengthNeedGreatThanZero)) continue;
            return false;
        }
        return true;
    }

    private boolean isValid(JTextField field, boolean lengthNeedGreatThanZero) {
        if (field.getText().length() == 0) {
            return !lengthNeedGreatThanZero;
        }
        return true;
    }

    private void normalize() {
        if (this.monthField.getText().length() == 0) {
            this.monthField.setText("1");
        }
        if (this.dayField.getText().length() == 0) {
            this.dayField.setText("1");
        }
        if (this.yearField.getText().length() == 0) {
            this.yearField.setText("1");
        } else {
            String text = this.yearField.getText();
            int length = text.length();
            if (length > 4) {
                this.yearField.setText(text.substring(length - 4));
            }
        }
        if (this.hourField.getText().length() == 0) {
            this.hourField.setText("0");
        }
        if (this.minuteField.getText().length() == 0) {
            this.minuteField.setText("0");
        }
        if (this.secondField.getText().length() == 0) {
            this.secondField.setText("0");
        }
    }
}

