/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.logicobject.TableRow;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class CustomTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Vector<TableRow> rows = new Vector();
    private String[] columnNames = new String[0];
    private int[] columnMapping;
    private boolean isEditable;

    public CustomTableModel() {
    }

    public CustomTableModel(String[] columnNames, int[] columnMapping) {
        this.columnNames = columnNames == null ? null : (String[])columnNames.clone();
        this.columnMapping = columnMapping == null ? null : (int[])columnMapping.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames == null ? null : (String[])columnNames.clone();
        this.columnMapping = null;
        this.rows.clear();
        this.fireTableStructureChanged();
    }

    public void setColumnNames(Vector<?> nameVector) {
        this.columnNames = new String[nameVector.size()];
        nameVector.copyInto(this.columnNames);
        this.columnMapping = null;
        this.rows.clear();
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int column) {
        if (this.columnNames[column] != null) {
            return this.columnNames[column];
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Object obj;
        if (this.getRowCount() > 0 && (obj = this.getValueAt(0, column)) != null) {
            return obj.getClass();
        }
        return Object.class;
    }

    public Class<?> getColumnValueType(int column) {
        Class<?> cls;
        if (this.getRowCount() > 0 && (cls = this.getValueTypeAt(this.rows, 0, column)) != null) {
            return cls;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isEditable;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getValueAt(this.rows, row, column);
    }

    public Object getValueAt(Vector<TableRow> data, int row, int column) {
        TableRow tableRow = data.elementAt(row);
        return tableRow.getValueAt(this.convertToRowIndex(column));
    }

    public Class<?> getValueTypeAt(Vector<TableRow> data, int row, int column) {
        TableRow tableRow = data.elementAt(row);
        return tableRow.getValueTypeAt(this.convertToRowIndex(column));
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        TableRow tableRow = this.rows.elementAt(row);
        tableRow.setValueAt(value, this.convertToRowIndex(column));
        this.fireTableCellUpdated(row, column);
    }

    public Vector<TableRow> getDataVector() {
        return this.rows;
    }

    public void setDataVector(Vector<TableRow> rows) {
        if (rows == null) {
            this.rows.clear();
        } else {
            this.rows = rows;
        }
    }

    public TableRow getRow(int index) {
        if (index != -1) {
            return this.rows.get(index);
        }
        return null;
    }

    public int getRowIndex(TableRow row) {
        int index = this.rows.indexOf(row);
        return index;
    }

    public List<TableRow> getAllRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public void setRow(int index, TableRow row) {
        this.rows.set(index, row);
        this.fireTableRowsUpdated(index, index);
    }

    public void addRow(TableRow row) {
        this.rows.add(row);
        this.fireTableRowsInserted(this.rows.size(), this.rows.size());
    }

    public void insertRow(int index, TableRow row) {
        this.rows.add(index, row);
        this.fireTableRowsInserted(index, index);
    }

    public void removeRow(int index) {
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void removeAll() {
        int size = this.rows.size();
        this.rows.clear();
        this.fireTableRowsDeleted(0, size);
    }

    public void moveRow(int start, int end, int to) {
        int last;
        int first;
        if (to < 0 || to > this.getRowCount()) {
            return;
        }
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        this.rotate(this.rows, first, last + 1, shift);
        this.fireTableRowsUpdated(first, last);
    }

    public void setEditMode(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean getEditMode() {
        return this.isEditable;
    }

    public void setColumnMapping(int[] columnMapping) {
        this.columnMapping = columnMapping == null ? null : (int[])columnMapping.clone();
    }

    public int convertToRowIndex(int column) {
        if (this.columnMapping == null) {
            return column;
        }
        return this.columnMapping[column];
    }

    private static int gcd(int i, int j) {
        return j == 0 ? i : CustomTableModel.gcd(j, i % j);
    }

    private void rotate(Vector<TableRow> v, int a, int b, int shift) {
        int size = b - a;
        int r = size - shift;
        int g = CustomTableModel.gcd(size, r);
        for (int i = 0; i < g; ++i) {
            int to = i;
            TableRow tmp = v.elementAt(a + to);
            int from = (to + r) % size;
            while (from != i) {
                v.setElementAt(v.elementAt(a + from), a + to);
                to = from;
                from = (to + r) % size;
            }
            v.setElementAt(tmp, a + to);
        }
    }
}

