/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomSlider
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 6567900824726802706L;
    public static final int SLIDER_ORIENTATION_NORMAL = 0;
    public static final int SLIDER_ORIENTATION_VERTICAL = 1;
    private DescriptionTextArea titleText;
    private String unitName = "";
    private String titleStr = "";
    private JSlider slider;
    private JPanel sliderPanel;
    private JPanel buttonPanel;
    private int orientation = 0;
    private boolean isOK = false;
    private boolean isDefault = true;
    private int majorStep = 10;
    private int minorStep = 5;
    private int minValue = 0;
    private int maxValue = 100;
    private Hashtable<Object, Object> labelTable = new Hashtable();
    private JButton jBOK = new JButton(UIText.get(3584));
    private JButton jBCancel = new JButton(UIText.get(512));
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.util.uiutil");

    public CustomSlider() {
        super(Manager.getFrame(), "", true);
        this.isDefault = true;
        this.orientation = 0;
        this.initialize();
    }

    public CustomSlider(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.isDefault = true;
        this.orientation = 0;
        this.initialize();
    }

    public CustomSlider(String title, String unit, boolean modal, int min, int max, int major, int minor) {
        super(Manager.getFrame(), title, modal);
        this.isDefault = false;
        this.setUndecorated(true);
        this.orientation = 0;
        this.unitName = unit;
        this.setMinValue(min);
        this.setMaxValue(max);
        this.majorStep = major;
        this.minorStep = minor;
        this.titleStr = title;
        this.initialize();
    }

    private void initialize() {
        Container contentPane = this.getContentPane();
        this.slider = new JSlider(this.orientation);
        if (!this.isDefault) {
            this.slider.setMinimum(this.getMinValue());
            this.slider.setMaximum(this.getMaxValue());
        }
        this.labelTable = this.getLabelTable();
        this.slider.setLabelTable(this.labelTable);
        this.slider.setMinorTickSpacing(this.minorStep);
        this.slider.setMajorTickSpacing(this.majorStep);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.titleText = new DescriptionTextArea(this.titleStr, false, false);
        this.sliderPanel = this.getSliderPanel();
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    LoggerUtilities.logException((Throwable)e1);
                }
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CustomSlider.this.slider.setToolTipText("" + CustomSlider.this.slider.getValue());
            }
        });
        this.slider.setToolTipText("" + this.slider.getValue());
        contentPane.add((Component)this.sliderPanel, "Center");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public void setTitleText(DescriptionTextArea titleText) {
        this.titleText = titleText;
    }

    private DescriptionTextArea getTitleText() {
        if (this.titleText == null || "".equals(this.titleText.getText())) {
            this.titleText = new DescriptionTextArea(MSGRES.getString("CustomSlider.title"), false, false);
        }
        return this.titleText;
    }

    private JPanel getSliderPanel() {
        if (this.sliderPanel == null) {
            this.sliderPanel = new JPanel(new GridBagLayout());
            this.titleText = this.getTitleText();
            JPanel slidePane = new JPanel(new BorderLayout());
            slidePane.setOpaque(false);
            slidePane.setBackground(this.slider.getBackground());
            slidePane.add((Component)this.slider, "North");
            slidePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getUnitName()));
            this.sliderPanel.setPreferredSize(new Dimension(368, 175));
            this.sliderPanel.setOpaque(false);
            this.sliderPanel.setBackground(this.slider.getBackground().brighter());
            this.sliderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIColorUtilities.CONTROL_BACKGROUND, 2), BorderFactory.createEmptyBorder(2, 12, 2, 2)));
            this.sliderPanel.add((Component)this.titleText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 30), 0, 0));
            this.sliderPanel.add((Component)slidePane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.buttonPanel = this.getButtonPanel();
            this.sliderPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 2), 0, 0));
        }
        return this.sliderPanel;
    }

    public JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.jBOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomSlider.this.isOK = true;
                    CustomSlider.this.closeDialog();
                }
            });
            this.jBCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomSlider.this.isOK = false;
                    CustomSlider.this.closeDialog();
                }
            });
            UIUtilities.layoutButtonPanel(this.buttonPanel, new JButton[]{this.jBOK, this.jBCancel}, 0, 4, true, false, 10);
        }
        return this.buttonPanel;
    }

    public void setLabelTable(Hashtable<Object, Object> labelTable) {
        this.labelTable = (Hashtable)(labelTable == null ? null : labelTable.clone());
    }

    public Hashtable<Object, Object> getLabelTable() {
        if (this.labelTable.size() < 1) {
            this.labelTable = (Hashtable)Cast.cast(this.slider.createStandardLabels(this.majorStep));
        }
        Hashtable tempLabelTable = (Hashtable)(this.labelTable == null ? null : this.labelTable.clone());
        return tempLabelTable;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    private String getUnitName() {
        return this.unitName;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getReadingThenClose() {
        int value = this.getReading();
        this.closeDialog();
        return value;
    }

    public int getReading() {
        return this.slider.getValue();
    }

    public void setInitialValue(int value) {
        this.slider.setValue(value);
    }

    public void closeDialog() {
        this.dispose();
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.windowClosing(arg0);
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

