/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CertificateDlg;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.TypeValuePair;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;

public class ConsoleCertificateDlg
extends CertificateDlg {
    private static final long serialVersionUID = 1L;
    private final JButton jBAccept = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.accept"));
    private final JButton jBAcceptAlways = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.acceptAlways"));
    private final JButton jBReject = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.reject"));
    private final JButton jBHelp = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.help"));
    private boolean accepted = false;
    private boolean acceptedAlways = false;
    private boolean rejected = true;
    private boolean initialized = false;
    private static final int OTHER_TYPE = 0;
    private static final int RFC822_TYPE = 1;
    private static final int DNS_TYPE = 2;
    private static final int X400_TYPE = 3;
    private static final int DIRECTORY_TYPE = 4;
    private static final int EDI_TYPE = 5;
    private static final int URI_TYPE = 6;
    private static final int IP_TYPE = 7;
    private static final int OID_TYPE = 8;
    private static final String OTHER_STRING = "Other Name: ";
    private static final String RFC822_STRING = "RFC822 Name: ";
    private static final String DNS_STRING = "DNS Name: ";
    private static final String X400_STRING = "X400 Address: ";
    private static final String DIRECTORY_STRING = "Directory Name: ";
    private static final String EDI_STRING = "EDI Party Name: ";
    private static final String URI_STRING = "URI: ";
    private static final String IP_STRING = "IP Address: ";
    private static final String OID_STRING = "OID: ";
    private static final String UNKNOWN = "Unknown type: ";
    private static final String HELP_TOKEN = "sesm_cert_trust";

    public ConsoleCertificateDlg(JFrame frame, X509Certificate cert, ImageIcon icon) {
        super(frame, cert, icon, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.titleMessage"));
    }

    public void initialize() {
        super.initialize();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void accept() {
        this.accepted = true;
        this.rejected = false;
        this.dispose();
    }

    protected void acceptAlways() {
        this.acceptedAlways = true;
        this.rejected = false;
        this.dispose();
    }

    protected void reject() {
        this.dispose();
    }

    protected void help() {
        HelpUtil.showHelp(HELP_TOKEN);
    }

    protected JPanel getButtonPanel(boolean addOk) {
        this.jBAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConsoleCertificateDlg.this.accept();
            }
        });
        this.jBAcceptAlways.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConsoleCertificateDlg.this.acceptAlways();
            }
        });
        this.jBReject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConsoleCertificateDlg.this.reject();
            }
        });
        this.jBHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConsoleCertificateDlg.this.help();
            }
        });
        JPanel panel = new JPanel();
        ConsoleCertificateDlg.layoutButtonPanel((JPanel)panel, (JButton[])new JButton[]{this.jBAccept, this.jBAcceptAlways, this.jBReject, this.jBHelp}, (int)0, (int)0, (boolean)true);
        UiUtilities.setDefaultButton((RootPaneContainer)((Object)this), (JButton)this.jBAccept);
        this.jBAccept.setFocusable(true);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JSeparator(), "North");
        bottomPanel.add((Component)panel, "Center");
        return bottomPanel;
    }

    protected boolean addAlternateNames(JPanel panel, int rowIdx) {
        ArrayList<TypeValuePair> alternateNameList = this.extractAlternateNames();
        if (alternateNameList.size() == 0) {
            return false;
        }
        DefaultListModel<CallSite> listModel = new DefaultListModel<CallSite>();
        for (int i = 0; i < alternateNameList.size(); ++i) {
            TypeValuePair attribute = alternateNameList.get(i);
            listModel.addElement((CallSite)((Object)(attribute.type + ": " + Utility.shortenIfIpv6Address((String)attribute.value))));
        }
        JList list = new JList(listModel);
        list.setVisibleRowCount(4);
        list.setBackground(panel.getBackground());
        list.setForeground(panel.getForeground());
        list.setSelectionBackground(panel.getBackground());
        list.setSelectionForeground(panel.getForeground());
        JScrollPane listScrollPane = new JScrollPane(list);
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.alternateSubjectNames")), new GridBagConstraints(0, rowIdx, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)listScrollPane, new GridBagConstraints(1, rowIdx, 2, 2, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        return true;
    }

    protected boolean addFingerprint(JPanel panel, int rowIdx) {
        String fingerPrint = this.extractFingerPrint();
        if (fingerPrint == null) {
            return false;
        }
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ConsoleCertificateDlg.fingerPrint")), new GridBagConstraints(0, rowIdx, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(fingerPrint), new GridBagConstraints(1, rowIdx, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        return true;
    }

    private ArrayList<TypeValuePair> extractAlternateNames() {
        ArrayList<TypeValuePair> retList = new ArrayList<TypeValuePair>();
        try {
            Collection<List<?>> alternateNames = this.cert.getSubjectAlternativeNames();
            if (alternateNames != null) {
                for (List<?> tempList : alternateNames) {
                    String alternateNameType = UNKNOWN;
                    switch ((Integer)tempList.get(0)) {
                        case 0: {
                            alternateNameType = OTHER_STRING;
                            break;
                        }
                        case 1: {
                            alternateNameType = RFC822_STRING;
                            break;
                        }
                        case 2: {
                            alternateNameType = DNS_STRING;
                            break;
                        }
                        case 3: {
                            alternateNameType = X400_STRING;
                            break;
                        }
                        case 4: {
                            alternateNameType = DIRECTORY_STRING;
                            break;
                        }
                        case 5: {
                            alternateNameType = EDI_STRING;
                            break;
                        }
                        case 6: {
                            alternateNameType = URI_STRING;
                            break;
                        }
                        case 7: {
                            alternateNameType = IP_STRING;
                            break;
                        }
                        case 8: {
                            alternateNameType = OID_STRING;
                            break;
                        }
                    }
                    String alternateNameVal = null;
                    if (tempList.get(1) instanceof String) {
                        alternateNameVal = (String)tempList.get(1);
                    } else {
                        byte[] alternateNameByteVal = (byte[])tempList.get(1);
                        alternateNameVal = this.toHex(alternateNameByteVal);
                    }
                    TypeValuePair attribute = new TypeValuePair(alternateNameType, alternateNameVal);
                    retList.add(attribute);
                }
            }
        }
        catch (CertificateParsingException ex) {
            ConsoleLogger.logError("Error extracting alternative names from certificate: " + ex.getLocalizedMessage());
            ConsoleLogger.log(ex);
        }
        return retList;
    }

    private String extractFingerPrint() {
        try {
            MessageDigest md = SymantecMessageDigest.getInstance((String)"SHA-1");
            md.update(this.cert.getEncoded());
            byte[] fp = md.digest();
            String fpString = Utility.toHexString((byte[])fp);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < fpString.length(); ++i) {
                buf.append(fpString.charAt(i));
                if ((i + 1) % 4 != 0 || i == fpString.length() - 1) continue;
                buf.append('-');
            }
            return buf.toString();
        }
        catch (GeneralSecurityException ex) {
            ConsoleLogger.logError("Error extracting fingerprint from certificate: " + ex.getLocalizedMessage());
            ConsoleLogger.log(ex);
            return null;
        }
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isAcceptedAlways() {
        return this.acceptedAlways;
    }

    public boolean isRejected() {
        return this.rejected;
    }
}

