/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.policy.av.common.DashLine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String strTitleText;
    private JCheckBox jChCollapsed;
    private Icon expandIcon;
    private Icon collapseIcon;
    private JPanel contentPanel;
    private DashLine dashedLine;
    private Color dashedLineColor;
    private int dashedLineWidth;

    public CollapsiblePanel() {
        this("");
    }

    public CollapsiblePanel(String strHeader) {
        this(strHeader, null);
    }

    public CollapsiblePanel(String strHeader, JPanel contentPanel) {
        this(strHeader, contentPanel, UIColorUtilities.CONTROL_BACKGROUND, 550, null, null);
    }

    public CollapsiblePanel(String strHeader, JPanel contentPanel, Color dashColor, int dashWidth, Icon expandIcon, Icon collapseIcon) {
        this.strTitleText = strHeader;
        this.contentPanel = contentPanel == null ? new JPanel() : contentPanel;
        this.dashedLineColor = dashColor;
        this.dashedLineWidth = dashWidth;
        this.expandIcon = expandIcon;
        this.collapseIcon = collapseIcon;
        this.init();
    }

    private void init() {
        JLabel jLblTitle = new JLabel(this.strTitleText);
        Font titleFont = UIFontUtilities.BOLD_FONT;
        jLblTitle.setFont(titleFont);
        jLblTitle.setForeground(UIColorUtilities.CONTROL_BACKGROUND);
        if (this.expandIcon == null) {
            this.expandIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("collapsed.gif")));
        }
        if (this.collapseIcon == null) {
            this.collapseIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("expanded.gif")));
        }
        this.jChCollapsed = new JCheckBox(this.expandIcon);
        this.jChCollapsed.setSelectedIcon(this.collapseIcon);
        this.jChCollapsed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean showPanel = CollapsiblePanel.this.jChCollapsed.isSelected();
                if (CollapsiblePanel.this.dashedLine != null) {
                    CollapsiblePanel.this.dashedLine.setVisible(showPanel);
                }
                if (CollapsiblePanel.this.contentPanel != null) {
                    CollapsiblePanel.this.contentPanel.setVisible(showPanel);
                }
                CollapsiblePanel.this.repaint();
                CollapsiblePanel.this.getParent().validate();
            }
        });
        this.dashedLine = new DashLine(this.dashedLineColor, this.dashedLineWidth);
        this.dashedLine.putClientProperty("cssClass", "collapsiblePanelDashedLine");
        this.dashedLine.setVisible(false);
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new GridBagLayout());
        headerPanel.add((Component)jLblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 5, 0, 0), 0, 0));
        headerPanel.add((Component)this.jChCollapsed, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 5, 0, 0), 0, 0));
        headerPanel.add((Component)this.dashedLine, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)headerPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 23, 2, new Insets(10, 10, 5, 0), 0, 0));
        this.add((Component)this.contentPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 23, 2, new Insets(0, 10, 10, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setRequestFocusEnabled(true);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(JPanel contentPanel) {
        if (contentPanel != null) {
            this.contentPanel = contentPanel;
        }
    }
}

