/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class ClickableSlider
extends JSlider {
    private static final long serialVersionUID = 1L;

    public ClickableSlider(int orientation, int min, int max, int initValue) {
        super(orientation, min, max, initValue);
    }

    @Override
    public void updateUI() {
        this.updateLocalUI();
        this.updateLabelUIs();
    }

    private void updateLocalUI() {
        final LocalSliderUI ui = new LocalSliderUI(this);
        this.setUI(ui);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (!me.getSource().equals(ClickableSlider.this)) {
                    return;
                }
                int trackValue = ClickableSlider.this.getMinimum();
                float ratio = 0.0f;
                int mouseDistance = 0;
                int ui2slider = 0;
                if (ClickableSlider.this.orientation == 0) {
                    ui2slider = (ClickableSlider.this.getWidth() - ui.getTrackWidth()) / 2;
                    mouseDistance = ClickableSlider.this.getInverted() ? ClickableSlider.this.getWidth() - me.getX() - ui2slider : me.getX() - ui2slider;
                    ratio = ui.getTrackWidth() == 0 ? 0.0f : Math.max(0.0f, (float)mouseDistance * 1.0f / (float)ui.getTrackWidth());
                } else {
                    ui2slider = (ClickableSlider.this.getHeight() - ui.getTrackHeight()) / 2;
                    mouseDistance = ClickableSlider.this.getInverted() ? me.getY() - ui2slider : ClickableSlider.this.getHeight() - me.getY() - ui2slider;
                    ratio = ui.getTrackHeight() == 0 ? 0.0f : Math.max(0.0f, (float)mouseDistance * 1.0f / (float)ui.getTrackHeight());
                }
                trackValue = ClickableSlider.this.getMinimum() + Math.round((float)(ClickableSlider.this.getMaximum() - ClickableSlider.this.getMinimum()) * ratio);
                ClickableSlider.this.setValue(trackValue);
            }
        });
    }

    private static class LocalSliderUI
    extends BasicSliderUI {
        public LocalSliderUI(JSlider js) {
            super(js);
        }

        public int getTrackWidth() {
            return this.trackRect == null ? 0 : this.trackRect.width;
        }

        public int getTrackHeight() {
            return this.trackRect == null ? 0 : this.trackRect.height;
        }
    }
}

