/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.CheckableItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

class CheckListRenderer
extends JPanel
implements ListCellRenderer<Object> {
    private static final long serialVersionUID = 1L;
    JList<CheckableItem> list;
    JCheckBox check;
    JLabel label;

    public CheckListRenderer(JList<CheckableItem> list) {
        this.list = list;
        this.check = new JCheckBox();
        this.add(this.check);
        this.label = new JLabel();
        this.add(this.label);
        this.check.setBackground(Color.WHITE);
        this.check.setOpaque(true);
        this.label.setForeground(list.getForeground());
        this.label.setOpaque(false);
        this.setBackground(list.getBackground());
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean hasFocus) {
        boolean listEnabled = list.isEnabled();
        this.setEnabled(listEnabled);
        CheckableItem item = (CheckableItem)value;
        this.check.setSelected(item.isSelected());
        this.check.setEnabled(listEnabled);
        this.label.setFont(this.getFont().deriveFont(item.isSelected() ? 1 : 0));
        if (isSelected) {
            this.label.setForeground(UIManager.getColor("List.selectionForeground"));
        } else {
            this.label.setForeground(UIManager.getColor("List.foreground"));
        }
        this.label.setText(item.getText());
        this.label.setIcon(item.getIcon());
        this.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : list.getBackground());
        return this;
    }

    public int getCheckBoxWidth() {
        return this.check.getWidth();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
    }

    @Override
    public void doLayout() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.getPreferredSize();
        int y_check = 0;
        int y_label = 0;
        if (d_check.height < d_label.height) {
            y_check = (d_label.height - d_check.height) / 2;
        } else {
            y_label = (d_check.height - d_label.height) / 2;
        }
        this.check.setLocation(0, y_check);
        this.check.setBounds(0, y_check, d_check.width, d_check.height);
        this.label.setLocation(d_check.width, y_label);
        this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
    }
}

