/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CalendarChooser
extends DialogBase
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private static MessageResources msgRes = MessageResources.getInstance();
    private static final String[] MONTHS = new String[]{msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.January"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.February"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.March"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.April"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.May"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.June"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.July"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.August"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.September"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.October"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.November"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.December")};
    private static final String[] DAYS_SUN_FIRST = new String[]{msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Sun"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Mon"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Tue"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Wed"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Thu"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Fri"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Sat")};
    private static final String[] DAYS_MON_FIRST = new String[]{msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Mon"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Tue"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Wed"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Thu"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Fri"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Sat"), msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.Sun")};
    private static final String[] DAYS;
    private static final int FIRST_DAY;
    private static final Border EMPTY_BORDER;
    private static final Border FOCUSED_BORDER;
    private static final int FIRST_YEAR = 1990;
    private static final int LAST_YEAR = 2100;
    private JLabel[][] days = new JLabel[7][7];
    private JPanel daysGrid = new JPanel(new GridLayout(7, 7, 5, 0));
    private int offset;
    private int lastDay;
    private JLabel day;
    private JComboBox<String> jCmbMonth = new JComboBox<String>(MONTHS);
    private JComboBox<String> jCmbYear = new JComboBox();
    private JCheckBox jCbxTime = new JCheckBox(UIText.get(4867));
    private JCheckBox jCbxTimeZone = new JCheckBox(UIText.get(4867));
    private TimeSpinner1 timeSpinner;

    public CalendarChooser(int year, int month, int date, int hour, int minute, int second, boolean hasAmpm, int am_pm, boolean showTimePortion, boolean hasTime, boolean hasTimeZone, String timePattern) {
        super(Manager.getFrame(), "", true);
        this.setTitle(showTimePortion ? msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.SelectDateAndTime") : msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.SelectDate"));
        this.initialize(showTimePortion, hasTime, timePattern);
        this.setChooser(year, month, date, hour, minute, second, hasAmpm, am_pm, showTimePortion, hasTime, hasTimeZone);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public boolean getHasTime() {
        return this.jCbxTime.isSelected();
    }

    public boolean getHasTimeZone() {
        return this.jCbxTime.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int iday = this.getSelectedDay();
        for (int i = 0; i < 7; ++i) {
            this.days[1][i].setText(" ");
            this.days[5][i].setText(" ");
            this.days[6][i].setText(" ");
        }
        Calendar cal = Utility.getCalendarInstance();
        cal.set(5, 1);
        cal.set(2, this.jCmbMonth.getSelectedIndex() + 0);
        cal.set(1, this.jCmbYear.getSelectedIndex() + 1990);
        this.offset = cal.get(7) - FIRST_DAY;
        if (this.offset < 0) {
            this.offset += 7;
        }
        this.lastDay = cal.getActualMaximum(5);
        for (int i = 0; i < this.lastDay; ++i) {
            this.days[(i + this.offset) / 7 + 1][(i + this.offset) % 7].setText(String.valueOf(i + 1));
        }
        if (iday != -1) {
            if (iday > this.lastDay) {
                iday = this.lastDay;
            }
            this.setSelected(iday);
        }
    }

    private void initialize(boolean showTimePortion, boolean hasTime, String timePattern) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getDateTimePanel(showTimePortion, hasTime, timePattern), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JPanel getDateTimePanel(boolean showTimePortion, boolean hasTime, String timePattern) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.getDatePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (showTimePortion) {
            this.jCbxTimeZone.setFont(this.jCbxTimeZone.getFont().deriveFont(1));
            this.jCbxTime.setFont(this.jCbxTime.getFont().deriveFont(1));
            this.jCbxTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarChooser.this.timeSpinner.setEnabled(CalendarChooser.this.jCbxTime.isSelected());
                    if (!CalendarChooser.this.jCbxTime.isSelected()) {
                        CalendarChooser.this.jCbxTimeZone.setSelected(false);
                    }
                }
            });
            this.timeSpinner = new TimeSpinner1(timePattern);
            this.timeSpinner.setEnabled(hasTime);
            this.jCbxTimeZone.setEnabled(hasTime);
            panel.add((Component)this.jCbxTime, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 12, 0, 4), 0, 0));
            panel.add((Component)this.getTimePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        return panel;
    }

    private JPanel getDatePanel() {
        int i;
        this.jCmbMonth.addItemListener(this);
        for (i = 1990; i <= 2100; ++i) {
            this.jCmbYear.addItem(Integer.toString(i));
        }
        this.jCmbYear.addItemListener(this);
        for (i = 0; i < 7; ++i) {
            this.days[0][i] = new JLabel(DAYS[i], 4);
            this.days[0][i].setForeground(UIColorUtilities.WEEK_DAYS_FOREGROUND);
        }
        for (i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.days[i][j] = new JLabel(" ", 4);
                this.days[i][j].setForeground(UIColorUtilities.DAYS_FOREGROUND);
                this.days[i][j].setBackground(UIColorUtilities.SELECTED_DAY_BACKGROUND);
                this.days[i][j].setBorder(EMPTY_BORDER);
                this.days[i][j].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JLabel day = (JLabel)e.getSource();
                        if (!day.getText().equals(" ")) {
                            CalendarChooser.this.setSelected(day);
                        }
                        CalendarChooser.this.daysGrid.requestFocus();
                    }
                });
            }
        }
        JPanel monthYear = new JPanel(new GridBagLayout());
        monthYear.add(this.jCmbMonth);
        monthYear.add(this.jCmbYear);
        this.daysGrid.setBorder(BorderFactory.createLoweredBevelBorder());
        this.daysGrid.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CalendarChooser.this.setSelected(CalendarChooser.this.day);
            }

            @Override
            public void focusLost(FocusEvent e) {
                CalendarChooser.this.setSelected(CalendarChooser.this.day);
            }
        });
        this.daysGrid.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int iday = CalendarChooser.this.getSelectedDay();
                switch (e.getKeyCode()) {
                    case 37: {
                        if (iday <= 1) break;
                        CalendarChooser.this.setSelected(iday - 1);
                        break;
                    }
                    case 39: {
                        if (iday >= CalendarChooser.this.lastDay) break;
                        CalendarChooser.this.setSelected(iday + 1);
                        break;
                    }
                    case 38: {
                        if (iday <= 7) break;
                        CalendarChooser.this.setSelected(iday - 7);
                        break;
                    }
                    case 40: {
                        if (iday > CalendarChooser.this.lastDay - 7) break;
                        CalendarChooser.this.setSelected(iday + 7);
                        break;
                    }
                }
            }
        });
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int j = 0; j < 7; ++j) {
                this.daysGrid.add(this.days[i2][j]);
            }
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.DateTitle")));
        panel.add(this.jCmbMonth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.jCmbYear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.daysGrid, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getTimePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarChooser.TimeTitle")));
        panel.add((Component)this.timeSpinner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        return panel;
    }

    private void setChooser(int year, int month, int date, int hour, int minute, int second, boolean hasAmpm, int am_pm, boolean showTimePortion, boolean hasTime, boolean hasTimeZone) {
        this.setYear(year);
        this.setMonth(month);
        this.setDate(date);
        this.jCbxTime.setSelected(hasTime);
        this.jCbxTimeZone.setSelected(hasTimeZone);
        if (showTimePortion) {
            this.setHour(hour);
            this.setMinute(minute);
            this.setSecond(second);
            if (hasAmpm) {
                this.setAmpm(am_pm);
            }
        }
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException e) {
            LoggerUtilities.logException((Throwable)e);
            return -1;
        }
    }

    private void setSelected(JLabel newDay) {
        if (this.day != null) {
            this.day.setForeground(UIColorUtilities.DAYS_FOREGROUND);
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = newDay;
        this.day.setForeground(UIColorUtilities.SELECTED_DAY_FOREGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int newDay) {
        this.setSelected(this.days[(newDay + this.offset - 1) / 7 + 1][(newDay + this.offset - 1) % 7]);
    }

    public int getYear() {
        return this.jCmbYear.getSelectedIndex() + 1990;
    }

    public void setYear(int yr) {
        this.jCmbYear.setSelectedIndex(yr - 1990);
    }

    public int getMonth() {
        return this.jCmbMonth.getSelectedIndex() + 0;
    }

    public void setMonth(int mon) {
        this.jCmbMonth.setSelectedIndex(mon - 0);
    }

    public int getDate() {
        return this.getSelectedDay();
    }

    public void setDate(int dt) {
        this.setSelected(dt);
    }

    public int getHour() {
        return this.timeSpinner != null ? this.timeSpinner.getHour() : 0;
    }

    public void setHour(int hr) {
        if (this.timeSpinner != null) {
            this.timeSpinner.setHour(hr);
        }
    }

    public int getMinute() {
        return this.timeSpinner != null ? this.timeSpinner.getMinute() : 0;
    }

    public void setMinute(int min) {
        if (this.timeSpinner != null) {
            this.timeSpinner.setMinute(min);
        }
    }

    public int getSecond() {
        return this.timeSpinner != null ? this.timeSpinner.getSecond() : 0;
    }

    public void setSecond(int sec) {
        if (this.timeSpinner != null) {
            this.timeSpinner.setSecond(sec);
        }
    }

    public int getAmpm() {
        return this.timeSpinner != null ? this.timeSpinner.getAmpm() : 0;
    }

    public void setAmpm(int ampm) {
        if (this.timeSpinner != null) {
            this.timeSpinner.setAmpm(ampm);
        }
    }

    public static void main(String[] args) {
        String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
        Calendar c = Utility.getCalendarInstance();
        CalendarChooser chooser = new CalendarChooser(c.get(1), c.get(2), c.get(5), c.get(10), c.get(12), c.get(13), true, 9, true, true, true, timePattern);
        if (chooser.isOk()) {
            System.out.println("year = " + chooser.getYear());
            System.out.println("month = " + (chooser.getMonth() + 1));
            System.out.println("date = " + chooser.getDate());
            System.out.println("hour = " + chooser.getHour());
            System.out.println("minute = " + chooser.getMinute());
            System.out.println("second = " + chooser.getSecond());
            System.out.println("ampm = " + chooser.getAmpm());
            System.out.println("hasTime = " + chooser.getHasTime());
            System.out.println("hasTimeZone = " + chooser.getHasTimeZone());
        }
        chooser.dispose();
        System.exit(0);
    }

    static {
        Calendar cal = Utility.getCalendarInstance();
        if (cal.getFirstDayOfWeek() == 2) {
            FIRST_DAY = 2;
            DAYS = DAYS_MON_FIRST;
        } else {
            FIRST_DAY = 1;
            DAYS = DAYS_SUN_FIRST;
        }
        EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        FOCUSED_BORDER = BorderFactory.createLineBorder(Color.yellow, 1);
    }
}

