/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.CalendarChooser;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JButton;

public class CalendarButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static MessageResources msgRes = MessageResources.getInstance();
    private DateFormat dateFormat = DateFormat.getDateInstance(1, Locale.getDefault());
    private DateFormat dateTimeWithoutZoneFormat = DateFormat.getDateTimeInstance(1, 2, Locale.getDefault());
    private DateFormat dateTimeWithZoneFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
    private String defaultTimePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePatternFull");
    private String timePattern;
    private TimeZone timeZone;
    private long dateTime;
    private boolean showTimePortion;
    public boolean hasTime;
    public boolean hasTimeZone;

    public CalendarButton(String timepattern) {
        this(timepattern, (TimeZone)null);
    }

    public CalendarButton(String timepattern, TimeZone tz) {
        this.timePattern = timepattern == null || timepattern.trim().length() == 0 ? this.defaultTimePattern : timepattern.trim();
        this.timeZone = tz == null ? Utility.getLocalTimeZone() : tz;
    }

    public void setDateTime(long dateTime, boolean showTimePortion, boolean hasTime, boolean hasTimeZone) {
        this.dateTime = dateTime;
        this.showTimePortion = showTimePortion;
        this.hasTime = hasTime;
        this.hasTimeZone = hasTimeZone;
        this.initialize(dateTime);
    }

    public long getDateTime() {
        return this.dateTime;
    }

    @Override
    protected void fireActionPerformed(ActionEvent e) {
        boolean hasHour = false;
        boolean hasMinute = false;
        boolean hasSecond = false;
        boolean hasAmpm = false;
        String hourPattern = "h";
        if (this.timePattern != null && this.timePattern.length() > 0) {
            if (this.timePattern.indexOf("h") != -1) {
                hourPattern = "h";
                hasHour = true;
            }
            if (this.timePattern.indexOf("H") != -1) {
                hourPattern = "H";
                hasHour = true;
            }
            if (this.timePattern.indexOf("k") != -1) {
                hourPattern = "k";
                hasHour = true;
            }
            if (this.timePattern.indexOf("K") != -1) {
                hourPattern = "K";
                hasHour = true;
            }
            if (this.timePattern.indexOf("m") != -1) {
                hasMinute = true;
            }
            if (this.timePattern.indexOf("s") != -1) {
                hasSecond = true;
            }
            if (this.timePattern.indexOf("a") != -1) {
                hasAmpm = true;
            }
        }
        SimpleDateFormat sdfDateTime = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Calendar calendar = Calendar.getInstance(this.timeZone);
        if (!this.hasTime || !this.hasTimeZone) {
            calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        calendar.setTimeInMillis(this.dateTime);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int date = calendar.get(5);
        int hour = 0;
        int minute = 0;
        int second = 0;
        int ampm = 0;
        if (this.hasTime) {
            hour = calendar.get(11);
            hour = Utility.convertHourFrom_H_Pattern((int)hour, (String)hourPattern);
            minute = calendar.get(12);
            second = calendar.get(13);
            ampm = hasAmpm ? calendar.get(9) : -1;
        } else {
            hour = Utility.convertHourFrom_H_Pattern((int)hour, (String)hourPattern);
        }
        CalendarChooser chooser = new CalendarChooser(year, month, date, hour, minute, second, hasAmpm, ampm, this.showTimePortion, this.hasTime, this.hasTimeZone, this.timePattern);
        if (chooser.isOk()) {
            year = chooser.getYear();
            month = chooser.getMonth() + 1;
            date = chooser.getDate();
            this.hasTime = chooser.getHasTime();
            this.hasTimeZone = chooser.getHasTimeZone();
            hour = 0;
            minute = 0;
            second = 0;
            if (this.showTimePortion) {
                if (hasHour) {
                    hour = chooser.getHour();
                    if (hasAmpm) {
                        ampm = chooser.getAmpm();
                    }
                    hour = Utility.convertHourTo_H_Pattern((int)hour, (String)hourPattern, (int)ampm);
                }
                if (hasMinute) {
                    minute = chooser.getMinute();
                }
                if (hasSecond) {
                    second = chooser.getSecond();
                }
            }
            String dateTimeStr = month + "/" + date + "/" + year + " " + hour + ":" + minute + ":" + second;
            try {
                if (!this.hasTime) {
                    sdfDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    Date d = sdfDateTime.parse(dateTimeStr);
                    this.dateTime = d.getTime();
                    this.setText(this.dateFormat.format(d));
                } else if (this.hasTimeZone) {
                    sdfDateTime.setTimeZone(this.timeZone);
                    this.dateTimeWithZoneFormat.setTimeZone(this.timeZone);
                    Date d = sdfDateTime.parse(dateTimeStr);
                    this.dateTime = d.getTime();
                    this.setText(this.dateTimeWithZoneFormat.format(d));
                } else {
                    sdfDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.dateTimeWithoutZoneFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    Date d = sdfDateTime.parse(dateTimeStr);
                    this.dateTime = d.getTime();
                    this.setText(this.dateTimeWithoutZoneFormat.format(d));
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        chooser.dispose();
    }

    private void initialize(long dateTime) {
        this.setPreferredSize();
        if (!this.hasTime) {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.setText(this.dateFormat.format(new Date(dateTime)));
        } else if (this.hasTimeZone) {
            this.dateTimeWithZoneFormat.setTimeZone(this.timeZone);
            this.setText(this.dateTimeWithZoneFormat.format(new Date(dateTime)));
        } else {
            this.dateTimeWithoutZoneFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.setText(this.dateTimeWithoutZoneFormat.format(new Date(dateTime)));
        }
    }

    private void setPreferredSize() {
        JButton button = new JButton(msgRes.getString("com.sygate.scm.console.ui.util.uiutil", "CalendarButton.maxDateTimeText"));
        this.setPreferredSize(button.getPreferredSize());
        Date date = new Date();
        String dateText = this.dateTimeWithZoneFormat.format(date);
        button.setText(dateText);
    }
}

