/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.border.Border;

public class BackgroundImageBorder
implements Border {
    protected Image mImage;
    protected Insets mInsets;

    public BackgroundImageBorder(Image image) {
        this.mImage = image;
        this.init();
    }

    public BackgroundImageBorder(Image image, Insets insets) {
        this.mInsets = insets;
        this.mImage = image;
        this.init();
    }

    protected void init() {
        if (this.mInsets == null) {
            this.mInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.mInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int paintX = 0;
        if (this.mImage.getWidth(null) < width) {
            paintX = x + (width - this.mImage.getWidth(null)) / 2;
        }
        int paintY = 0;
        if (this.mImage.getHeight(null) < height) {
            paintY = y + (height - this.mImage.getHeight(null)) / 2;
        }
        g.drawImage(this.mImage, paintX, paintY, null);
    }
}

