/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class ArrowIcon
implements Icon,
SwingConstants {
    private int width;
    private int height;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];

    public ArrowIcon(int direction) {
        this(direction, 10, 10);
    }

    public ArrowIcon(int direction, int width, int height) {
        this.width = width;
        this.height = height;
        switch (direction) {
            case 10: {
                this.xPoints[0] = width;
                this.yPoints[0] = -1;
                this.xPoints[1] = width;
                this.yPoints[1] = height;
                this.xPoints[2] = 0;
                this.yPoints[2] = height / 2;
                this.xPoints[3] = 0;
                this.yPoints[3] = height / 2 - 1;
                break;
            }
            case 11: {
                this.xPoints[0] = 0;
                this.yPoints[0] = -1;
                this.xPoints[1] = 0;
                this.yPoints[1] = height;
                this.xPoints[2] = width;
                this.yPoints[2] = height / 2;
                this.xPoints[3] = width;
                this.yPoints[3] = height / 2 - 1;
                break;
            }
            case 1: {
                this.xPoints[0] = -1;
                this.yPoints[0] = height;
                this.xPoints[1] = width / 2 - 1;
                this.yPoints[1] = 0;
                this.xPoints[2] = width / 2;
                this.yPoints[2] = 0;
                this.xPoints[3] = width;
                this.yPoints[3] = height;
                break;
            }
            case 3: {
                this.xPoints[0] = -1;
                this.yPoints[0] = 0;
                this.xPoints[1] = width;
                this.yPoints[1] = 0;
                this.xPoints[2] = width / 2;
                this.yPoints[2] = height;
                this.xPoints[3] = width / 2 - 1;
                this.yPoints[3] = height;
                break;
            }
        }
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int length = this.xPoints.length;
        int[] adjustedXPoints = new int[length];
        int[] adjustedYPoints = new int[length];
        for (int i = 0; i < length; ++i) {
            adjustedXPoints[i] = this.xPoints[i] + x;
            adjustedYPoints[i] = this.yPoints[i] + y;
        }
        if (c.isEnabled()) {
            g.setColor(c.getForeground());
        } else {
            g.setColor(Color.gray);
        }
        g.fillPolygon(adjustedXPoints, adjustedYPoints, length);
    }
}

