/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.AniStripData;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;

public class AniStripPanel
extends JPanel
implements Runnable,
ComponentListener {
    private static final long serialVersionUID = 1L;
    AniStripData m_aniData = null;
    private int m_iIndex = 0;
    Rectangle m_rectSource = null;
    Rectangle m_rectTarget = null;
    private Thread animate = null;

    public AniStripPanel() {
        this.addComponentListener(this);
    }

    public void init(Class<?> classResource, String szFilename, int iFrameCount, boolean isVerticalStrip) {
        this.m_aniData = new AniStripData(this);
        this.m_aniData.loadImage(classResource, szFilename, iFrameCount, isVerticalStrip);
        this.m_aniData.setSpeed(100);
    }

    public boolean isInit() {
        return this.m_aniData != null && this.m_aniData.isInit();
    }

    public void caculatePosition(int index) {
        this.m_rectSource = this.m_aniData.getSourcePosition(index);
        if (this.m_rectTarget == null) {
            this.m_rectTarget = this.m_aniData.getTargetCenterPosition();
        }
    }

    public void start() {
        if (this.animate == null) {
            this.animate = new Thread(this);
            this.animate.start();
        }
    }

    public void stop() {
        if (this.animate != null) {
            this.animate = null;
        }
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.animate == thisThread) {
            this.repaint();
            try {
                Thread.sleep(this.m_aniData.getSpeed());
            }
            catch (InterruptedException e) {
                System.out.println(e.toString());
            }
            ++this.m_iIndex;
            if (this.m_iIndex < this.m_aniData.getFrameCount()) continue;
            this.m_iIndex = 0;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_aniData.isValid()) {
            if (!this.m_aniData.isInit()) {
                this.m_aniData.postLoadImage();
            }
            this.caculatePosition(this.m_iIndex);
            g.drawImage(this.m_aniData.getImage(), this.m_rectTarget.x, this.m_rectTarget.y, this.m_rectTarget.x + this.m_rectTarget.width, this.m_rectTarget.y + this.m_rectTarget.height, this.m_rectSource.x, this.m_rectSource.y, this.m_rectSource.x + this.m_rectSource.width, this.m_rectSource.y + this.m_rectSource.height, this);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this != e.getSource()) {
            return;
        }
        this.m_rectTarget = null;
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

