/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;

class AniStripData {
    private Component m_parentComponent = null;
    private Image m_image = null;
    private String m_szFilename = null;
    private Class<?> m_classResource = null;
    private int m_iFrameCount = 0;
    private boolean m_bVerticalStrip = true;
    private int m_iImageWidth = 0;
    private int m_iImageHeight = 0;
    private int m_iFrameWidth = 0;
    private int m_iFrameHeight = 0;
    private int m_iSpeed = 0;
    private boolean m_doneInit = false;
    private int m_countInit = 0;

    public Component getParentComponent() {
        return this.m_parentComponent;
    }

    public String getParentComponanetClassName() {
        return this.m_parentComponent != null ? this.m_parentComponent.getClass().getName() : "";
    }

    public Image getImage() {
        return this.m_image;
    }

    public Class<?> getClassResource() {
        return this.m_classResource;
    }

    public String getClassResourceName() {
        return this.m_classResource != null ? this.m_classResource.getName() : "";
    }

    public String getFilename() {
        return this.m_szFilename;
    }

    public int getFrameCount() {
        return this.m_iFrameCount;
    }

    public int getImageWidth() {
        return this.m_iImageWidth;
    }

    public int getImageHeight() {
        return this.m_iImageHeight;
    }

    public int getFrameWidth() {
        return this.m_iFrameWidth;
    }

    public int getFrameHeight() {
        return this.m_iFrameHeight;
    }

    public int getSpeed() {
        return this.m_iSpeed;
    }

    public void setSpeed(int speed) {
        this.m_iSpeed = speed;
    }

    public AniStripData(Component parent) {
        this.m_parentComponent = parent;
    }

    public boolean isValid() {
        return this.m_image != null;
    }

    public boolean isInit() {
        return this.m_doneInit;
    }

    public boolean loadImage(Class<?> classResource, String fileName, int frameCount, boolean isVerticalStrip) {
        this.m_doneInit = false;
        if (this.m_parentComponent == null) {
            return false;
        }
        this.m_szFilename = fileName;
        this.m_iFrameCount = frameCount;
        this.m_bVerticalStrip = isVerticalStrip;
        this.m_classResource = classResource;
        this.m_image = classResource == null ? Toolkit.getDefaultToolkit().getImage(this.m_szFilename) : Toolkit.getDefaultToolkit().getImage(classResource.getResource(this.m_szFilename));
        if (this.m_image == null) {
            return false;
        }
        return this.postLoadImage();
    }

    public boolean postLoadImage() {
        if (this.m_image == null) {
            return false;
        }
        if (this.m_doneInit) {
            return true;
        }
        ++this.m_countInit;
        MediaTracker mt = new MediaTracker(this.m_parentComponent);
        mt.addImage(this.m_image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
        this.m_iImageWidth = this.m_image.getWidth(this.m_parentComponent);
        this.m_iImageHeight = this.m_image.getHeight(this.m_parentComponent);
        if (this.m_bVerticalStrip) {
            this.m_iFrameWidth = this.m_iImageWidth;
            this.m_iFrameHeight = this.m_iImageHeight / this.m_iFrameCount;
        } else {
            this.m_iFrameWidth = this.m_iImageWidth / this.m_iFrameCount;
            this.m_iFrameHeight = this.m_iImageHeight;
        }
        this.m_doneInit = true;
        return true;
    }

    public Rectangle getSourcePosition(int index) {
        return new Rectangle(this.m_bVerticalStrip ? 0 : this.m_iFrameWidth * index, this.m_bVerticalStrip ? this.m_iFrameHeight * index : 0, this.m_iFrameWidth, this.m_iFrameHeight);
    }

    public Rectangle getTargetCenterPosition() {
        Rectangle rect = this.m_parentComponent.getBounds();
        return new Rectangle((rect.width - this.m_iFrameWidth) / 2, (rect.height - this.m_iFrameHeight) / 2, this.m_iFrameWidth, this.m_iFrameHeight);
    }

    public void test() {
        System.out.println("==== AniStripData : Begin =============");
        System.out.println("parent component=" + this.getParentComponanetClassName());
        System.out.println("file=" + this.m_szFilename);
        System.out.println("res class=" + this.getClassResourceName());
        System.out.println("isVerticalStrip=" + this.m_bVerticalStrip);
        System.out.println("image width=" + this.m_iImageWidth);
        System.out.println("image height=" + this.m_iImageHeight);
        System.out.println("frame width=" + this.m_iFrameWidth);
        System.out.println("frame height=" + this.m_iFrameHeight);
        System.out.println("frame count=" + this.m_iFrameCount);
        System.out.println("speed=" + this.m_iSpeed);
        System.out.println("valid=" + this.isValid());
        System.out.println("init done=" + this.m_doneInit);
        System.out.println("init count=" + this.m_countInit);
        System.out.println("==== AniStripData : End =============");
    }
}

