/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;

public class ActionConfirmationDlg
extends DialogBase {
    private static final long serialVersionUID = 1487960943034399157L;
    public static final int DISABLE_DOMAIN = 0;
    public static final int DELETE_DOMAIN = 1;
    public static final int DISABLE_ARP = 2;
    private static final String DISABLE_DOMAIN_MESSAGE = "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ActionConfirmationDlg.disableDomainMessage") + "</html>";
    private static final String DELETE_DOMAIN_MESSAGE = "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ActionConfirmationDlg.deleteDomainMessage") + "</html>";
    private static final String DISABLE_ARP_MESSAGE = "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ActionConfirmationDlg.disableAPRMessage") + "</html>";
    private JCheckBox jCbxYes = new JCheckBox();
    private String csToken;

    public ActionConfirmationDlg(String title, String name, int type) {
        super(Manager.getFrame(), title, true);
        this.initialize(name, type);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.csToken;
    }

    private void initialize(String name, int type) {
        String message = this.initMessage(name, type);
        this.csToken = this.initContentSensitiveHelpToken(type);
        switch (type) {
            case 0: {
                this.jCbxYes.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ActionConfirmationDlg.msg.yesIAgreeDisable"));
                break;
            }
            case 1: {
                this.jCbxYes.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ActionConfirmationDlg.msg.yesIAgreeDelete"));
                break;
            }
            default: {
                this.jCbxYes.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ActionConfirmationDlg.msg.yesIAgree"));
            }
        }
        this.jCbxYes.setFont(this.jCbxYes.getFont().deriveFont(1));
        this.jCbxYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionConfirmationDlg.this.jBOk.setEnabled(ActionConfirmationDlg.this.jCbxYes.isSelected());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        panel.add((Component)new JLabel(UIManager.getDefaults().getIcon("OptionPane.warningIcon")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new HtmlEnabledJLabel(message), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxYes, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 20, 0), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.jBOk.setEnabled(false);
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBCancel);
        this.pack();
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    private String initMessage(String name, int type) {
        String domainName = StringUtilities.to_html_entities((String)name);
        Object[] obj = new Object[]{domainName};
        String message = "";
        switch (type) {
            case 0: {
                message = MessageFormat.format(DISABLE_DOMAIN_MESSAGE, obj);
                break;
            }
            case 1: {
                message = MessageFormat.format(DELETE_DOMAIN_MESSAGE, obj);
                break;
            }
            default: {
                message = DISABLE_ARP_MESSAGE;
            }
        }
        return message;
    }

    private String initContentSensitiveHelpToken(int type) {
        switch (type) {
            case 0: {
                return "sesm_admin_domain_dialog_disable";
            }
            case 1: {
                return "sesm_admin_domain_dialog_delete";
            }
        }
        return null;
    }
}

