/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class VipServerDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private JTextField jtfFile = new JTextField();
    private JButton jbBrowse = new JButton(UIText.get(257));
    private JPasswordField jpfKeyStorePassword = new SEPMPasswordField();
    private ServerObject model;
    private static final String INVALID_COMPUTER_NAME_CHARACTERS = "/\\[]\";|<>+=,?* _";
    private String pksKeysoreFilePath = null;
    Hashtable<String, byte[]> data = null;

    public VipServerDialog(ServerObject model, boolean readOnly) {
        super(Manager.getFrame(), MSG_RES.getString("VipServerDialog.title"), true, true);
        this.model = model;
        this.readOnly = readOnly;
        this.initialize();
        this.setModel(model);
        this.setReadOnlyStatus();
        this.setVisible(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_configure_vip";
    }

    @Override
    protected void setReadOnlyStatus() {
        this.jtfFile.setEnabled(!this.readOnly);
        this.jpfKeyStorePassword.setEnabled(!this.readOnly);
    }

    @Override
    protected boolean ok() {
        if (!Env.isUnitTest() && !this.isValidState()) {
            return false;
        }
        this.updateModel();
        try {
            if (this.data == null) {
                return false;
            }
            GUIManager.storeVIPCertificateAndPassword("PFX", this.data);
            DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)this.model.getParentSite());
        }
        catch (ConsoleException ex) {
            String errorMsg = ex.getMessageString();
            if (-33554432 == ex.getErrorCode()) {
                errorMsg = MSG_RES.getString("VipServerDialog.error.canNotConnectError");
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, MSG_RES.getString("VipServerDialog.error.keyStoreDetailsUpdate"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return false;
        }
        this.isOk = true;
        JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.completedSuccessfully"), MSG_RES.getString("VipServerDialog.title.success"), 1);
        this.dispose();
        return true;
    }

    private void updateModel() {
        if (this.readOnly) {
            return;
        }
        SemServer server = this.model.getSemServer();
        server.setOptHasVipAuth(Boolean.valueOf(true));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
        this.add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getInnerPanel() {
        RestrictedPlainDocument passwordDocument = new RestrictedPlainDocument(256);
        this.jpfKeyStorePassword.setDocument(passwordDocument);
        RestrictedPlainDocument serverAddressDocument = new RestrictedPlainDocument(256);
        serverAddressDocument.setValidator(INVALID_COMPUTER_NAME_CHARACTERS, false);
        DescriptionTextArea desc = new DescriptionTextArea(MSG_RES.getString("VipServerDialog.desc"));
        desc.setColumns(60);
        JPanel panel = new JPanel(new GridBagLayout());
        int gridY = 0;
        panel.add((Component)desc, new GridBagConstraints(0, gridY, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 10, 0), 0, 0));
        panel.add((Component)new JLabel(MSG_RES.getString("VipServerDialog.label.file")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this.jtfFile, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 0), 0, 0));
        panel.add((Component)this.jbBrowse, new GridBagConstraints(2, gridY, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(MSG_RES.getString("VipServerDialog.label.password")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 15, 0), 0, 0));
        panel.add((Component)this.jpfKeyStorePassword, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 15, 0), 0, 0));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VipServerDialog.this.browsePfxFile();
            }
        });
        return panel;
    }

    private void setModel(ServerObject model) {
        this.model = model;
    }

    private void browsePfxFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(MSG_RES.getString("VipServerDialog.title.SelectP12File"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".p12");
            }

            @Override
            public String getDescription() {
                return MSG_RES.getString("VipServerDialog.P12FileDesc");
            }
        });
        if (0 == fileChooser.showOpenDialog(Manager.getFrame())) {
            File selection = fileChooser.getSelectedFile();
            if (selection != null && selection.getName().toLowerCase().endsWith(".p12")) {
                this.jtfFile.setText(AjaxSwingUtil.getDisplayFileName(selection));
                this.pksKeysoreFilePath = selection.getAbsolutePath();
            } else {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStoreFileInvalid", new Object[]{AjaxSwingUtil.getDisplayFileName(selection)}), MSG_RES.getString("VipServerDialog.title.Error"), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidState() {
        if (StringUtilities.isEmpty((String)this.pksKeysoreFilePath)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStorePathCannotBeEmpty"), MSG_RES.getString("VipServerDialog.title.Error"), 0);
            this.jtfFile.requestFocus();
            return false;
        }
        String password = new String(this.jpfKeyStorePassword.getPassword());
        if (StringUtilities.isEmpty((String)password)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStorePasswordCannotBeEmpty"), MSG_RES.getString("VipServerDialog.title.Error"), 0);
            this.jpfKeyStorePassword.requestFocus();
            return false;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] buffer = null;
        int lenRead = 0;
        try {
            fis = new FileInputStream(this.pksKeysoreFilePath);
            bis = new BufferedInputStream(fis);
            File file = new File(this.pksKeysoreFilePath);
            long length = file.length();
            buffer = new byte[(int)length];
            lenRead = bis.read(buffer);
            if ((long)lenRead != length) {
                ConsoleLogger.log("VipServerDialog >> isValidState > Should read " + length + " bytes but only read " + lenRead + " bytes.");
                throw new IOException("Not enough bytes read for VIP.");
            }
        }
        catch (IOException ex) {
            boolean length = this.showInvalidCertificateMessage();
            return length;
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ConsoleLogger.log("VipServerDialog >> isValidState > Exception occured in closing stream handle, after loading file contents.");
            }
        }
        if (buffer == null || buffer.length == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStoreFileInvalid", new Object[]{AjaxSwingUtil.getDisplayFileName(this.pksKeysoreFilePath)}), MSG_RES.getString("VipServerDialog.title.Error"), 0);
            return false;
        }
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(buffer);
            if (!Utility.validatePfx((InputStream)inputStream, (char[])this.jpfKeyStorePassword.getPassword())) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStoreFileOrPasswordInvalid"), MSG_RES.getString("VipServerDialog.title.Error"), 0);
                boolean length = false;
                return length;
            }
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException ex) {
                ConsoleLogger.log("VipServerDialog >> isValidState > Exception occured in closing stream handle, after validating file contents.");
            }
        }
        this.data = new Hashtable();
        try {
            this.data.put("PFX", buffer);
            this.data.put("StorePass", Utility.encryptLatest((char[])this.jpfKeyStorePassword.getPassword()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStoreFileOrPasswordInvalid"), MSG_RES.getString("VipServerDialog.title.Error"), 0);
            return false;
        }
        return true;
    }

    private boolean showInvalidCertificateMessage() {
        JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("VipServerDialog.error.keyStoreFileInvalid"), MSG_RES.getString("VipServerDialog.title.Error"), 0);
        return false;
    }
}

