/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.PlatformObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.PlatformTree;
import com.sygate.scm.console.ui.util.PlatformUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class UpdatePlatformDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private PlatformTree platformTree = null;

    public UpdatePlatformDialog(ArrayList<LuSupportedClientPlatform> platforms) {
        super(Manager.getFrame(), UpdatePlatformDialog.getRes("dialog.luPlatform"), true);
        PlatformObject allPlatformObj = PlatformUtil.getTheAllPlatformObj();
        this.platformTree = new PlatformTree(allPlatformObj, platforms);
        this.initialize();
        this.setObject(platforms);
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize() {
        this.getContentPane().add((Component)new AvTemplatePane(UpdatePlatformDialog.getRes("label.platformTitle"), UpdatePlatformDialog.getRes("label.platformDesc")), "North");
        this.getContentPane().add(Box.createHorizontalStrut(20), "West");
        this.getContentPane().add((Component)this.getPlatformPane(), "Center");
        this.getContentPane().add(Box.createHorizontalStrut(20), "East");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JScrollPane getPlatformPane() {
        Box box = new Box(1);
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane pane = new JScrollPane(this.platformTree, 20, 30);
        pane.setPreferredSize(new Dimension(300, 300));
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
        pane.getViewport().setBackground(UIManager.getColor("Panel.background"));
        return pane;
    }

    public ArrayList<LuSupportedClientPlatform> getSelectedPlatforms() {
        return this.platformTree.getSelectedPlatforms();
    }

    private void setObject(ArrayList<LuSupportedClientPlatform> platforms) {
        this.platformTree.setSelectedPlatforms(platforms);
    }

    @Override
    protected boolean isValidate() {
        boolean isValidate = true;
        if (this.getSelectedPlatforms().size() < 1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdatePlatformDialog.error.MustSelectAtLeastOnePlatform"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdatePlatformDialog.error.title"), 0);
            isValidate = false;
        }
        return isValidate && super.isValidate();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_lu_change_selection_platform";
    }

    private static String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel." + key);
    }
}

