/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class TxnLogScheduleDlg
extends DialogBase {
    private static final long serialVersionUID = 4716706832216920068L;
    private TimeSpinner1 startSpinner;
    private JSpinner hourSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
    private JRadioButton hourlyButton;
    private JRadioButton dailyButton;
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private String hourPattern = Utility.getHourPatterFromTimePattern((String)this.timePattern);
    private JPanel jSchedulePanel;
    private Schedule schedule;
    private boolean readOnly;

    public TxnLogScheduleDlg(Schedule sch, boolean readOnly) {
        super(Manager.getFrame(), "", true, false);
        this.schedule = sch;
        this.readOnly = readOnly;
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "TxnLogScheduleDlg.title");
        super.setTitle(str);
        this.initialize();
        this.setModel();
        this.setReadOnlyStatus();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    @Override
    protected void commit() {
        if (this.readOnly) {
            return;
        }
        if (this.hourlyButton.isSelected()) {
            int hourValue = (Integer)this.hourSpinner.getValue();
            this.schedule.setOptFrequencyInterval(Integer.valueOf(hourValue));
            this.schedule.setOptSimpleFrequency(Integer.valueOf(0));
        } else {
            int hour = this.startSpinner.getHour();
            int minute = this.startSpinner.getMinute();
            int ampm = this.startSpinner.getAmpm();
            hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
            this.schedule.setOptSimpleFrequency(Integer.valueOf(1));
            this.schedule.setOptStartHour(Integer.toString(hour));
            this.schedule.setOptStartMinute(Integer.valueOf(minute));
        }
    }

    private String getResourceString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", key);
    }

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getSchedulePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    private JPanel getSchedulePanel() {
        this.jSchedulePanel = new JPanel(new GridBagLayout());
        JLabel lblFrequency = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "TxnLogScheduleDlg.label.frequency"));
        JLabel lblStart = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "TxnLogScheduleDlg.label.start"));
        JLabel lblHours = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "TxnLogScheduleDlg.label.hours"));
        this.hourlyButton = new JRadioButton(this.getResourceString("TxnLogScheduleDlg.radio.every"));
        this.hourlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnLogScheduleDlg.this.hourSpinner.setEnabled(TxnLogScheduleDlg.this.hourlyButton.isSelected());
                TxnLogScheduleDlg.this.startSpinner.setEnabled(!TxnLogScheduleDlg.this.hourlyButton.isSelected());
            }
        });
        UIUtilities.enableOnlyValidEdits(this.hourSpinner);
        this.dailyButton = new JRadioButton(this.getResourceString("TxnLogScheduleDlg.radio.daily"));
        this.dailyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnLogScheduleDlg.this.startSpinner.setEnabled(TxnLogScheduleDlg.this.dailyButton.isSelected());
                TxnLogScheduleDlg.this.hourSpinner.setEnabled(!TxnLogScheduleDlg.this.dailyButton.isSelected());
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hourlyButton);
        buttonGroup.add(this.dailyButton);
        this.startSpinner = new TimeSpinner1(this.timePattern);
        this.jSchedulePanel.add((Component)lblFrequency, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.jSchedulePanel.add((Component)this.hourlyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.jSchedulePanel.add((Component)this.hourSpinner, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.jSchedulePanel.add((Component)lblHours, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.jSchedulePanel.add((Component)this.dailyButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.jSchedulePanel.add((Component)this.startSpinner, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.jSchedulePanel.add((Component)lblStart, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        return this.jSchedulePanel;
    }

    private void setModel() {
        if (this.schedule.getOptSimpleFrequency() == 0) {
            this.hourSpinner.setValue(this.schedule.getOptFrequencyInterval());
            this.hourlyButton.setSelected(true);
        } else {
            boolean hasAMPM;
            this.dailyButton.setSelected(true);
            String startHour = this.schedule.getOptStartHour();
            Integer startMinute = this.schedule.getOptStartMinute();
            int hour = Integer.parseInt(startHour);
            int minute = startMinute == null ? 0 : startMinute;
            this.startSpinner.setHour(hour);
            this.startSpinner.setMinute(minute);
            boolean bl = hasAMPM = this.timePattern.indexOf("a") != -1;
            if (hasAMPM) {
                int ampm = Utility.getAmpmFrom_H_Pattern((int)Integer.parseInt(startHour), (String)this.hourPattern);
                this.startSpinner.setAmpm(ampm);
            }
        }
    }

    @Override
    protected void setReadOnlyStatus() {
        boolean freqHourly;
        boolean bl = freqHourly = this.schedule.getOptSimpleFrequency() == 0;
        if (this.startSpinner != null) {
            this.startSpinner.setEnabled(!this.readOnly && !freqHourly);
        }
        if (this.hourSpinner != null) {
            this.hourSpinner.setEnabled(!this.readOnly && freqHourly);
        }
        this.hourlyButton.setEnabled(!this.readOnly);
        this.dailyButton.setEnabled(!this.readOnly);
    }
}

