/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class TxnLogRunNowDlg
extends DialogBase {
    private static final long serialVersionUID = 2426597610791587131L;
    private static final int DLG_WIDTH = 400;
    private static final int DLG_HEIGHT = 400;
    static MessageResourcesFile myRes = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private JPanel topPanel = null;
    private JTextArea editorPane = null;

    public TxnLogRunNowDlg() {
        super(Manager.getFrame(), "", true);
        String str = myRes.getString("TxnLogRunNowDlg.title");
        super.setTitle(str);
        this.initialize();
        this.setSize(400, 400);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected String getOkButtonText() {
        return myRes.getString("TxnLogRunNowDlg.button.ok");
    }

    @Override
    protected String getCancelButtonText() {
        return myRes.getString("TxnLogRunNowDlg.button.cancel");
    }

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getTopPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    @Override
    protected boolean ok() {
        this.getEditPane().setText("");
        this.startProgressDisplay();
        this.resetOKButton(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GUIManager.truncateTxnLog();
                }
                catch (ConsoleException e) {
                    throw e;
                }
                catch (Exception e) {
                    LoggerUtilities.logException((Throwable)e);
                    throw new ConsoleException(e);
                }
                finally {
                    TxnLogRunNowDlg.this.resetOKButton(true);
                }
                return null;
            }

            @Override
            protected void done() {
            }
        };
        SwingWorkerExecutor.getInstance().execute(swingWorker);
        return true;
    }

    @Override
    protected void cancel() {
        this.stopProgressDisplay();
        super.cancel();
    }

    private JPanel getTopPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        JLabel label = new JLabel(myRes.getString("TxnLogRunNowDlg.label.execHeading"));
        this.topPanel.add((Component)label, "North");
        JScrollPane sPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sPane, (JTextArea)this.getEditPane());
        this.topPanel.add((Component)sPane, "Center");
        return this.topPanel;
    }

    private JTextArea getEditPane() {
        if (this.editorPane == null) {
            this.editorPane = new JTextArea();
            this.editorPane.setEditable(false);
        }
        return this.editorPane;
    }

    private void startProgressDisplay() {
        ServerSystemLogMonitor.getTxnLogStatusMonitor().setMonitorStartTime(TimeUtil.getServerTime());
        ServerSystemLogMonitor.getTxnLogStatusMonitor().start();
        ServerSystemLogMonitor.getTxnLogStatusMonitor().setMonitoring(true, this.getEditPane());
    }

    private void stopProgressDisplay() {
        ServerSystemLogMonitor.getTxnLogStatusMonitor().setMonitoring(false, this.getEditPane());
        ServerSystemLogMonitor.getTxnLogStatusMonitor().stop();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_truncate_transaction_log";
    }
}

