/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.TelemetryClientInstallData;
import com.sygate.scm.common.configobject.schema.TelemetryDataConfigSettings;
import com.sygate.scm.common.configobject.schema.TelemetryMetadata;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.TelemetryOptionPanel;
import com.sygate.scm.common.ui.TroubleshootingOptionPanel;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.StatPingConsole;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class TelemetryPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 3468652398905889775L;
    TelemetryOptionPanel telemetryOptionsPanel = new TelemetryOptionPanel();
    private static final MessageResourcesFile MSG_RES_UTIL = new MessageResourcesFile("com.sygate.scm.util.util");
    private TroubleshootingOptionPanel troubleshootingOptionPanel = new TroubleshootingOptionPanel();
    protected boolean readOnly;
    private SiteObject model;

    public TelemetryPanel() {
        this(false);
    }

    public TelemetryPanel(boolean readOnly) {
        this.init(readOnly);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_dc";
    }

    protected void init(boolean readOnly) {
        this.readOnly = readOnly;
        this.telemetryOptionsPanel.setBorder((Border)BorderFactory.createTitledBorder(MSG_RES_UTIL.getString("TelemetryPanel.heading")));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new VerticalFlowLayout());
        panel.add((Component)this.telemetryOptionsPanel);
        panel.add((Component)this.troubleshootingOptionPanel);
        this.add((Component)panel, "North");
        this.setReadOnly();
    }

    public void loadData(SiteObject model) {
        this.model = model;
        try {
            SemSite semSite;
            SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
            if (configRoot.getOptTelemetryMetadata() != null && configRoot.getOptTelemetryMetadata().getOptTelemetryDataConfigSettings() != null) {
                TelemetryDataConfigSettings td = configRoot.getOptTelemetryMetadata().getOptTelemetryDataConfigSettings();
                this.telemetryOptionsPanel.setTelemetryOptedIn(td.getOptInValue().booleanValue());
            }
            if ((semSite = model.getSemSite()) != null) {
                this.troubleshootingOptionPanel.setSymQualOptedIn((semSite.getOptEnableSymQual() == null ? semSite.getDefEnableSymQual() : semSite.getOptEnableSymQual()).booleanValue());
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void saveData() {
        try {
            TelemetryMetadata tm;
            boolean isOptin = this.telemetryOptionsPanel.isTelemetryOptedIn();
            SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
            if (configRoot.getOptTelemetryMetadata() == null) {
                configRoot.setOptTelemetryMetadata(new TelemetryMetadata());
            }
            if ((tm = configRoot.getOptTelemetryMetadata()).getOptTelemetryDataConfigSettings() == null) {
                tm.setOptTelemetryDataConfigSettings(new TelemetryDataConfigSettings());
                tm.getOptTelemetryDataConfigSettings().setEnableAnonymousTransfer(tm.getOptTelemetryDataConfigSettings().getDefEnableAnonymousTransfer());
                tm.getOptTelemetryDataConfigSettings().setDefaultDataCollectionInterval(tm.getOptTelemetryDataConfigSettings().getDefDefaultDataCollectionInterval());
            }
            TelemetryDataConfigSettings td = tm.getOptTelemetryDataConfigSettings();
            td.setOptInValue(Boolean.valueOf(isOptin));
            if (configRoot.getOptTelemetryClientInstallData() == null) {
                configRoot.setOptTelemetryClientInstallData(new TelemetryClientInstallData());
            }
            TelemetryClientInstallData tmc = configRoot.getOptTelemetryClientInstallData();
            tmc.setOptEnabled(Boolean.valueOf(isOptin));
            DataobjectManager.getInstance().updateSemConfigRoot("Merge", configRoot);
            StatPingConsole.getInstance().setEnabled(isOptin);
            SemSite semSite = this.model.getSemSite();
            boolean isSymQualOptIn = this.troubleshootingOptionPanel.isSymQualOptedIn();
            if (semSite != null) {
                semSite.setReadonly(false, false);
                semSite.setOptEnableSymQual(Boolean.valueOf(isSymQualOptIn));
                DataobjectManager.getInstance().updateSemSite("Merge", semSite);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (this.readOnly) {
            UIUtilities.setContainerStatus(this.telemetryOptionsPanel.getTelemetryOptIncheckBox(), false);
            UIUtilities.setContainerStatus(this.troubleshootingOptionPanel.getSymQualOptIncheckBox(), false);
        }
    }
}

