/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.CertificateUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.SmartCardStatusPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.DatatypeConverter;

public class SmartCardDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    JTextField jtfFile = new JTextField();
    JButton jbBrowse = new JButton(UIText.get(257));
    JTextField jtfCrlFile = new JTextField();
    JButton jbCrlBrowse = new JButton(UIText.get(257));
    private String filePaths = "";
    private String crlFilePaths = "";
    private final boolean inAjaxMode = AjaxSwingCommonUtil.isAjaxSwingRunning();
    private SmartCardStatusPanel smartCardStatusPanel = new SmartCardStatusPanel();
    private HashMap<Component, Boolean> componentStatus = new HashMap();
    Hashtable<String, byte[]> data = null;
    StringBuilder pemFormattedCaCerts = null;
    StringBuilder pemFormattedCrls = null;
    boolean isCancelled;

    public SmartCardDialog(boolean readOnly) {
        super(Manager.getFrame(), MSG_RES.getString("SmartCardServerDialog.title"), true, true);
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
        this.setVisible(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_configure_smartcard";
    }

    @Override
    protected void setReadOnlyStatus() {
        this.jtfFile.setEnabled(!this.readOnly && !this.inAjaxMode);
    }

    @Override
    protected void cancel() {
        this.isCancelled = true;
        super.cancel();
    }

    @Override
    protected boolean ok() {
        this.isCancelled = false;
        if (StringUtilities.isEmpty((String)this.jtfFile.getText().trim()) && StringUtilities.isEmpty((String)this.jtfCrlFile.getText().trim())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("SmartCardServerDialog.error.CertCrlFilePathCannotBeEmpty"), MSG_RES.getString("SmartCardServerDialog.title.Error"), 0);
            this.jtfFile.requestFocus();
            return false;
        }
        if (!this.validateCertFiles() || !this.validateCrlFiles()) {
            return false;
        }
        if (this.pemFormattedCaCerts == null && this.pemFormattedCrls == null) {
            return false;
        }
        this.data = new Hashtable();
        if (this.pemFormattedCaCerts != null && !StringUtilities.isEmpty((String)this.pemFormattedCaCerts.toString())) {
            this.data.put("smartCardCaCerts", this.pemFormattedCaCerts.toString().getBytes(StandardCharsets.UTF_8));
        }
        if (this.pemFormattedCrls != null && !StringUtilities.isEmpty((String)this.pemFormattedCrls.toString())) {
            this.data.put("smartCardCrls", this.pemFormattedCrls.toString().getBytes(StandardCharsets.UTF_8));
        }
        this.certChainValidationAndSave();
        return false;
    }

    void disableUiForCertValidation() {
        this.componentStatus.clear();
        this.componentStatus.put(this.jtfFile, this.jtfFile.isEnabled());
        this.componentStatus.put(this.jtfCrlFile, this.jtfCrlFile.isEnabled());
        this.componentStatus.put(this.jbBrowse, this.jbBrowse.isEnabled());
        this.componentStatus.put(this.jbCrlBrowse, this.jbCrlBrowse.isEnabled());
        this.componentStatus.put(this.jBOk, this.jBOk.isEnabled());
        this.jtfFile.setEnabled(false);
        this.jtfCrlFile.setEnabled(false);
        this.jbBrowse.setEnabled(false);
        this.jbCrlBrowse.setEnabled(false);
        this.jBOk.setEnabled(false);
    }

    void resetUiForCertValidation() {
        this.jtfFile.setEnabled(this.componentStatus.get(this.jtfFile));
        this.jtfCrlFile.setEnabled(this.componentStatus.get(this.jtfCrlFile));
        this.jbBrowse.setEnabled(this.componentStatus.get(this.jbBrowse));
        this.jbCrlBrowse.setEnabled(this.componentStatus.get(this.jbCrlBrowse));
        this.jBOk.setEnabled(this.componentStatus.get(this.jBOk));
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void validateCertChain() throws ConsoleException {
        try {
            this.disableUiForCertValidation();
            this.smartCardStatusPanel.updateStatus(SmartCardStatusPanel.Status.RUNNING);
            GUIManager.doSmartCardCertificateValidation(null, Optional.ofNullable(this.pemFormattedCaCerts).orElse(new StringBuilder()).toString());
            this.smartCardStatusPanel.updateStatus(SmartCardStatusPanel.Status.SUCCEEDED);
            Utility.threadSleep((int)2);
        }
        catch (ConsoleException ex) {
            this.smartCardStatusPanel.updateStatus(SmartCardStatusPanel.Status.FAILED);
            throw ex;
        }
    }

    public Object okWorkerConstruct() {
        this.isOk = false;
        try {
            this.validateCertChain();
            if (!this.isCancelled()) {
                GUIManager.doSmartCardPreConfiguration(this.data);
                this.isOk = true;
            } else {
                ConsoleLogger.log("SmartCardDialog >> okWorkerConstruct >> The thread is canceled!");
            }
        }
        catch (ConsoleException ex) {
            if (!this.isCancelled()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessageString(), MSG_RES.getString("SmartCardServerDialog.error.ConfigurationFailure.Title"), 0);
            } else {
                ConsoleLogger.log("SmartCardDialog >> okWorkerConstruct >> The thread is canceled!");
            }
            LoggerUtilities.logException((Throwable)ex);
        }
        return null;
    }

    public void okWorkerFinish() {
        this.resetUiForCertValidation();
        if (this.isOk()) {
            this.dispose();
        }
    }

    void certChainValidationAndSave() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return SmartCardDialog.this.okWorkerConstruct();
            }

            public void finished() {
                SmartCardDialog.this.okWorkerFinish();
            }
        };
        worker.start();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
        this.add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.jtfFile.setEnabled(!this.inAjaxMode);
        this.jtfCrlFile.setEnabled(!this.inAjaxMode);
    }

    private JPanel getInnerPanel() {
        DescriptionTextArea desc = new DescriptionTextArea(MSG_RES.getString("SmartCardServerDialog.desc"));
        desc.setColumns(60);
        JPanel panel = new JPanel(new GridBagLayout());
        int gridY = 0;
        panel.add((Component)desc, new GridBagConstraints(0, gridY, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)new JLabel(MSG_RES.getString("SmartCardServerDialog.label.file")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.jtfFile, new GridBagConstraints(0, ++gridY, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 15, 5), 0, 0));
        panel.add((Component)this.jbBrowse, new GridBagConstraints(2, gridY, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 15, 20), 0, 0));
        panel.add((Component)new JLabel(MSG_RES.getString("SmartCardServerDialog.label.crlfile.1")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSG_RES.getString("SmartCardServerDialog.label.crlfile.2")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.jtfCrlFile, new GridBagConstraints(0, ++gridY, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 15, 5), 0, 0));
        panel.add((Component)this.jbCrlBrowse, new GridBagConstraints(2, gridY, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 15, 20), 0, 0));
        ++gridY;
        HTMLEditorPane restartServicesDesc = new HTMLEditorPane();
        restartServicesDesc.setPreferredSize(new Dimension(200, 50));
        restartServicesDesc.setText(MSG_RES.getString("SmartCardServerDialog.desc.restartServices"));
        panel.add((Component)restartServicesDesc, new GridBagConstraints(0, ++gridY, 3, 1, 1.0, 0.0, 16, 2, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)this.smartCardStatusPanel, new GridBagConstraints(0, ++gridY, 3, 1, 1.0, 0.0, 16, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SmartCardDialog.this.browseCertFiles();
                SmartCardDialog.this.smartCardStatusPanel.updateStatus(SmartCardStatusPanel.Status.NONE);
            }
        });
        this.jbCrlBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SmartCardDialog.this.browseCrlFiles();
            }
        });
        return panel;
    }

    List<File> filterFiles(File[] files, Predicate<File> predicate, Consumer<File> handleExclusion) {
        ArrayList<File> selectedFiles = new ArrayList<File>();
        Arrays.asList(files).forEach(file -> {
            if (predicate.test((File)file)) {
                selectedFiles.add((File)file);
            } else {
                handleExclusion.accept((File)file);
            }
        });
        return selectedFiles;
    }

    List<File> selectCrlFiles(File[] files) {
        Predicate<File> predicate = file -> this.isCrlFile((File)file);
        Consumer<File> handleExclusion = file -> this.reportInvalidCrlFile((File)file);
        return this.filterFiles(files, predicate, handleExclusion);
    }

    List<File> selectCertFiles(File[] files) {
        Predicate<File> predicate = file -> this.isCertFile((File)file);
        Consumer<File> handleExclusion = file -> this.reportInvalidCertFile((File)file);
        return this.filterFiles(files, predicate, handleExclusion);
    }

    boolean isCrlFile(File file) {
        return file != null && (file.getName().toLowerCase().endsWith(".crl") || file.getName().toLowerCase().endsWith(".pem"));
    }

    boolean isCertFile(File file) {
        return file != null && (file.getName().toLowerCase().endsWith(".cer") || file.getName().toLowerCase().endsWith(".crt") || file.getName().toLowerCase().endsWith(".pem") || file.getName().toLowerCase().endsWith(".der"));
    }

    void reportInvalidCrlFile(File file) {
        JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("SmartCardServerDialog.error.CrlFileInvalid", new Object[]{AjaxSwingUtil.getDisplayFileName(file)}), MSG_RES.getString("SmartCardServerDialog.title.Error"), 0);
    }

    void reportInvalidCertFile(File file) {
        JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("SmartCardServerDialog.error.CertFileInvalid", new Object[]{AjaxSwingUtil.getDisplayFileName(file)}), MSG_RES.getString("SmartCardServerDialog.title.Error"), 0);
    }

    protected void browseCrlFiles() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(MSG_RES.getString("SmartCardServerDialog.title.SelectCrlFiles"));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".crl") || file.getName().toLowerCase().endsWith(".pem");
            }

            @Override
            public String getDescription() {
                return MSG_RES.getString("SmartCardServerDialog.CrlFileDesc");
            }
        });
        if (0 == fileChooser.showOpenDialog(Manager.getFrame())) {
            File[] files = fileChooser.getSelectedFiles();
            List<File> selectedFiles = this.selectCrlFiles(files);
            this.crlFilePaths = selectedFiles.stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining(", "));
            this.jtfCrlFile.setText(selectedFiles.stream().map(file -> AjaxSwingUtil.getDisplayFileName(file)).collect(Collectors.joining(", ")));
        }
    }

    protected void browseCertFiles() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(MSG_RES.getString("SmartCardServerDialog.title.SelectCertFiles"));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".crt") || file.getName().toLowerCase().endsWith(".cer") || file.getName().toLowerCase().endsWith(".pem") || file.getName().toLowerCase().endsWith(".der");
            }

            @Override
            public String getDescription() {
                return MSG_RES.getString("SmartCardServerDialog.CertFileDesc");
            }
        });
        if (0 == fileChooser.showOpenDialog(Manager.getFrame())) {
            File[] files = fileChooser.getSelectedFiles();
            List<File> selectedFiles = this.selectCertFiles(files);
            this.filePaths = selectedFiles.stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining(", "));
            this.jtfFile.setText(selectedFiles.stream().map(file -> AjaxSwingUtil.getDisplayFileName(file)).collect(Collectors.joining(", ")));
        }
    }

    String getCertFilePaths() {
        if (this.inAjaxMode) {
            return this.filePaths.trim();
        }
        return this.jtfFile.getText().trim();
    }

    private boolean validateCertFiles() {
        List<String> caCertFilePathList;
        String caCertsFilePath = this.getCertFilePaths();
        if (!StringUtilities.isEmpty((String)caCertsFilePath) && (caCertFilePathList = Arrays.asList(caCertsFilePath.split(","))) != null && !caCertFilePathList.isEmpty()) {
            String certFilePath = null;
            this.pemFormattedCaCerts = new StringBuilder();
            try {
                for (int i = 0; i < caCertFilePathList.size(); ++i) {
                    certFilePath = caCertFilePathList.get(i).trim();
                    Set certsFromPem = CertificateUtil.getX509certsFromFile((String)certFilePath);
                    for (X509Certificate certificate : certsFromPem) {
                        certificate.checkValidity();
                        this.pemFormattedCaCerts.append(CertificateUtil.x509CertToPem((X509Certificate)certificate));
                    }
                }
            }
            catch (Throwable t1) {
                LoggerUtilities.logException((Throwable)t1);
                return this.showInvalidCertificateMessage(certFilePath);
            }
        }
        return true;
    }

    String getCrlFilePaths() {
        if (this.inAjaxMode) {
            return this.crlFilePaths.trim();
        }
        return this.jtfCrlFile.getText().trim();
    }

    private boolean validateCrlFiles() {
        List<String> crlFilePathList;
        String crlsFilePath = this.getCrlFilePaths();
        if (!StringUtilities.isEmpty((String)crlsFilePath) && (crlFilePathList = Arrays.asList(crlsFilePath.split(","))) != null && !crlFilePathList.isEmpty()) {
            String crlFilePath = null;
            this.pemFormattedCrls = new StringBuilder();
            try {
                for (int i = 0; i < crlFilePathList.size(); ++i) {
                    crlFilePath = crlFilePathList.get(i).trim();
                    Set<X509CRL> crlsFromPem = this.getX509crlsFromFile(crlFilePath);
                    for (X509CRL crl : crlsFromPem) {
                        this.pemFormattedCrls.append(this.x509CrlToPem(crl));
                    }
                }
            }
            catch (Throwable t1) {
                LoggerUtilities.logException((Throwable)t1);
                return this.showInvalidCrlMessage(crlFilePath);
            }
        }
        return true;
    }

    private String x509CrlToPem(X509CRL crl) throws CRLException {
        StringWriter sw = new StringWriter();
        sw.write("-----BEGIN X509 CRL-----\n");
        sw.write(DatatypeConverter.printBase64Binary((byte[])crl.getEncoded()).replaceAll("(.{64})", "$1\n"));
        sw.write("\n-----END X509 CRL-----\n");
        return sw.toString();
    }

    private boolean showInvalidCertificateMessage(String fileName) {
        System.out.println("the invalid file is " + fileName);
        JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("SmartCardServerDialog.error.CertFileInvalid", new Object[]{fileName}), MSG_RES.getString("SmartCardServerDialog.error.ConfigurationFailure.Title"), 0);
        return false;
    }

    private boolean showInvalidCrlMessage(String fileName) {
        System.out.println("the invalid file is " + fileName);
        JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("SmartCardServerDialog.error.CrlFileInvalid", new Object[]{fileName}), MSG_RES.getString("SmartCardServerDialog.title.Error"), 0);
        return false;
    }

    private Set<X509CRL> getX509crlsFromFile(String crlFilePath) throws IOException, CRLException, CertificateException {
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        byte[] array = Files.readAllBytes(new File(crlFilePath).toPath());
        Object var4_4 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(array);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends CRL> collection = cf.generateCRLs(is);
            for (X509CRL x509CRL : collection) {
                crls.add(x509CRL);
            }
        }
        return crls;
    }
}

