/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.server.dlg.ServerSecurityPanel;
import com.sygate.scm.console.ui.server.dlg.SiteGeneralPanel;
import com.sygate.scm.console.ui.server.dlg.SiteInsightServerPanel;
import com.sygate.scm.console.ui.server.dlg.SiteLuPanel;
import com.sygate.scm.console.ui.server.dlg.TelemetryPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class SitePropertiesDlg
extends DialogBase {
    private static final long serialVersionUID = 6122670831863702975L;
    private final JTabbedPane jTabPane = new JTabbedPane();
    private SiteGeneralPanel generalPanel = null;
    private SiteLuPanel luPanel = null;
    private ServerSecurityPanel securityPanel = null;
    private TelemetryPanel telemetryPanel = null;
    private SiteInsightServerPanel siteInsightServerPanel = null;
    private SiteObject model = null;
    private JScrollPane luScrollabelPanel = null;

    public SitePropertiesDlg(SiteObject siteObject, boolean readOnly) {
        super(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.SitePropsFor"), siteObject), true);
        this.readOnly = readOnly;
        this.initialize();
        this.setModel(siteObject);
        UiUtilities.centerComponent((Component)this);
        this.setReadOnly(readOnly);
        this.pack();
        this.setReadOnlyStatus();
        this.setVisible(true);
    }

    public SiteObject getModel() {
        return this.model;
    }

    @Override
    public boolean isValidate() {
        if (!this.generalPanel.isValidate()) {
            return false;
        }
        if (!this.luPanel.isValidate()) {
            this.jTabPane.setSelectedComponent(this.luPanel);
            return false;
        }
        return this.siteInsightServerPanel.isValidate();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.jTabPane.getSelectedComponent());
    }

    @Override
    protected void commit() {
        this.generalPanel.updateModel();
        this.luPanel.updateModel();
        if (AdminObject.retrieveCurrentAdminObject().isSysAdmin()) {
            this.securityPanel.updateModel();
        }
        this.telemetryPanel.saveData();
        this.siteInsightServerPanel.updateModel();
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.generalPanel, this.luPanel, this.securityPanel, this.telemetryPanel, this.siteInsightServerPanel};
    }

    private void initialize() {
        this.generalPanel = new SiteGeneralPanel(this.readOnly);
        this.luPanel = new SiteLuPanel(this.readOnly, this);
        this.securityPanel = new ServerSecurityPanel(true);
        this.telemetryPanel = new TelemetryPanel(this.readOnly);
        this.jTabPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.General"), this.generalPanel);
        this.luScrollabelPanel = UIUtilities.createScrollPaneWithoutBoard(this.luPanel);
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.LiveUpdate"), this.luScrollabelPanel);
        if (AdminObject.retrieveCurrentAdminObject().isSysAdmin()) {
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SecurityPanel.title.Security"), this.securityPanel);
        }
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.Telemetry"), this.telemetryPanel);
        this.siteInsightServerPanel = new SiteInsightServerPanel();
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.PrivateInsightServer"), this.siteInsightServerPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jTabPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private void setModel(SiteObject model) {
        this.model = model;
        this.generalPanel.setModel(model);
        this.luPanel.setModel(model);
        this.telemetryPanel.loadData(model);
        this.siteInsightServerPanel.setModel(model);
    }
}

