/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.LuCategories;
import com.sygate.scm.common.configobject.schema.LuCategory;
import com.sygate.scm.common.configobject.schema.LuConfig;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelection;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelections;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatforms;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LuConfigObject;
import com.sygate.scm.console.logicobject.LuSupportLanguageObj;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.LuCategoryPanel;
import com.sygate.scm.console.ui.policy.lu.LuContentSizeSelectionPanel;
import com.sygate.scm.console.ui.policy.lu.LuServerPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.lu.SchedulePanel;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.server.dlg.UpdatePlatformDialog;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.PlatformTree;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.DateUtilities;
import com.sygate.scm.util.FiltersUtility;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SiteLuPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 5991664184717377256L;
    private static final int MINUTE = 60;
    private static String SYMANTEC_SERVER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.label.defaultServer");
    private static String SPECIFIED_SERVER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.label.specifiedServer");
    private static String EAS_SERVER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.label.earlyAdopterServer");
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private JScrollPane jspContent;
    private DefaultListModel<String> contentModel;
    private JList<String> contentList;
    private JButton changeContentButton;
    private ArrayList<LuSupportedClientPlatform> platforms = new ArrayList();
    private JButton scheduleButton;
    private JButton platformButton;
    private JButton sizeButton;
    private JLabel currentSchedule;
    private HtmlEnabledJLabel currentPlatform;
    private HtmlEnabledJLabel contentSizeLabel;
    private DefaultListModel<LuSupportLanguageObj> languageModel;
    private JList<LuSupportLanguageObj> languageList;
    private JButton changeLanguageButton;
    private JLabel currentServer;
    private JButton sourceButton;
    private LuConfigObject luConfig;
    private LuDownloadSchedule luSchedule;
    private Vector<LuCategory> luTypes;
    private LuContentSourceInfo luSource;
    private List<LuCategoryPanel> categoryPanelList = new ArrayList<LuCategoryPanel>();
    private JTextField numRevision = new JTextField(new NumberPlainDocument(1L, ScmProperties.getMaxContentRevisionAllowed(), true), String.valueOf(new LuConfig(false).getDefNumberOfRevisions()), 4);
    private JComboBox<String> dayBox;
    private List<LuCategory> unLicensedTypes;
    private SemSite currentSite;
    private boolean readOnly;
    private JDialog parent;

    public SiteLuPanel(JDialog parent) {
        this(false, parent);
    }

    public SiteLuPanel(boolean readOnly, JDialog parent) {
        this.numRevision.setMinimumSize(new Dimension(45, 25));
        this.numRevision.setPreferredSize(new Dimension(45, 25));
        this.unLicensedTypes = new ArrayList<LuCategory>();
        this.readOnly = readOnly;
        this.parent = parent;
        this.initialize();
        this.setReadOnlyStatus();
    }

    public void updateModel() {
        this.luConfig.saveContentTypes(this.luTypes, this.unLicensedTypes);
        this.luConfig.saveLanguages(this.languageModel);
        this.saveSource();
        this.saveDiskSpaceManagement();
        this.savePlatform();
        this.luConfig.setOptLuDownloadSchedule(this.luSchedule);
    }

    public void updateSite() {
        this.luConfig.setOptLuDownloadSchedule(this.luSchedule);
    }

    private boolean validateRevisions() {
        boolean isValid = true;
        String revisionAsString = this.numRevision.getText().trim();
        String companySizeAsString = ScmProperties.get("scm.companysize", Integer.toString(0));
        int revisions = 0;
        int companySize = 0;
        int maxRevisionsAllowed = ScmProperties.getMaxContentRevisionAllowed();
        try {
            revisions = Integer.parseInt(revisionAsString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            companySize = Integer.parseInt(companySizeAsString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (revisions <= 0 || revisions > maxRevisionsAllowed) {
            String msgFormat = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.error.InvalidRevisions");
            String msg = MessageFormat.format(msgFormat, maxRevisionsAllowed);
            JOptionPane.showMessageDialog(this, msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Error"), 0);
            isValid = false;
        } else {
            Integer origRevisions;
            Integer n = origRevisions = this.luConfig.getOptNumberOfRevisions() == null ? this.luConfig.getDefNumberOfRevisions() : this.luConfig.getOptNumberOfRevisions();
            if (revisions < origRevisions) {
                int compareRevision = 12;
                if (companySize == 0 || companySize == 1) {
                    compareRevision = 42;
                }
                if (revisions < compareRevision && 0 != JOptionPane.showConfirmDialog(this, SiteLuPanel.getRes("warning.NumContentRevisionWarning"), SiteLuPanel.getRes("title.Warning"), 0)) {
                    this.numRevision.requestFocus();
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    List<LuSupportedClientPlatform> getPlatforms() {
        return this.platforms;
    }

    private static String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel." + key);
    }

    private void saveSource() {
    }

    private void savePlatform() {
        LuSupportedClientPlatforms newPlatforms = new LuSupportedClientPlatforms();
        this.platforms.stream().filter(platform -> !"Linux-ARM64".equalsIgnoreCase(platform.getContent())).forEach(arg_0 -> ((LuSupportedClientPlatforms)newPlatforms).addLuSupportedClientPlatform(arg_0));
        if (newPlatforms.getLuSupportedClientPlatform().stream().anyMatch(platform -> "Linux".equalsIgnoreCase(platform.getContent()))) {
            LuSupportedClientPlatform linuxArm = new LuSupportedClientPlatform();
            linuxArm.setContent("Linux-ARM64");
            newPlatforms.addLuSupportedClientPlatform(linuxArm);
        }
        this.setLuSupportedClientPlatformsFromModel(newPlatforms);
    }

    private void updateDiskSpaceManagement() {
        Boolean bExtractFullPackage = this.luConfig.getOptExtractFullPackage();
        if (bExtractFullPackage == null) {
            this.luConfig.setOptExtractFullPackage(true);
        }
        if (this.luConfig.getOptNumberOfRevisions() == null) {
            this.numRevision.setText(String.valueOf(this.luConfig.getDefNumberOfRevisions()));
            this.luConfig.setOptNumberOfRevisions(this.luConfig.getDefNumberOfRevisions());
        } else {
            this.numRevision.setText(String.valueOf(this.luConfig.getOptNumberOfRevisions()));
        }
    }

    private void updateContentSizePanel(List<LuContentSizeSelection> sizeList) {
        StringBuffer contentSizeBuffer = new StringBuffer("");
        int size = sizeList.size();
        contentSizeBuffer.append("<html>");
        if (size > 0) {
            for (int i = 0; i < sizeList.size(); ++i) {
                LuContentSizeSelection contentSizeSelection = sizeList.get(i);
                String reducedSizeSDS = SiteLuPanel.getRes("contentSize.label.ReducedSDS") + "<br>";
                String stdSizeSDS = SiteLuPanel.getRes("contentSize.label.StandardSDS") + "<br>";
                int contentSize = contentSizeSelection.getOptDownloadSize();
                if ((contentSize & 1) == 1) {
                    contentSizeBuffer.append(reducedSizeSDS);
                }
                if ((contentSize & 2) != 2) continue;
                contentSizeBuffer.append(stdSizeSDS);
            }
        } else {
            LuContentSizeSelection contentSize = new LuContentSizeSelection();
            contentSize.setOptCategoryName("AV_DEFS");
            contentSize.setOptDownloadSize(Integer.valueOf(3));
            LuContentSizeSelections luContentSizeSelections = this.luConfig.getOptLuContentSizeSelections();
            luContentSizeSelections.addLuContentSizeSelection(contentSize);
            this.luConfig.setOptLuContentSizeSelections(luContentSizeSelections);
            contentSizeBuffer.append(SiteLuPanel.getRes("contentSize.label.ReducedSDS") + "<br>");
            contentSizeBuffer.append(SiteLuPanel.getRes("contentSize.label.StandardSDS") + "<br>");
        }
        contentSizeBuffer.append("</html>");
        this.contentSizeLabel.setText(contentSizeBuffer.toString());
    }

    private void saveDiskSpaceManagement() {
        if (!StringUtilities.isEmpty((String)this.numRevision.getText())) {
            this.luConfig.setOptNumberOfRevisions(Integer.valueOf(this.numRevision.getText().trim()));
        } else {
            this.luConfig.setOptNumberOfRevisions(this.luConfig.getDefNumberOfRevisions());
        }
    }

    private String getDisplayName(String type) {
        for (LuCategoryPanel lu : this.categoryPanelList) {
            if (!lu.getType().equals(type)) continue;
            return lu.getDisplayName();
        }
        return type;
    }

    private void updateContentTypes() {
        this.contentModel.removeAllElements();
        for (LuCategory oneType : this.luTypes) {
            if ("DEC_ABI".equals(oneType.getCategoryName()) || oneType.getCategoryName().equals("SYN_APPS") || oneType.getCategoryName().equals("SESM_CONTENT_CATALOG") || oneType.getCategoryName().equals("SEPM_API") || oneType.getCategoryName().equals("SEPM_METADATA")) continue;
            this.contentModel.addElement(this.getDisplayName(oneType.getCategoryName()));
        }
        this.jspContent.setPreferredSize(new Dimension(this.contentList.getPreferredSize().width + 30, 60));
    }

    protected DefaultListModel<String> getContentModel() {
        return this.contentModel;
    }

    private void updateLanguages(List<LuSupportLanguage> languageList) {
        this.languageModel.removeAllElements();
        for (LuSupportLanguage language : languageList) {
            this.languageModel.addElement(new LuSupportLanguageObj(language));
        }
    }

    private void updateSource() {
        LuContentSourceInfoObject obj = new LuContentSourceInfoObject(this.luSource);
        if (LuContentSourceInfo.SYMANTEC.compareTo(obj.getLiveUpdateServerType()) == 0) {
            this.currentServer.setText(SYMANTEC_SERVER);
        } else if (LuContentSourceInfo.INTERNAL.compareTo(obj.getLiveUpdateServerType()) == 0) {
            this.currentServer.setText(SPECIFIED_SERVER);
        } else {
            this.currentServer.setText(EAS_SERVER);
        }
    }

    private void updatePanel() {
        this.updateSchedulePanel();
        this.updateContentTypes();
        this.updateLanguages(this.luConfig.getLuSupportLanguage());
        this.updatePlatformsPanel(this.getLuSupportedClientPlatformsFromModel().getLuSupportedClientPlatform());
        this.updateSource();
        this.updateDiskSpaceManagement();
        this.updateContentSizePanel(this.getLuContentSizeSelectionsFromModel().getLuContentSizeSelection());
        if (this.parent != null) {
            this.parent.pack();
        }
    }

    private void updatePlatformsPanel(List<LuSupportedClientPlatform> clientPlatforms) {
        this.platforms.clear();
        StringBuffer platformContent = new StringBuffer("");
        int size = clientPlatforms.size();
        platformContent.append("<html>");
        if (size > 0) {
            Collections.sort(clientPlatforms, new PlatformTree.PlatformComparator());
            for (int i = 0; i < clientPlatforms.size(); ++i) {
                LuSupportedClientPlatform platform = clientPlatforms.get(i);
                this.platforms.add(platform);
                if ("Linux-ARM64".equalsIgnoreCase(platform.getContent())) continue;
                platformContent.append(SiteLuPanel.getRes("label." + platform.getContent().toLowerCase()) + "<br>");
            }
        } else {
            platformContent.append(SiteLuPanel.getRes("label.NonePlatform"));
        }
        platformContent.append("</html>");
        this.currentPlatform.setText(platformContent.toString());
    }

    private void initialize() {
        this.initializeDayComboBox();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "Center");
    }

    private void initializeDayComboBox() {
        String[] day = new String[7];
        int iFirstDay = Calendar.getInstance().getFirstDayOfWeek() - 1;
        for (int i = 0; i < 7; ++i) {
            day[i] = SchedulePanel.getDayByIndex((iFirstDay + i) % 7);
        }
        this.dayBox = new JComboBox<String>(day);
    }

    private void initComponents() {
        this.contentModel = new DefaultListModel();
        this.contentList = new JList<String>(this.contentModel);
        this.contentList.setEnabled(false);
        this.changeContentButton = new JButton(SiteLuPanel.getRes("button.changeSelection"));
        this.changeContentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateSelectDialog usd = new UpdateSelectDialog(SiteLuPanel.getRes("label.updateTypes"), SiteLuPanel.this.readOnly);
                usd.setSelectedTypes(SiteLuPanel.this.luTypes);
                usd.setVisible(true);
                if (usd.isOk()) {
                    SiteLuPanel.this.luTypes = new Vector<LuCategory>(usd.getSelectedTypes());
                    SiteLuPanel.this.categoryPanelList = usd.getCategoryPanels();
                    SiteLuPanel.this.updateContentTypes();
                    if (SiteLuPanel.this.parent != null) {
                        SiteLuPanel.this.parent.pack();
                    }
                }
            }
        });
        this.languageModel = new DefaultListModel();
        this.languageList = new JList<LuSupportLanguageObj>(this.languageModel);
        this.languageList.setEnabled(false);
        this.changeLanguageButton = new JButton(SiteLuPanel.getRes("button.changeSelection"));
        this.changeLanguageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Enumeration luSupportLanguageObjs = (Enumeration)Cast.cast(SiteLuPanel.this.languageModel.elements());
                UpdataLanguageDialog dlg = new UpdataLanguageDialog(luSupportLanguageObjs);
                if (dlg.isOk()) {
                    SiteLuPanel.this.updateLanguages(dlg.getSelectedLanguageList());
                }
            }
        });
        this.scheduleButton = new JButton(SiteLuPanel.getRes("button.editSchedule"));
        this.scheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateScheduleDialog scheduleDlg = new UpdateScheduleDialog(SiteLuPanel.getRes("label.downloadSched"));
                if (scheduleDlg.isOk()) {
                    SiteLuPanel.this.updateSchedulePanel();
                }
            }
        });
        this.platformButton = new JButton(SiteLuPanel.getRes("button.editPlatform"));
        this.platformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatePlatformDialog platformDlg = new UpdatePlatformDialog(SiteLuPanel.this.platforms);
                platformDlg.setVisible(true);
                if (platformDlg.isOk()) {
                    SiteLuPanel.this.updatePlatformsPanel(platformDlg.getSelectedPlatforms());
                    if (SiteLuPanel.this.parent != null) {
                        SiteLuPanel.this.parent.pack();
                    }
                }
            }
        });
        this.currentSchedule = new JLabel();
        this.currentPlatform = new HtmlEnabledJLabel();
        this.contentSizeLabel = new HtmlEnabledJLabel();
        this.sizeButton = new JButton(SiteLuPanel.getRes("button.changeSelection"));
        this.sizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateContentSizeDialog contentSizeDlg = new UpdateContentSizeDialog(SiteLuPanel.this.getLuContentSizeSelectionsFromModel().getLuContentSizeSelection());
                if (contentSizeDlg.isOk()) {
                    Vector<LuContentSizeSelection> contentSizeSelectionList = contentSizeDlg.getContentSizeSelections();
                    SiteLuPanel.this.updateContentSizePanel(contentSizeSelectionList);
                    SiteLuPanel.this.updateContentSizeSelectionsInModel(contentSizeSelectionList);
                    if (SiteLuPanel.this.parent != null) {
                        SiteLuPanel.this.parent.pack();
                    }
                }
            }
        });
        this.sourceButton = new JButton(SiteLuPanel.getRes("button.sourceServers"));
        this.sourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSelectDialog ssd = new ServerSelectDialog(SiteLuPanel.getRes("label.luServers"), SiteLuPanel.this.readOnly);
                ssd.setObject(SiteLuPanel.this.luSource);
                ssd.setVisible(true);
                if (ssd.isOk()) {
                    SiteLuPanel.this.luSource = ssd.getObject();
                    SiteLuPanel.this.updateSource();
                }
            }
        });
        this.currentServer = new JLabel(SYMANTEC_SERVER);
        UIUtilities.fitJComponent(new JComponent[]{this.sourceButton, this.changeLanguageButton, this.platformButton, this.scheduleButton, this.changeContentButton, this.sizeButton});
    }

    private void updateSchedulePanel() {
        Integer i = this.luSchedule.getOptFrequency();
        if (i == null) {
            i = this.luSchedule.getDefFrequency();
        }
        if (i.equals(LuDownloadSchedule.HOURLY)) {
            Integer interval = this.luSchedule.getOptFrequencyInterval();
            if (interval == null) {
                interval = this.luSchedule.getDefFrequencyInterval();
            }
            Object[] obj = new Object[]{interval / 60};
            String str = SiteLuPanel.getRes("label.DowloadSchedule_" + i);
            String fm = MessageFormat.format(str, obj);
            this.currentSchedule.setText(fm);
        } else {
            this.currentSchedule.setText(SiteLuPanel.getRes("label.DowloadSchedule_" + i));
        }
    }

    private JPanel getInnerPanel() {
        this.initComponents();
        JPanel panel = new JPanel(new VerticalFlowLayout());
        JPanel jContentSelectPanel = this.getContentSelectPanel();
        JPanel jContentSizePanel = this.getContentSizePanel();
        JPanel jLanguageSelectPanel = this.getLanguageSelectPanel();
        JPanel jSourceServerPanel = this.getSourceServerPanel();
        JPanel jDiskSpaceManagementPanel = this.getDiskSpaceManagementPanel();
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add(jSourceServerPanel);
            panel.add(jDiskSpaceManagementPanel);
        }
        panel.add(this.getDownloadSchedulePanel());
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add(this.getPlatformSelectPanel());
            panel.add(jContentSelectPanel);
            if (!LicenseObject.getInstance().isSNACOnlyProduct()) {
                panel.add(jContentSizePanel);
            }
            panel.add(jLanguageSelectPanel);
        }
        return panel;
    }

    private JPanel getDownloadSchedulePanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout(10, 0));
        p.add((Component)this.currentSchedule, "West");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.scheduleButton, "North");
        p.add((Component)temp, "East");
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)p, "Center");
        result.setBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.downloadSched")));
        return result;
    }

    private JPanel getContentSelectPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JPanel p = new JPanel(new BorderLayout(10, 0));
        this.jspContent = new JScrollPane(this.contentList, 20, 31);
        this.jspContent.setPreferredSize(new Dimension(10, 60));
        p.add((Component)this.jspContent, "Center");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.changeContentButton, "North");
        p.add((Component)temp, "East");
        result.add((Component)new JLabel(SiteLuPanel.getRes("label.definitionDesc")), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 1, 1), 0, 0));
        result.add((Component)p, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 1, 1), 0, 0));
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.downloadTypes")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        return result;
    }

    private JPanel getContentSizePanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.contentSizeLabel, "West");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.sizeButton, "North");
        p.add((Component)temp, "East");
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)p, "Center");
        result.setBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.contentSize")));
        return result;
    }

    private JPanel getPlatformSelectPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.currentPlatform, "West");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.platformButton, "North");
        p.add((Component)temp, "East");
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)p, "Center");
        result.setBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.platformTitle")));
        return result;
    }

    private JPanel getLanguageSelectPanel() {
        JPanel p = new JPanel(new BorderLayout(10, 0));
        JScrollPane jsp = new JScrollPane(this.languageList);
        jsp.setPreferredSize(new Dimension(10, 60));
        p.add((Component)jsp, "Center");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.changeLanguageButton, "North");
        p.add((Component)temp, "East");
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)new JLabel(SiteLuPanel.getRes("label.languagesDesc")), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 0, 1, 1), 0, 0));
        result.add((Component)p, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 1, 1), 0, 0));
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.languages")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        return result;
    }

    private JPanel getSourceServerPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.currentServer, "West");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.sourceButton, "North");
        p.add((Component)temp, "East");
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)p, "Center");
        result.setBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.luSource")));
        return result;
    }

    private JPanel getDiskSpaceManagementPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(SiteLuPanel.getRes("label.NumContentRevision")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 1, 1), 0, 0));
        this.numRevision.setHorizontalAlignment(4);
        p.add((Component)this.numRevision, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 1, 1), 0, 0));
        JLabel iconLabel = new JLabel("");
        iconLabel.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconWarning.png"))));
        p.add((Component)iconLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 1), 0, 0));
        p.add((Component)this.getJTextArea(SiteLuPanel.getRes("warning.NumContentRevisionText")), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 40, 1, 1), 0, 0));
        result.add((Component)p, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 1, 1), 0, 0));
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SiteLuPanel.getRes("label.DiskSpaceTitle")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        return result;
    }

    private JTextArea getJTextArea(String text) {
        JTextArea jTextArea = new JTextArea(text);
        jTextArea.setEditable(false);
        jTextArea.setColumns(75);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setAlignmentX(0.0f);
        return jTextArea;
    }

    private void cacheUnLicencedTypes(Vector<LuCategory> allTypesFromDB, Vector<LuCategory> licensedTypesFromDB) {
        this.unLicensedTypes.clear();
        if (allTypesFromDB != null) {
            int allTypesFromDbCount = allTypesFromDB.size();
            for (int index = 0; index < allTypesFromDbCount; ++index) {
                LuCategory categoryFromDB = allTypesFromDB.get(index);
                if (licensedTypesFromDB.contains(categoryFromDB)) continue;
                this.unLicensedTypes.add(categoryFromDB);
            }
        }
    }

    public void setModel(SiteObject model) {
        this.setSemSite(model.getSemSite());
    }

    public void setSemSite(SemSite site) {
        this.currentSite = site;
        this.luConfig = new LuConfigObject(this.currentSite);
        LuDownloadSchedule schedule = this.luConfig.getOptLuDownloadSchedule();
        if (schedule != null) {
            try {
                this.luSchedule = (LuDownloadSchedule)PolicyHandler.getCopyOfObj((ConfigObject)schedule);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        } else {
            this.luSchedule = new LuDownloadSchedule();
        }
        LuCategories luCategories = this.luConfig.getOptLuCategories();
        Vector luTypesfromDB = null;
        if (luCategories != null) {
            luTypesfromDB = luCategories.getLuCategory();
        }
        this.luTypes = LuUtility.getSupportedLuContentTypesForEdit(luTypesfromDB);
        this.cacheUnLicencedTypes(luTypesfromDB, this.luTypes);
        for (LuContentCategory cat : LuUtility.getAllLuCategories(true)) {
            this.categoryPanelList.add(new LuCategoryPanel(cat, true));
        }
        this.luSource = this.luConfig.getOptLuContentSourceInfo();
        if (this.luSource == null) {
            this.luSource = new LuContentSourceInfo();
        }
        this.updatePanel();
    }

    public boolean isValidate() {
        return this.validateRevisions();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_lu";
    }

    public void setReadOnlyStatus() {
        this.scheduleButton.setEnabled(!this.readOnly);
        this.platformButton.setEnabled(!this.readOnly);
        this.changeContentButton.setEnabled(!this.readOnly);
        this.changeLanguageButton.setEnabled(!this.readOnly);
        this.sourceButton.setEnabled(!this.readOnly);
        this.numRevision.setEnabled(!this.readOnly);
        this.sizeButton.setEnabled(!this.readOnly);
    }

    void setLuSupportedClientPlatformsFromModel(LuSupportedClientPlatforms platforms) {
        this.luConfig.setOptLuSupportedClientPlatforms(platforms);
    }

    LuSupportedClientPlatforms getLuSupportedClientPlatformsFromModel() {
        LuSupportedClientPlatforms luPlatforms = this.luConfig.getOptLuSupportedClientPlatforms();
        if (luPlatforms == null) {
            luPlatforms = new LuSupportedClientPlatforms();
            this.luConfig.setOptLuSupportedClientPlatforms(luPlatforms);
        }
        return luPlatforms;
    }

    private LuContentSizeSelections getLuContentSizeSelectionsFromModel() {
        LuContentSizeSelections luContentSizeSelections = this.luConfig.getOptLuContentSizeSelections();
        if (luContentSizeSelections == null) {
            luContentSizeSelections = new LuContentSizeSelections();
            this.luConfig.setOptLuContentSizeSelections(luContentSizeSelections);
        }
        return luContentSizeSelections;
    }

    private void updateContentSizeSelectionsInModel(Vector<LuContentSizeSelection> contentSizeSelectionList) {
        LuContentSizeSelections luContentSizeSelections = new LuContentSizeSelections();
        for (LuContentSizeSelection contentSizeSelection : contentSizeSelectionList) {
            LuContentSizeSelection luContentSizeSelection = new LuContentSizeSelection();
            luContentSizeSelection.setOptCategoryName(contentSizeSelection.getOptCategoryName());
            luContentSizeSelection.setOptDownloadSize(contentSizeSelection.getOptDownloadSize());
            luContentSizeSelections.addLuContentSizeSelection(luContentSizeSelection);
        }
        this.luConfig.setOptLuContentSizeSelections(luContentSizeSelections);
    }

    private static class LanguageComparator
    implements Comparator<LuSupportLanguage>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LanguageComparator() {
        }

        @Override
        public int compare(LuSupportLanguage o1, LuSupportLanguage o2) {
            return o1.getContent().compareTo(o2.getContent());
        }
    }

    private static class UpdateContentSizeDialog
    extends DialogBase {
        private static final long serialVersionUID = -3208289482156209088L;
        private LuContentSizeSelectionPanel contentSizePanel;

        public UpdateContentSizeDialog(Vector<LuContentSizeSelection> contentSizeSelections) {
            super(Manager.getFrame(), SiteLuPanel.getRes("dialog.luContentSize"), true);
            this.initialize(contentSizeSelections);
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        public Vector<LuContentSizeSelection> getContentSizeSelections() {
            return this.contentSizePanel.getContentSizeSelections();
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_site_properties_lu_contentsize";
        }

        private JPanel getContentSizeSelectionPanel() {
            JPanel result = new JPanel();
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)this.contentSizePanel, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(p);
            return result;
        }

        private void initialize(Vector<LuContentSizeSelection> contentSizeSelections) {
            this.contentSizePanel = new LuContentSizeSelectionPanel(contentSizeSelections);
            String contentSizeDesc = SiteLuPanel.getRes("label.contentSizeDesc");
            String contentSizeWarning = SiteLuPanel.getRes("label.contentSizeWarning");
            String panelDesc = contentSizeDesc + contentSizeWarning;
            this.getContentPane().add((Component)new AvTemplatePane(SiteLuPanel.getRes("label.contentSize"), panelDesc), "North");
            this.getContentPane().add(Box.createHorizontalStrut(20), "East");
            this.getContentPane().add((Component)this.getContentSizeSelectionPanel(), "West");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.pack();
        }

        @Override
        protected boolean isValidate() {
            boolean isValidate = true;
            if (this.getContentSizeSelections().get(0).getOptDownloadSize() == 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdatePlatformDialog.error.MustSelectAtLeastOneContentSize"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdatePlatformDialog.error.title"), 0);
                isValidate = false;
            }
            return isValidate && super.isValidate();
        }
    }

    private static class UpdataLanguageDialog
    extends DialogBase {
        private static final long serialVersionUID = -3208289482156209088L;
        private List<LuSupportLanguage> list = LuUtility.getAllLuLanguages();
        private DefaultListModel<LuSupportLanguageObj> listLanguages = new DefaultListModel();
        private JList<LuSupportLanguageObj> jLiLanguages = new JList<LuSupportLanguageObj>(this.listLanguages);
        private String strEnglish = "English";

        public UpdataLanguageDialog(Enumeration<LuSupportLanguageObj> selLanguageList) {
            super(Manager.getFrame(), SiteLuPanel.getRes("dialog.luLanguage"), true);
            this.initialize();
            this.setObject(selLanguageList);
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_site_properties_lu_change_selection_language";
        }

        private void initialize() {
            this.getContentPane().add((Component)new AvTemplatePane(SiteLuPanel.getRes("label.languageTitle"), SiteLuPanel.getRes("label.languageDesc")), "North");
            this.getContentPane().add(Box.createHorizontalStrut(20), "West");
            this.getContentPane().add((Component)this.getLanguagePane(), "Center");
            this.getContentPane().add(Box.createHorizontalStrut(20), "East");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.jLiLanguages.setCellRenderer(new CustomListCellRenderer());
            this.pack();
        }

        private JScrollPane getLanguagePane() {
            Box box = new Box(1);
            box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Collections.sort(this.list, new LanguageComparator());
            for (int i = 0; i < this.list.size(); ++i) {
                this.listLanguages.addElement(new LuSupportLanguageObj(this.list.get(i)));
            }
            JScrollPane pane = new JScrollPane(this.jLiLanguages, 20, 30);
            pane.setPreferredSize(new Dimension(300, 300));
            pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            pane.getViewport().setBackground(UIManager.getColor("Panel.background"));
            return pane;
        }

        private void setObject(Enumeration<LuSupportLanguageObj> selLanguageList) {
            ArrayList<LuSupportLanguageObj> list = new ArrayList<LuSupportLanguageObj>();
            while (selLanguageList.hasMoreElements()) {
                list.add(selLanguageList.nextElement());
            }
            int[] arrSelected = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                LuSupportLanguageObj obj = (LuSupportLanguageObj)list.get(i);
                for (int j = 0; j < this.listLanguages.size(); ++j) {
                    LuSupportLanguageObj language = this.listLanguages.elementAt(j);
                    if (!obj.getLanguage().getContent().equals(language.getLanguage().getContent())) continue;
                    arrSelected[i] = j;
                }
            }
            this.jLiLanguages.setSelectedIndices(arrSelected);
        }

        @Override
        public boolean isResizable() {
            return true;
        }

        public List<LuSupportLanguage> getSelectedLanguageList() {
            int[] indices;
            ArrayList<LuSupportLanguage> list = new ArrayList<LuSupportLanguage>();
            for (int index : indices = this.jLiLanguages.getSelectedIndices()) {
                list.add(this.listLanguages.get(index).getLanguage());
            }
            for (int i = 0; i < this.listLanguages.size(); ++i) {
                LuSupportLanguageObj langObj = this.listLanguages.get(i);
                if (!this.strEnglish.equals(langObj.getLanguage().getContent())) continue;
                if (list.contains(langObj.getLanguage())) break;
                list.add(langObj.getLanguage());
                break;
            }
            Collections.sort(list, new LanguageComparator());
            return list;
        }

        private class CustomListCellRenderer
        extends JLabel
        implements ListCellRenderer<Object> {
            private static final long serialVersionUID = 1L;

            public CustomListCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String strEntry = ((LuSupportLanguageObj)value).toString();
                this.setText(strEntry);
                boolean isEnglish = UpdataLanguageDialog.this.strEnglish.equals(((LuSupportLanguageObj)value).getLanguage().getContent());
                this.setEnabled(!isEnglish);
                if (isSelected || isEnglish) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.repaint();
                return this;
            }
        }
    }

    private static class UpdateSelectDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private Map<String, LuCategoryPanel> updateTypes;
        private JPanel contentPane = null;

        public UpdateSelectDialog(String title, boolean readOnly) {
            super(title, true, true, true, readOnly);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_site_properties_lu_change_selection";
        }

        @Override
        protected JPanel getContentPanel() {
            if (this.contentPane == null) {
                this.setupComponents();
                this.contentPane = new JPanel(new BorderLayout());
                AvTemplatePane avp = new AvTemplatePane(this.getRes("label.typeTitle"), this.getRes("label.typeDesc"));
                JPanel p = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 21;
                c.fill = 2;
                c.insets = new Insets(5, 0, 0, 0);
                int i = 0;
                for (LuCategoryPanel cp : this.updateTypes.values()) {
                    if ("DEC_ABI".equals(cp.getType()) || "SYN_APPS".equals(cp.getType())) continue;
                    c.gridx = 0;
                    c.gridy = i++;
                    p.add((Component)cp, c);
                }
                JPanel temp = new JPanel(new BorderLayout());
                temp.add((Component)p, "Before");
                avp.add(temp);
                this.contentPane.add((Component)avp, "Center");
            }
            return this.contentPane;
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdateSelectDialog." + key);
        }

        private void setupComponents() {
            this.updateTypes = new LinkedHashMap<String, LuCategoryPanel>();
            List<LuContentCategory> categories = LuUtility.getAllLuCategories(true);
            for (LuContentCategory cat : categories) {
                String name = cat.getName();
                this.updateTypes.put(name, new LuCategoryPanel(cat, true));
            }
        }

        public List<LuCategoryPanel> getCategoryPanels() {
            ArrayList<LuCategoryPanel> result = new ArrayList<LuCategoryPanel>();
            for (LuCategoryPanel cp : this.updateTypes.values()) {
                if (!cp.getSelected()) continue;
                result.add(cp);
            }
            return result;
        }

        public List<LuCategory> getSelectedTypes() {
            ArrayList<LuCategory> result = new ArrayList<LuCategory>();
            for (LuCategoryPanel cp : this.updateTypes.values()) {
                if (!cp.getSelected()) continue;
                LuCategory type = new LuCategory();
                type.setCategoryName(cp.getType());
                type.setOptFilters(FiltersUtility.getFilters((String)cp.getType()));
                if ("DEC_ABI".equals(cp.getType()) || "SYN_APPS".equals(cp.getType())) continue;
                result.add(type);
            }
            return result;
        }

        public void setSelectedTypes(List<LuCategory> types) {
            LuCategoryPanel clientUpdatePanel;
            for (LuCategory category : types) {
                LuCategoryPanel cp = this.updateTypes.get(category.getCategoryName());
                if (cp == null) continue;
                cp.setSelected(true);
            }
            if (Utility.isTrialVersion() && (clientUpdatePanel = this.updateTypes.get("CLIENT_UPDATE")) != null) {
                clientUpdatePanel.setSelected(false);
                clientUpdatePanel.setReadOnly(false);
            }
        }

        @Override
        protected boolean isValidate() {
            boolean isValidate = true;
            if (this.getSelectedTypes().size() < 1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdatePlatformDialog.error.MustSelectAtLeastOneContentType"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "UpdatePlatformDialog.error.title"), 0);
                isValidate = false;
            }
            return isValidate && super.isValidate();
        }
    }

    private class UpdateScheduleDialog
    extends DialogBase {
        private static final long serialVersionUID = 1448516414449214010L;
        private JButton downloadNowButton;
        private JRadioButton min15Button;
        private JRadioButton hourlyButton;
        private JRadioButton dailyButton;
        private JRadioButton weeklyButton;
        private JSpinner hourSpinner;
        private JCheckBox specifyTimeRangeBox;
        private TimeSpinner1 startSpinner;
        private TimeSpinner1 endSpinner;
        private boolean hasHour;
        private boolean hasMinute;
        private boolean hasSecond;
        private boolean hasAmpm;
        private String hourPattern;
        private JCheckBox retryBox;
        private JSpinner retryIntervalSpinner;
        private JLabel lbRetryWindow;
        private JSpinner retryWindowSpinner;
        private JLabel lbStartTime;
        private JLabel lbEndTime;
        private JLabel lbEvery;

        public UpdateScheduleDialog(String title) {
            super(Manager.getFrame(), title, true);
            this.hourSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
            this.specifyTimeRangeBox = new JCheckBox();
            this.initializeComponents();
            this.updateSchedule();
            this.initializeUI();
            UiUtilities.centerComponent((Component)this);
            this.enableAppropriate(true);
            this.pack();
            this.setVisible(true);
        }

        private void initializeComponents() {
            this.downloadNowButton = new JButton(SiteLuPanel.getRes("button.runNow"));
            this.downloadNowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        GUIManager.runLuNow();
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                    }
                    JOptionPane.showMessageDialog(Manager.getFrame(), SiteLuPanel.getRes("label.luLaunched"));
                }
            });
            this.lbStartTime = new JLabel(SiteLuPanel.getRes("label.start"));
            this.lbEndTime = new JLabel(SiteLuPanel.getRes("label.end"));
            this.lbEvery = new JLabel(SiteLuPanel.getRes("label.every"));
            this.min15Button = new JRadioButton(SiteLuPanel.getRes("button.continuously"));
            this.min15Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateScheduleDialog.this.enableAppropriate();
                }
            });
            this.hourlyButton = new JRadioButton(SiteLuPanel.getRes("button.hourlyFrequency"));
            this.hourlyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateScheduleDialog.this.enableAppropriate();
                }
            });
            UIUtilities.enableOnlyValidEdits(this.hourSpinner);
            this.hourSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UpdateScheduleDialog.this.updateRetryWindowAndInterval();
                }
            });
            this.dailyButton = new JRadioButton(SiteLuPanel.getRes("button.daily"));
            this.dailyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateScheduleDialog.this.specifyTimeRangeBox.setSelected(true);
                    UpdateScheduleDialog.this.enableAppropriate();
                }
            });
            this.weeklyButton = new JRadioButton(SiteLuPanel.getRes("button.weekly"));
            this.weeklyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateScheduleDialog.this.specifyTimeRangeBox.setSelected(true);
                    UpdateScheduleDialog.this.enableAppropriate();
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.min15Button);
            buttonGroup.add(this.hourlyButton);
            buttonGroup.add(this.dailyButton);
            buttonGroup.add(this.weeklyButton);
            this.specifyTimeRangeBox = new JCheckBox(SiteLuPanel.getRes("box.downloadWindow"));
            this.specifyTimeRangeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.error.starttimeShouldBeSet"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Error"), 0);
                        UpdateScheduleDialog.this.specifyTimeRangeBox.setSelected(true);
                    } else {
                        UpdateScheduleDialog.this.enableAppropriate(false);
                    }
                }
            });
            this.startSpinner = new TimeSpinner1(SiteLuPanel.this.timePattern);
            this.endSpinner = new TimeSpinner1(SiteLuPanel.this.timePattern);
            if (SiteLuPanel.this.timePattern.indexOf("h") != -1) {
                this.hourPattern = "h";
                this.hasHour = true;
            }
            if (SiteLuPanel.this.timePattern.indexOf("H") != -1) {
                this.hourPattern = "H";
                this.hasHour = true;
            }
            if (SiteLuPanel.this.timePattern.indexOf("k") != -1) {
                this.hourPattern = "k";
                this.hasHour = true;
            }
            if (SiteLuPanel.this.timePattern.indexOf("K") != -1) {
                this.hourPattern = "K";
                this.hasHour = true;
            }
            if (SiteLuPanel.this.timePattern.indexOf("m") != -1) {
                this.hasMinute = true;
            }
            if (SiteLuPanel.this.timePattern.indexOf("s") != -1) {
                this.hasSecond = true;
            }
            if (SiteLuPanel.this.timePattern.indexOf("a") != -1) {
                this.hasAmpm = true;
            }
            this.retryBox = new JCheckBox(SiteLuPanel.getRes("box.retryIntervalMins"));
            this.retryBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateScheduleDialog.this.enableAppropriate();
                }
            });
            SpinnerNumberModel model = new SpinnerNumberModel(15, 15, 60, 15);
            this.retryIntervalSpinner = new JSpinner(model);
            this.retryIntervalSpinner.setPreferredSize(new Dimension(50, this.retryIntervalSpinner.getHeight()));
            UIUtilities.enableOnlyValidEdits(this.retryIntervalSpinner);
            this.lbRetryWindow = new JLabel(SiteLuPanel.getRes("label.retryWindowHours"));
            model = new SpinnerNumberModel(1, 1, 24, 1);
            this.retryWindowSpinner = new JSpinner(model);
            this.retryWindowSpinner.setPreferredSize(new Dimension(50, this.retryWindowSpinner.getHeight()));
            UIUtilities.enableOnlyValidEdits(this.retryWindowSpinner);
            this.retryWindowSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UpdateScheduleDialog.this.updateRetryInterval();
                }
            });
        }

        private void enableAppropriate() {
            this.enableAppropriate(false);
        }

        private void updateSchedule() {
            Integer i = SiteLuPanel.this.luSchedule.getOptFrequency();
            if (i == null) {
                i = SiteLuPanel.this.luSchedule.getDefFrequency();
            }
            if (i.equals(LuDownloadSchedule.CONTINUOUS)) {
                this.min15Button.setSelected(true);
            } else if (i.equals(LuDownloadSchedule.HOURLY)) {
                this.hourlyButton.setSelected(true);
            } else if (i.equals(LuDownloadSchedule.WEEKLY)) {
                this.weeklyButton.setSelected(true);
            } else {
                this.dailyButton.setSelected(true);
            }
            Integer hourly = SiteLuPanel.this.luSchedule.getDefFrequencyInterval();
            if (SiteLuPanel.this.luSchedule.getOptFrequencyInterval() != null) {
                hourly = SiteLuPanel.this.luSchedule.getOptFrequencyInterval();
            }
            this.hourSpinner.setValue(hourly / 60);
            Boolean b = SiteLuPanel.this.luSchedule.getOptSpecifyTimeRange();
            if (b == null) {
                b = Boolean.TRUE;
            }
            this.specifyTimeRangeBox.setSelected(b);
            int hour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
            int minute = 0;
            int second = 0;
            int ampm = 0;
            Long stTime = SiteLuPanel.this.luSchedule.getOptStartTime();
            if (stTime != null) {
                int startTime = stTime.intValue();
                int hourOfDay = startTime / 3600;
                if (this.hasAmpm) {
                    ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
                }
                if (this.hasHour) {
                    hour = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
                }
                if (this.hasMinute) {
                    minute = (startTime - hourOfDay * 3600) / 60;
                }
                if (this.hasSecond) {
                    second = startTime - hourOfDay * 3600 - minute * 60;
                }
            }
            this.startSpinner.setHour(hour);
            this.startSpinner.setMinute(minute);
            this.startSpinner.setSecond(second);
            if (this.hasAmpm) {
                this.startSpinner.setAmpm(ampm);
            }
            hour = Utility.convertHourFrom_H_Pattern((int)23, (String)this.hourPattern);
            minute = 59;
            second = 0;
            ampm = 1;
            Long edTime = SiteLuPanel.this.luSchedule.getOptEndTime();
            if (edTime != null) {
                int endTime = edTime.intValue();
                int hourOfDay = endTime / 3600;
                if (this.hasAmpm) {
                    ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
                }
                if (this.hasHour) {
                    hour = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
                }
                if (this.hasMinute) {
                    minute = (endTime - hourOfDay * 3600) / 60;
                }
                if (this.hasSecond) {
                    second = endTime - hourOfDay * 3600 - minute * 60;
                }
            }
            this.endSpinner.setHour(hour);
            this.endSpinner.setMinute(minute);
            this.endSpinner.setSecond(second);
            if (this.hasAmpm) {
                this.endSpinner.setAmpm(ampm);
            }
            if ((i = SiteLuPanel.this.luSchedule.getOptDayOfWeek()) == null) {
                i = 2;
            }
            SiteLuPanel.this.dayBox.setSelectedIndex((i - Calendar.getInstance().getFirstDayOfWeek() + 1 + 7) % 7);
            b = SiteLuPanel.this.luSchedule.getOptAllowRetry();
            if (b == null) {
                b = SiteLuPanel.this.luSchedule.getDefAllowRetry();
            }
            this.retryBox.setSelected(b);
        }

        private void enableAppropriate(boolean setRetry) {
            if (this.readOnly) {
                return;
            }
            this.hourSpinner.setEnabled(this.hourlyButton.isSelected());
            this.specifyTimeRangeBox.setEnabled(!this.min15Button.isSelected() && !this.hourlyButton.isSelected());
            this.lbStartTime.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
            this.startSpinner.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
            this.lbEndTime.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
            this.endSpinner.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
            this.lbEvery.setEnabled(this.specifyTimeRangeBox.isSelected() && this.weeklyButton.isSelected());
            SiteLuPanel.this.dayBox.setEnabled(this.specifyTimeRangeBox.isSelected() && this.weeklyButton.isSelected());
            this.retryBox.setEnabled(!this.min15Button.isSelected());
            this.retryIntervalSpinner.setEnabled(this.retryBox.isSelected() && !this.min15Button.isSelected());
            this.lbRetryWindow.setEnabled(!this.min15Button.isSelected());
            this.retryWindowSpinner.setEnabled(this.retryBox.isSelected() && !this.min15Button.isSelected());
            this.min15Button.requestFocus();
            if (!this.min15Button.isSelected()) {
                if (this.hourlyButton.isSelected()) {
                    this.retryBox.setText(SiteLuPanel.getRes("box.retryIntervalMins"));
                    this.lbRetryWindow.setText(SiteLuPanel.getRes("label.retryWindowHours"));
                    this.hourlyButton.requestFocus();
                } else if (this.dailyButton.isSelected()) {
                    this.retryBox.setText(SiteLuPanel.getRes("box.retryIntervalMins"));
                    this.lbRetryWindow.setText(SiteLuPanel.getRes("label.retryWindowHours"));
                    this.dailyButton.requestFocus();
                } else if (this.weeklyButton.isSelected()) {
                    this.retryBox.setText(SiteLuPanel.getRes("box.retryIntervalHours"));
                    this.lbRetryWindow.setText(SiteLuPanel.getRes("label.retryWindowDays"));
                    this.weeklyButton.requestFocus();
                }
                this.updateRetryWindowAndInterval();
                if (setRetry && this.retryBox.isSelected()) {
                    Integer retryInterval = SiteLuPanel.this.luSchedule.getOptRetryInterval();
                    if (retryInterval == null) {
                        retryInterval = SiteLuPanel.this.luSchedule.getDefRetryInterval();
                    }
                    if (this.weeklyButton.isSelected()) {
                        retryInterval = retryInterval / 60;
                    }
                    this.retryIntervalSpinner.setValue(retryInterval);
                    Integer retryWindow = SiteLuPanel.this.luSchedule.getOptRetryWindow();
                    if (retryWindow == null) {
                        retryWindow = SiteLuPanel.this.luSchedule.getDefRetryWindow();
                    }
                    if (this.weeklyButton.isSelected()) {
                        retryWindow = retryWindow / 24;
                    }
                    this.retryWindowSpinner.setValue(retryWindow);
                }
            }
        }

        private long calculateSecondsForTimeSpinner(TimeSpinner1 spinner) {
            if (spinner == null) {
                return 0L;
            }
            int hour = 0;
            int minute = 0;
            int second = 0;
            int ampm = -1;
            if (this.hasHour) {
                hour = spinner.getHour();
                if (this.hasAmpm) {
                    ampm = spinner.getAmpm();
                }
                hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
            }
            if (this.hasMinute) {
                minute = spinner.getMinute();
            }
            if (this.hasSecond) {
                second = spinner.getSecond();
            }
            return (long)hour * 3600L + (long)(minute * 60) + (long)second;
        }

        private long getStartTime() {
            return this.calculateSecondsForTimeSpinner(this.startSpinner);
        }

        private long getEndTime() {
            long endTime;
            long startTime = this.calculateSecondsForTimeSpinner(this.startSpinner);
            if (startTime > (endTime = this.calculateSecondsForTimeSpinner(this.endSpinner))) {
                endTime += 86400L;
            }
            return endTime;
        }

        @Override
        protected boolean isValidate() {
            if (!this.specifyTimeRangeBox.isSelected() || this.min15Button.isSelected() || this.hourlyButton.isSelected()) {
                return true;
            }
            boolean isValid = true;
            int LUTaskTicket = 2;
            long startTime = this.getStartTime();
            long endTime = this.getEndTime();
            if (endTime - startTime < (long)(LUTaskTicket * 60)) {
                Object[] obj = new Object[]{Integer.toString(LUTaskTicket)};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.error.InvalidTimeWindow");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Error"), 0);
                isValid = false;
            }
            return isValid;
        }

        @Override
        protected void commit() {
            int newDayOfWeek;
            int newFrequency;
            int originalDayOfWeek;
            int originalFrequency;
            boolean isChanged = false;
            int originalHour = 240;
            int newHour = 240;
            int n = originalFrequency = SiteLuPanel.this.luSchedule.getOptFrequency() == null ? SiteLuPanel.this.luSchedule.getDefFrequency().intValue() : SiteLuPanel.this.luSchedule.getOptFrequency().intValue();
            if (originalFrequency == LuDownloadSchedule.HOURLY) {
                originalHour = SiteLuPanel.this.luSchedule.getOptFrequencyInterval() == null ? 240 : SiteLuPanel.this.luSchedule.getOptFrequencyInterval();
            }
            boolean originalSpecifyTimeRange = SiteLuPanel.this.luSchedule.getOptSpecifyTimeRange() == null ? false : SiteLuPanel.this.luSchedule.getOptSpecifyTimeRange();
            long originalStartTime = SiteLuPanel.this.luSchedule.getOptStartTime() == null ? 0L : SiteLuPanel.this.luSchedule.getOptStartTime();
            long originalEndTime = SiteLuPanel.this.luSchedule.getOptEndTime() == null ? 0L : SiteLuPanel.this.luSchedule.getOptEndTime();
            int n2 = originalDayOfWeek = SiteLuPanel.this.luSchedule.getOptDayOfWeek() == null ? 0 : SiteLuPanel.this.luSchedule.getOptDayOfWeek();
            if (this.min15Button.isSelected()) {
                SiteLuPanel.this.luSchedule.setOptFrequency(LuDownloadSchedule.CONTINUOUS);
            } else if (this.hourlyButton.isSelected()) {
                Integer hour = (Integer)this.hourSpinner.getValue() * 60;
                SiteLuPanel.this.luSchedule.setOptFrequency(LuDownloadSchedule.HOURLY);
                SiteLuPanel.this.luSchedule.setOptFrequencyInterval(hour);
            } else if (this.weeklyButton.isSelected()) {
                SiteLuPanel.this.luSchedule.setOptFrequency(LuDownloadSchedule.WEEKLY);
            } else {
                SiteLuPanel.this.luSchedule.setOptFrequency(LuDownloadSchedule.DAILY);
            }
            SiteLuPanel.this.luSchedule.setOptSpecifyTimeRange(Boolean.valueOf(this.specifyTimeRangeBox.isSelected()));
            if (this.specifyTimeRangeBox.isSelected()) {
                SiteLuPanel.this.luSchedule.setOptStartTime(Long.valueOf(this.getStartTime()));
                SiteLuPanel.this.luSchedule.setOptEndTime(Long.valueOf(this.getEndTime()));
            }
            SiteLuPanel.this.luSchedule.setOptDayOfWeek(Integer.valueOf((SiteLuPanel.this.dayBox.getSelectedIndex() + Calendar.getInstance().getFirstDayOfWeek() - 1) % 7));
            SiteLuPanel.this.luSchedule.setOptAllowRetry(Boolean.valueOf(this.retryBox.isSelected()));
            if (this.retryBox.isSelected()) {
                Integer retryInterval = (Integer)this.retryIntervalSpinner.getValue();
                Integer retryWindow = (Integer)this.retryWindowSpinner.getValue();
                if (this.weeklyButton.isSelected()) {
                    retryInterval = retryInterval * 60;
                    retryWindow = retryWindow * 24;
                }
                SiteLuPanel.this.luSchedule.setOptRetryInterval(retryInterval);
                SiteLuPanel.this.luSchedule.setOptRetryWindow(retryWindow);
            }
            int n3 = newFrequency = SiteLuPanel.this.luSchedule.getOptFrequency() != null ? SiteLuPanel.this.luSchedule.getOptFrequency().intValue() : SiteLuPanel.this.luSchedule.getDefFrequency().intValue();
            if (newFrequency == LuDownloadSchedule.HOURLY) {
                newHour = SiteLuPanel.this.luSchedule.getOptFrequencyInterval() != null ? SiteLuPanel.this.luSchedule.getOptFrequencyInterval() : 240;
            }
            boolean newSpecifyTimeRange = SiteLuPanel.this.luSchedule.getOptSpecifyTimeRange() != null ? SiteLuPanel.this.luSchedule.getOptSpecifyTimeRange() : false;
            long newStartTime = SiteLuPanel.this.luSchedule.getOptStartTime() != null ? SiteLuPanel.this.luSchedule.getOptStartTime() : 0L;
            long newEndTime = SiteLuPanel.this.luSchedule.getOptEndTime() != null ? SiteLuPanel.this.luSchedule.getOptEndTime() : 0L;
            int n4 = newDayOfWeek = SiteLuPanel.this.luSchedule.getOptDayOfWeek() != null ? SiteLuPanel.this.luSchedule.getOptDayOfWeek() : 0;
            if (originalFrequency != newFrequency) {
                isChanged = true;
            } else if (newFrequency != LuDownloadSchedule.CONTINUOUS) {
                if (newFrequency == LuDownloadSchedule.HOURLY) {
                    if (originalHour != newHour) {
                        isChanged = true;
                    }
                } else if (newFrequency == LuDownloadSchedule.DAILY || newFrequency == LuDownloadSchedule.WEEKLY) {
                    if (originalSpecifyTimeRange != newSpecifyTimeRange) {
                        isChanged = true;
                    } else if (newSpecifyTimeRange) {
                        if (originalStartTime != newStartTime || originalEndTime != newEndTime) {
                            isChanged = true;
                        }
                        if (newFrequency == LuDownloadSchedule.WEEKLY && originalDayOfWeek != newDayOfWeek) {
                            isChanged = true;
                        }
                    }
                }
            }
            if (isChanged && newEndTime >= 86400L) {
                if (newFrequency == LuDownloadSchedule.DAILY) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    String strStart = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newStartTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                    String strEnd = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newEndTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.info.accrossDay.daily");
                    msg = MessageFormat.format(msg, strStart, strEnd);
                    MultiLineMsgBox.show(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Info"), msg, 50, 1, -1);
                } else if (newFrequency == LuDownloadSchedule.WEEKLY) {
                    int iDay = SiteLuPanel.this.dayBox.getSelectedIndex();
                    String strDay = SiteLuPanel.this.dayBox.getSelectedItem().toString();
                    int dayBoxItemCount = SiteLuPanel.this.dayBox.getItemCount();
                    String strNextDay = "0";
                    if (dayBoxItemCount > 0) {
                        strNextDay = SiteLuPanel.this.dayBox.getItemAt((iDay + 1) % dayBoxItemCount);
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    String strStart = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newStartTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                    String strEnd = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newEndTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.info.accrossDay.weekly");
                    msg = MessageFormat.format(msg, strDay, strStart, strNextDay, strEnd);
                    MultiLineMsgBox.show(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Info"), msg, 50, 1, -1);
                }
            }
            SiteLuPanel.this.luSchedule.setOptIsChangedByConsole(Boolean.valueOf(isChanged));
        }

        private void initializeUI() {
            this.getContentPane().add((Component)new AvTemplatePane(SiteLuPanel.getRes("label.downloadSched"), SiteLuPanel.getRes("label.downloadDesc")), "North");
            this.getContentPane().add(Box.createHorizontalStrut(20), "West");
            this.getContentPane().add((Component)this.getContentPanel(), "Center");
            this.getContentPane().add(Box.createHorizontalStrut(20), "East");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.pack();
        }

        private void updateRetryWindowAndInterval() {
            int curRetryWindow = (Integer)this.retryWindowSpinner.getValue();
            int maxRetryWindow = 24;
            if (this.weeklyButton.isSelected()) {
                maxRetryWindow = 7;
                if (curRetryWindow > 7) {
                    curRetryWindow = 7;
                }
            } else if (this.dailyButton.isSelected()) {
                maxRetryWindow = 24;
            } else if (this.hourlyButton.isSelected()) {
                int hourFreq;
                maxRetryWindow = hourFreq = ((Integer)this.hourSpinner.getValue()).intValue();
                if (curRetryWindow > hourFreq) {
                    curRetryWindow = hourFreq;
                }
            }
            this.retryWindowSpinner.setModel(new SpinnerNumberModel(curRetryWindow, 1, maxRetryWindow, 1));
            this.updateRetryInterval();
        }

        private void updateRetryInterval() {
            int curRetryWindow = (Integer)this.retryWindowSpinner.getValue();
            int curRetryInterval = (Integer)this.retryIntervalSpinner.getValue();
            int maxRetryInterval = 0;
            if (this.weeklyButton.isSelected()) {
                maxRetryInterval = curRetryWindow == 1 ? 12 : 24;
                if (curRetryInterval > maxRetryInterval) {
                    curRetryInterval = maxRetryInterval;
                }
                if (curRetryInterval < 1) {
                    curRetryInterval = 1;
                }
                this.retryIntervalSpinner.setModel(new SpinnerNumberModel(curRetryInterval, 1, maxRetryInterval, 1));
            } else {
                maxRetryInterval = curRetryWindow == 1 ? 30 : 60;
                if (curRetryInterval > maxRetryInterval) {
                    curRetryInterval = maxRetryInterval;
                }
                if (curRetryInterval < 60 && curRetryInterval > 45) {
                    curRetryInterval = 60;
                }
                if (curRetryInterval < 45 && curRetryInterval > 30) {
                    curRetryInterval = 45;
                }
                if (curRetryInterval < 30 && curRetryInterval > 15) {
                    curRetryInterval = 30;
                }
                if (curRetryInterval < 15 && curRetryInterval > 0) {
                    curRetryInterval = 15;
                }
                this.retryIntervalSpinner.setModel(new SpinnerNumberModel(curRetryInterval, 15, maxRetryInterval, 15));
            }
        }

        protected JPanel getContentPanel() {
            JPanel result = new JPanel(new GridBagLayout());
            JPanel p = new JPanel(new GridBagLayout());
            JPanel freqPanel = new JPanel(new GridBagLayout());
            freqPanel.add((Component)new JLabel(SiteLuPanel.getRes("label.frequency")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0));
            freqPanel.add((Component)this.min15Button, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 0, 1, 10), 0, 0));
            freqPanel.add((Component)this.hourlyButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 1, 1), 0, 0));
            freqPanel.add((Component)this.hourSpinner, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 0), 0, 0));
            freqPanel.add((Component)new JLabel(SiteLuPanel.getRes("label.hourlyFrequency")), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 5, 1, 0), 0, 0));
            freqPanel.add((Component)this.dailyButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 1, 10), 0, 0));
            freqPanel.add((Component)this.weeklyButton, new GridBagConstraints(6, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 1, 1), 0, 0));
            p.add((Component)freqPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 0, new Insets(1, 0, 1, 1), 0, 0));
            p.add((Component)this.specifyTimeRangeBox, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(1, 20, 1, 1), 0, 0));
            this.specifyTimeRangeBox.setVisible(false);
            JPanel timeRangePanel = new JPanel(new GridBagLayout());
            timeRangePanel.add((Component)this.lbStartTime, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 45, 1, 1), 0, 0));
            timeRangePanel.add((Component)this.startSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 10), 0, 0));
            timeRangePanel.add((Component)this.lbEndTime, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 10, 1, 1), 0, 0));
            timeRangePanel.add((Component)this.endSpinner, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 10), 0, 0));
            timeRangePanel.add((Component)this.lbEvery, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 10, 1, 1), 0, 0));
            timeRangePanel.add(SiteLuPanel.this.dayBox, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 0, 1, 10), 0, 0));
            p.add((Component)timeRangePanel, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 1, 1), 0, 0));
            JPanel retryPanel = new JPanel(new GridBagLayout());
            retryPanel.add((Component)this.retryBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 1), 0, 0));
            retryPanel.add((Component)this.retryIntervalSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 0, 1, 1), 0, 0));
            retryPanel.add((Component)this.lbRetryWindow, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 22, 1, 1), 0, 0));
            retryPanel.add((Component)this.retryWindowSpinner, new GridBagConstraints(3, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 1, 1), 0, 0));
            p.add((Component)retryPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, -10, 1, 1), 0, 0));
            result.add((Component)p, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 1, 1), 0, 0));
            return result;
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_site_properties_lu_change_schedule";
        }
    }

    private static class ServerSelectDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private LuContentSourceInfoObject info;
        private LuServerPanel serverPanel;

        public ServerSelectDialog(String title, boolean readOnly) {
            super(title, true, true, true, readOnly);
        }

        @Override
        protected boolean isValidate() {
            return this.serverPanel.isValidate();
        }

        @Override
        protected void commit() {
            if (this.isValidate()) {
                this.serverPanel.save();
            }
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_site_properties_lu_edit_server";
        }

        @Override
        protected JPanel getContentPanel() {
            this.setupComponents();
            AvTemplatePane result = new AvTemplatePane(this.getRes("label.serverTitle"), this.getRes("label.serverDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)this.serverPanel, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(temp);
            return result;
        }

        private void updatePanel() {
            this.serverPanel.setObject(this.info);
        }

        private void setupComponents() {
            this.serverPanel = new LuServerPanel();
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSelectDialog." + key);
        }

        public LuContentSourceInfo getObject() {
            return this.info.getSchemaObject();
        }

        public void setObject(LuContentSourceInfo info) {
            this.info = new LuContentSourceInfoObject(info);
            this.updatePanel();
        }
    }
}

