/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SiteInsightServerPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -2056492869872044845L;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MAX_STRING_COUNT = 60;
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTP_PREFIX = "http://";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String[] PROTOCOLS = new String[]{"https://", "http://"};
    private final JTextArea description = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.label.Description"), false, true);
    private final JTextField jTFName = new JTextField(new RestrictedPlainDocument(256), "", 3);
    private final JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(1024), "", 4, 0);
    private final JLabel name = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.label.Name"));
    private final JLabel desc = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.label.Desc"));
    private final JLabel serverAddrLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.lable.SvrAddr"));
    private final JLabel portLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.lable.SvrPort"));
    private final JTextField jTFAddress = new JTextField(new RestrictedPlainDocument(255), "", 30);
    private final JTextField jTFPort = new JTextField(new NumberPlainDocument(1L, 65535L, true), "", 5);
    private final JCheckBox jCbxEnabled = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.checkbox.Enabled"));
    private final JComboBox<String> jCmbProtocols = new JComboBox<String>(PROTOCOLS);
    private SiteObject model;

    public SiteInsightServerPanel() {
        this.initialize();
    }

    public void setModel(SiteObject model) {
        this.model = model;
        SemSite semSite = model.getSemSite();
        PrivateInsightServer insightServer = semSite.getOptPrivateInsightServer();
        if (insightServer == null) {
            this.changePrivateInsightServerStatus(false);
            return;
        }
        if (null != insightServer.getOptEnable()) {
            this.jCbxEnabled.setSelected(insightServer.getOptEnable());
        }
        this.jTFName.setText(insightServer.getName());
        this.jTADesc.setText(insightServer.getOptDescription());
        this.jTADesc.setCaretPosition(0);
        String serverAddress = insightServer.getAddress();
        if (serverAddress.startsWith(HTTP_PREFIX)) {
            serverAddress = serverAddress.substring(HTTP_PREFIX.length());
        }
        if (serverAddress.startsWith(HTTPS_PREFIX)) {
            serverAddress = serverAddress.substring(HTTPS_PREFIX.length());
        }
        this.jTFAddress.setText(serverAddress);
        if (insightServer.getOptProtocol().equals(PrivateInsightServer.HTTP)) {
            this.jCmbProtocols.setSelectedItem(HTTP_PREFIX);
        }
        if (insightServer.getOptProtocol().equals(PrivateInsightServer.HTTPS)) {
            this.jCmbProtocols.setSelectedItem(HTTPS_PREFIX);
        }
        this.jTFPort.setText(insightServer.getPort().toString());
        boolean value = this.jCbxEnabled.isSelected();
        this.changePrivateInsightServerStatus(value);
    }

    public void updateModel() {
        boolean changed;
        SemSite semSite = this.model.getSemSite();
        PrivateInsightServer insightServer = semSite.getOptPrivateInsightServer();
        if (insightServer == null) {
            insightServer = new PrivateInsightServer();
        }
        if (changed = this.isChanged(insightServer)) {
            int port;
            block8: {
                insightServer.setOptEnable(Boolean.valueOf(this.jCbxEnabled.isSelected()));
                insightServer.setName(this.jTFName.getText().trim());
                insightServer.setOptDescription(this.jTADesc.getText().trim());
                port = 80;
                try {
                    port = Integer.parseInt(this.jTFPort.getText().trim());
                }
                catch (NumberFormatException ev) {
                    if (!this.jCmbProtocols.getSelectedItem().equals(HTTPS_PREFIX)) break block8;
                    port = 443;
                }
            }
            insightServer.setPort(Integer.valueOf(port));
            insightServer.setOptHttpsVerifyCA(Boolean.valueOf(false));
            String serverAddress = null;
            if (this.jCmbProtocols.getSelectedItem().equals(HTTP_PREFIX)) {
                insightServer.setOptProtocol(PrivateInsightServer.HTTP);
            } else {
                insightServer.setOptProtocol(PrivateInsightServer.HTTPS);
            }
            serverAddress = this.jCmbProtocols.getSelectedItem() + this.jTFAddress.getText().trim();
            insightServer.setAddress(serverAddress);
            semSite.setOptPrivateInsightServer(insightServer);
            try {
                DataobjectManager.getInstance().updateSemSite("Merge", semSite);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }

    private boolean isChanged(PrivateInsightServer insightServer) {
        boolean result = true;
        if (null != insightServer.getOptEnable()) {
            boolean value = insightServer.getOptEnable();
            if (this.jCbxEnabled.isSelected() == value) {
                result = false;
            } else {
                result = true;
                return result;
            }
        }
        if (!this.jTFName.getText().trim().equals(insightServer.getName())) {
            result = true;
            return result;
        }
        result = false;
        if (!this.jTADesc.getText().trim().equals(insightServer.getOptDescription())) {
            result = true;
            return result;
        }
        result = false;
        String serverAddress = insightServer.getAddress();
        if (serverAddress.startsWith(HTTP_PREFIX)) {
            serverAddress = serverAddress.substring(HTTP_PREFIX.length());
        }
        if (serverAddress.startsWith(HTTPS_PREFIX)) {
            serverAddress = serverAddress.substring(HTTPS_PREFIX.length());
        }
        if (!this.jTFAddress.getText().trim().equals(serverAddress)) {
            result = true;
            return result;
        }
        result = false;
        try {
            Integer port = Integer.parseInt(this.jTFPort.getText().trim());
            if (!port.equals(insightServer.getPort())) {
                result = true;
                return result;
            }
            result = false;
        }
        catch (NumberFormatException port) {
            // empty catch block
        }
        if (null != insightServer.getOptProtocol()) {
            Integer value = insightServer.getOptProtocol();
            if (this.jCmbProtocols.getSelectedItem().equals(HTTP_PREFIX)) {
                if (value.equals(PrivateInsightServer.HTTP)) {
                    result = false;
                } else {
                    result = true;
                    return result;
                }
            }
            if (this.jCmbProtocols.getSelectedItem().equals(HTTPS_PREFIX)) {
                if (value.equals(PrivateInsightServer.HTTPS)) {
                    result = false;
                } else {
                    result = true;
                    return result;
                }
            }
        }
        return result;
    }

    public boolean isValidate() {
        boolean enabled = this.jCbxEnabled.isSelected();
        if (enabled) {
            int length = this.jTFName.getText().trim().length();
            if (length == 0 || length > 60) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.errNameCantBeEmptyorLongerThan60Chars"));
                this.jTFName.requestFocus();
                return false;
            }
            String serverAddress = this.jTFAddress.getText().trim();
            String port = this.jTFPort.getText().trim();
            if (StringUtilities.isEmpty((String)serverAddress)) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.error.serverSettingServerCannotBeEmpty"));
                this.jTFAddress.requestFocus();
                return false;
            }
            if (StringUtilities.isEmpty((String)port)) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.error.PortCannotBeEmpty"));
                this.jTFPort.requestFocus();
                return false;
            }
            if (serverAddress.startsWith(HTTP_PREFIX) || serverAddress.startsWith(HTTPS_PREFIX)) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.error.InvalidURL"));
                this.jTFAddress.requestFocus();
                return false;
            }
            if (!Utility.isValidIPAddressOrHostName((String)serverAddress, (boolean)false)) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.error.pleaseEnterValidServerIP"));
                this.jTFAddress.requestFocus();
                return false;
            }
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteInsightServerPanel.title.SiteSettings")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        this.jTFName.setEnabled(true);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.description, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.jCbxEnabled, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.name, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.desc, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.jTADesc);
        panel.add((Component)scrollPane, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.serverAddrLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 0), 0, 0));
        JPanel serverPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gcd = new GridBagConstraints();
        gcd.insets = new Insets(5, 0, 0, 5);
        gcd.gridx = 0;
        gcd.weightx = 0.1;
        gcd.gridwidth = 1;
        gcd.fill = 2;
        serverPanel.add(this.jCmbProtocols, gcd);
        ++gcd.gridx;
        gcd.weightx = 0.9;
        gcd.insets = new Insets(5, 0, 0, 0);
        serverPanel.add((Component)this.jTFAddress, gcd);
        panel.add((Component)serverPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.portLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 0), 0, 0));
        panel.add((Component)this.jTFPort, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jCbxEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean selected = SiteInsightServerPanel.this.jCbxEnabled.isSelected();
                SiteInsightServerPanel.this.changePrivateInsightServerStatus(selected);
            }
        });
        this.jCmbProtocols.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean isHTTPS = false;
                if (SiteInsightServerPanel.this.jCmbProtocols.getSelectedItem().equals(SiteInsightServerPanel.HTTPS_PREFIX)) {
                    isHTTPS = true;
                }
                if (isHTTPS) {
                    SiteInsightServerPanel.this.jTFPort.setText(String.valueOf(443));
                } else {
                    SiteInsightServerPanel.this.jTFPort.setText(String.valueOf(80));
                }
            }
        });
        return panel;
    }

    private void changePrivateInsightServerStatus(boolean enabled) {
        this.jTFName.setEnabled(enabled);
        this.jTFAddress.setEnabled(enabled);
        this.jTFPort.setEnabled(enabled);
        this.jTADesc.setEnabled(enabled);
        this.jCmbProtocols.setEnabled(enabled);
        if (enabled && StringUtilities.isEmpty((String)this.jTFPort.getText())) {
            if (this.jCmbProtocols.getSelectedItem().equals(HTTPS_PREFIX)) {
                this.jTFPort.setText(String.valueOf(443));
            } else {
                this.jTFPort.setText(String.valueOf(80));
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_insight";
    }
}

