/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.AppLearning;
import com.sygate.scm.common.configobject.schema.Reporting;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SiteGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private String siteName;
    private String siteDesc;
    private boolean isAppLearningEnabled;
    private boolean isAppLearningPurgeEnabled;
    private int daysPurgeAppData;
    private long timeout;
    private static final long serialVersionUID = -4370549423327884765L;
    private static final String[] TIME_OUTS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.5Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.10Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.15Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.20Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.25Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.30Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.35Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.40Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.45Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.50Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.1Hr")};
    private JTextField jTFName = new JTextField(new RestrictedPlainDocument(256), "", 3);
    private JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(1024), "", 4, 0);
    private JLabel siteNameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.label.SiteName"));
    private JLabel desc = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.label.Desc"));
    private JLabel timeoutLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.label.ConsoleTimeout"));
    private JTextArea reportSvrArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteReportSchedulerPanel.label.SelectReportSvr"));
    private JCheckBox jCbxAppLearn = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.checkbox.EnableAppLearning"));
    private JCheckBox jcbxPurgeAppData = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.checkbox.EnableAppLearningPurge"));
    private JTextField jtfPurgeAppDataDaysOld = new JTextField(new NumberPlainDocument(1L, 65536L, true), "", 5);
    private JLabel jlblDays = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.label.Days"));
    private JLabel timeoutWarning = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.label.ConsoleTimeoutWarning"));
    private JComboBox<String> jCmbTimeout = new JComboBox<String>(TIME_OUTS);
    private DefaultListModel<Object> serverModel = new DefaultListModel();
    private JList<Object> jLServer = new JList<Object>(this.serverModel);
    private SiteObject model;
    private JButton jBMoveUp = new JButton(UIText.get(3075));
    private JButton jBMoveDown = new JButton(UIText.get(3074));
    private boolean readOnly;

    public SiteGeneralPanel() {
        this(false);
    }

    public SiteGeneralPanel(boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
    }

    public void setModel(SiteObject model) {
        Integer optPurgeAppDataDaysOld;
        Boolean isEnabled;
        this.model = model;
        SemSite semSite = model.getSemSite();
        Reporting report = semSite.getOptReporting();
        if (report == null) {
            ServerArray serverArray = semSite.getServerArray();
            Vector servers = serverArray.getSemServer();
            SemServer server = null;
            for (int i = 0; i < servers.size(); ++i) {
                server = (SemServer)servers.get(i);
                this.serverModel.addElement(server.getName());
            }
        } else {
            String reportServers = report.getReportingServer();
            StringTokenizer tokens = new StringTokenizer(reportServers, ";");
            while (tokens.hasMoreTokens()) {
                this.serverModel.addElement(tokens.nextToken());
            }
        }
        this.jLServer.setSelectionMode(0);
        if (this.jLServer.getModel().getSize() < 2) {
            this.jBMoveUp.setEnabled(false);
            this.jBMoveDown.setEnabled(false);
        }
        this.jTFName.setText(semSite.getName());
        this.jTADesc.setText(semSite.getOptDescription());
        this.jTADesc.setCaretPosition(0);
        Long consoleTimeout = semSite.getSiteConsoleLogin().getOptConsoleTimeout();
        this.setConsoleTimeout(consoleTimeout == null ? semSite.getSiteConsoleLogin().getDefConsoleTimeout().longValue() : consoleTimeout.longValue());
        AppLearning appLearning = semSite.getOptAppLearning();
        if (appLearning == null) {
            appLearning = new AppLearning();
            semSite.setOptAppLearning(appLearning);
        }
        if ((isEnabled = appLearning.getOptEnable()) == null) {
            isEnabled = appLearning.getDefEnable();
        }
        this.jCbxAppLearn.setSelected(isEnabled);
        Boolean optPurgeAppData = appLearning.getOptPurgeAppData();
        if (null == optPurgeAppData) {
            optPurgeAppData = appLearning.getDefPurgeAppData();
        }
        if (null == (optPurgeAppDataDaysOld = appLearning.getOptPurgeAppDataDaysOld())) {
            optPurgeAppDataDaysOld = appLearning.getDefPurgeAppDataDaysOld();
        }
        this.jcbxPurgeAppData.setSelected(optPurgeAppData);
        this.jtfPurgeAppDataDaysOld.setText("" + optPurgeAppDataDaysOld);
        this.jtfPurgeAppDataDaysOld.setEnabled(this.jcbxPurgeAppData.isSelected() && !this.readOnly);
    }

    public void updateModel() {
        this.siteName = this.jTFName.getText().trim();
        this.siteDesc = this.jTADesc.getText().trim();
        this.isAppLearningEnabled = this.jCbxAppLearn.isSelected();
        this.isAppLearningPurgeEnabled = this.jcbxPurgeAppData.isSelected();
        this.daysPurgeAppData = Integer.parseUnsignedInt(this.jtfPurgeAppDataDaysOld.getText());
        this.timeout = this.getConsoleTimeout();
        SwingWorker myWorker = new SwingWorker(){

            public Object construct() {
                AppLearning appLearning;
                SemSite semSite = SiteGeneralPanel.this.model.getSemSite();
                Reporting report = semSite.getOptReporting();
                if (report == null) {
                    report = new Reporting();
                }
                report.setReportingServer(SiteGeneralPanel.this.getReportServers());
                semSite.setOptReporting(report);
                semSite.setName(SiteGeneralPanel.this.siteName);
                semSite.setOptDescription(SiteGeneralPanel.this.siteDesc);
                Long timeoutOriginal = semSite.getSiteConsoleLogin().getOptConsoleTimeout();
                if (timeoutOriginal == null || !timeoutOriginal.equals(SiteGeneralPanel.this.timeout)) {
                    semSite.getSiteConsoleLogin().setOptConsoleTimeout(Long.valueOf(SiteGeneralPanel.this.timeout));
                    KeepAlive.setTimeout(SiteGeneralPanel.this.timeout == -1L ? -1L : SiteGeneralPanel.this.timeout * 1000L);
                }
                if ((appLearning = semSite.getOptAppLearning()) == null) {
                    appLearning = new AppLearning();
                    semSite.setOptAppLearning(appLearning);
                }
                appLearning.setOptEnable(Boolean.valueOf(SiteGeneralPanel.this.isAppLearningEnabled));
                appLearning.setOptPurgeAppData(Boolean.valueOf(SiteGeneralPanel.this.isAppLearningPurgeEnabled));
                appLearning.setOptPurgeAppDataDaysOld(Integer.valueOf(SiteGeneralPanel.this.daysPurgeAppData));
                return 0;
            }
        };
        myWorker.start();
    }

    public boolean isValidate() {
        int length = this.jTFName.getText().trim().length();
        if (length == 0 || length > 60) {
            UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.errSiteNameCantBeEmptyorLongerThan60Chars"));
            this.jTFName.requestFocus();
            return false;
        }
        if (this.jCmbTimeout.getSelectedIndex() == 11) {
            UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.error.ConsoleTimeout"));
            this.jCmbTimeout.requestFocus();
            return false;
        }
        length = this.jtfPurgeAppDataDaysOld.getText().trim().length();
        if (length == 0 || 1 > Integer.parseInt(this.jtfPurgeAppDataDaysOld.getText())) {
            if (!this.jcbxPurgeAppData.isSelected()) {
                this.jtfPurgeAppDataDaysOld.setText("" + new AppLearning().getDefPurgeAppDataDaysOld());
            } else {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.error.InvalidDays"));
                this.jtfPurgeAppDataDaysOld.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_general";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.SiteSettings")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.getInnerPanel(), "North");
        this.jcbxPurgeAppData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.purgeAppDataChanged();
            }

            private void purgeAppDataChanged() {
                SiteGeneralPanel.this.jtfPurgeAppDataDaysOld.setEnabled(SiteGeneralPanel.this.jcbxPurgeAppData.isSelected() && !SiteGeneralPanel.this.readOnly);
            }
        });
    }

    private JPanel getInnerPanel() {
        this.jTFName.setEnabled(false);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.jTADesc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.siteNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.desc, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.timeoutLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 0), 0, 0));
        panel.add(this.jCmbTimeout, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ImageIcon alertIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("alertTriangle.gif")));
        this.timeoutWarning.setIcon(alertIcon);
        panel.add((Component)this.timeoutWarning, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.timeoutWarning.setVisible(false);
        if (LicenseObject.getInstance().isFirewallPolicy()) {
            panel.add((Component)this.jCbxAppLearn, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
            JPanel panelPurgeApp = new JPanel(new GridBagLayout());
            panelPurgeApp.add((Component)this.jcbxPurgeAppData, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 0, 0));
            panelPurgeApp.add((Component)this.jtfPurgeAppDataDaysOld, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 0, 0));
            panelPurgeApp.add((Component)this.jlblDays, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 0, 0));
            panel.add((Component)panelPurgeApp, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 5, 0), 0, 0));
        }
        panel.add((Component)this.reportSvrArea, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 0, 0), 0, 0));
        panel.add((Component)this.getReportServerPanel(), new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getReportServerPanel() {
        this.jLServer.setPrototypeCellValue("WWWWWWWWWWWWWWWWWWWWWWWWW");
        this.jLServer.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SiteGeneralPanel.this.setupServerPanelButtons();
            }
        });
        this.jBMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SiteGeneralPanel.this.moveServer(true);
            }
        });
        this.jBMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SiteGeneralPanel.this.moveServer(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.jBMoveUp, this.jBMoveDown}, 1, 1, true);
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, this.jLServer);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.setupServerPanelButtons();
        return panel;
    }

    private void setupServerPanelButtons() {
        this.jBMoveUp.setEnabled(true);
        this.jBMoveDown.setEnabled(true);
        int selIndex = this.jLServer.getSelectedIndex();
        if (selIndex <= 0) {
            this.jBMoveUp.setEnabled(false);
        }
        if (selIndex == -1 || selIndex == this.serverModel.size() - 1) {
            this.jBMoveDown.setEnabled(false);
        }
    }

    private void moveServer(boolean isUp) {
        int selIndex = this.jLServer.getSelectedIndex();
        if (selIndex != -1) {
            Object item = this.serverModel.remove(selIndex);
            selIndex = isUp ? --selIndex : ++selIndex;
            this.serverModel.insertElementAt(item, selIndex);
            this.jLServer.addSelectionInterval(selIndex, selIndex);
        }
    }

    private long getConsoleTimeout() {
        int selIndex = this.jCmbTimeout.getSelectedIndex();
        if (selIndex == 11) {
            return -1L;
        }
        if (selIndex == 10) {
            return 3600L;
        }
        return (long)((selIndex + 1) * 5) * 60L;
    }

    private void setConsoleTimeout(long seconds) {
        int sec = (int)seconds;
        if (sec == -1) {
            this.jCmbTimeout.addItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.combo.Never"));
            this.jCmbTimeout.setSelectedIndex(11);
            this.timeoutWarning.setVisible(true);
            return;
        }
        if ((sec /= 60) == 60) {
            this.jCmbTimeout.setSelectedIndex(10);
        } else {
            this.jCmbTimeout.setSelectedIndex(sec / 5 - 1);
        }
    }

    private String getReportServers() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.serverModel.size(); ++i) {
            buf.append(";" + this.serverModel.get(i));
        }
        return buf.substring(1).toString();
    }

    private void setReadOnlyStatus() {
        this.jTFName.setEnabled(!this.readOnly);
        this.jTADesc.setEnabled(!this.readOnly);
        this.jCbxAppLearn.setEnabled(!this.readOnly);
        this.jcbxPurgeAppData.setEnabled(!this.readOnly);
        this.jtfPurgeAppDataDaysOld.setEnabled(!this.readOnly);
        this.jlblDays.setEnabled(!this.readOnly);
        this.jCmbTimeout.setEnabled(!this.readOnly);
        this.jBMoveUp.setEnabled(!this.readOnly);
        this.jBMoveDown.setEnabled(!this.readOnly);
        this.jLServer.setEnabled(!this.readOnly);
    }
}

