/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.DirectoryServerIntegration;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.server.dlg.DirectoryServerDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerSynchronizePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -2440164226941232721L;
    static final int MAX_HOURS = 999;
    private DirectoryTableModel tableModel = new DirectoryTableModel();
    private JTable jTServer = new StripesTable(this.tableModel);
    private JCheckBox jCbxEnable = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.checkbox.EnableSyncWithDirSvrs"), true);
    private JRadioButton jRBAuto = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.radio.AutoSched"), true);
    private JRadioButton jRBSync = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.radio.SyncEvery"));
    private JTextField jTFHour = new JTextField("", 3);
    private JLabel hoursLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.label.Hours"));
    private JButton jBAdd = new JButton(UIText.get(5));
    private JButton jBEdit = new JButton(UIText.get(1024));
    private JButton jBDelete = new JButton(UIText.get(769));
    private ServerObject model;
    private String addc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.table.addc");
    private String ldap = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.table.ldap");
    private String ldapPattern = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.table.ldapPattern");
    private String ldapPatternNoUser = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.table.ldapPatternNoUser");
    private String addcPattern = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.table.addcPattern");
    private String addcPatternNoUser = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.table.addcPatternNoUser");
    private JPopupMenu popupMenu;
    private JMenuItem addMenu;
    private JMenuItem deleteMenu;
    private JMenuItem editMenu;
    protected boolean readOnly;
    private boolean needSchedule = true;
    private JPanel innerPanel;
    private JPanel schedulePanel;
    private JPanel cloudWarningPanel = null;
    private DescriptionTextArea cloudWarningMessageDesc;

    public ServerSynchronizePanel(boolean readOnly) {
        this(readOnly, true);
    }

    public ServerSynchronizePanel(boolean readOnly, boolean needScheduleFeature) {
        this.readOnly = readOnly;
        this.needSchedule = needScheduleFeature;
        this.initialize();
        this.setReadOnlyStatus();
    }

    public ServerSynchronizePanel() {
        this(false);
    }

    public void updateModel() {
        if (this.readOnly) {
            return;
        }
        SemServer server = this.model.getSemServer();
        DirectoryServerIntegration directoryConfig = this.tableModel.getDirectoryServerIntegration();
        boolean syncEnabled = this.jCbxEnable.isSelected();
        directoryConfig.setOptEnable(Boolean.valueOf(syncEnabled));
        boolean autoSchedule = this.jRBAuto.isSelected();
        if (autoSchedule) {
            directoryConfig.setOptSyncFreq(null);
        } else {
            Integer hours = null;
            try {
                hours = Integer.valueOf(this.jTFHour.getText().trim());
            }
            catch (Exception ignore) {
                LoggerUtilities.logException((Throwable)ignore);
            }
            if (hours == null || hours < 1) {
                directoryConfig.setOptSyncFreq(null);
            } else {
                directoryConfig.setOptSyncFreq(hours);
            }
        }
        server.setOptDirectoryServerIntegration(directoryConfig);
    }

    protected void showPopup(MouseEvent event) {
        if (this.readOnly) {
            return;
        }
        Point p = event.getPoint();
        int row = this.jTServer.rowAtPoint(p);
        if (row != -1) {
            this.jTServer.setRowSelectionInterval(row, row);
        }
        if (event.isPopupTrigger()) {
            this.getPopupMenu().show(event.getComponent(), event.getX(), event.getY());
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.editMenu = new JMenuItem(UIText.get(1024));
            this.editMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 9164349201266512357L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerSynchronizePanel.this.edit();
                }
            });
            this.deleteMenu = new JMenuItem(UIText.get(769));
            this.deleteMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -5063123194887302009L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerSynchronizePanel.this.delete();
                }
            });
            this.addMenu = new JMenuItem(UIText.get(5));
            this.addMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 4054555399357189289L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerSynchronizePanel.this.add();
                }
            });
            this.popupMenu.add(this.addMenu);
            this.popupMenu.add(this.editMenu);
            this.popupMenu.add(this.deleteMenu);
            this.tableSelectionChanged();
        }
        return this.popupMenu;
    }

    private void updateSyncADCheckOption(DirectoryServerIntegration directoryConfig) {
        boolean isSyncPanelReadOnly = this.readOnly;
        GroupObject rootGroupObject = null;
        try {
            rootGroupObject = GroupHandler.getRootGroupObject();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        if (rootGroupObject != null && !rootGroupObject.isTypeNative() && this.needSchedule) {
            isSyncPanelReadOnly = true;
            this.cloudWarningPanel.setVisible(true);
            this.jCbxEnable.setSelected(false);
        }
        boolean enable = directoryConfig != null && directoryConfig.getDirectoryServerCount() > 0 && !isSyncPanelReadOnly;
        this.jCbxEnable.setEnabled(enable);
        this.jRBAuto.setEnabled(enable && this.jCbxEnable.isSelected());
        this.jRBSync.setEnabled(enable && this.jCbxEnable.isSelected());
        this.jTFHour.setEnabled(enable && this.jCbxEnable.isSelected());
        this.hoursLabel.setEnabled(enable && this.jCbxEnable.isSelected());
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.needSchedule) {
            this.add((Component)this.getInnerPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.cloudWarningPanel.setVisible(false);
        }
    }

    private JPanel getInnerPanel() {
        this.innerPanel = new JPanel(new GridBagLayout());
        this.innerPanel.add((Component)this.jCbxEnable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.innerPanel.add((Component)this.getSchedulePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        if (this.cloudWarningPanel == null) {
            this.cloudWarningPanel = new JPanel();
            BorderLayout layout = new BorderLayout();
            layout.setHgap(5);
            this.cloudWarningPanel.setLayout(layout);
            JLabel warningIconLabel = new JLabel(ConsoleMain.warningIcon16);
            this.cloudWarningPanel.add((Component)warningIconLabel, "West");
            if (this.cloudWarningMessageDesc == null) {
                this.cloudWarningMessageDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.cloudmaster.warning"));
            }
            this.cloudWarningPanel.add((Component)this.cloudWarningMessageDesc, "Center");
        }
        this.innerPanel.add((Component)this.cloudWarningPanel, new GridBagConstraints(0, 2, 1, 50, 1.0, 3.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.innerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.title.SyncDirSettings"))));
        return this.innerPanel;
    }

    private JPanel getSchedulePanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBAuto);
        group.add(this.jRBSync);
        this.jRBAuto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ServerSynchronizePanel.this.scheduleTypeChanged();
            }
        });
        this.jRBSync.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ServerSynchronizePanel.this.scheduleTypeChanged();
            }
        });
        this.jCbxEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                ServerSynchronizePanel.this.jRBAuto.setEnabled(ServerSynchronizePanel.this.jCbxEnable.isSelected());
                ServerSynchronizePanel.this.jRBSync.setEnabled(ServerSynchronizePanel.this.jCbxEnable.isSelected());
                ServerSynchronizePanel.this.jTFHour.setEnabled(ServerSynchronizePanel.this.jCbxEnable.isSelected());
                ServerSynchronizePanel.this.hoursLabel.setEnabled(ServerSynchronizePanel.this.jCbxEnable.isSelected());
            }
        });
        NumberPlainDocument doc = new NumberPlainDocument(999L);
        this.jTFHour.setDocument(doc);
        this.jTFHour.setHorizontalAlignment(4);
        this.schedulePanel = new JPanel(new GridBagLayout());
        this.schedulePanel.add((Component)this.jRBAuto, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.schedulePanel.add((Component)this.jRBSync, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.schedulePanel.add((Component)this.jTFHour, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.schedulePanel.add((Component)this.hoursLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.title.Schedule")));
        wrapPanel.add((Component)this.schedulePanel, "West");
        return wrapPanel;
    }

    private JPanel getTablePanel() {
        this.getPopupMenu();
        Dimension size = this.jTServer.getPreferredScrollableViewportSize();
        this.jTServer.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTServer.getRowHeight() + this.jTServer.getRowMargin()) * 5));
        this.jTServer.getSelectionModel().setSelectionMode(0);
        this.jTServer.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServerSynchronizePanel.this.tableSelectionChanged();
            }
        });
        this.jTServer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ServerSynchronizePanel.this.showPopup(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                ServerSynchronizePanel.this.showPopup(event);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ServerSynchronizePanel.this.edit();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)this.jTServer);
        scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ServerSynchronizePanel.this.showPopup(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                ServerSynchronizePanel.this.showPopup(event);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ServerSynchronizePanel.this.edit();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.title.AutoSyncWithDirSvrs")));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(this.jTServer.getTableHeader().getPreferredSize().height, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSynchronizePanel.this.add();
            }
        });
        this.jBEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSynchronizePanel.this.edit();
            }
        });
        this.jBDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSynchronizePanel.this.delete();
            }
        });
        JPanel panel = new JPanel();
        UIUtilities.layoutButtonPanel(panel, new JButton[]{this.jBAdd, this.jBEdit, this.jBDelete}, 1, 1, true);
        return panel;
    }

    private void scheduleTypeChanged() {
        this.jTFHour.setEnabled(this.jRBSync.isSelected());
    }

    private void tableSelectionChanged() {
        boolean isEnabled = this.jTServer.getSelectedRow() != -1;
        this.jBEdit.setEnabled(isEnabled);
        this.editMenu.setEnabled(isEnabled);
        this.jBDelete.setEnabled(isEnabled);
        this.deleteMenu.setEnabled(isEnabled);
    }

    private void add() {
        DirectoryServer server = null;
        DirectoryServerDialog dialog = new DirectoryServerDialog(server, this.tableModel.getDirectoryServerIntegration());
        if (dialog.isOk()) {
            server = dialog.getDirectoryServer();
            dialog.updateDirectoryServer();
            this.tableModel.getDirectoryServerIntegration().addDirectoryServer(server);
            this.updateSyncADCheckOption(this.tableModel.getDirectoryServerIntegration());
            this.tableModel.fireTableDataChanged();
        }
        dialog.dispose();
    }

    private void edit() {
        int selectedRow = this.jTServer.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        DirectoryServer server = this.tableModel.getDirectoryServerIntegration().getDirectoryServer(selectedRow);
        if (server == null) {
            return;
        }
        DirectoryServerDialog dialog = new DirectoryServerDialog(server, this.tableModel.getDirectoryServerIntegration());
        if (dialog.isOk()) {
            dialog.updateDirectoryServer();
            this.tableModel.fireTableDataChanged();
        }
        dialog.dispose();
    }

    private void delete() {
        int selectedRow = this.jTServer.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        DirectoryServer server = this.tableModel.getDirectoryServerIntegration().getDirectoryServer(selectedRow);
        if (server == null) {
            return;
        }
        if (this.isDirectoryServerInUse(server)) {
            Object[] options = new Object[]{ServerSynchronizePanel.getResourceValue("ServerSynchronizePanel.ConfirmDelDirSvr.Option.OK"), ServerSynchronizePanel.getResourceValue("ServerSynchronizePanel.ConfirmDelDirSvr.Option.Cancel")};
            if (0 != JOptionPane.showOptionDialog(Manager.getFrame(), ServerSynchronizePanel.getResourceValue("ServerSynchronizePanel.ConfirmDelDirSvr.ServerInUsing"), ServerSynchronizePanel.getResourceValue("ServerSynchronizePanel.title.ConfirmDel"), 0, 3, null, options, options[1])) {
                return;
            }
        } else if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), ServerSynchronizePanel.getResourceValue("ServerSynchronizePanel.ConfirmDelDirSvr"), ServerSynchronizePanel.getResourceValue("ServerSynchronizePanel.title.ConfirmDel"), 0)) {
            return;
        }
        this.tableModel.getDirectoryServerIntegration().removeDirectoryServer(server);
        this.updateSyncADCheckOption(this.tableModel.getDirectoryServerIntegration());
        this.tableModel.fireTableDataChanged();
    }

    boolean isDirectoryServerInUse(DirectoryServer server) {
        try {
            return DataobjectManager.getInstance().isDirectoryServerInUse(server.getOptGuid(), false);
        }
        catch (ConsoleException e) {
            if (e.getErrorCode() != 302186496) {
                UIUtilities.showErrorMessageDialog(this, e, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.title.ConfirmDel"));
            }
            return false;
        }
    }

    private void setReadOnlyStatus() {
        this.jTServer.setEnabled(!this.readOnly);
        this.jCbxEnable.setEnabled(!this.readOnly);
        this.jRBAuto.setEnabled(!this.readOnly);
        this.jRBSync.setEnabled(!this.readOnly);
        this.jTFHour.setEnabled(!this.readOnly);
        this.jBAdd.setEnabled(!this.readOnly);
        this.jBEdit.setEnabled(!this.readOnly);
        this.jBDelete.setEnabled(!this.readOnly);
    }

    public void setModel(ServerObject model) {
        this.model = model;
        SemServer server = model.getSemServer();
        DirectoryServerIntegration directoryConfig = server.getOptDirectoryServerIntegration();
        if (directoryConfig == null) {
            directoryConfig = new DirectoryServerIntegration();
            server.setOptDirectoryServerIntegration(directoryConfig);
            directoryConfig.setOptEnable(Boolean.FALSE);
        }
        DirectoryServerIntegration directoryConfigCopy = null;
        try {
            directoryConfigCopy = (DirectoryServerIntegration)AbstractSchema.readXML((byte[])directoryConfig.getBytes());
            boolean selected = directoryConfig.getOptEnable() != null && directoryConfig.getOptEnable() != false;
            this.jCbxEnable.setSelected(selected);
            this.updateSyncADCheckOption(directoryConfigCopy);
            if (directoryConfigCopy.getOptSyncFreq() != null) {
                Integer frequency = directoryConfigCopy.getOptSyncFreq();
                if (frequency == null || frequency.equals(0)) {
                    this.jRBAuto.setSelected(true);
                } else {
                    this.jRBSync.setSelected(true);
                    this.jTFHour.setText(String.valueOf(frequency));
                }
            }
            this.tableModel.setDirectoryServerIntegration(directoryConfigCopy);
            this.scheduleTypeChanged();
            this.tableSelectionChanged();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public boolean isValidState() {
        if (this.readOnly) {
            return true;
        }
        boolean autoSchedule = this.jRBAuto.isSelected();
        if (!autoSchedule) {
            Integer hours = null;
            try {
                hours = Integer.valueOf(this.jTFHour.getText().trim());
            }
            catch (Exception ignore) {
                LoggerUtilities.logException((Throwable)ignore);
            }
            if (hours == null || hours < 1 || hours > 999) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.error.InvalidFreq"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.title.Error"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_directory_servers";
    }

    private static String getResourceValue(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", key);
    }

    class DirectoryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -3059062122190841274L;
        private DirectoryServerIntegration dsi;

        public void setDirectoryServerIntegration(DirectoryServerIntegration dsi) {
            this.dsi = dsi;
        }

        public DirectoryServerIntegration getDirectoryServerIntegration() {
            return this.dsi;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.column.Name");
                }
                case 1: {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.column.Protocol");
                }
            }
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerSynchronizePanel.column.Props");
        }

        @Override
        public int getRowCount() {
            if (this.dsi == null) {
                return 0;
            }
            return this.dsi.getDirectoryServerCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DirectoryServer directoryServer = this.dsi.getDirectoryServer(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return directoryServer.getName();
                }
                case 1: {
                    return directoryServer.getType() == DirectoryServer.ADDC ? ServerSynchronizePanel.this.addc : ServerSynchronizePanel.this.ldap;
                }
            }
            String address = directoryServer.getServerAddress();
            Integer protocol = directoryServer.getType();
            Long port = directoryServer.getOptPort();
            String user = directoryServer.getOptUsername();
            String basedn = directoryServer.getOptBaseDN();
            String strPort = port == null ? "-" : String.valueOf(port);
            boolean hasUser = true;
            if (user == null || user.trim().length() == 0) {
                hasUser = false;
            }
            String string = basedn = basedn == null || basedn.trim().length() == 0 ? "-" : basedn;
            String property = DirectoryServer.LDAP.equals(protocol) ? (hasUser ? MessageFormat.format(ServerSynchronizePanel.this.ldapPattern, address, strPort, basedn, user) : MessageFormat.format(ServerSynchronizePanel.this.ldapPatternNoUser, address, strPort, basedn)) : (hasUser ? MessageFormat.format(ServerSynchronizePanel.this.addcPattern, address, user) : MessageFormat.format(ServerSynchronizePanel.this.addcPatternNoUser, address));
            return property;
        }
    }
}

