/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ServerSecurityPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCbxAllowReset = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SecurityPanel.checkbox.allowResetOfPasswords"));
    private JCheckBox jCbxAllowRememberCredentials = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SecurityPanel.checkbox.allowRememberCredentials"));
    private JCheckBox jCbxAllowNeverExpiringPasswords = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SecurityPanel.checkbox.allowNeverExpiringPasswords"));
    private boolean isSBE = LicenseObject.getInstance().isSBProduct();
    private boolean isSiteDialog = false;
    private SemDomain domain = null;

    public ServerSecurityPanel(boolean isSiteDialog) {
        this.isSiteDialog = isSiteDialog;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Boolean isCbxSelected = null;
        if (this.isSBE || !this.isSBE && this.isSiteDialog) {
            try {
                SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
                isCbxSelected = configRoot.getOptIsPSWRecoverable();
                this.jCbxAllowReset.setSelected(configRoot.getDefIsPSWRecoverable());
            }
            catch (ConsoleException e) {
                System.out.println("ServerSecurityPanel >> updateModel");
                LoggerUtilities.logException((Throwable)e);
            }
            if (isCbxSelected != null) {
                this.jCbxAllowReset.setSelected(isCbxSelected);
            }
            panel.add(this.jCbxAllowReset);
        }
        if (this.isSBE || !this.isSBE && !this.isSiteDialog) {
            panel.add(this.jCbxAllowRememberCredentials);
            panel.add(this.jCbxAllowNeverExpiringPasswords);
        }
        return panel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (this.isSBE) {
            return "sesm_admin_servers_dialog_server_properties_security";
        }
        if (this.isSiteDialog) {
            return "sesm_admin_servers_dialog_site_properties_security";
        }
        return "sesm_admin_domain_dialog_properties_security";
    }

    public void updateModel() {
        try {
            if (this.isSBE || !this.isSBE && this.isSiteDialog) {
                SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
                Boolean bIsPwdRecoverable = configRoot.getOptIsPSWRecoverable();
                if (bIsPwdRecoverable != null) {
                    if (bIsPwdRecoverable.booleanValue() != this.jCbxAllowReset.isSelected()) {
                        configRoot.setOptIsPSWRecoverable(Boolean.valueOf(this.jCbxAllowReset.isSelected()));
                        DataobjectManager.getInstance().updateSemConfigRoot("Merge", configRoot);
                        DataobjectManager.getInstance().updatePasswordRecoveryFile(configRoot);
                    }
                } else {
                    configRoot.setOptIsPSWRecoverable(Boolean.valueOf(this.jCbxAllowReset.isSelected()));
                    DataobjectManager.getInstance().updateSemConfigRoot("Merge", configRoot);
                    DataobjectManager.getInstance().updatePasswordRecoveryFile(configRoot);
                }
            }
            if (this.isSBE || !this.isSBE && !this.isSiteDialog) {
                boolean valueChanged = false;
                if (this.domain != null) {
                    Boolean bIsRememberPwd = this.domain.getOptRememberPassword();
                    Boolean bIsAllowNeverExpiringPwd = this.domain.getOptAllowNeverExpiringPassword();
                    if (bIsRememberPwd != null) {
                        if (bIsRememberPwd.booleanValue() != this.jCbxAllowRememberCredentials.isSelected()) {
                            this.domain.setOptRememberPassword(Boolean.valueOf(this.jCbxAllowRememberCredentials.isSelected()));
                            valueChanged = true;
                        }
                    } else {
                        this.domain.setOptRememberPassword(Boolean.valueOf(this.jCbxAllowRememberCredentials.isSelected()));
                        valueChanged = true;
                    }
                    if (bIsAllowNeverExpiringPwd != null) {
                        if (bIsAllowNeverExpiringPwd.booleanValue() != this.jCbxAllowNeverExpiringPasswords.isSelected()) {
                            this.domain.setOptAllowNeverExpiringPassword(Boolean.valueOf(this.jCbxAllowNeverExpiringPasswords.isSelected()));
                            valueChanged = true;
                        }
                    } else {
                        this.domain.setOptAllowNeverExpiringPassword(Boolean.valueOf(this.jCbxAllowNeverExpiringPasswords.isSelected()));
                        valueChanged = true;
                    }
                    if (valueChanged) {
                        AdminHandler.updateDomain(this.domain);
                    }
                }
            }
        }
        catch (ConsoleException e) {
            System.out.println("ServerSecurityPanel >> updateModel");
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public boolean getRememberPasswordStatus() {
        return this.jCbxAllowRememberCredentials.isSelected();
    }

    public boolean getAllowNeverExpiringPasswordStatus() {
        return this.jCbxAllowNeverExpiringPasswords.isSelected();
    }

    public void setRememberPasswordStatus(SemDomain currentDomain) {
        if (this.isSBE || !this.isSBE && !this.isSiteDialog) {
            Boolean isCbxSelected = null;
            if (currentDomain != null) {
                this.domain = currentDomain;
                isCbxSelected = currentDomain.getOptRememberPassword();
                this.jCbxAllowRememberCredentials.setSelected(currentDomain.getDefRememberPassword());
                if (isCbxSelected != null) {
                    this.jCbxAllowRememberCredentials.setSelected(isCbxSelected);
                }
            }
        }
    }

    public void setAllowNeverExpiringPassword(SemDomain currentDomain) {
        if (this.isSBE || !this.isSBE && !this.isSiteDialog) {
            Boolean isCbxSelected = null;
            if (currentDomain != null) {
                this.domain = currentDomain;
                isCbxSelected = currentDomain.getOptAllowNeverExpiringPassword();
                this.jCbxAllowNeverExpiringPasswords.setSelected(currentDomain.getDefAllowNeverExpiringPassword());
                if (isCbxSelected != null) {
                    this.jCbxAllowNeverExpiringPasswords.setSelected(isCbxSelected);
                }
            }
        }
    }
}

