/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.server.dlg.FullContentDistributionConfigPanel;
import com.sygate.scm.console.ui.server.dlg.ServerEMailPanel;
import com.sygate.scm.console.ui.server.dlg.ServerFingerprintPanel;
import com.sygate.scm.console.ui.server.dlg.ServerGeneralPanel;
import com.sygate.scm.console.ui.server.dlg.ServerHttpProxyPanel;
import com.sygate.scm.console.ui.server.dlg.ServerLuPanel;
import com.sygate.scm.console.ui.server.dlg.ServerSecurityPanel;
import com.sygate.scm.console.ui.server.dlg.ServerSynchronizePanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;

public class ServerPropertiesDlg
extends DialogBase {
    private static final long serialVersionUID = -1630137663945073811L;
    private int DLG_WIDTH = 550;
    private int DLG_HEIGHT = 580;
    private JTabbedPane jTabPane = new JTabbedPane();
    private ServerGeneralPanel generalPanel = null;
    private ServerEMailPanel emailPanel = null;
    private ServerSynchronizePanel syncPanel = null;
    private ServerHttpProxyPanel proxyPanel = null;
    private ServerLuPanel luPanel = null;
    private ServerSecurityPanel securityPanel = null;
    private ServerFingerprintPanel fingerprintPanel = new ServerFingerprintPanel();
    private FullContentDistributionConfigPanel fullContentDistributionConfigPanel = null;
    private ServerObject model;

    public ServerPropertiesDlg(ServerObject server, boolean readOnly) {
        super(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.SvrPropsFor"), server), true);
        this.readOnly = readOnly;
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.setPreferredSize(new Dimension(this.DLG_WIDTH, this.DLG_HEIGHT)));
        this.initialize(server);
        this.setModel(server);
        this.setSize((int)((double)this.getWidth() * 1.2), this.getHeight());
        this.setReadOnlyStatus();
        this.setSize(new Dimension(this.DLG_WIDTH, this.DLG_HEIGHT));
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public ServerPropertiesDlg(ServerObject server) {
        this(server, false);
    }

    public ServerObject getModel() {
        return this.model;
    }

    public boolean isConsoleAccessAllowed() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return true;
        }
        return this.generalPanel.isConsoleAccessAllowed();
    }

    @Override
    protected boolean isValidate() {
        if (this.readOnly) {
            return true;
        }
        if (!LicenseObject.getInstance().isSBProduct()) {
            if (!this.generalPanel.isValidState()) {
                this.jTabPane.setSelectedIndex(0);
                return false;
            }
            if (!this.emailPanel.isValidState(true)) {
                this.jTabPane.setSelectedIndex(1);
                return false;
            }
            if (!this.syncPanel.isValidState()) {
                this.jTabPane.setSelectedIndex(2);
                return false;
            }
            if (!this.proxyPanel.isValidState()) {
                this.jTabPane.setSelectedIndex(3);
                return false;
            }
            if (!this.fingerprintPanel.isValidState()) {
                this.jTabPane.setSelectedIndex(4);
                return false;
            }
            if (!this.fullContentDistributionConfigPanel.isValidState()) {
                this.jTabPane.setSelectedIndex(5);
                return false;
            }
            return true;
        }
        if (!this.emailPanel.isValidState(true)) {
            this.jTabPane.setSelectedIndex(0);
            return false;
        }
        if (!this.proxyPanel.isValidState()) {
            this.jTabPane.setSelectedIndex(1);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        if (this.readOnly) {
            return;
        }
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.generalPanel.updateModel();
            this.emailPanel.updateModel();
            this.syncPanel.updateModel();
            this.proxyPanel.updateModel();
            this.fingerprintPanel.updateModel();
            this.fullContentDistributionConfigPanel.updateModel();
        } else {
            this.emailPanel.updateModel();
            this.proxyPanel.updateModel();
            this.securityPanel.updateModel();
            this.luPanel.updateSite();
        }
    }

    @Override
    public boolean ok() {
        if (!Env.isUnitTest() && !this.isValidate()) {
            return false;
        }
        this.isOk = true;
        this.commit();
        this.dispose();
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.jTabPane.getSelectedComponent());
    }

    private void initialize(ServerObject server) {
        this.generalPanel = new ServerGeneralPanel(this.readOnly);
        this.emailPanel = new ServerEMailPanel(server, this.readOnly);
        this.syncPanel = new ServerSynchronizePanel(this.readOnly);
        this.proxyPanel = new ServerHttpProxyPanel(this.readOnly);
        this.luPanel = new ServerLuPanel(this.readOnly, this);
        this.securityPanel = new ServerSecurityPanel(false);
        this.fullContentDistributionConfigPanel = new FullContentDistributionConfigPanel(this.readOnly, Manager.isLocalServer(server.getId()));
        boolean isSEPSB = LicenseObject.getInstance().isSBProduct();
        this.jTabPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        if (!isSEPSB) {
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.General"), this.generalPanel);
        }
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.MailSvr"), this.emailPanel);
        if (!isSEPSB) {
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.DirectorySvrs"), this.syncPanel);
        }
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.HTTPProxySvr"), this.proxyPanel);
        if (isSEPSB) {
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.LiveUpdate"), this.luPanel);
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SecurityPanel.title.Security"), this.securityPanel);
        }
        if (!isSEPSB) {
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.FileFingerprintUpdate"), this.fingerprintPanel);
            this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.FullContentDistributionConfig"), this.fullContentDistributionConfigPanel);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jTabPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.resetOKButton(!this.readOnly);
        this.pack();
    }

    private void setModel(ServerObject model) {
        boolean isSEPSB = LicenseObject.getInstance().isSBProduct();
        this.model = model;
        if (!isSEPSB) {
            this.generalPanel.setModel(model);
            this.emailPanel.setModel(model);
            this.syncPanel.setModel(model);
            this.proxyPanel.setModel(model);
            this.fingerprintPanel.setModel(model);
            this.fullContentDistributionConfigPanel.setModel(model);
        } else {
            this.emailPanel.setModel(model);
            this.proxyPanel.setModel(model);
            this.luPanel.setSemSite(model);
            try {
                SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
                this.securityPanel.setRememberPasswordStatus(currentDomain);
                this.securityPanel.setAllowNeverExpiringPassword(currentDomain);
            }
            catch (ConsoleException e) {
                System.out.println("ServerPropertiesDlg >> setModel");
                LoggerUtilities.logException((Throwable)e);
            }
        }
    }
}

