/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LuConfigObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.policy.lu.SchedulePanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.DateUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServerLuPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -4478723706069870926L;
    private JButton downloadNowButton;
    private JRadioButton min15Button;
    private JRadioButton hourlyButton;
    private JRadioButton dailyButton;
    private JRadioButton weeklyButton;
    private JSpinner hourSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
    private JCheckBox specifyTimeRangeBox = new JCheckBox();
    private TimeSpinner1 startSpinner;
    private TimeSpinner1 endSpinner;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasSecond;
    private boolean hasAmpm;
    private String hourPattern;
    private JCheckBox retryBox;
    private JSpinner retryIntervalSpinner;
    private JLabel lbRetryWindow;
    private JSpinner retryWindowSpinner;
    private JLabel lbStartTime;
    private JLabel lbEndTime;
    private JLabel lbEvery;
    private LuConfigObject luConfig;
    private LuDownloadSchedule luSchedule;
    private SemSite currentSite;
    private JComboBox<String> dayBox;
    private JTextArea downloadDesc;
    private boolean readOnly;
    private JDialog parent;
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private static final int MINUTE = 60;
    private ServerObject model;

    public ServerLuPanel(JDialog parent) {
        this(false, parent);
    }

    public ServerLuPanel(boolean readOnly, JDialog parent) {
        this.readOnly = readOnly;
        this.parent = parent;
        this.initialize();
        this.setReadOnlyStatus();
    }

    private void initialize() {
        this.initializeDayComboBox();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private void initializeDayComboBox() {
        String[] day = new String[7];
        int iFirstDay = Calendar.getInstance().getFirstDayOfWeek() - 1;
        for (int i = 0; i < 7; ++i) {
            day[i] = SchedulePanel.getDayByIndex((iFirstDay + i) % 7);
        }
        this.dayBox = new JComboBox<String>(day);
    }

    private JPanel getInnerPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(BorderFactory.createTitledBorder(ServerLuPanel.getRes("label.downloadSched")));
        this.downloadDesc = new DescriptionTextArea(ServerLuPanel.getRes("label.downloadDesc"), 70);
        result.add((Component)this.downloadDesc, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.initializeComponents();
        result.add((Component)this.getContentPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        return result;
    }

    public void setReadOnlyStatus() {
        this.min15Button.setEnabled(!this.readOnly);
        this.hourlyButton.setEnabled(!this.readOnly);
        this.dailyButton.setEnabled(!this.readOnly);
        this.weeklyButton.setEnabled(!this.readOnly);
        this.startSpinner.setEnabled(!this.readOnly);
        this.endSpinner.setEnabled(!this.readOnly);
        this.retryIntervalSpinner.setEnabled(!this.readOnly);
        this.retryWindowSpinner.setEnabled(!this.readOnly);
        this.dayBox.setEnabled(!this.readOnly);
        this.specifyTimeRangeBox.setEnabled(!this.readOnly);
    }

    public void setSemSite(ServerObject model) {
        this.model = model;
        this.currentSite = model.getParentSite();
        this.luConfig = new LuConfigObject(this.currentSite);
        LuDownloadSchedule schedule = this.luConfig.getOptLuDownloadSchedule();
        if (schedule != null) {
            try {
                this.luSchedule = (LuDownloadSchedule)PolicyHandler.getCopyOfObj((ConfigObject)schedule);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        } else {
            this.luSchedule = new LuDownloadSchedule();
        }
        this.updateSchedule();
        this.enableAppropriate(true);
    }

    private void initializeComponents() {
        this.downloadNowButton = new JButton(ServerLuPanel.getRes("button.runNow"));
        this.downloadNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GUIManager.runLuNow();
                }
                catch (ConsoleException ce) {
                    LoggerUtilities.logException((Throwable)ce);
                }
                JOptionPane.showMessageDialog(Manager.getFrame(), ServerLuPanel.getRes("label.luLaunched"));
            }
        });
        this.lbStartTime = new JLabel(ServerLuPanel.getRes("label.start"));
        this.lbEndTime = new JLabel(ServerLuPanel.getRes("label.end"));
        this.lbEvery = new JLabel(ServerLuPanel.getRes("label.every"));
        this.min15Button = new JRadioButton(ServerLuPanel.getRes("button.continuously"));
        this.min15Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLuPanel.this.enableAppropriate();
            }
        });
        this.hourlyButton = new JRadioButton(ServerLuPanel.getRes("button.hourlyFrequency"));
        this.hourlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLuPanel.this.enableAppropriate();
            }
        });
        UIUtilities.enableOnlyValidEdits(this.hourSpinner);
        this.hourSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServerLuPanel.this.updateRetryWindowAndInterval();
            }
        });
        this.dailyButton = new JRadioButton(ServerLuPanel.getRes("button.daily"));
        this.dailyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLuPanel.this.specifyTimeRangeBox.setSelected(true);
                ServerLuPanel.this.enableAppropriate();
            }
        });
        this.weeklyButton = new JRadioButton(ServerLuPanel.getRes("button.weekly"));
        this.weeklyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLuPanel.this.specifyTimeRangeBox.setSelected(true);
                ServerLuPanel.this.enableAppropriate();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.min15Button);
        buttonGroup.add(this.hourlyButton);
        buttonGroup.add(this.dailyButton);
        buttonGroup.add(this.weeklyButton);
        this.specifyTimeRangeBox = new JCheckBox(ServerLuPanel.getRes("box.downloadWindow"));
        this.specifyTimeRangeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.error.starttimeShouldBeSet"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Error"), 0);
                    ServerLuPanel.this.specifyTimeRangeBox.setSelected(true);
                } else {
                    ServerLuPanel.this.enableAppropriate(false);
                }
            }
        });
        this.startSpinner = new TimeSpinner1(this.timePattern);
        this.endSpinner = new TimeSpinner1(this.timePattern);
        if (this.timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("m") != -1) {
            this.hasMinute = true;
        }
        if (this.timePattern.indexOf("s") != -1) {
            this.hasSecond = true;
        }
        if (this.timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
        this.retryBox = new JCheckBox(ServerLuPanel.getRes("box.retryIntervalMins"));
        this.retryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLuPanel.this.enableAppropriate();
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(15, 15, 60, 15);
        this.retryIntervalSpinner = new JSpinner(model);
        UIUtilities.enableOnlyValidEdits(this.retryIntervalSpinner);
        this.lbRetryWindow = new JLabel(ServerLuPanel.getRes("label.retryWindowHours"));
        model = new SpinnerNumberModel(1, 1, 24, 1);
        this.retryWindowSpinner = new JSpinner(model);
        UIUtilities.enableOnlyValidEdits(this.retryWindowSpinner);
        this.retryWindowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServerLuPanel.this.updateRetryInterval();
            }
        });
    }

    private void enableAppropriate() {
        this.enableAppropriate(false);
    }

    private void enableAppropriate(boolean setRetry) {
        if (this.readOnly) {
            return;
        }
        this.hourSpinner.setEnabled(this.hourlyButton.isSelected());
        this.specifyTimeRangeBox.setEnabled(!this.min15Button.isSelected() && !this.hourlyButton.isSelected());
        this.lbStartTime.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
        this.startSpinner.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
        this.lbEndTime.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
        this.endSpinner.setEnabled(this.specifyTimeRangeBox.isSelected() && !this.min15Button.isSelected() && !this.hourlyButton.isSelected());
        this.lbEvery.setEnabled(this.specifyTimeRangeBox.isSelected() && this.weeklyButton.isSelected());
        this.dayBox.setEnabled(this.specifyTimeRangeBox.isSelected() && this.weeklyButton.isSelected());
        this.retryBox.setEnabled(!this.min15Button.isSelected());
        this.retryIntervalSpinner.setEnabled(this.retryBox.isSelected() && !this.min15Button.isSelected());
        this.lbRetryWindow.setEnabled(!this.min15Button.isSelected());
        this.retryWindowSpinner.setEnabled(this.retryBox.isSelected() && !this.min15Button.isSelected());
        this.min15Button.requestFocus();
        if (!this.min15Button.isSelected()) {
            if (this.hourlyButton.isSelected()) {
                this.retryBox.setText(ServerLuPanel.getRes("box.retryIntervalMins"));
                this.lbRetryWindow.setText(ServerLuPanel.getRes("label.retryWindowHours"));
                this.hourlyButton.requestFocus();
            } else if (this.dailyButton.isSelected()) {
                this.retryBox.setText(ServerLuPanel.getRes("box.retryIntervalMins"));
                this.lbRetryWindow.setText(ServerLuPanel.getRes("label.retryWindowHours"));
                this.dailyButton.requestFocus();
            } else if (this.weeklyButton.isSelected()) {
                this.retryBox.setText(ServerLuPanel.getRes("box.retryIntervalHours"));
                this.lbRetryWindow.setText(ServerLuPanel.getRes("label.retryWindowDays"));
                this.weeklyButton.requestFocus();
            }
            this.updateRetryWindowAndInterval();
            if (setRetry && this.retryBox.isSelected()) {
                this.updateRetryInfo();
            }
        }
    }

    private void updateRetryInfo() {
        Integer retryInterval = this.luSchedule.getOptRetryInterval();
        if (retryInterval == null) {
            retryInterval = this.luSchedule.getDefRetryInterval();
        }
        if (this.weeklyButton.isSelected()) {
            retryInterval = retryInterval / 60;
        }
        this.retryIntervalSpinner.setValue(retryInterval);
        Integer retryWindow = this.luSchedule.getOptRetryWindow();
        if (retryWindow == null) {
            retryWindow = this.luSchedule.getDefRetryWindow();
        }
        if (this.weeklyButton.isSelected()) {
            retryWindow = retryWindow / 24;
        }
        this.retryWindowSpinner.setValue(retryWindow);
    }

    private void updateRetryWindowAndInterval() {
        int curRetryWindow = (Integer)this.retryWindowSpinner.getValue();
        int maxRetryWindow = 24;
        if (this.weeklyButton.isSelected()) {
            maxRetryWindow = 7;
            if (curRetryWindow > 7) {
                curRetryWindow = 7;
            }
        } else if (this.dailyButton.isSelected()) {
            maxRetryWindow = 24;
        } else if (this.hourlyButton.isSelected()) {
            int hourFreq;
            maxRetryWindow = hourFreq = ((Integer)this.hourSpinner.getValue()).intValue();
            if (curRetryWindow > hourFreq) {
                curRetryWindow = hourFreq;
            }
        }
        this.retryWindowSpinner.setModel(new SpinnerNumberModel(curRetryWindow, 1, maxRetryWindow, 1));
        this.updateRetryInterval();
    }

    private void updateRetryInterval() {
        int curRetryWindow = (Integer)this.retryWindowSpinner.getValue();
        int curRetryInterval = (Integer)this.retryIntervalSpinner.getValue();
        int maxRetryInterval = 0;
        if (this.weeklyButton.isSelected()) {
            maxRetryInterval = curRetryWindow == 1 ? 12 : 24;
            if (curRetryInterval > maxRetryInterval) {
                curRetryInterval = maxRetryInterval;
            }
            if (curRetryInterval < 1) {
                curRetryInterval = 1;
            }
            this.retryIntervalSpinner.setModel(new SpinnerNumberModel(curRetryInterval, 1, maxRetryInterval, 1));
        } else {
            maxRetryInterval = curRetryWindow == 1 ? 30 : 60;
            if (curRetryInterval > maxRetryInterval) {
                curRetryInterval = maxRetryInterval;
            }
            if (curRetryInterval < 60 && curRetryInterval > 45) {
                curRetryInterval = 60;
            }
            if (curRetryInterval < 45 && curRetryInterval > 30) {
                curRetryInterval = 45;
            }
            if (curRetryInterval < 30 && curRetryInterval > 15) {
                curRetryInterval = 30;
            }
            if (curRetryInterval < 15 && curRetryInterval > 0) {
                curRetryInterval = 15;
            }
            this.retryIntervalSpinner.setModel(new SpinnerNumberModel(curRetryInterval, 15, maxRetryInterval, 15));
        }
    }

    private void updateSchedule() {
        Integer i = this.luSchedule.getOptFrequency();
        if (i == null) {
            i = this.luSchedule.getDefFrequency();
        }
        if (i.equals(LuDownloadSchedule.CONTINUOUS)) {
            this.min15Button.setSelected(true);
        } else if (i.equals(LuDownloadSchedule.HOURLY)) {
            this.hourlyButton.setSelected(true);
        } else if (i.equals(LuDownloadSchedule.WEEKLY)) {
            this.weeklyButton.setSelected(true);
        } else {
            this.dailyButton.setSelected(true);
        }
        Integer hourly = this.luSchedule.getDefFrequencyInterval();
        if (this.luSchedule.getOptFrequencyInterval() != null) {
            hourly = this.luSchedule.getOptFrequencyInterval();
        }
        this.hourSpinner.setValue(hourly / 60);
        Boolean b = this.luSchedule.getOptSpecifyTimeRange();
        if (b == null) {
            b = Boolean.TRUE;
        }
        this.specifyTimeRangeBox.setSelected(b);
        int hour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
        int minute = 0;
        int second = 0;
        int ampm = 0;
        Long stTime = this.luSchedule.getOptStartTime();
        if (stTime != null) {
            int startTime = stTime.intValue();
            int hourOfDay = startTime / 3600;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                hour = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                minute = (startTime - hourOfDay * 3600) / 60;
            }
            if (this.hasSecond) {
                second = startTime - hourOfDay * 3600 - minute * 60;
            }
        }
        this.startSpinner.setHour(hour);
        this.startSpinner.setMinute(minute);
        this.startSpinner.setSecond(second);
        if (this.hasAmpm) {
            this.startSpinner.setAmpm(ampm);
        }
        hour = Utility.convertHourFrom_H_Pattern((int)23, (String)this.hourPattern);
        minute = 59;
        second = 0;
        ampm = 1;
        Long edTime = this.luSchedule.getOptEndTime();
        if (edTime != null) {
            int endTime = edTime.intValue();
            int hourOfDay = endTime / 3600;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                hour = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                minute = (endTime - hourOfDay * 3600) / 60;
            }
            if (this.hasSecond) {
                second = endTime - hourOfDay * 3600 - minute * 60;
            }
        }
        this.endSpinner.setHour(hour);
        this.endSpinner.setMinute(minute);
        this.endSpinner.setSecond(second);
        if (this.hasAmpm) {
            this.endSpinner.setAmpm(ampm);
        }
        if ((i = this.luSchedule.getOptDayOfWeek()) == null) {
            i = 2;
        }
        this.dayBox.setSelectedIndex((i - Calendar.getInstance().getFirstDayOfWeek() + 1 + 7) % 7);
        b = this.luSchedule.getOptAllowRetry();
        if (b == null) {
            b = this.luSchedule.getDefAllowRetry();
        }
        this.retryBox.setSelected(b);
        this.updateRetryInfo();
        if (this.parent != null) {
            this.parent.pack();
        }
    }

    protected JPanel getContentPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JPanel p = new JPanel(new GridBagLayout());
        JPanel freqPanel = new JPanel(new GridBagLayout());
        freqPanel.add((Component)new JLabel(ServerLuPanel.getRes("label.frequency")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0));
        freqPanel.add((Component)this.min15Button, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 0, 1, 10), 0, 0));
        freqPanel.add((Component)this.hourlyButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 1, 1), 0, 0));
        freqPanel.add((Component)this.hourSpinner, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 0), 0, 0));
        freqPanel.add((Component)new JLabel(ServerLuPanel.getRes("label.hourlyFrequency")), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 5, 1, 0), 0, 0));
        freqPanel.add((Component)this.dailyButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 1, 10), 0, 0));
        freqPanel.add((Component)this.weeklyButton, new GridBagConstraints(6, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 1, 1), 0, 0));
        p.add((Component)freqPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 0, new Insets(1, 0, 1, 1), 0, 0));
        p.add((Component)this.specifyTimeRangeBox, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(1, 20, 1, 1), 0, 0));
        this.specifyTimeRangeBox.setVisible(false);
        JPanel timeRangePanel = new JPanel(new GridBagLayout());
        timeRangePanel.add((Component)this.lbStartTime, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 45, 1, 1), 0, 0));
        timeRangePanel.add((Component)this.startSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 10), 0, 0));
        timeRangePanel.add((Component)this.lbEndTime, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 10, 1, 1), 0, 0));
        timeRangePanel.add((Component)this.endSpinner, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 10), 0, 0));
        timeRangePanel.add((Component)this.lbEvery, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 10, 1, 1), 0, 0));
        timeRangePanel.add(this.dayBox, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 0, 1, 10), 0, 0));
        p.add((Component)timeRangePanel, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 1, 1), 0, 0));
        JPanel retryPanel = new JPanel(new GridBagLayout());
        retryPanel.add((Component)this.retryBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 1, 1), 0, 0));
        retryPanel.add((Component)this.retryIntervalSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 0, 1, 1), 0, 0));
        retryPanel.add((Component)this.lbRetryWindow, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 22, 1, 1), 0, 0));
        retryPanel.add((Component)this.retryWindowSpinner, new GridBagConstraints(3, 0, 3, 1, 1.0, 0.0, 17, 0, new Insets(1, 5, 1, 1), 0, 0));
        p.add((Component)retryPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, -10, 1, 1), 0, 0));
        result.add((Component)p, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 1, 1), 0, 0));
        return result;
    }

    public void updateSite() {
        this.saveServerLuSchedule();
        this.luConfig.setOptLuDownloadSchedule(this.luSchedule);
    }

    private void saveServerLuSchedule() {
        int newDayOfWeek;
        int newFrequency;
        int originalDayOfWeek;
        int originalFrequency;
        boolean isChanged = false;
        int originalHour = 240;
        int newHour = 240;
        int n = originalFrequency = this.luSchedule.getOptFrequency() == null ? this.luSchedule.getDefFrequency().intValue() : this.luSchedule.getOptFrequency().intValue();
        if (originalFrequency == LuDownloadSchedule.HOURLY) {
            originalHour = this.luSchedule.getOptFrequencyInterval() == null ? 240 : this.luSchedule.getOptFrequencyInterval();
        }
        boolean originalSpecifyTimeRange = this.luSchedule.getOptSpecifyTimeRange() == null ? false : this.luSchedule.getOptSpecifyTimeRange();
        long originalStartTime = this.luSchedule.getOptStartTime() == null ? 0L : this.luSchedule.getOptStartTime();
        long originalEndTime = this.luSchedule.getOptEndTime() == null ? 0L : this.luSchedule.getOptEndTime();
        int n2 = originalDayOfWeek = this.luSchedule.getOptDayOfWeek() == null ? 0 : this.luSchedule.getOptDayOfWeek();
        if (this.min15Button.isSelected()) {
            this.luSchedule.setOptFrequency(LuDownloadSchedule.CONTINUOUS);
        } else if (this.hourlyButton.isSelected()) {
            Integer hour = (Integer)this.hourSpinner.getValue() * 60;
            this.luSchedule.setOptFrequency(LuDownloadSchedule.HOURLY);
            this.luSchedule.setOptFrequencyInterval(hour);
        } else if (this.weeklyButton.isSelected()) {
            this.luSchedule.setOptFrequency(LuDownloadSchedule.WEEKLY);
        } else {
            this.luSchedule.setOptFrequency(LuDownloadSchedule.DAILY);
        }
        this.luSchedule.setOptSpecifyTimeRange(Boolean.valueOf(this.specifyTimeRangeBox.isSelected()));
        if (this.specifyTimeRangeBox.isSelected()) {
            this.luSchedule.setOptStartTime(Long.valueOf(this.getStartTime()));
            this.luSchedule.setOptEndTime(Long.valueOf(this.getEndTime()));
        }
        this.luSchedule.setOptDayOfWeek(Integer.valueOf((this.dayBox.getSelectedIndex() + Calendar.getInstance().getFirstDayOfWeek() - 1) % 7));
        this.luSchedule.setOptAllowRetry(Boolean.valueOf(this.retryBox.isSelected()));
        Integer retryInterval = (Integer)this.retryIntervalSpinner.getValue();
        Integer retryWindow = (Integer)this.retryWindowSpinner.getValue();
        if (this.weeklyButton.isSelected()) {
            retryInterval = retryInterval * 60;
            retryWindow = retryWindow * 24;
        }
        this.luSchedule.setOptRetryInterval(retryInterval);
        this.luSchedule.setOptRetryWindow(retryWindow);
        int n3 = newFrequency = this.luSchedule.getOptFrequency() != null ? this.luSchedule.getOptFrequency().intValue() : this.luSchedule.getDefFrequency().intValue();
        if (newFrequency == LuDownloadSchedule.HOURLY) {
            newHour = this.luSchedule.getOptFrequencyInterval() != null ? this.luSchedule.getOptFrequencyInterval() : 240;
        }
        boolean newSpecifyTimeRange = this.luSchedule.getOptSpecifyTimeRange() != null ? this.luSchedule.getOptSpecifyTimeRange() : false;
        long newStartTime = this.luSchedule.getOptStartTime() != null ? this.luSchedule.getOptStartTime() : 0L;
        long newEndTime = this.luSchedule.getOptEndTime() != null ? this.luSchedule.getOptEndTime() : 0L;
        int n4 = newDayOfWeek = this.luSchedule.getOptDayOfWeek() != null ? this.luSchedule.getOptDayOfWeek() : 0;
        if (originalFrequency != newFrequency) {
            isChanged = true;
        } else if (newFrequency != LuDownloadSchedule.CONTINUOUS) {
            if (newFrequency == LuDownloadSchedule.HOURLY) {
                if (originalHour != newHour) {
                    isChanged = true;
                }
            } else if (newFrequency == LuDownloadSchedule.DAILY || newFrequency == LuDownloadSchedule.WEEKLY) {
                if (originalSpecifyTimeRange != newSpecifyTimeRange) {
                    isChanged = true;
                } else if (newSpecifyTimeRange) {
                    if (originalStartTime != newStartTime || originalEndTime != newEndTime) {
                        isChanged = true;
                    }
                    if (newFrequency == LuDownloadSchedule.WEEKLY && originalDayOfWeek != newDayOfWeek) {
                        isChanged = true;
                    }
                }
            }
        }
        if (isChanged && newEndTime >= 86400L) {
            if (newFrequency == LuDownloadSchedule.DAILY) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                String strStart = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newStartTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                String strEnd = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newEndTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.info.accrossDay.daily");
                msg = MessageFormat.format(msg, strStart, strEnd);
                MultiLineMsgBox.show(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Info"), msg, 50, 1, -1);
            } else if (newFrequency == LuDownloadSchedule.WEEKLY) {
                int iDay = this.dayBox.getSelectedIndex();
                String strDay = this.dayBox.getSelectedItem().toString();
                String strNextDay = this.dayBox.getItemAt((iDay + 1) % this.dayBox.getItemCount()).toString();
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                String strStart = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newStartTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                String strEnd = DateUtilities.formatDate((long)(cal.getTimeInMillis() + newEndTime * 1000L), (Format)DateFormat.getTimeInstance(3));
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.info.accrossDay.weekly");
                msg = MessageFormat.format(msg, strDay, strStart, strNextDay, strEnd);
                MultiLineMsgBox.show(this.parent, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.title.Info"), msg, 50, 1, -1);
            }
        }
        this.luSchedule.setOptIsChangedByConsole(Boolean.valueOf(isChanged));
    }

    private long getStartTime() {
        return this.calculateSecondsForTimeSpinner(this.startSpinner);
    }

    private long getEndTime() {
        long endTime;
        long startTime = this.calculateSecondsForTimeSpinner(this.startSpinner);
        if (startTime > (endTime = this.calculateSecondsForTimeSpinner(this.endSpinner))) {
            endTime += 86400L;
        }
        return endTime;
    }

    private long calculateSecondsForTimeSpinner(TimeSpinner1 spinner) {
        if (spinner == null) {
            return 0L;
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        int ampm = -1;
        if (this.hasHour) {
            hour = spinner.getHour();
            if (this.hasAmpm) {
                ampm = spinner.getAmpm();
            }
            hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
        }
        if (this.hasMinute) {
            minute = spinner.getMinute();
        }
        if (this.hasSecond) {
            second = spinner.getSecond();
        }
        return (long)hour * 3600L + (long)(minute * 60) + (long)second;
    }

    private static String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel." + key);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_lu_change_schedule";
    }

    public LuDownloadSchedule getLuSchedule() {
        return this.luSchedule;
    }
}

