/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.FtpProxyServerConfig;
import com.sygate.scm.common.configobject.schema.ProxyServerConfig;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerHttpProxyPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile RES = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private static final String DESCRIPTION = RES.getString("ServerHttpProxyPanel.ProxySvrDesc");
    private static final String HTTP_USE_SYSTEM = RES.getString("ServerHttpProxyPanel.combo.HttpUseIeSettings");
    private static final String HTTP_USE_CUSTOM = RES.getString("ServerHttpProxyPanel.combo.HttpUseCustom");
    private static final String HTTP_NOT_USED = RES.getString("ServerHttpProxyPanel.combo.HttpNotUse");
    private static final String FTP_USE_CUSTOM = RES.getString("ServerHttpProxyPanel.combo.FtpUseCustom");
    private static final String FTP_NOT_USED = RES.getString("ServerHttpProxyPanel.combo.FtpNotUse");
    private String[] httpProxyItems = new String[]{HTTP_USE_SYSTEM, HTTP_NOT_USED, HTTP_USE_CUSTOM};
    private Integer[] httpProxyValues = new Integer[]{ProxyServerConfig.USE_IE_SETTINGS, ProxyServerConfig.NOT_USED, ProxyServerConfig.USE_CUSTOM};
    private String[] ftpProxyItems = new String[]{FTP_NOT_USED, FTP_USE_CUSTOM};
    private Integer[] ftpProxyValues = new Integer[]{FtpProxyServerConfig.NOT_USED, FtpProxyServerConfig.USE_CUSTOM};
    private JPanel jHttpProxyPanel = new JPanel(new GridBagLayout());
    private JComboBox<String> jCmbHttpProxy = new JComboBox<String>(this.httpProxyItems);
    private JTextField jTFHttpServer = new JTextField();
    private JTextField jTFHttpPort = new JTextField();
    private JTextField jTFHttpUserName = new JTextField();
    private JTextField jTFHttpPassword = new SEPMPasswordField();
    private JCheckBox jCbxNeedAuth = new JCheckBox(RES.getString("ServerHttpProxyPanel.checkbox.NeedAuthentication"));
    private JCheckBox jCbxIsWindowsAuthentication = new JCheckBox(RES.getString("ServerHttpProxyPanel.checkbox.IsWindowsAuthentication"));
    private JPanel jFtpProxyPanel = new JPanel(new GridBagLayout());
    private JComboBox<String> jCmbFtpProxy = new JComboBox<String>(this.ftpProxyItems);
    private JTextField jTFFtpServer = new JTextField();
    private JTextField jTFFtpPort = new JTextField();
    ServerObject model;
    private boolean readOnly;

    public ServerHttpProxyPanel(boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
    }

    public ServerHttpProxyPanel() {
        this(false);
    }

    public void updateModel() {
        FtpProxyServerConfig ftpProxy;
        SemServer server = this.model.getSemServer();
        ProxyServerConfig httpProxy = server.getOptProxyServerConfig();
        if (httpProxy == null) {
            httpProxy = new ProxyServerConfig();
            server.setOptProxyServerConfig(httpProxy);
        } else {
            httpProxy.setOptEnable(null);
        }
        httpProxy.setOptUsage(this.httpProxyValues[this.jCmbHttpProxy.getSelectedIndex()]);
        httpProxy.setProxyServerAddress(Utility.checkAndAddBrackets((String)this.jTFHttpServer.getText().trim()));
        httpProxy.setProxyServerPort(Integer.valueOf(this.getPortNumber(this.jTFHttpPort.getText().trim())));
        httpProxy.setOptNeedAuthentication(Boolean.valueOf(this.jCbxNeedAuth.isSelected()));
        if (this.jCbxNeedAuth.isSelected()) {
            if (this.jCbxIsWindowsAuthentication.isSelected()) {
                httpProxy.setOptProxyAuthenticationType(ProxyServerConfig.NTLM);
            } else {
                httpProxy.setOptProxyAuthenticationType(ProxyServerConfig.BASIC);
            }
        }
        httpProxy.setOptProxyUserName(this.jTFHttpUserName.getText().trim());
        String oldPassword = httpProxy.getOptProxyPassword();
        String newPassword = this.jTFHttpPassword.getText().trim();
        if (!StringUtilities.isEmpty((String)oldPassword) && StringUtilities.isEmpty((String)newPassword)) {
            httpProxy.setOptProxyPassword("");
        } else if (this.jTFHttpPassword.isEnabled()) {
            int result;
            if (StringUtilities.isEmpty((String)oldPassword) && !StringUtilities.isEmpty((String)newPassword)) {
                httpProxy.setOptProxyPassword(newPassword);
            } else if (!StringUtilities.isEmpty((String)oldPassword) && !"********".equals(newPassword) && 0 == (result = JOptionPane.showConfirmDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.confirmPasswordChangeMessage"), RES.getString("ServerEMailPanel.confirmPasswordChangeTitle"), 0))) {
                httpProxy.setOptProxyPassword(newPassword);
            }
        }
        if (null == httpProxy.getOptProxyPassword()) {
            httpProxy.setOptProxyPassword("");
        }
        if ((ftpProxy = server.getOptFtpProxyServerConfig()) == null) {
            ftpProxy = new FtpProxyServerConfig();
            server.setOptFtpProxyServerConfig(ftpProxy);
        }
        ftpProxy.setOptUsage(this.ftpProxyValues[this.jCmbFtpProxy.getSelectedIndex()]);
        ftpProxy.setProxyServerAddress(Utility.checkAndAddBrackets((String)this.jTFFtpServer.getText().trim()));
        ftpProxy.setProxyServerPort(Integer.valueOf(this.getPortNumber(this.jTFFtpPort.getText().trim())));
    }

    private void initialize() {
        DescriptionTextArea desc = new DescriptionTextArea(DESCRIPTION, 2, 20);
        desc.setColumns(60);
        this.setLayout(new GridBagLayout());
        this.add((Component)desc, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
        this.add((Component)this.getHttpProxyPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getFtpProxyPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getHttpProxyPanel() {
        this.jHttpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.HttpUsage")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jHttpProxyPanel.add(this.jCmbHttpProxy, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jCmbHttpProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ServerHttpProxyPanel.this.httpUsageChanged();
                }
            }
        });
        this.jHttpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.SvrAddr")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jHttpProxyPanel.add((Component)this.jTFHttpServer, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jHttpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.Port")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jHttpProxyPanel.add((Component)this.jTFHttpPort, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jHttpProxyPanel.add((Component)this.jCbxNeedAuth, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.jCbxNeedAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerHttpProxyPanel.this.needAuthChanged();
            }
        });
        this.jHttpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.UserName")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jHttpProxyPanel.add((Component)this.jTFHttpUserName, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jHttpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.ProxyPassword")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jHttpProxyPanel.add((Component)this.jTFHttpPassword, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.jHttpProxyPanel.add((Component)this.jCbxIsWindowsAuthentication, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.jCbxIsWindowsAuthentication.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerHttpProxyPanel.this.isWindowsAuthChanged();
            }
        });
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createTitledBorder(RES.getString("ServerHttpProxyPanel.label.HttpSettings")));
        wrapPanel.add((Component)this.jHttpProxyPanel, "North");
        return wrapPanel;
    }

    private JPanel getFtpProxyPanel() {
        this.jFtpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.FtpUsage")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jFtpProxyPanel.add(this.jCmbFtpProxy, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jCmbFtpProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ServerHttpProxyPanel.this.ftpUsageChanged();
                }
            }
        });
        this.jFtpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.SvrAddr")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jFtpProxyPanel.add((Component)this.jTFFtpServer, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jFtpProxyPanel.add((Component)new JLabel(RES.getString("ServerHttpProxyPanel.label.Port")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jFtpProxyPanel.add((Component)this.jTFFtpPort, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createTitledBorder(RES.getString("ServerHttpProxyPanel.label.FtpSettings")));
        wrapPanel.add((Component)this.jFtpProxyPanel, "Center");
        return wrapPanel;
    }

    private void httpUsageChanged() {
        Integer usage = this.httpProxyValues[this.jCmbHttpProxy.getSelectedIndex()];
        if (ProxyServerConfig.USE_CUSTOM.equals(usage)) {
            this.jTFHttpServer.setEnabled(true);
            this.jTFHttpPort.setEnabled(true);
            this.jCbxNeedAuth.setEnabled(true);
        } else if (ProxyServerConfig.USE_IE_SETTINGS.equals(usage)) {
            this.jTFHttpServer.setEnabled(false);
            this.jTFHttpPort.setEnabled(false);
            this.jCbxNeedAuth.setEnabled(true);
        } else {
            this.jTFHttpServer.setEnabled(false);
            this.jTFHttpPort.setEnabled(false);
            this.jCbxNeedAuth.setEnabled(false);
        }
        this.needAuthChanged();
    }

    private void needAuthChanged() {
        this.jCbxIsWindowsAuthentication.setEnabled(this.jCbxNeedAuth.isEnabled() && this.jCbxNeedAuth.isSelected());
        this.isWindowsAuthChanged();
    }

    private void isWindowsAuthChanged() {
        Integer usage = this.httpProxyValues[this.jCmbHttpProxy.getSelectedIndex()];
        boolean isEnabled = !this.jCbxIsWindowsAuthentication.isEnabled() ? false : (ProxyServerConfig.USE_CUSTOM.equals(usage) ? this.jCbxNeedAuth.isEnabled() && this.jCbxNeedAuth.isSelected() : (ProxyServerConfig.USE_IE_SETTINGS.equals(usage) ? this.jCbxNeedAuth.isEnabled() && this.jCbxNeedAuth.isSelected() && (!this.jCbxIsWindowsAuthentication.isEnabled() || !this.jCbxIsWindowsAuthentication.isSelected()) : false));
        this.jTFHttpUserName.setEnabled(isEnabled);
        this.jTFHttpPassword.setEnabled(isEnabled);
    }

    private void ftpUsageChanged() {
        if (FtpProxyServerConfig.USE_CUSTOM.equals(this.ftpProxyValues[this.jCmbFtpProxy.getSelectedIndex()])) {
            this.jTFFtpServer.setEnabled(true);
            this.jTFFtpPort.setEnabled(true);
        } else {
            this.jTFFtpServer.setEnabled(false);
            this.jTFFtpPort.setEnabled(false);
        }
    }

    private int getPortNumber(String portString) {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            if (!StringUtilities.isEmpty((String)portString)) {
                LoggerUtilities.logException((Throwable)ex);
            }
            return -1;
        }
    }

    private void setHttpModel(ProxyServerConfig config) {
        String usageStr;
        if (null == config) {
            this.jCmbHttpProxy.setSelectedItem(HTTP_USE_SYSTEM);
            return;
        }
        if (config.getOptEnable() != null) {
            usageStr = config.getOptEnable().booleanValue() ? HTTP_USE_CUSTOM : HTTP_USE_SYSTEM;
        } else {
            Integer usage = config.getOptUsage();
            if (null == usage) {
                usage = config.getDefUsage();
            }
            usageStr = ProxyServerConfig.USE_CUSTOM.equals(usage) ? HTTP_USE_CUSTOM : (ProxyServerConfig.NOT_USED.equals(usage) ? HTTP_NOT_USED : HTTP_USE_SYSTEM);
        }
        this.jCmbHttpProxy.setSelectedItem(usageStr);
        this.jTFHttpServer.setText(Utility.checkAndRemoveBrackets((String)config.getProxyServerAddress()));
        Integer port = config.getProxyServerPort();
        if (null == port || port < 0 || port > 65535) {
            this.jTFHttpPort.setText(null);
        } else {
            this.jTFHttpPort.setText(port.toString());
        }
        Boolean needAuth = config.getOptNeedAuthentication();
        if (null == needAuth) {
            needAuth = config.getDefNeedAuthentication();
        }
        this.jCbxNeedAuth.setSelected(needAuth);
        this.jTFHttpUserName.setText(config.getOptProxyUserName());
        String password = config.getOptProxyPassword();
        if (!StringUtilities.isEmpty((String)password)) {
            this.jTFHttpPassword.setText("********");
        } else {
            this.jTFHttpPassword.setText(null);
        }
        Integer authType = config.getOptProxyAuthenticationType();
        if (null == authType) {
            authType = config.getDefProxyAuthenticationType();
        }
        this.jCbxIsWindowsAuthentication.setSelected(ProxyServerConfig.NTLM.equals(authType));
    }

    private void setFtpModel(FtpProxyServerConfig config) {
        if (null == config) {
            this.jCmbFtpProxy.setSelectedItem(FTP_NOT_USED);
            return;
        }
        Integer usage = config.getOptUsage();
        if (null == usage) {
            usage = config.getDefUsage();
        }
        String usageStr = FtpProxyServerConfig.USE_CUSTOM.equals(usage) ? FTP_USE_CUSTOM : FTP_NOT_USED;
        this.jCmbFtpProxy.setSelectedItem(usageStr);
        this.jTFFtpServer.setText(Utility.checkAndRemoveBrackets((String)config.getProxyServerAddress()));
        Integer port = config.getProxyServerPort();
        if (null == port || port < 0 || port > 65535) {
            this.jTFFtpPort.setText(null);
        } else {
            this.jTFFtpPort.setText(port.toString());
        }
    }

    private boolean isValidHttpState() {
        Pattern pattern;
        Matcher matcher;
        Integer usage = this.httpProxyValues[this.jCmbHttpProxy.getSelectedIndex()];
        if (ProxyServerConfig.NOT_USED.equals(usage)) {
            return true;
        }
        if (ProxyServerConfig.USE_CUSTOM.equals(usage)) {
            String address = this.jTFHttpServer.getText().trim();
            if (!Utility.isValidIPAddressOrHostName((String)address, (boolean)false)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidHttpSvrAddr"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
                this.jTFHttpServer.requestFocusInWindow();
                return false;
            }
            int port = this.getPortNumber(this.jTFHttpPort.getText().trim());
            if (port < 0 || port > 65535) {
                JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidHttpSvrPort"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
                this.jTFHttpPort.requestFocusInWindow();
                return false;
            }
        }
        if (!this.jCbxNeedAuth.isEnabled() || !this.jCbxNeedAuth.isSelected() || ProxyServerConfig.USE_IE_SETTINGS.equals(usage) && this.jCbxIsWindowsAuthentication.isSelected()) {
            return true;
        }
        String userName = this.jTFHttpUserName.getText().trim();
        if (StringUtilities.isEmpty((String)userName)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidHttpUser"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
            this.jTFHttpUserName.requestFocusInWindow();
            return false;
        }
        if (userName.contains(":")) {
            JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidHttpUserContainsColon"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
            this.jTFHttpUserName.requestFocusInWindow();
            return false;
        }
        if (this.jCbxIsWindowsAuthentication.isSelected() && !(matcher = (pattern = Pattern.compile("^([A-Za-z0-9\\-_]{1}[A-Za-z0-9.\\-_]{0,14})([\\\\]{1})([^\\/\\\\\\[:;|=,+*?<>\\]\"]{1,64})$")).matcher(userName)).find()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.httpDomainnameError"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
            this.jTFHttpUserName.requestFocusInWindow();
            return false;
        }
        if (StringUtilities.isEmpty((String)this.jTFHttpPassword.getText().trim())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidHttpPwd"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
            this.jTFHttpPassword.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private boolean isValidFtpState() {
        if (!FtpProxyServerConfig.USE_CUSTOM.equals(this.ftpProxyValues[this.jCmbFtpProxy.getSelectedIndex()])) {
            return true;
        }
        String address = this.jTFFtpServer.getText().trim();
        if (!Utility.isValidIPAddressOrHostName((String)address, (boolean)false)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidFtpSvrAddr"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
            this.jTFFtpServer.requestFocusInWindow();
            return false;
        }
        int port = this.getPortNumber(this.jTFFtpPort.getText().trim());
        if (port < 0 || port > 65535) {
            JOptionPane.showMessageDialog(Manager.getFrame(), RES.getString("ServerHttpProxyPanel.error.InvalidFtpSvrPort"), RES.getString("ServerHttpProxyPanel.title.Error"), 0);
            this.jTFFtpPort.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void setModel(ServerObject model) {
        this.model = model;
        SemServer server = model.getSemServer();
        if (null != server) {
            this.setHttpModel(server.getOptProxyServerConfig());
            this.httpUsageChanged();
            this.setFtpModel(server.getOptFtpProxyServerConfig());
            this.ftpUsageChanged();
            this.setReadOnlyStatus();
        }
    }

    public boolean isValidState() {
        return this.isValidHttpState() && this.isValidFtpState();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_http_proxy_server";
    }

    public void setReadOnlyStatus() {
        if (this.readOnly) {
            this.jCmbHttpProxy.setEnabled(false);
            this.jCmbFtpProxy.setEnabled(false);
            this.jTFHttpServer.setEnabled(false);
            this.jTFHttpPort.setEnabled(false);
            this.jTFHttpUserName.setEnabled(false);
            this.jTFHttpPassword.setEnabled(false);
            this.jCbxIsWindowsAuthentication.setEnabled(false);
            this.jCbxNeedAuth.setEnabled(false);
            this.jTFFtpServer.setEnabled(false);
            this.jTFFtpPort.setEnabled(false);
        }
    }
}

