/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.NetworkACL;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.server.dlg.AddIpDlg;
import com.sygate.scm.console.ui.server.dlg.IpEditAllDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.ListMessageBox;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.TextValidator;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String GRANT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.GrantedAccess");
    private static final String DENY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.DeniedAccess");
    private JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(1024), "", 4, 20);
    private JRadioButton jRBGrant = new JRadioButton(GRANT, true);
    private JRadioButton jRBDeny = new JRadioButton(DENY);
    private JButton jBAdd = new JButton(UIText.get(5));
    private JButton jBEdit = new JButton(UIText.get(1024));
    private JButton jBEditAll = new JButton(UIText.get(1025));
    private JButton jBDelete = new JButton(UIText.get(769));
    private NetworkACL grantModeACL = new NetworkACL();
    private NetworkACL denyModeACL = new NetworkACL();
    private ServerObject model;
    private ACLTableModel tableModel = new ACLTableModel();
    private JTable jTACLTable = new StripesTable(this.tableModel);
    private boolean consoleAccessAllowed;
    private JPopupMenu popupMenu;
    private JMenuItem addMenu;
    private JMenuItem deleteMenu;
    private JMenuItem editMenu;
    private JMenuItem editAllMenu;
    protected boolean readOnly;

    public ServerGeneralPanel(boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
        this.denyModeACL.setDefaultMode(NetworkACL.DENY_ALL);
        this.grantModeACL.setDefaultMode(NetworkACL.GRANT_ALL);
    }

    public ServerGeneralPanel() {
        this(false);
    }

    public void updateModel() {
        SemServer server = this.model.getSemServer();
        server.setOptDescription(this.jTADesc.getText());
        server.getConsoleNetworkACL().setNetworkACL(this.tableModel.getNetworkACL());
    }

    protected void showPopup(MouseEvent event) {
        if (this.readOnly) {
            return;
        }
        Point p = event.getPoint();
        int row = this.jTACLTable.rowAtPoint(p);
        if (row != -1) {
            this.jTACLTable.setRowSelectionInterval(row, row);
        }
        if (event.isPopupTrigger()) {
            this.getPopupMenu().show(event.getComponent(), event.getX(), event.getY());
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.editMenu = new JMenuItem(UIText.get(1024));
            this.editMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerGeneralPanel.this.edit();
                }
            });
            this.editAllMenu = new JMenuItem(UIText.get(1025));
            this.editAllMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerGeneralPanel.this.editAll();
                }
            });
            this.deleteMenu = new JMenuItem(UIText.get(769));
            this.deleteMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerGeneralPanel.this.delete(false);
                }
            });
            this.addMenu = new JMenuItem(UIText.get(5));
            this.addMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerGeneralPanel.this.add();
                }
            });
            this.popupMenu.add(this.addMenu);
            this.popupMenu.add(this.editMenu);
            this.popupMenu.add(this.editAllMenu);
            this.popupMenu.add(this.deleteMenu);
            this.tableSelectionChanged();
        }
        return this.popupMenu;
    }

    protected void setReadOnlyStatus() {
        this.jTADesc.setEnabled(!this.readOnly);
        this.jRBGrant.setEnabled(!this.readOnly);
        this.jRBDeny.setEnabled(!this.readOnly);
        this.jBAdd.setEnabled(!this.readOnly);
        this.jBEdit.setEnabled(!this.readOnly);
        this.jBEditAll.setEnabled(!this.readOnly);
        this.jBDelete.setEnabled(!this.readOnly);
        this.jTACLTable.setEnabled(!this.readOnly);
    }

    private void initialize() {
        this.getPopupMenu();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getMainAccessPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        DescriptionTextArea warning = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.LocalIpAllowed"));
        this.add((Component)warning, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(25, 5, 5, 5), 0, 0));
    }

    private JPanel getDescriptionPanel() {
        this.jTADesc.setLineWrap(true);
        this.jTADesc.setWrapStyleWord(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Desc")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panel.add((Component)new JScrollPane(this.jTADesc), "Center");
        return panel;
    }

    private JPanel getMainAccessPanel() {
        Dimension size = this.jTACLTable.getPreferredScrollableViewportSize();
        this.jTACLTable.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTACLTable.getRowHeight() + this.jTACLTable.getRowMargin()) * 5));
        this.jTACLTable.getSelectionModel().setSelectionMode(0);
        this.jTACLTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ex) {
                ServerGeneralPanel.this.tableSelectionChanged();
            }
        });
        this.jTACLTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ServerGeneralPanel.this.showPopup(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                ServerGeneralPanel.this.showPopup(event);
            }

            @Override
            public void mouseClicked(MouseEvent ex) {
                if (ex.getClickCount() >= 2) {
                    ServerGeneralPanel.this.edit();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)this.jTACLTable);
        scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ServerGeneralPanel.this.showPopup(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                ServerGeneralPanel.this.showPopup(event);
            }

            @Override
            public void mouseClicked(MouseEvent ex) {
                if (ex.getClickCount() >= 2) {
                    ServerGeneralPanel.this.edit();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.ConsAccessPerm")));
        panel.add((Component)this.getAccessPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(this.jTACLTable.getTableHeader().getPreferredSize().height, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getAccessPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBGrant);
        group.add(this.jRBDeny);
        this.jRBGrant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerGeneralPanel.this.accessTypeChanged();
            }
        });
        this.jRBDeny.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerGeneralPanel.this.accessTypeChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.label.AccessStateForCons")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.jRBGrant, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBDeny, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.label.Exceptions")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getButtonPanel() {
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ServerGeneralPanel.this.add();
            }
        });
        this.jBEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ServerGeneralPanel.this.edit();
            }
        });
        this.jBEditAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ServerGeneralPanel.this.editAll();
            }
        });
        this.jBDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ServerGeneralPanel.this.delete(false);
            }
        });
        JPanel panel = new JPanel();
        UIUtilities.layoutButtonPanel(panel, new JButton[]{this.jBAdd, this.jBEdit, this.jBEditAll, this.jBDelete}, 1, 1, true, false);
        return panel;
    }

    private void accessTypeChanged() {
        if (this.jRBDeny.isSelected()) {
            this.addLocalHostInDenyMode();
            this.tableModel.setNetworkACL(this.denyModeACL);
        } else {
            this.removeLocalHostInGrantMode();
            this.tableModel.setNetworkACL(this.grantModeACL);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void tableSelectionChanged() {
        boolean isEnabled = this.jTACLTable.getSelectedRow() != -1;
        this.jBEdit.setEnabled(isEnabled);
        this.editMenu.setEnabled(isEnabled);
        this.jBDelete.setEnabled(isEnabled);
        this.deleteMenu.setEnabled(isEnabled);
    }

    private void add() {
        Set<String> ips;
        String description;
        Integer mode = this.tableModel.getNetworkACL().getDefaultMode();
        String title = NetworkACL.GRANT_ALL.equals(mode) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.DenyAccess") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.AllowAccess");
        AddIpDlg dlg = new AddIpDlg(title, null, description = NetworkACL.GRANT_ALL.equals(mode) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.description.DenyAccess") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.description.AllowAccess"), ips = this.getAllIPAddresses());
        if (dlg.isOk()) {
            String ip = dlg.getIP();
            if (ip.indexOf(47) != -1) {
                String ipPart = ip.substring(0, ip.indexOf(47)).trim();
                String maskPart = ip.substring(ip.indexOf(47) + 1).trim();
                SubNet subnet = new SubNet();
                subnet.setNetAddr(ipPart);
                subnet.setNetMask(maskPart);
                this.tableModel.getNetworkACL().addSubNet(subnet);
            } else {
                if (this.isLocalHost(NetworkACL.GRANT_ALL, mode, ip)) {
                    return;
                }
                IpAddress newIP = new IpAddress();
                newIP.setContent(ip);
                this.tableModel.getNetworkACL().addIpAddress(newIP);
            }
            this.tableModel.fireTableDataChanged();
        }
        dlg.dispose();
    }

    private void delete(boolean delSilent) {
        int rowIndex = this.jTACLTable.getSelectedRow();
        if (rowIndex == -1) {
            return;
        }
        if (!delSilent && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.ConfirmDeleteConsole"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.ConfirmDel"), 0)) {
            return;
        }
        NetworkACL acl = this.tableModel.getNetworkACL();
        if (acl.getIpAddressCount() > rowIndex) {
            IpAddress address = acl.getIpAddress(rowIndex);
            if (this.isLocalHost(NetworkACL.DENY_ALL, acl.getDefaultMode(), address.getContent())) {
                return;
            }
            address.getParent().removeChild((AbstractSchema)address);
        } else {
            SubNet subnet = acl.getSubNet(rowIndex - acl.getIpAddressCount());
            subnet.getParent().removeChild((AbstractSchema)subnet);
        }
        this.tableModel.fireTableDataChanged();
    }

    private Set<String> getAllIPAddresses() {
        HashSet<String> ips = new HashSet<String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            ips.add(Utility.getDecompressedIpv6Addr((String)this.tableModel.getValueAt(i, 1).toString()));
        }
        return ips;
    }

    private void edit() {
        int rowIndex = this.jTACLTable.getSelectedRow();
        if (rowIndex == -1) {
            return;
        }
        Integer mode = this.tableModel.getNetworkACL().getDefaultMode();
        String title = NetworkACL.GRANT_ALL.equals(mode) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.DenyAccess") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.AllowAccess");
        String description = NetworkACL.GRANT_ALL.equals(mode) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.description.DenyAccess") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.description.AllowAccess");
        NetworkACL acl = this.tableModel.getNetworkACL();
        IpAddress address = null;
        SubNet subnet = null;
        Object ipAddress = null;
        if (acl.getIpAddressCount() > rowIndex) {
            address = acl.getIpAddress(rowIndex);
            if (this.isLocalHost(NetworkACL.DENY_ALL, acl.getDefaultMode(), address.getContent())) {
                return;
            }
            ipAddress = address.getContent();
        } else {
            subnet = acl.getSubNet(rowIndex - acl.getIpAddressCount());
            ipAddress = subnet.getNetAddr() + "/" + subnet.getNetMask();
        }
        Set<String> ips = this.getAllIPAddresses();
        AddIpDlg dlg = new AddIpDlg(title, (String)ipAddress, description, ips);
        if (dlg.isOk()) {
            String ip = dlg.getIP();
            if (this.isLocalHost(NetworkACL.GRANT_ALL, mode, ip)) {
                return;
            }
            if (ip.indexOf(47) != -1 && subnet != null) {
                String ipPart = ip.substring(0, ip.indexOf(47)).trim();
                String maskPart = ip.substring(ip.indexOf(47) + 1).trim();
                subnet.setNetAddr(ipPart);
                subnet.setNetMask(maskPart);
            } else if (ip.indexOf(47) != -1 && subnet == null) {
                this.delete(true);
                String ipPart = ip.substring(0, ip.indexOf(47)).trim();
                String maskPart = ip.substring(ip.indexOf(47) + 1).trim();
                SubNet newSubnet = new SubNet();
                newSubnet.setNetAddr(ipPart);
                newSubnet.setNetMask(maskPart);
                this.tableModel.getNetworkACL().addSubNet(newSubnet);
            } else if (ip.indexOf(47) == -1 && address != null) {
                address.setContent(ip);
            } else {
                this.delete(true);
                IpAddress newIP = new IpAddress();
                newIP.setContent(ip);
                this.tableModel.getNetworkACL().addIpAddress(newIP);
            }
            this.tableModel.fireTableDataChanged();
        }
        dlg.dispose();
    }

    private void editAll() {
        IpValidator validator;
        String instruction = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.html.InstructionText");
        IpEditAllDlg dlg = new IpEditAllDlg(instruction, validator = new IpValidator());
        if (dlg.isOk()) {
            dlg.exportContent();
        }
        dlg.dispose();
    }

    private void addLocalHostInDenyMode() {
        if (this.jRBDeny.isSelected()) {
            Vector ips = this.denyModeACL.getIpAddress();
            int ipCount = ips.size();
            for (int i = 0; i < ipCount; ++i) {
                IpAddress ip = (IpAddress)ips.get(i);
                if (!ip.getContent().equals(LOCAL_HOST)) continue;
                return;
            }
            IpAddress newIP = new IpAddress();
            newIP.setContent(LOCAL_HOST);
            this.denyModeACL.addIpAddress(newIP);
        }
    }

    private void removeLocalHostInGrantMode() {
        if (this.jRBGrant.isSelected()) {
            int ipCount = this.grantModeACL.getIpAddressCount();
            for (int j = 0; j < ipCount; ++j) {
                IpAddress ipAddress = this.grantModeACL.getIpAddress(j);
                String ipAddr = ipAddress.getContent();
                if (!ipAddr.equals(LOCAL_HOST)) continue;
                this.grantModeACL.removeIpAddress(ipAddress);
            }
        }
    }

    private boolean isLocalHost(Integer aclMode, Integer mode, String ip) {
        if (aclMode.equals(mode) && ip.equals(LOCAL_HOST)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.error.AllowFromLocalhost"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Error"), 0);
            return true;
        }
        return false;
    }

    public boolean isConsoleAccessAllowed() {
        return this.consoleAccessAllowed;
    }

    public void setModel(ServerObject model) {
        this.model = model;
        SemServer server = model.getSemServer();
        String description = server.getOptDescription();
        this.jTADesc.setText(description);
        this.jTADesc.setCaretPosition(0);
        NetworkACL aclData = null;
        try {
            aclData = server.getConsoleNetworkACL().getNetworkACL();
        }
        catch (Exception ignore) {
            ConsoleLogger.log(ignore);
        }
        if (aclData == null) {
            ConsoleLogger.log("Error: NetworkACL is NULL.");
            return;
        }
        Integer defaultMode = aclData.getDefaultMode();
        if (defaultMode == null) {
            aclData.setDefaultMode(NetworkACL.GRANT_ALL);
            defaultMode = NetworkACL.GRANT_ALL;
        }
        if (NetworkACL.GRANT_ALL.equals(defaultMode)) {
            this.jRBGrant.setSelected(true);
        } else {
            this.jRBDeny.setSelected(true);
        }
        if (aclData.getDefaultMode().equals(NetworkACL.DENY_ALL)) {
            this.denyModeACL = aclData;
        } else {
            this.grantModeACL = aclData;
        }
        this.accessTypeChanged();
        this.tableSelectionChanged();
    }

    public boolean isValidState() {
        boolean blockAccess = this.jRBGrant.isSelected();
        if (!blockAccess && this.tableModel.getRowCount() < 1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.error.NeedIPAddr"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Error"), 0);
            return false;
        }
        String consoleLoginIp = null;
        SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
        if (loginInfo != null) {
            consoleLoginIp = loginInfo.getClientIP();
        }
        if (consoleLoginIp == null || consoleLoginIp.trim().length() == 0) {
            try {
                consoleLoginIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException shallNeverHappen) {
                LoggerUtilities.logException((Throwable)shallNeverHappen);
            }
        }
        NetworkACL acls = this.tableModel.getNetworkACL();
        this.consoleAccessAllowed = ServerHandler.isCurrentConsoleAllowedAccess(blockAccess, acls, consoleLoginIp);
        return this.consoleAccessAllowed || 0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.ConfirmSettingsDenyAccess"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Warning"), 0);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_general";
    }

    public void setEditable(boolean editable) {
    }

    private class IpValidator
    implements TextValidator {
        private ArrayList<ConfigObject> validateIPs = new ArrayList();
        private boolean hasLocalHost;

        private IpValidator() {
        }

        @Override
        public String importContent() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < ServerGeneralPanel.this.tableModel.getRowCount(); ++i) {
                buf.append(ServerGeneralPanel.this.tableModel.getValueAt(i, 1) + "\n");
            }
            return buf.toString();
        }

        @Override
        public Collection<String> exportContent(String content) {
            ServerGeneralPanel.this.tableModel.resetModel(this.validateIPs);
            ServerGeneralPanel.this.tableModel.fireTableDataChanged();
            return null;
        }

        private boolean isLineOk(String line) {
            if (line.length() == 0 || line.startsWith("#")) {
                return true;
            }
            boolean isOk = false;
            String ipAddress = line;
            int subnetIndex = ipAddress.indexOf(47);
            if (subnetIndex > 0) {
                String ip = ipAddress.substring(0, subnetIndex).trim();
                String mask = ipAddress.substring(subnetIndex + 1).trim();
                boolean bl = isOk = Utility.isValidIPAddr((String)ip) && Utility.isValidIPAddr((String)mask);
                if (isOk) {
                    SubNet subnet = new SubNet();
                    subnet.setNetAddr(ip);
                    subnet.setNetMask(mask);
                    this.validateIPs.add((ConfigObject)subnet);
                }
            } else {
                isOk = Utility.isValidIPAddr((String)ipAddress);
                this.hasLocalHost |= ipAddress.equals(ServerGeneralPanel.LOCAL_HOST);
                if (!(!isOk || ServerGeneralPanel.this.tableModel.getNetworkACL().getDefaultMode().equals(NetworkACL.GRANT_ALL) && ipAddress.equals(ServerGeneralPanel.LOCAL_HOST))) {
                    IpAddress ip = new IpAddress();
                    ip.setContent(ipAddress.toUpperCase());
                    this.validateIPs.add((ConfigObject)ip);
                }
            }
            return isOk;
        }

        @Override
        public boolean isValidate(String content) {
            if (content == null || content.length() == 0) {
                return true;
            }
            StringTokenizer tokens = new StringTokenizer(content, "\n");
            this.hasLocalHost = false;
            HashMap<String, CallSite> addrMap = new HashMap<String, CallSite>();
            ArrayList<String> invalidAddr = new ArrayList<String>();
            HashSet decompressedAddresses = new HashSet();
            while (tokens.hasMoreTokens()) {
                String addr = tokens.nextToken();
                String decompressedAddress = Utility.getDecompressedIpv6Addr((String)addr).toUpperCase();
                decompressedAddresses.clear();
                decompressedAddresses.addAll(addrMap.keySet());
                if (!decompressedAddresses.contains(decompressedAddress)) {
                    addrMap.put(decompressedAddress, (CallSite)((Object)(addr + "//1")));
                } else {
                    String timesStr = ((String)addrMap.get(decompressedAddress)).split("//")[1];
                    int times = Integer.parseInt(timesStr);
                    addrMap.put(decompressedAddress, (CallSite)((Object)(addr + "//" + (times + 1))));
                }
                if (this.isLineOk(addr)) continue;
                invalidAddr.add(addr);
            }
            if (invalidAddr.size() > 0) {
                ListMessageBox msgBox = new ListMessageBox(Manager.getFrame(), 50, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Error"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.error.invalidIPAddresses"), 0, -1, invalidAddr);
                msgBox.show();
                this.validateIPs.clear();
                return false;
            }
            Set enSet = addrMap.entrySet();
            for (Map.Entry en : enSet) {
                String[] originalAddrWithCount = ((String)en.getValue()).split("//");
                int times = Integer.parseInt(originalAddrWithCount[1]);
                if (times <= 1) continue;
                String msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.duplicateAddressFormat"), times, originalAddrWithCount[0]);
                invalidAddr.add(msg);
            }
            if (invalidAddr.size() > 0) {
                ListMessageBox msgBox = new ListMessageBox(Manager.getFrame(), 50, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Error"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.error.duplicateIPAddresses"), 0, -1, invalidAddr);
                msgBox.show();
                this.validateIPs.clear();
                return false;
            }
            Integer mode = ServerGeneralPanel.this.tableModel.getNetworkACL().getDefaultMode();
            if (mode.equals(NetworkACL.GRANT_ALL) && this.hasLocalHost) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.LocalHostRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Message"), -1);
            } else if (mode.equals(NetworkACL.DENY_ALL) && !this.hasLocalHost) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.LocalHostAdded"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Message"), -1);
                IpAddress ip = new IpAddress();
                ip.setContent(ServerGeneralPanel.LOCAL_HOST);
                this.validateIPs.add(0, (ConfigObject)ip);
            }
            return true;
        }
    }

    private static class ACLTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private NetworkACL acl;

        private ACLTableModel() {
        }

        public void resetModel(Collection<ConfigObject> collection) {
            Vector children = this.acl.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.acl.removeChild((AbstractSchema)children.get(i));
            }
            Iterator<ConfigObject> itr = collection.iterator();
            while (itr.hasNext()) {
                this.acl.addChild((AbstractSchema)itr.next());
            }
        }

        public void setNetworkACL(NetworkACL acl) {
            this.acl = acl;
        }

        public NetworkACL getNetworkACL() {
            return this.acl;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.column.Access");
                }
            }
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.column.IPAddrMask");
        }

        @Override
        public int getRowCount() {
            if (this.acl == null) {
                return 0;
            }
            return this.acl.getIpAddressCount() + this.acl.getSubNetCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (this.acl.getDefaultMode().intValue() == NetworkACL.GRANT_ALL.intValue()) {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.Deny");
                }
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.Allow");
            }
            if (columnIndex == 1) {
                if (this.acl.getIpAddressCount() > rowIndex) {
                    return this.acl.getIpAddress(rowIndex).getContent();
                }
                SubNet subnet = this.acl.getSubNet(rowIndex - this.acl.getIpAddressCount());
                return subnet.getNetAddr() + "/" + subnet.getNetMask();
            }
            return null;
        }
    }
}

