/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.WhitelistLiveUpdateConfig;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ServerFingerprintPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCbxEnable = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.checkbox.EnableLiveUpdate"), true);
    private JTextField jtURLIndex = new JTextField(new RestrictedPlainDocument(256), "", 30);
    private JTextField jtUsernameIndex = new JTextField(new RestrictedPlainDocument(256), "", 30);
    private JPasswordField jpPasswordIndex = new JPasswordField();
    private JTextField jtURLContent = new JTextField(new RestrictedPlainDocument(256), "", 30);
    private JTextField jtUsernameContent = new JTextField(new RestrictedPlainDocument(256), "", 30);
    private JPasswordField jpPasswordContent = new JPasswordField();
    private JRadioButton jRBAuto = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.radio.autoSched"), true);
    private JRadioButton jRBSync = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.radio.syncEvery"));
    private JTextField jtMinutes = new JTextField("", 3);
    private JLabel minutesLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.minutes"));
    private ServerObject model;

    public JCheckBox getAutoUpdateCheckBox() {
        return this.jCbxEnable;
    }

    public JTextField getUrlIndexTextBox() {
        return this.jtURLIndex;
    }

    public JTextField getUrlContentTextBox() {
        return this.jtURLContent;
    }

    public JRadioButton getSyncScheduleRadioButton() {
        return this.jRBSync;
    }

    public JTextField getSyncMinutesTextBox() {
        return this.jtMinutes;
    }

    public ServerFingerprintPanel() {
        this.initialize();
    }

    public void setModel(ServerObject model) {
        Boolean enabled;
        this.model = model;
        SemServer server = model.getSemServer();
        WhitelistLiveUpdateConfig updateConfig = server.getOptWhitelistLiveUpdateConfig();
        if (updateConfig == null) {
            updateConfig = new WhitelistLiveUpdateConfig();
            updateConfig.setOptEnable(Boolean.valueOf(false));
            server.setOptWhitelistLiveUpdateConfig(updateConfig);
        }
        enabled = (enabled = updateConfig.getOptEnable()) == null ? updateConfig.getDefEnable() : enabled;
        this.jCbxEnable.setSelected(enabled);
        this.jtURLIndex.setText(updateConfig.getOptUrlForIndex());
        this.jtURLContent.setText(updateConfig.getOptUrlForContent());
        this.jtUsernameIndex.setText(updateConfig.getOptUserNameForIndex());
        this.jtUsernameContent.setText(updateConfig.getOptUserNameForContent());
        this.jpPasswordIndex.setText(updateConfig.getOptPasswordForIndex());
        this.jpPasswordContent.setText(updateConfig.getOptPasswordForContent());
        Integer frequency = updateConfig.getOptSyncFreq();
        if (frequency == null || 0 == frequency) {
            this.jRBAuto.setSelected(true);
        } else {
            this.jRBSync.setSelected(true);
            this.jtMinutes.setText(String.valueOf(frequency));
        }
        this.enableItemStateChanged();
        this.scheduleTypeChanged();
    }

    public void updateModel() {
        SemServer server = this.model.getSemServer();
        WhitelistLiveUpdateConfig updateConfig = server.getOptWhitelistLiveUpdateConfig();
        if (updateConfig == null) {
            updateConfig = new WhitelistLiveUpdateConfig();
        }
        updateConfig.setOptEnable(Boolean.valueOf(this.jCbxEnable.isSelected()));
        updateConfig.setOptUrlForIndex(this.jtURLIndex.getText());
        updateConfig.setOptUrlForContent(this.jtURLContent.getText());
        updateConfig.setOptUserNameForIndex(this.jtUsernameIndex.getText());
        updateConfig.setOptUserNameForContent(this.jtUsernameContent.getText());
        updateConfig.setOptPasswordForIndex(String.valueOf(this.jpPasswordIndex.getPassword()));
        updateConfig.setOptPasswordForContent(String.valueOf(this.jpPasswordContent.getPassword()));
        boolean autoSchedule = this.jRBAuto.isSelected();
        if (autoSchedule) {
            updateConfig.setOptSyncFreq(null);
        } else {
            Integer hours = null;
            try {
                hours = Integer.valueOf(this.jtMinutes.getText().trim());
            }
            catch (Exception ignore) {
                LoggerUtilities.logException((Throwable)ignore);
            }
            if (hours == null || hours < 1) {
                updateConfig.setOptSyncFreq(null);
            } else {
                updateConfig.setOptSyncFreq(hours);
            }
        }
    }

    public boolean isValidState() {
        if (!this.jCbxEnable.isSelected()) {
            return true;
        }
        String urlIndex = this.jtURLIndex.getText().trim();
        String urlContent = this.jtURLContent.getText().trim();
        if (!this.isValidProtocol(urlIndex) || !this.isValidProtocol(urlContent)) {
            JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.pathError"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.title.Error"), 0);
            return false;
        }
        if (this.jRBSync.isSelected()) {
            Integer minutes = null;
            try {
                minutes = Integer.valueOf(this.jtMinutes.getText().trim());
            }
            catch (Exception ignore) {
                LoggerUtilities.logException((Throwable)ignore);
            }
            if (minutes == null || minutes < 1) {
                JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.error.InvalidFreq"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.title.Error"), 0);
                return false;
            }
        }
        if (!this.isSecureProtocol(urlIndex) || !this.isSecureProtocol(urlContent)) {
            int option = JOptionPane.showConfirmDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.securityWarning"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.title.Warning"), 2, 2);
            return option == 0;
        }
        return true;
    }

    protected boolean isUncPath(String urlPath) {
        boolean isUNC = false;
        if (urlPath != null && !urlPath.isBlank() && ((urlPath = urlPath.trim()).startsWith("\\\\") || urlPath.startsWith("//")) && urlPath.length() > 2) {
            isUNC = true;
        }
        return isUNC;
    }

    protected boolean isValidProtocol(String urlPath) {
        boolean isValid = false;
        try {
            if (urlPath != null && !urlPath.trim().isEmpty()) {
                if (this.isUncPath(urlPath = urlPath.trim())) {
                    isValid = true;
                } else {
                    URL url = new URL(urlPath);
                    String protocolStr = url.getProtocol();
                    boolean isHttp = protocolStr.equalsIgnoreCase("HTTP");
                    boolean isHttps = protocolStr.equalsIgnoreCase("HTTPS");
                    boolean isFtp = protocolStr.equalsIgnoreCase("FTP");
                    isValid = isHttp || isHttps || isFtp;
                }
            }
        }
        catch (MalformedURLException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return isValid;
    }

    protected boolean isSecureProtocol(String urlPath) {
        boolean isSecure = false;
        try {
            URL url = new URL(urlPath);
            if (url.getProtocol() != null && url.getProtocol().equalsIgnoreCase("HTTPS")) {
                isSecure = true;
            }
        }
        catch (MalformedURLException e) {
            if (this.isUncPath(urlPath)) {
                isSecure = true;
            }
            LoggerUtilities.log((String)("Given URL is invalid: " + e.getMessage()));
        }
        return isSecure;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_file_fingerprint_update";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        UiUtilities.setupTitledPanel((JPanel)this, (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.title.fingerprintSettings"));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getEnablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.getSourcePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.getSchedulerPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private void enableItemStateChanged() {
        this.jtURLIndex.setEnabled(this.jCbxEnable.isSelected());
        this.jtUsernameIndex.setEnabled(this.jCbxEnable.isSelected());
        this.jpPasswordIndex.setEnabled(this.jCbxEnable.isSelected());
        this.jtURLContent.setEnabled(this.jCbxEnable.isSelected());
        this.jtUsernameContent.setEnabled(this.jCbxEnable.isSelected());
        this.jpPasswordContent.setEnabled(this.jCbxEnable.isSelected());
        this.jRBAuto.setEnabled(this.jCbxEnable.isSelected());
        this.jRBSync.setEnabled(this.jCbxEnable.isSelected());
        this.jtMinutes.setEnabled(this.jCbxEnable.isSelected());
        this.jtMinutes.setEnabled(this.jCbxEnable.isSelected());
        this.minutesLabel.setEnabled(this.jCbxEnable.isSelected());
    }

    private JPanel getEnablePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.jCbxEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                ServerFingerprintPanel.this.enableItemStateChanged();
            }
        });
        panel.add((Component)this.jCbxEnable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getSourcePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        RestrictedPlainDocument passwordDocument = new RestrictedPlainDocument(256);
        this.jpPasswordIndex.setDocument(passwordDocument);
        RestrictedPlainDocument passwordDocumentContent = new RestrictedPlainDocument(256);
        this.jpPasswordContent.setDocument(passwordDocumentContent);
        int index = 0;
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.urlIndex")), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jtURLIndex, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.usernameIndex")), new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jtUsernameIndex, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.passwordIndex")), new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jpPasswordIndex, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.urlContent")), new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jtURLContent, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.usernameContent")), new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jtUsernameContent, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.label.passwordContent")), new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jpPasswordContent, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        UiUtilities.setupTitledPanel((JPanel)panel, (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.title.sourceForUpdate"));
        return panel;
    }

    private JPanel getSchedulerPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBAuto);
        group.add(this.jRBSync);
        this.jRBAuto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerFingerprintPanel.this.scheduleTypeChanged();
            }
        });
        this.jRBSync.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerFingerprintPanel.this.scheduleTypeChanged();
            }
        });
        this.jtMinutes.setHorizontalAlignment(4);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jRBAuto, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.jRBSync, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.jtMinutes, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.minutesLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "West");
        UiUtilities.setupTitledPanel((JPanel)wrapPanel, (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerFingerprintPanel.title.schedule"));
        return wrapPanel;
    }

    private void scheduleTypeChanged() {
        this.jtMinutes.setEnabled(this.jRBSync.isSelected() && this.jCbxEnable.isSelected());
    }
}

