/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.EmailServerConfig;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.valueobject.EmailServerSettingsVO;
import com.sygate.scm.common.valueobject.LoginUserVO;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.EmailValidator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.mail.TestEmailSender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ServerEMailPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 3689712671587810617L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private static final MessageResourcesFile MSG_RES_MAIL = new MessageResourcesFile("com.sygate.scm.util.mail.mail");
    protected JTextField jTFAddress = new JTextField(new RestrictedPlainDocument(256), "", 30);
    protected JTextField jTFPort = new JTextField(new NumberPlainDocument(65535L, true), "", 5);
    RestrictedPlainDocument emailDoc = new RestrictedPlainDocument(256, "!:;`<>/',()+={}[]|?#$%^&* \\\"~", false);
    protected JTextField jTFUser = new JTextField(new RestrictedPlainDocument(256), "", 30);
    protected JTextField jTFSender = new JTextField(this.emailDoc, "", 30);
    protected JPasswordField jTFPassword = new SEPMPasswordField();
    protected JCheckBox jCBSecureConnectionEnable = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.checkbox.requireSecureConnection"));
    protected JRadioButton jRBsslEnable = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.radio.SSLEnable"));
    protected JRadioButton jRBtlsEnable = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.radio.TLSEnable"));
    protected final JCheckBox jCBDisableCertValidation = new JCheckBox(MSG_RES_MAIL.getString("mailServer.disableCertValidation.checkbox.label"));
    protected final JLabel disableCertValidationWarningIcon = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconWarning.png"))));
    protected final JTextArea disableCertValidationWarningText = new JTextArea(MSG_RES_MAIL.getString("mailServer.disableCertValidation.checkbox.warning"));
    private JButton jTestEmailButton = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.button.testEmailSettings.title"));
    private ButtonGroup emailConfirmationButtonGroup = new ButtonGroup();
    private JLabel emailConfirmationLabel = new JLabel(MSG_RES.getString("ServerEMailPanel.confirmTestEmail"));
    private JRadioButton emailReceievedButton = new JRadioButton(MSG_RES.getString("ServerEMailPanel.receivedTestEmail"));
    private JRadioButton emailNotReceievedButton = new JRadioButton(MSG_RES.getString("ServerEMailPanel.notReceivedTestEmail"));
    boolean testEmailSentSuccessfully = false;
    boolean emailAddressValidationFlowCompleted = false;
    boolean testEmailConfirmed = false;
    int testEmailSendCount = 0;
    private boolean passwordChanged = false;
    private String currPassword;
    private boolean userConfirmedPasswordChange = false;
    private ServerObject model;
    private EmailServerConfig emailConfig;
    protected boolean readOnly;

    public ServerEMailPanel(ServerObject model, boolean readOnly) {
        this.model = model;
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
    }

    public ServerObject getModel() {
        return this.model;
    }

    public void setModel(ServerObject model) {
        this.model = model;
        this.setEmailConfigObject(model);
        this.jTFAddress.setText(this.emailConfig.getSmtpServerAddress());
        if (this.emailConfig.getOptSmtpServerPort() == null) {
            this.jTFPort.setText("");
        } else {
            this.jTFPort.setText(Integer.toString(this.emailConfig.getOptSmtpServerPort()));
        }
        this.jTFUser.setText(this.emailConfig.getOptUserName());
        this.currPassword = this.emailConfig.getOptUserPassword();
        if (!StringUtilities.isEmpty((String)this.emailConfig.getOptUserPassword())) {
            this.jTFPassword.setText("********");
        } else {
            this.jTFPassword.setText(this.emailConfig.getOptUserPassword());
        }
        this.jTFSender.setText(this.emailConfig.getOptSenderAddress());
        this.jRBsslEnable.setSelected(this.emailConfig.getOptSSLConnection() == null ? this.emailConfig.getDefSSLConnection() : this.emailConfig.getOptSSLConnection());
        this.jRBtlsEnable.setSelected(this.emailConfig.getOptTLSConnection() == null ? this.emailConfig.getDefTLSConnection() : this.emailConfig.getOptTLSConnection());
        this.jCBDisableCertValidation.setSelected(this.emailConfig.getOptDisableCertValidation() == null ? this.emailConfig.getDefDisableCertValidation() : this.emailConfig.getOptDisableCertValidation());
        this.jCBSecureConnectionEnable.setSelected(this.jRBsslEnable.isSelected() || this.jRBtlsEnable.isSelected());
        this.changeCheckBoxStatus();
        this.changeDisableCertValidationWarningStatus();
        if (StringUtilities.isEmpty((String)this.jTFAddress.getText().trim())) {
            this.jTestEmailButton.setEnabled(false);
        }
    }

    private void setEmailConfigObject(ServerObject model) {
        SemServer server = model.getSemServer();
        this.emailConfig = server.getOptEmailServerConfig();
        if (this.emailConfig == null) {
            this.emailConfig = new EmailServerConfig();
            this.emailConfig.setSmtpServerAddress("");
            this.emailConfig.setRequireAuthentication(Boolean.FALSE);
            this.emailConfig.setOptSmtpServerPort(Integer.valueOf(25));
            server.setOptEmailServerConfig(this.emailConfig);
        }
    }

    public void updateModel() {
        SemServer server = this.model.getSemServer();
        if (this.readEmailConfig(this.emailConfig) == null) {
            server.setOptEmailServerConfig(null);
        }
    }

    protected EmailServerConfig readEmailConfig(EmailServerConfig emailConfig) {
        String serverAddress = this.jTFAddress.getText().trim();
        if (StringUtilities.isEmpty((String)serverAddress)) {
            return null;
        }
        if (emailConfig == null) {
            emailConfig = new EmailServerConfig();
        }
        emailConfig.setSmtpServerAddress(serverAddress);
        String srvPort = this.jTFPort.getText().trim();
        if (srvPort == null || srvPort.length() == 0) {
            emailConfig.setOptSmtpServerPort(null);
        } else {
            emailConfig.setOptSmtpServerPort(Integer.valueOf(Integer.parseInt(srvPort)));
        }
        emailConfig.setOptUserName(this.jTFUser.getText().trim());
        if (this.passwordChanged) {
            emailConfig.setOptUserPassword(new String(this.jTFPassword.getPassword()));
        } else {
            emailConfig.setOptUserPassword(this.currPassword);
        }
        emailConfig.setOptSSLConnection(Boolean.valueOf(this.jCBSecureConnectionEnable.isSelected() && this.jRBsslEnable.isSelected()));
        emailConfig.setOptTLSConnection(Boolean.valueOf(this.jCBSecureConnectionEnable.isSelected() && this.jRBtlsEnable.isSelected()));
        emailConfig.setOptDisableCertValidation(Boolean.valueOf(this.jCBSecureConnectionEnable.isSelected() && this.jCBDisableCertValidation.isSelected()));
        emailConfig.setOptSenderAddress(this.jTFSender.getText().trim());
        return emailConfig;
    }

    private boolean compareValues(String valueInUI, String valueInModel) {
        boolean valueEqual;
        boolean valueInModelEmpty = StringUtilities.isEmpty((String)valueInModel);
        boolean valueInUIEmpty = StringUtilities.isEmpty((String)valueInUI);
        boolean bl = valueEqual = valueInUIEmpty && valueInModelEmpty;
        if (!valueInUIEmpty && !valueInModelEmpty) {
            valueEqual = valueInModel.equals(valueInUI);
        }
        return valueEqual;
    }

    public boolean isValidState(boolean skipValidateIfValuesUnchanged) {
        boolean disableCertValidationValueEqual;
        boolean tLSEnabledValueEqual;
        boolean sSLEnabledValueEqual;
        boolean portValueEqual;
        String password = new String(this.jTFPassword.getPassword());
        this.verifyPasswordChange(password);
        String emailServer = this.jTFAddress.getText().trim();
        String port = this.jTFPort.getText().trim();
        String user = this.jTFUser.getText().trim();
        String sender = this.jTFSender.getText().trim();
        boolean portEmpty = StringUtilities.isEmpty((String)port);
        boolean portInModelNull = this.emailConfig.getOptSmtpServerPort() == null;
        boolean bl = portValueEqual = portEmpty && portInModelNull;
        if (!portEmpty && !portInModelNull) {
            portValueEqual = this.emailConfig.getOptSmtpServerPort() == Integer.parseInt(port);
        }
        boolean sSLEnabledInModelNull = this.emailConfig.getOptSSLConnection() == null;
        boolean bl2 = sSLEnabledValueEqual = sSLEnabledInModelNull && !this.jRBsslEnable.isSelected();
        if (!sSLEnabledInModelNull) {
            sSLEnabledValueEqual = this.emailConfig.getOptSSLConnection().booleanValue() == this.jRBsslEnable.isSelected();
        }
        boolean tLSEnabledInModelNull = this.emailConfig.getOptTLSConnection() == null;
        boolean bl3 = tLSEnabledValueEqual = tLSEnabledInModelNull && !this.jRBtlsEnable.isSelected();
        if (!tLSEnabledInModelNull) {
            tLSEnabledValueEqual = this.emailConfig.getOptTLSConnection().booleanValue() == this.jRBtlsEnable.isSelected();
        }
        boolean disableCertValidationInModelNull = this.emailConfig.getOptDisableCertValidation() == null;
        boolean bl4 = disableCertValidationValueEqual = disableCertValidationInModelNull && !this.jCBDisableCertValidation.isSelected();
        if (!disableCertValidationInModelNull) {
            boolean bl5 = disableCertValidationValueEqual = this.emailConfig.getOptDisableCertValidation().booleanValue() == this.jCBDisableCertValidation.isSelected();
        }
        if (skipValidateIfValuesUnchanged && this.compareValues(emailServer, this.emailConfig.getSmtpServerAddress()) && this.compareValues(user, this.emailConfig.getOptUserName()) && this.compareValues(sender, this.emailConfig.getOptSenderAddress()) && (!this.passwordChanged || this.compareValues(password, this.emailConfig.getOptUserPassword())) && portValueEqual && sSLEnabledValueEqual && tLSEnabledValueEqual && disableCertValidationValueEqual && this.testEmailSendCount == 0) {
            return true;
        }
        if (StringUtilities.isEmpty((String)emailServer) && portEmpty) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.error.serverSettingCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.Error"), 0);
            this.jTFAddress.requestFocus();
            return false;
        }
        if (StringUtilities.isEmpty((String)emailServer) && !portEmpty) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.error.EmailServerCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.Error"), 0);
            this.jTFAddress.requestFocus();
            return false;
        }
        if (!Utility.isValidIPAddressOrHostName((String)emailServer, (boolean)false)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.pleaseEnterValidServerIP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.Error"), 0);
            this.jTFAddress.requestFocus();
            return false;
        }
        if (!StringUtilities.isEmpty((String)emailServer) && portEmpty) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.error.EmailPortCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.Error"), 0);
            this.jTFPort.requestFocus();
            return false;
        }
        if (this.passwordChanged && StringUtilities.isEmpty((String)user) && !StringUtilities.isEmpty((String)password)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.error.userNameIsRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.Error"), 0);
            this.jTFUser.requestFocus();
            return false;
        }
        if (!StringUtilities.isEmpty((String)sender) && !EmailValidator.isValidEmailAddress((String)sender)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.error.invalidEmailMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.Error"), 0);
            this.jTFSender.requestFocus();
            return false;
        }
        return this.isEmailValidated();
    }

    private boolean isEmailValidated() {
        if (!this.emailAddressValidationFlowCompleted) {
            if (this.testEmailSendCount == 0) {
                String msg = MSG_RES.getString("ServerEMailPanel.emailAddressValidationFlowNotCompleted");
                String title = MSG_RES.getString("ServerEMailPanel.emailAddressValidationFlowNotCompletedTitle");
                int result = JOptionPane.showConfirmDialog(Manager.getFrame(), msg, title, 0);
                if (result == 0) {
                    this.sendTestMail();
                    return false;
                }
                this.emailAddressValidationFlowCompleted = true;
                this.testEmailSentSuccessfully = true;
                this.testEmailConfirmed = true;
            } else {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("ServerEMailPanel.confirmEmailReceived"), MSG_RES.getString("ServerEMailPanel.confirmEmailReceivedTitle"), 1);
                this.emailReceievedButton.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_mail_server";
    }

    private void initialize() {
        this.jTFAddress.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (StringUtilities.isEmpty((String)ServerEMailPanel.this.jTFAddress.getText().trim())) {
                    ServerEMailPanel.this.jTestEmailButton.setEnabled(false);
                } else {
                    ServerEMailPanel.this.jTestEmailButton.setEnabled(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.jTFPassword.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ServerEMailPanel.this.userConfirmedPasswordChange = false;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.jTestEmailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEMailPanel.this.sendTestMail();
            }
        });
        this.setEmailConfigObject(this.model);
        this.setLayout(new BorderLayout());
        UiUtilities.setupTitledPanel((JPanel)this, (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.title.EmailSvrSetting"));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        RestrictedPlainDocument passwordDocument = new RestrictedPlainDocument(256);
        this.jTFPassword.setDocument(passwordDocument);
        this.emailReceievedButton.setEnabled(this.testEmailSentSuccessfully);
        this.emailNotReceievedButton.setEnabled(this.testEmailSentSuccessfully);
        this.emailReceievedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEMailPanel.this.emailAddressValidationFlowCompleted = true;
                ServerEMailPanel.this.testEmailConfirmed = true;
            }
        });
        this.emailNotReceievedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEMailPanel.this.handleErrorWithTestEmailFlow("");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.label.SvrAddr")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFAddress, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.label.Port")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFPort, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.label.Sender")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFSender, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.label.UserName")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFUser, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.label.Passwd")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFPassword, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.jCBSecureConnectionEnable, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 5), 0, 0));
        panel.add((Component)this.jRBsslEnable, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.jRBtlsEnable, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.jCBDisableCertValidation, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 40, 0, 0), 0, 0));
        panel.add((Component)this.getDisableCertValidationWarningBox(), new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 60, 0, 0), 0, 0));
        JPanel userConfirmationPanel = new JPanel(new GridBagLayout());
        userConfirmationPanel.add((Component)this.jTestEmailButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        userConfirmationPanel.add((Component)this.emailConfirmationLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 35, 5, 0), 0, 0));
        userConfirmationPanel.add((Component)this.emailReceievedButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        userConfirmationPanel.add((Component)this.emailNotReceievedButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.emailConfirmationButtonGroup.add(this.emailReceievedButton);
        this.emailConfirmationButtonGroup.add(this.emailNotReceievedButton);
        panel.add((Component)userConfirmationPanel, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 17, 2, new Insets(30, 5, 0, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBsslEnable);
        group.add(this.jRBtlsEnable);
        this.jCBSecureConnectionEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEMailPanel.this.changeCheckBoxStatus();
                ServerEMailPanel.this.validatePort();
            }
        });
        this.jRBsslEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEMailPanel.this.validatePort();
            }
        });
        this.jRBtlsEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEMailPanel.this.validatePort();
            }
        });
        this.jCBDisableCertValidation.addActionListener(e -> this.changeDisableCertValidationWarningStatus());
        return panel;
    }

    private Box getDisableCertValidationWarningBox() {
        this.disableCertValidationWarningText.setEditable(false);
        this.disableCertValidationWarningText.setWrapStyleWord(true);
        this.disableCertValidationWarningText.setLineWrap(true);
        this.disableCertValidationWarningText.setOpaque(true);
        this.disableCertValidationWarningText.setAlignmentX(0.0f);
        this.disableCertValidationWarningText.setMargin(new Insets(0, 10, 0, 0));
        Box disableCertValidationWarningBox = Box.createHorizontalBox();
        disableCertValidationWarningBox.add(this.disableCertValidationWarningIcon);
        disableCertValidationWarningBox.add(this.disableCertValidationWarningText);
        return disableCertValidationWarningBox;
    }

    protected void validatePort() {
        if (this.jCBSecureConnectionEnable.isEnabled() && this.jCBSecureConnectionEnable.isSelected()) {
            if (this.jRBsslEnable.isSelected()) {
                this.jTFPort.setText("465");
            } else if (this.jRBtlsEnable.isSelected()) {
                this.jTFPort.setText("587");
            } else {
                this.jTFPort.setText("");
            }
        } else {
            this.jTFPort.setText("25");
        }
    }

    private void changeCheckBoxStatus() {
        boolean secureEnabled = this.jCBSecureConnectionEnable.isSelected();
        this.jRBsslEnable.setEnabled(secureEnabled);
        this.jRBtlsEnable.setEnabled(secureEnabled);
        this.jCBDisableCertValidation.setEnabled(secureEnabled);
        this.changeDisableCertValidationWarningStatus();
        if (secureEnabled && !this.jRBtlsEnable.isSelected() && !this.jRBsslEnable.isSelected()) {
            this.jRBtlsEnable.setSelected(true);
        }
    }

    protected void changeDisableCertValidationWarningStatus() {
        boolean enabled = this.jCBDisableCertValidation.isEnabled() && this.jCBDisableCertValidation.isSelected();
        this.disableCertValidationWarningIcon.setEnabled(enabled);
        this.disableCertValidationWarningText.setEnabled(enabled);
    }

    private void setReadOnlyStatus() {
        this.jTFAddress.setEnabled(!this.readOnly);
        this.jTFPort.setEnabled(!this.readOnly);
        this.jTFUser.setEnabled(!this.readOnly);
        this.jTFPassword.setEnabled(!this.readOnly);
        this.jTFSender.setEnabled(!this.readOnly);
        this.jCBSecureConnectionEnable.setEnabled(!this.readOnly);
        this.jRBsslEnable.setEnabled(!this.readOnly);
        this.jRBtlsEnable.setEnabled(!this.readOnly);
        this.jCBDisableCertValidation.setEnabled(!this.readOnly);
        this.disableCertValidationWarningIcon.setEnabled(!this.readOnly);
        this.disableCertValidationWarningText.setEnabled(!this.readOnly);
        this.jTestEmailButton.setEnabled(!this.readOnly);
    }

    private String toEmailAddress() {
        return DataobjectManager.getInstance().getCurrentAdministrator().getOptEmailAddress();
    }

    private String toSysAdminName() {
        return DataobjectManager.getInstance().getCurrentAdministrator().getName();
    }

    private ServerObject getCurrentServerObject() {
        ServerObject server = null;
        try {
            server = ServerHandler.getSBServerByGUID(Manager.getCurrentServerId());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        finally {
            if (server == null) {
                server = new ServerObject();
            }
        }
        return server;
    }

    private void sendTestMail() {
        this.jTestEmailButton.setEnabled(false);
        ServerObject currentServer = this.getCurrentServerObject();
        String serverIp = currentServer.getServerAddressString();
        serverIp = serverIp.replaceAll("<BR>", ",");
        LoginUserVO loginUser = null;
        String toEmailAddress = this.toEmailAddress();
        if (!EmailValidator.isValidEmailAddress((String)toEmailAddress)) {
            System.out.println("To email address is invalid in sendTestMail(). Email address: " + toEmailAddress);
            String sMessageEmailInvalid = MSG_RES.getString("ServerEMailPanel.toEmailIsInvalid");
            sMessageEmailInvalid = MessageFormat.format(sMessageEmailInvalid, this.toSysAdminName());
            JOptionPane.showMessageDialog(Manager.getFrame(), sMessageEmailInvalid, MSG_RES.getString("ServerEMailPanel.title.Error"), 0);
            this.jTFAddress.requestFocus();
            this.jTestEmailButton.setEnabled(true);
            return;
        }
        loginUser = new LoginUserVO(toEmailAddress);
        String password = new String(this.jTFPassword.getPassword());
        this.verifyPasswordChange(password);
        TestEmailSender sender = new TestEmailSender(new EmailServerSettingsVO(this.readEmailConfig(null)), loginUser, (JFrame)Manager.getFrame(), "TestEmailSender", currentServer.getName(), serverIp);
        sender.setDisplayStatusMessages(false);
        if (sender.sendTestEmail()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("ServerEMailPanel.sentTestEmail"), MSG_RES.getString("ServerEMailPanel.testEmail"), 1);
            this.testEmailSentSuccessfully = true;
            this.emailReceievedButton.setEnabled(true);
            this.emailNotReceievedButton.setEnabled(true);
            this.emailReceievedButton.requestFocus();
        } else {
            this.handleErrorWithTestEmailFlow(MSG_RES.getString("ServerEMailPanel.cannotSendTestEmail"));
            this.emailReceievedButton.setEnabled(false);
            this.emailNotReceievedButton.setEnabled(false);
            this.jTFAddress.requestFocus();
        }
        ++this.testEmailSendCount;
        this.jTestEmailButton.setEnabled(true);
    }

    private void handleErrorWithTestEmailFlow(String startingMessage) {
        this.testEmailConfirmed = false;
        this.emailAddressValidationFlowCompleted = true;
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
        String url = MessageFormat.format(MSG_RES.getString("ServerEMailPanel.configureEmailServerSettingsKBLink"), obj);
        String text = MSG_RES.getString("ServerEMailPanel.configureEmailServerSettingsKBText");
        UIUtilities.showHTMLMessageDialog(Manager.getFrame(), startingMessage + MSG_RES.getString("ServerEMailPanel.configureEmailServerSettingsMessageText_prefix"), text, MSG_RES.getString("ServerEMailPanel.configureEmailServerSettingsMessageText_suffix"), url, MSG_RES.getString("ServerEMailPanel.configureEmailServerSettings"), 1, false);
    }

    private void verifyPasswordChange(String password) {
        if (!(StringUtilities.isEmpty((String)password) || StringUtilities.isEmpty((String)this.emailConfig.getOptUserPassword()) || this.userConfirmedPasswordChange || password.equals("********"))) {
            int result = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.confirmPasswordChangeMessage"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.confirmPasswordChangeTitle"), 0);
            if (result == 0) {
                this.passwordChanged = true;
                this.currPassword = password;
            }
            this.userConfirmedPasswordChange = true;
        }
        if (StringUtilities.isEmpty((String)this.emailConfig.getOptUserPassword()) && !StringUtilities.isEmpty((String)password) || !StringUtilities.isEmpty((String)this.emailConfig.getOptUserPassword()) && StringUtilities.isEmpty((String)password)) {
            this.passwordChanged = true;
            this.currPassword = password;
        }
    }
}

