/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ReIndexScheduleDlg
extends DialogBase {
    private static final long serialVersionUID = -9095531314437650230L;
    private TimeSpinner1 startSpinner;
    private JRadioButton weeklyButton;
    private JRadioButton dailyButton;
    private JComboBox<String> weekDay;
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private String hourPattern = Utility.getHourPatterFromTimePattern((String)this.timePattern);
    private JPanel schedulePanel;
    private Schedule schedule;
    private boolean readOnly;

    public ReIndexScheduleDlg(Schedule sch, boolean readOnly) {
        super(Manager.getFrame(), "", true, false);
        this.readOnly = readOnly;
        this.schedule = sch;
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ReIndexScheduleDlg.title");
        super.setTitle(str);
        this.initialize();
        this.setModel();
        this.setReadOnlyStatus();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    @Override
    protected void commit() {
        if (this.readOnly) {
            return;
        }
        int hour = this.startSpinner.getHour();
        int minute = this.startSpinner.getMinute();
        int ampm = this.startSpinner.getAmpm();
        hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
        this.schedule.setOptStartHour(Integer.toString(hour));
        this.schedule.setOptStartMinute(Integer.valueOf(minute));
        if (this.weeklyButton.isSelected()) {
            int dayOfWeek = this.weekDay.getSelectedIndex();
            this.schedule.setOptStartDayOfWeek(Integer.toString(dayOfWeek));
            this.schedule.setOptSimpleFrequency(Integer.valueOf(2));
        } else {
            this.schedule.setOptSimpleFrequency(Integer.valueOf(1));
        }
    }

    private String getResourceString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", key);
    }

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getSchedulePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    private JPanel getSchedulePanel() {
        this.schedulePanel = new JPanel(new GridBagLayout());
        JLabel lblFrequency = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ReIndexScheduleDlg.label.frequency"));
        JLabel lblStart = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ReIndexScheduleDlg.label.start"));
        JLabel lblEvery = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ReIndexScheduleDlg.label.every"));
        this.weekDay = new JComboBox<String>(Utility.getDayOfWeek());
        this.weeklyButton = new JRadioButton(this.getResourceString("ReIndexScheduleDlg.radio.weekly"));
        this.weeklyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReIndexScheduleDlg.this.weekDay.setEnabled(ReIndexScheduleDlg.this.weeklyButton.isSelected());
            }
        });
        this.dailyButton = new JRadioButton(this.getResourceString("ReIndexScheduleDlg.radio.daily"));
        this.dailyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReIndexScheduleDlg.this.weekDay.setEnabled(ReIndexScheduleDlg.this.weeklyButton.isSelected());
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.weeklyButton);
        buttonGroup.add(this.dailyButton);
        this.startSpinner = new TimeSpinner1(this.timePattern);
        this.schedulePanel.add((Component)lblFrequency, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.schedulePanel.add((Component)this.dailyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.schedulePanel.add((Component)this.weeklyButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.schedulePanel.add((Component)lblStart, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.schedulePanel.add((Component)this.startSpinner, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.schedulePanel.add((Component)lblEvery, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.schedulePanel.add(this.weekDay, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        return this.schedulePanel;
    }

    private void setModel() {
        boolean hasAMPM;
        int day = 0;
        String dayOfWeek = this.schedule.getOptStartDayOfWeek();
        if (this.schedule.getOptSimpleFrequency() == 2) {
            this.weeklyButton.setSelected(true);
            day = Integer.parseInt(dayOfWeek);
            this.weekDay.setSelectedIndex(day);
        } else {
            this.dailyButton.setSelected(true);
        }
        String startHour = this.schedule.getOptStartHour();
        Integer startMinute = this.schedule.getOptStartMinute();
        int hour = Integer.parseInt(startHour);
        int minute = startMinute == null ? 0 : startMinute;
        this.startSpinner.setHour(hour);
        this.startSpinner.setMinute(minute);
        boolean bl = hasAMPM = this.timePattern.indexOf("a") != -1;
        if (hasAMPM) {
            int ampm = Utility.getAmpmFrom_H_Pattern((int)Integer.parseInt(startHour), (String)this.hourPattern);
            this.startSpinner.setAmpm(ampm);
        }
    }

    @Override
    protected void setReadOnlyStatus() {
        boolean freqWeekly = this.schedule.getOptSimpleFrequency() == 2;
        this.startSpinner.setEnabled(!this.readOnly);
        this.weeklyButton.setEnabled(!this.readOnly);
        this.dailyButton.setEnabled(!this.readOnly);
        this.weekDay.setEnabled(!this.readOnly && freqWeekly);
    }
}

