/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.common.configobject.schema.Replication;
import com.sygate.scm.common.configobject.schema.ReplicationContent;
import com.sygate.scm.common.configobject.schema.ReplicationPartnerArray;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SiteContactArray;
import com.sygate.scm.common.configobject.schema.TimeFrame;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ReplicationScheduleUtility;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class PartnerDlg
extends DialogBase {
    private static MessageResourcesFile resource = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private static final long serialVersionUID = 1L;
    private static final String sHOURLY = resource.getString("PartnerDlg.combo.Hourly");
    private static final String sDAILY = resource.getString("PartnerDlg.combo.Daily");
    private static final String sWEEKLY = resource.getString("PartnerDlg.combo.Weekly");
    private static final String sAUTO = resource.getString("PartnerDlg.checkbox.AutoRepl");
    private static final String sMANUAL = resource.getString("PartnerDlg.checkbox.ManualRepl");
    private JTextField jTFName = new JTextField();
    private JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(1024), "", 3, 20);
    private JTextArea jTAServer = new JTextArea(3, 20);
    private JCheckBox jCbxLocalToPartnerLog = new JCheckBox(resource.getString("PartnerDlg.checkbox.ReplLocalToPartner"));
    private JCheckBox jCbxPartnerToLocalLog = new JCheckBox(resource.getString("PartnerDlg.checkbox.ReplPartnerToLocal"));
    private JCheckBox jCbxReplicateClientPackages = new JCheckBox();
    protected final JCheckBox jCbxDisableHostnameValidation = new JCheckBox(resource.getString("PartnerDlg.checkbox.DisableHostnameValidation"));
    private final JLabel disableHostnameValidationWarningIcon = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconWarning.png"))));
    private final JTextArea disableHostnameValidationWarningText = new JTextArea(resource.getString("PartnerDlg.checkbox.DisableHostnameValidation.warning"));
    private JRadioButton jRBAuto = new JRadioButton(resource.getString("PartnerDlg.checkbox.AutoRepl"));
    private JRadioButton jRBManual = new JRadioButton(resource.getString("PartnerDlg.checkbox.ManualRepl"));
    private JRadioButton jRBHourly = new JRadioButton(resource.getString("PartnerDlg.combo.Hourly"));
    private JRadioButton jRBDaily = new JRadioButton(resource.getString("PartnerDlg.combo.Daily"));
    private JRadioButton jRBWeekly = new JRadioButton(resource.getString("PartnerDlg.combo.Weekly"));
    private ButtonGroup autoManualGroup = new ButtonGroup();
    private ButtonGroup freqGroup = new ButtonGroup();
    private JSpinner jSpinnerhourSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
    private SchBetweenPanel schBetweenPanel = new SchBetweenPanel();
    private JPanel autoPanel = null;
    private JPanel frequencyPanel = null;
    private JPanel weeklyPanel = null;
    private JPanel hourlyRepeat = null;
    private JPanel manualPanel = null;
    private JPanel scheduleBetweenPanel = null;
    private boolean replicationScheduleChanged;
    private boolean otherSettingChanged;
    private static final int END_MINUTES_DEFAULT = 59;
    private static final int START_MINUTES_DEFAULT = 0;
    private static final int END_HOURS_DEFAULT = 23;
    private static boolean hasAmpm;
    private static String timePattern;
    private static String hourPattern;
    private JComboBox<String> jCmbDay = new JComboBox<String>(Utility.getDayOfWeek());
    private JPanel jPartnerPanel = new JPanel(new GridBagLayout());
    private JPanel jSchedulePanel = new JPanel(new GridBagLayout());
    private ReplicationPartnership remotePartnerShip;
    private ReplicationPartnership localPartnerShip;
    private Boolean replicateLogsFromRemotePartner;
    private Boolean replicateLogsToRemotePartner;
    private Boolean replicateClientPackages;
    private Boolean replicateLuContents;
    protected Boolean disableHostnameValidation;
    private Boolean enableSchedule;
    private Integer simpleFrequency;
    private Integer startYear;
    private String startMonth;
    private String startDayOfMonth;
    private String startDayOfWeek;
    private String startHour;
    private Integer startMinute;
    private Integer startSecond;
    private TimeFrame timeFrame;
    private Integer hourlyFrequency;
    private SemSite localSite;
    private SemSite remoteSite;
    private Partner partner;

    public PartnerDlg(Partner partner, boolean readOnly) {
        super(Manager.getFrame(), MessageFormat.format(resource.getString("PartnerDlg.title.ReplPartnerProps"), partner), true);
        this.partner = partner;
        this.readOnly = readOnly;
        this.initialize();
        this.initData(partner);
        this.setReadOnlyStatus();
        this.setSize(super.getWidth(), (int)((double)super.getHeight() * 1.05));
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public Boolean replicateLogsToRemotePartnerOrg() {
        return this.replicateLogsToRemotePartner;
    }

    public Boolean isOtherSettingFlagChanged() {
        return this.otherSettingChanged;
    }

    public boolean isReplicationScheduleChanged() {
        return this.replicationScheduleChanged;
    }

    public PartnerDlg(Partner partner) {
        this(partner, false);
    }

    public boolean replicateLogsToRemotePartner() {
        return this.jCbxLocalToPartnerLog.isSelected();
    }

    @Override
    protected boolean isValidate() {
        String serverList = this.jTAServer.getText().trim();
        if (serverList == null || serverList.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), resource.getString("PartnerDlg.error.SMSSvrAddr"), resource.getString("PartnerDlg.title.Error"), 0);
            return false;
        }
        if (UIUtilities.isReplicating(this.partner)) {
            UIUtilities.showWarningDialog(resource.getString("PartnerDlg.warning.IsReplicating"));
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        HostAddress address;
        String serverList = this.jTAServer.getText().trim();
        String siteDesc = this.jTADesc.getText().trim();
        if (!siteDesc.equals(this.remotePartnerShip.getOptSourceSiteDescription())) {
            this.remotePartnerShip.setOptSourceSiteDescription(siteDesc);
        }
        this.remotePartnerShip.setOptDisableHostnameValidation(Boolean.valueOf(this.jCbxDisableHostnameValidation.isSelected()));
        if (this.isReplicationLogsOrPackagesChanged()) {
            ReplicationContent remotePartnerReplicationContent = this.remotePartnerShip.getOptReplicationContent();
            Boolean replicateLogs = this.jCbxPartnerToLocalLog.isSelected();
            remotePartnerReplicationContent.setOptReplicateLogs(replicateLogs);
            Boolean replicateClientPackages = this.jCbxReplicateClientPackages.isSelected();
            remotePartnerReplicationContent.setOptReplicateClientPackages(replicateClientPackages);
            remotePartnerReplicationContent.setOptReplicateLuContents(replicateClientPackages);
            ReplicationContent localPartnerReplicationContent = this.localPartnerShip.getOptReplicationContent();
            Boolean localtoPartnerLog = this.jCbxLocalToPartnerLog.isSelected();
            localPartnerReplicationContent.setOptReplicateLogs(localtoPartnerLog);
        }
        SiteContactArray contactArray = this.remotePartnerShip.getSiteContactArray();
        Vector addresses = contactArray.getHostAddress();
        Vector addressesCopy = new Vector();
        addressesCopy.addAll(addresses);
        int addressesCount = addressesCopy.size();
        for (int i = 0; i < addressesCount; ++i) {
            address = (HostAddress)addressesCopy.get(i);
            address.getParent().removeChild((AbstractSchema)address);
        }
        if (serverList != null && serverList.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(serverList);
            while (tokenizer.hasMoreTokens()) {
                address = new HostAddress();
                String portStr = "";
                String token = tokenizer.nextToken();
                int pos = token.indexOf(":");
                if (pos > 0) {
                    if (token.contains("]:")) {
                        int endPos = token.indexOf("]");
                        address.setContent(token.substring(0, endPos + 1));
                        portStr = token.substring(endPos + 2);
                    } else if (token.startsWith("[") && token.endsWith("]")) {
                        address.setContent(token);
                    } else if (Utility.isValidIpv6Address((String)token)) {
                        address.setContent(Utility.checkAndAddBrackets((String)token));
                    } else {
                        address.setContent(token.substring(0, pos));
                        portStr = token.substring(pos + 1);
                    }
                    if (!StringUtilities.isEmpty((String)portStr)) {
                        try {
                            address.setOptPort(Integer.valueOf(portStr));
                        }
                        catch (Exception ex) {
                            LoggerUtilities.logException((Throwable)ex);
                        }
                    }
                } else {
                    address.setContent(token);
                }
                contactArray.addHostAddress(address);
            }
        }
        Schedule schedule = this.remotePartnerShip.getOptSchedule();
        schedule.setOptEnable(this.enableSchedule);
        schedule.setOptStartYear(null);
        schedule.setOptStartMonth(null);
        schedule.setOptStartDayOfMonth(null);
        int ampm = 0;
        int dayOfWeek = this.jCmbDay.getSelectedIndex();
        AbstractButton selectedButton = this.getSelectedButton(this.autoManualGroup);
        if (selectedButton == null) {
            selectedButton = this.jRBAuto;
        }
        if (selectedButton.equals(this.jRBAuto)) {
            schedule.setOptEnable(Boolean.valueOf(false));
        } else {
            schedule.setOptEnable(Boolean.valueOf(true));
            AbstractButton selectedFreq = this.getSelectedButton(this.freqGroup);
            if (selectedFreq == null) {
                selectedFreq = this.jRBHourly;
            }
            if (selectedFreq.equals(this.jRBHourly)) {
                int hourlyFrequency = Integer.parseInt(this.jSpinnerhourSpinner.getValue().toString());
                schedule.setOptStartHour(null);
                schedule.setOptHourlyFrequency(Integer.valueOf(hourlyFrequency));
                schedule.setOptStartDayOfWeek(null);
                this.setTimeFrame(this.schBetweenPanel, schedule);
                ampm = this.schBetweenPanel.getAmpm();
                int hour = this.schBetweenPanel.getStartHour();
                int minute = this.schBetweenPanel.getStartMinute();
                hour = Utility.convertHourTo_H_Pattern((int)hour, (String)hourPattern, (int)ampm);
                Calendar calendar = Utility.changeTimeZoneToGMTForScheduleHour((int)dayOfWeek, (int)hour, (int)minute, (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                schedule.setOptStartHour(Integer.toString(calendar.get(11)));
                schedule.setOptStartMinute(Integer.valueOf(calendar.get(12)));
                HashMap map = ReplicationScheduleUtility.getSiteMap();
                if (map.containsKey(this.partner.getId())) {
                    ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.partner.getId())).setReplicationScheduleChanged(true);
                } else {
                    ReplicationScheduleUtility.ReplicationPartnerScheduleState rpuic = new ReplicationScheduleUtility.ReplicationPartnerScheduleState();
                    rpuic.setReplicationScheduleChanged(true);
                    map.put(this.partner.getId(), rpuic);
                }
            } else {
                int hour;
                ampm = this.schBetweenPanel.getAmpm();
                if (selectedFreq.equals(this.jRBDaily)) {
                    this.setTimeFrame(this.schBetweenPanel, schedule);
                    schedule.setOptStartDayOfWeek(null);
                    schedule.setOptHourlyFrequency(null);
                    hour = this.schBetweenPanel.getStartHour();
                    int minute = this.schBetweenPanel.getStartMinute();
                    hour = Utility.convertHourTo_H_Pattern((int)hour, (String)hourPattern, (int)ampm);
                    Calendar calendar = Utility.changeTimeZoneToGMTForScheduleHour((int)dayOfWeek, (int)hour, (int)minute, (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                    schedule.setOptStartHour(Integer.toString(calendar.get(11)));
                    schedule.setOptStartMinute(Integer.valueOf(calendar.get(12)));
                } else {
                    hour = this.schBetweenPanel.getStartHour();
                    int minute = this.schBetweenPanel.getStartMinute();
                    hour = Utility.convertHourTo_H_Pattern((int)hour, (String)hourPattern, (int)ampm);
                    Calendar calendar = Utility.changeTimeZoneToGMTForScheduleHour((int)dayOfWeek, (int)hour, (int)minute, (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                    schedule.setOptStartHour(Integer.toString(calendar.get(11)));
                    schedule.setOptStartMinute(Integer.valueOf(calendar.get(12)));
                    this.setTimeFrame(this.schBetweenPanel, schedule);
                    schedule.setOptHourlyFrequency(null);
                    schedule.setOptStartDayOfWeek(Integer.toString(calendar.get(7) - 1));
                }
            }
        }
        if (this.isScheduleChanged()) {
            this.replicationScheduleChanged = true;
        } else if (this.isOtherSettingChanged()) {
            this.otherSettingChanged = true;
        }
    }

    private AbstractButton getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    private void setTimeFrame(SchBetweenPanel schBetweenPanel, Schedule schedule) {
        schedule.setOptTimeFrame(null);
        if (schBetweenPanel != null) {
            int startHour = schBetweenPanel.getStartHour();
            int endHour = schBetweenPanel.getEndHour();
            int startMinute = schBetweenPanel.getStartMinute();
            int endMinute = schBetweenPanel.getEndMinute();
            Calendar cal = Calendar.getInstance();
            Calendar startCalendar = Utility.changeTimeZoneToGMTForScheduleHour((int)cal.get(7), (int)startHour, (int)startMinute, (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
            Calendar endCalendar = Utility.changeTimeZoneToGMTForScheduleHour((int)cal.get(7), (int)endHour, (int)endMinute, (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
            TimeFrame timeFrame = new TimeFrame();
            timeFrame.setOptStartHour(Integer.valueOf(startCalendar.get(11)));
            timeFrame.setOptEndHour(Integer.valueOf(endCalendar.get(11)));
            timeFrame.setOptStartMin(Integer.valueOf(startCalendar.get(12)));
            timeFrame.setOptEndMin(Integer.valueOf(endCalendar.get(12)));
            schedule.setOptTimeFrame(timeFrame);
        }
    }

    private boolean isReplicationLogsOrPackagesChanged() {
        ReplicationContent remotePartnerReplicationContent = this.remotePartnerShip.getOptReplicationContent();
        Boolean replicateLogs = this.jCbxPartnerToLocalLog.isSelected();
        if (!replicateLogs.equals(remotePartnerReplicationContent.getOptReplicateLogs())) {
            return true;
        }
        Boolean replicateClientPackages = this.jCbxReplicateClientPackages.isSelected();
        if (!replicateClientPackages.equals(remotePartnerReplicationContent.getOptReplicateClientPackages())) {
            return true;
        }
        if (!replicateClientPackages.equals(remotePartnerReplicationContent.getOptReplicateLuContents())) {
            return true;
        }
        ReplicationContent localPartnerReplicationContent = this.localPartnerShip.getOptReplicationContent();
        Boolean localtoPartnerLog = this.jCbxLocalToPartnerLog.isSelected();
        return !localtoPartnerLog.equals(localPartnerReplicationContent.getOptReplicateLogs());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_partner_properties";
    }

    @Override
    protected void setReadOnlyStatus() {
        if (this.readOnly) {
            this.jTFName.setEnabled(!this.readOnly);
            this.jTADesc.setEnabled(!this.readOnly);
            this.jTAServer.setEnabled(!this.readOnly);
            this.jCbxLocalToPartnerLog.setEnabled(!this.readOnly);
            this.jCbxPartnerToLocalLog.setEnabled(!this.readOnly);
            this.jCbxReplicateClientPackages.setEnabled(!this.readOnly);
            this.jCbxDisableHostnameValidation.setEnabled(!this.readOnly);
            this.jCmbDay.setEnabled(!this.readOnly);
            this.jSpinnerhourSpinner.setEnabled(!this.readOnly);
            this.schBetweenPanel.startSpinner1.setEnabled(!this.readOnly);
            this.schBetweenPanel.endSpinner1.setEnabled(!this.readOnly);
            this.jRBAuto.setEnabled(!this.readOnly);
            this.jRBManual.setEnabled(!this.readOnly);
            this.jRBHourly.setEnabled(!this.readOnly);
            this.jRBDaily.setEnabled(!this.readOnly);
            this.jRBWeekly.setEnabled(!this.readOnly);
            super.setReadOnlyStatus();
        }
    }

    public boolean isInitiatorSite() {
        boolean isInitiator = true;
        if (this.localSite.getId().compareTo(this.remoteSite.getI()) > 0) {
            isInitiator = false;
        }
        return isInitiator;
    }

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getPartnerPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getSchedulePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    private JPanel getPartnerPanel() {
        this.jTFName.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.jTADesc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        JScrollPane jScrollPaneServer = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPaneServer, (JTextArea)this.jTAServer);
        this.jPartnerPanel.setBorder(BorderFactory.createTitledBorder(resource.getString("PartnerDlg.title.Partner")));
        this.jPartnerPanel.add((Component)new JLabel(resource.getString("PartnerDlg.label.PartnerName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPartnerPanel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.jPartnerPanel.add((Component)new JLabel(resource.getString("PartnerDlg.label.Desc")), new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPartnerPanel.add((Component)jScrollPane, new GridBagConstraints(1, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        JPanel newPanel = new JPanel(new GridBagLayout());
        newPanel.add((Component)new JLabel(resource.getString("PartnerDlg.lavel.ReplPolMgrList")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        newPanel.add((Component)new JLabel(resource.getString("PartnerDlg.lavel.ReplPolMgrList.IPAddress")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        newPanel.add((Component)new JLabel(resource.getString("PartnerDlg.lavel.ReplPolMgrList.HostName")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPartnerPanel.add((Component)newPanel, new GridBagConstraints(0, 4, 1, 3, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPartnerPanel.add((Component)jScrollPaneServer, new GridBagConstraints(1, 4, 1, 3, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.jPartnerPanel.add((Component)this.jCbxLocalToPartnerLog, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        this.jPartnerPanel.add((Component)this.jCbxPartnerToLocalLog, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        JPanel replicateClientAndContentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 11;
        replicateClientAndContentPanel.add((Component)this.jCbxReplicateClientPackages, constraints);
        constraints.gridx = 1;
        constraints.insets.top = 3;
        replicateClientAndContentPanel.add((Component)new MultiLineLabel(resource.getString("PartnerDlg.checkbox.ReplClientPackages")), constraints);
        this.jPartnerPanel.add((Component)replicateClientAndContentPanel, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        this.jPartnerPanel.add((Component)this.jCbxDisableHostnameValidation, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        this.jPartnerPanel.add((Component)this.getDisableHostnameValidationWarningBox(), new GridBagConstraints(0, 12, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 35, 0, 5), 0, 0));
        this.jCbxDisableHostnameValidation.addItemListener(event -> {
            this.disableHostnameValidationWarningIcon.setEnabled(this.jCbxDisableHostnameValidation.isSelected());
            this.disableHostnameValidationWarningText.setEnabled(this.jCbxDisableHostnameValidation.isSelected());
        });
        return this.jPartnerPanel;
    }

    private Box getDisableHostnameValidationWarningBox() {
        this.disableHostnameValidationWarningText.setEditable(false);
        this.disableHostnameValidationWarningText.setWrapStyleWord(true);
        this.disableHostnameValidationWarningText.setLineWrap(true);
        this.disableHostnameValidationWarningText.setOpaque(true);
        this.disableHostnameValidationWarningText.setAlignmentX(0.0f);
        this.disableHostnameValidationWarningText.setMargin(new Insets(0, 10, 0, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.disableHostnameValidationWarningIcon);
        box.add(this.disableHostnameValidationWarningText);
        return box;
    }

    private JPanel getSchedulePanel() {
        this.jRBAuto.setName(sAUTO);
        this.jRBManual.setName(sMANUAL);
        this.jRBHourly.setName(sHOURLY);
        this.jRBDaily.setName(sDAILY);
        this.jRBWeekly.setName(sWEEKLY);
        this.autoManualGroup.add(this.jRBAuto);
        this.autoManualGroup.add(this.jRBManual);
        this.freqGroup.add(this.jRBHourly);
        this.freqGroup.add(this.jRBDaily);
        this.freqGroup.add(this.jRBWeekly);
        this.jRBAuto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                PartnerDlg.this.enableComponents(PartnerDlg.this.autoPanel);
                PartnerDlg.this.freqGroup.clearSelection();
                PartnerDlg.this.disableComponents(PartnerDlg.this.frequencyPanel);
                PartnerDlg.this.disableComponents(PartnerDlg.this.hourlyRepeat);
                PartnerDlg.this.disableComponents(PartnerDlg.this.weeklyPanel);
                PartnerDlg.this.disableComponents(PartnerDlg.this.scheduleBetweenPanel);
                PartnerDlg.this.jRBHourly.setEnabled(false);
                PartnerDlg.this.jRBDaily.setEnabled(false);
                PartnerDlg.this.jRBWeekly.setEnabled(false);
                PartnerDlg.this.schBetweenPanel.setEnabled(false);
            }
        });
        this.jRBManual.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                PartnerDlg.this.schBetweenPanel.setEnabled(true);
                PartnerDlg.this.enableComponents(PartnerDlg.this.scheduleBetweenPanel);
                PartnerDlg.this.jRBHourly.setEnabled(true);
                PartnerDlg.this.jRBDaily.setEnabled(true);
                PartnerDlg.this.jRBWeekly.setEnabled(true);
                PartnerDlg.this.freqGroup.clearSelection();
                PartnerDlg.this.freqGroup.setSelected(PartnerDlg.this.jRBHourly.getModel(), true);
            }
        });
        this.jRBHourly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                PartnerDlg.this.schBetweenPanel.setEnabled(true);
                PartnerDlg.this.enableComponents(PartnerDlg.this.scheduleBetweenPanel);
                PartnerDlg.this.enableComponents(PartnerDlg.this.hourlyRepeat);
                PartnerDlg.this.enableComponents(PartnerDlg.this.frequencyPanel);
                PartnerDlg.this.jRBHourly.setEnabled(true);
                PartnerDlg.this.jRBDaily.setEnabled(true);
                PartnerDlg.this.jRBWeekly.setEnabled(true);
                PartnerDlg.this.disableComponents(PartnerDlg.this.weeklyPanel);
            }
        });
        this.jRBDaily.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                PartnerDlg.this.schBetweenPanel.setEnabled(true);
                PartnerDlg.this.enableComponents(PartnerDlg.this.scheduleBetweenPanel);
                PartnerDlg.this.disableComponents(PartnerDlg.this.hourlyRepeat);
                PartnerDlg.this.disableComponents(PartnerDlg.this.weeklyPanel);
                PartnerDlg.this.frequencyPanel.setEnabled(true);
                PartnerDlg.this.jRBHourly.setEnabled(true);
                PartnerDlg.this.jRBDaily.setEnabled(true);
                PartnerDlg.this.jRBWeekly.setEnabled(true);
            }
        });
        this.jRBWeekly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                PartnerDlg.this.schBetweenPanel.setEnabled(true);
                PartnerDlg.this.enableComponents(PartnerDlg.this.scheduleBetweenPanel);
                PartnerDlg.this.enableComponents(PartnerDlg.this.weeklyPanel);
                PartnerDlg.this.frequencyPanel.setEnabled(true);
                PartnerDlg.this.jRBHourly.setEnabled(true);
                PartnerDlg.this.jRBDaily.setEnabled(true);
                PartnerDlg.this.jRBWeekly.setEnabled(true);
                PartnerDlg.this.disableComponents(PartnerDlg.this.hourlyRepeat);
            }
        });
        this.jSchedulePanel.setBorder(BorderFactory.createTitledBorder(resource.getString("PartnerDlg.title.Schedule")));
        this.autoPanel = new JPanel(new GridBagLayout());
        this.autoPanel.add((Component)this.jRBAuto, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel autoReplDescription = new JLabel(resource.getString("PartnerDlg.label.Auto.Replication.Description"));
        this.autoPanel.add((Component)autoReplDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        this.autoPanel.setVisible(true);
        this.autoPanel.setEnabled(false);
        this.jSchedulePanel.add((Component)this.autoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        this.manualPanel = new JPanel(new GridBagLayout());
        this.manualPanel.add((Component)this.jRBManual, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        this.frequencyPanel = new JPanel(new GridBagLayout());
        JLabel repFreqDescription = new JLabel(resource.getString("PartnerDlg.label.ReplFreq"));
        this.frequencyPanel.add((Component)repFreqDescription, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        this.frequencyPanel.add((Component)this.jRBHourly, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 25, 0, 0), 0, 0));
        this.frequencyPanel.add((Component)this.jRBDaily, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 0, 0), 0, 0));
        this.frequencyPanel.add((Component)this.jRBWeekly, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 0, 0), 0, 0));
        this.frequencyPanel.setVisible(true);
        this.manualPanel.add((Component)this.frequencyPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.hourlyRepeat = new JPanel(new GridBagLayout());
        this.hourlyRepeat.add((Component)new JLabel(resource.getString("PartnerDlg.label.Every")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 10, new Insets(5, 48, 0, 0), 0, 0));
        this.hourlyRepeat.add((Component)this.jSpinnerhourSpinner, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 56, 0, 0), 0, 0));
        this.hourlyRepeat.add((Component)new JLabel(resource.getString("PartnerDlg.label.Hours")), new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.hourlyRepeat.setVisible(true);
        this.manualPanel.add((Component)this.hourlyRepeat, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.weeklyPanel = new JPanel(new GridBagLayout());
        this.weeklyPanel.add((Component)new JLabel(resource.getString("PartnerDlg.label.DayOfWeek.On")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 10, new Insets(10, 48, 0, 0), 0, 0));
        this.weeklyPanel.add(this.jCmbDay, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 70, 0, 0), 0, 0));
        this.weeklyPanel.setVisible(true);
        this.manualPanel.add((Component)this.weeklyPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.scheduleBetweenPanel = new JPanel(new GridBagLayout());
        JLabel schdTimeFrameDescription = new JLabel(resource.getString("PartnerDlg.schBetweenPanel.description"));
        this.scheduleBetweenPanel.add((Component)schdTimeFrameDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 43, 0, 0), 0, 0));
        this.scheduleBetweenPanel.add((Component)this.schBetweenPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 10, new Insets(2, 2, 0, 0), 0, 0));
        this.scheduleBetweenPanel.setVisible(true);
        this.schBetweenPanel.setVisible(true);
        this.manualPanel.add((Component)this.scheduleBetweenPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.manualPanel.setVisible(true);
        this.jSchedulePanel.add((Component)this.manualPanel, new GridBagConstraints(0, 8, 5, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        return this.jSchedulePanel;
    }

    private static void parseTimePattern(String timePattern, TimeSpinner1 startSpinner1, TimeSpinner1 endSpinner1) {
        if (timePattern.indexOf("h") != -1) {
            hourPattern = "h";
        }
        if (timePattern.indexOf("H") != -1) {
            hourPattern = "H";
        }
        if (timePattern.indexOf("k") != -1) {
            hourPattern = "k";
        }
        if (timePattern.indexOf("K") != -1) {
            hourPattern = "K";
        }
        if (timePattern.indexOf("a") != -1) {
            hasAmpm = true;
        }
    }

    private void disableComponents(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (panel.getComponent(i) instanceof JPanel) {
                this.disableComponents((JPanel)panel.getComponent(i));
            }
            if (panel instanceof SchBetweenPanel) continue;
            panel.getComponent(i).setEnabled(false);
        }
    }

    private void enableComponents(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (panel.getComponent(i) instanceof JPanel) {
                this.enableComponents((JPanel)panel.getComponent(i));
            }
            panel.getComponent(i).setEnabled(true);
        }
    }

    private void initData(Partner remotePartner) {
        block20: {
            this.remotePartnerShip = remotePartner.getReplicationPartnership();
            this.localSite = remotePartner.getSemSite();
            try {
                ReplicationContent remotePartnerReplicationContent;
                this.remoteSite = ServerHandler.retrieveSite(remotePartner.getName());
                System.out.println("Remote site name is :" + this.remoteSite.getName());
                Replication replication = this.remoteSite.getReplication();
                ReplicationPartnerArray partners = replication.getReplicationPartnerArray();
                Vector v = partners.getReplicationPartnership();
                if (v != null) {
                    for (ReplicationPartnership partnership : v) {
                        if (!partnership.getPartnerSiteName().equals(this.localSite.getName())) continue;
                        this.localPartnerShip = partnership;
                        System.out.println("Local partner name is:" + this.localPartnerShip.getPartnerSiteName());
                        break;
                    }
                }
                if (this.localPartnerShip == null) {
                    this.localPartnerShip = new ReplicationPartnership(true);
                    this.localPartnerShip.setOptReplicationContent(new ReplicationContent(true));
                }
                boolean replicatePartnerToLocalLogs = (remotePartnerReplicationContent = this.remotePartnerShip.getOptReplicationContent()) == null || remotePartnerReplicationContent.getOptReplicateLogs() == null ? false : remotePartnerReplicationContent.getOptReplicateLogs();
                boolean replicateClientPackages = remotePartnerReplicationContent == null || remotePartnerReplicationContent.getOptReplicateClientPackages() == null ? true : remotePartnerReplicationContent.getOptReplicateClientPackages();
                ReplicationContent localPartnerReplicationContent = this.localPartnerShip.getOptReplicationContent();
                boolean replicateLocalToPartnerLogs = localPartnerReplicationContent == null || localPartnerReplicationContent.getOptReplicateLogs() == null ? false : localPartnerReplicationContent.getOptReplicateLogs();
                this.jTFName.setText(this.remotePartnerShip.getPartnerSiteName());
                this.jTADesc.setText(this.remotePartnerShip.getOptSourceSiteDescription());
                this.jTADesc.setCaretPosition(0);
                this.jTAServer.setText(this.getContactList(this.remotePartnerShip));
                this.jCbxPartnerToLocalLog.setSelected(replicatePartnerToLocalLogs);
                this.jCbxLocalToPartnerLog.setSelected(replicateLocalToPartnerLogs);
                this.jCbxReplicateClientPackages.setSelected(replicateClientPackages);
                this.jCbxDisableHostnameValidation.setSelected(Optional.ofNullable(this.remotePartnerShip.getOptDisableHostnameValidation()).orElseGet(() -> ((ReplicationPartnership)this.remotePartnerShip).getDefDisableHostnameValidation()));
                this.disableHostnameValidationWarningIcon.setEnabled(this.jCbxDisableHostnameValidation.isSelected());
                this.disableHostnameValidationWarningText.setEnabled(this.jCbxDisableHostnameValidation.isSelected());
                Schedule schedule = this.remotePartnerShip.getOptSchedule();
                if (schedule == null) {
                    schedule = new Schedule();
                    schedule.setOptEnable(Boolean.TRUE);
                    schedule.setOptStartHour(Utility.getMidnightHour((int)0));
                    schedule.setOptStartMinute(Integer.valueOf(0));
                    TimeFrame timeFrame = new TimeFrame();
                    timeFrame.setOptStartHour(Integer.valueOf(Integer.parseInt(Utility.getMidnightHour((int)0))));
                    timeFrame.setOptEndHour(Integer.valueOf(Integer.parseInt(Utility.getEndHourInGMT())));
                    timeFrame.setOptStartMin(Integer.valueOf(0));
                    timeFrame.setOptEndMin(Integer.valueOf(59));
                    schedule.setOptTimeFrame(timeFrame);
                    this.remotePartnerShip.setOptSchedule(schedule);
                }
                String dayOfWeek = schedule.getOptStartDayOfWeek();
                String startHour = schedule.getOptStartHour();
                Integer startMinute = schedule.getOptStartMinute() != null ? schedule.getOptStartMinute() : Integer.valueOf(0);
                boolean hourlyUpgradeCase = false;
                if (startHour == null) {
                    startHour = Utility.getMidnightHour((int)startMinute);
                    startMinute = Utility.getMidnightMinute((int)startMinute);
                    hourlyUpgradeCase = true;
                }
                Integer endHour = Integer.parseInt(startHour) % 24;
                Integer endMinute = startMinute % 60;
                if (endMinute == 0 && (endHour = Integer.valueOf(endHour - 1)) < 0) {
                    endHour = Integer.parseInt(Utility.getEndHourInGMT());
                }
                endMinute = endMinute - 1 < 0 ? Integer.valueOf(59) : Integer.valueOf(endMinute - 1);
                boolean enableSchedule = schedule.getOptEnable();
                int day = 0;
                int startHourForPattern = 0;
                int startMinuteForPattern = 0;
                int endHourForPattern = 0;
                int endMinuteForPattern = 0;
                int ampm = 0;
                if (!enableSchedule) {
                    this.autoManualGroup.setSelected(this.jRBAuto.getModel(), true);
                    this.schBetweenPanel.setEnabled(false);
                } else if (dayOfWeek != null && dayOfWeek.trim().length() > 0) {
                    this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
                    this.freqGroup.setSelected(this.jRBWeekly.getModel(), true);
                    this.schBetweenPanel.setEnabled(true);
                    TimeFrame curFrame = schedule.getOptTimeFrame();
                    if (curFrame != null) {
                        startHour = curFrame.getOptStartHour() == null ? curFrame.getDefStartHour().toString() : curFrame.getOptStartHour().toString();
                        startMinute = curFrame.getOptStartMin() == null ? curFrame.getDefStartMin() : curFrame.getOptStartMin();
                        endHour = curFrame.getOptEndHour() == null ? curFrame.getDefEndHour() : curFrame.getOptEndHour();
                        endMinute = curFrame.getOptEndMin() == null ? curFrame.getDefEndMin() : curFrame.getOptEndMin();
                    }
                    Calendar startCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)Integer.parseInt(dayOfWeek), (int)Integer.parseInt(startHour), (int)startMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                    Calendar endCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)Integer.parseInt(dayOfWeek), (int)endHour, (int)endMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                    startHourForPattern = Utility.convertHourFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                    startMinute = startCal.get(12);
                    startMinuteForPattern = startMinute == null ? 0 : startMinute;
                    endHourForPattern = Utility.convertHourFrom_H_Pattern((int)endCal.get(11), (String)hourPattern);
                    endMinute = endCal.get(12);
                    int n = endMinuteForPattern = endMinute == null ? 0 : endMinute;
                    if (hasAmpm) {
                        ampm = Utility.getAmpmFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                    }
                    this.schBetweenPanel.setStartHour(startHourForPattern);
                    this.schBetweenPanel.setEndHour(endHourForPattern);
                    this.schBetweenPanel.setStartMinute(startMinuteForPattern);
                    this.schBetweenPanel.setEndMinute(endMinuteForPattern);
                    this.schBetweenPanel.enableAmpm(hasAmpm, ampm);
                    day = startCal.get(7) - 1;
                } else if (schedule.getOptHourlyFrequency() == null && !hourlyUpgradeCase) {
                    this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
                    this.freqGroup.setSelected(this.jRBDaily.getModel(), true);
                    this.schBetweenPanel.setEnabled(true);
                    TimeFrame curFrame = schedule.getOptTimeFrame();
                    if (curFrame != null) {
                        startHour = curFrame.getOptStartHour() == null ? curFrame.getDefStartHour().toString() : curFrame.getOptStartHour().toString();
                        startMinute = curFrame.getOptStartMin() == null ? curFrame.getDefStartMin() : curFrame.getOptStartMin();
                        endHour = curFrame.getOptEndHour() == null ? curFrame.getDefEndHour() : curFrame.getOptEndHour();
                        endMinute = curFrame.getOptEndMin() == null ? curFrame.getDefEndMin() : curFrame.getOptEndMin();
                    }
                    Calendar startCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)Integer.parseInt(startHour), (int)startMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                    Calendar endCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)endHour, (int)endMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                    startHourForPattern = Utility.convertHourFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                    startMinute = startCal.get(12);
                    startMinuteForPattern = startMinute == null ? 0 : startMinute;
                    endHourForPattern = Utility.convertHourFrom_H_Pattern((int)endCal.get(11), (String)hourPattern);
                    endMinute = endCal.get(12);
                    int n = endMinuteForPattern = endMinute == null ? 0 : endMinute;
                    if (hasAmpm) {
                        ampm = Utility.getAmpmFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                    }
                    this.schBetweenPanel.setStartHour(startHourForPattern);
                    this.schBetweenPanel.setEndHour(endHourForPattern);
                    this.schBetweenPanel.setStartMinute(startMinuteForPattern);
                    this.schBetweenPanel.setEndMinute(endMinuteForPattern);
                    this.schBetweenPanel.enableAmpm(hasAmpm, ampm);
                    day = 0;
                } else {
                    this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
                    this.freqGroup.setSelected(this.jRBHourly.getModel(), true);
                    this.schBetweenPanel.setEnabled(true);
                    day = 0;
                    this.jSpinnerhourSpinner.setEnabled(true);
                    Integer hourlyFrequency = schedule.getOptHourlyFrequency() == null ? schedule.getDefHourlyFrequency() : schedule.getOptHourlyFrequency();
                    this.jSpinnerhourSpinner.setValue(hourlyFrequency);
                    TimeFrame curFrame = schedule.getOptTimeFrame();
                    if (curFrame != null) {
                        startHour = curFrame.getOptStartHour() == null ? curFrame.getDefStartHour().toString() : curFrame.getOptStartHour().toString();
                        startMinute = curFrame.getOptStartMin() == null ? curFrame.getDefStartMin() : curFrame.getOptStartMin();
                        endHour = curFrame.getOptEndHour() == null ? curFrame.getDefEndHour() : curFrame.getOptEndHour();
                        endMinute = curFrame.getOptEndMin() == null ? curFrame.getDefEndMin() : curFrame.getOptEndMin();
                    }
                    Calendar startCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)Integer.parseInt(startHour), (int)startMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                    Calendar endCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)endHour, (int)endMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                    startHourForPattern = Utility.convertHourFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                    startMinute = startCal.get(12);
                    startMinuteForPattern = startMinute;
                    endHourForPattern = Utility.convertHourFrom_H_Pattern((int)endCal.get(11), (String)hourPattern);
                    endMinute = endCal.get(12);
                    endMinuteForPattern = endMinute;
                    if (hasAmpm) {
                        ampm = Utility.getAmpmFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                    }
                    this.schBetweenPanel.setStartHour(startHourForPattern);
                    this.schBetweenPanel.setEndHour(endHourForPattern);
                    this.schBetweenPanel.setStartMinute(startMinuteForPattern);
                    this.schBetweenPanel.setEndMinute(endMinuteForPattern);
                    this.schBetweenPanel.enableAmpm(hasAmpm, ampm);
                }
                this.jCmbDay.setSelectedIndex(day);
                this.saveOriginalValues();
            }
            catch (ConsoleException ex) {
                System.out.println("***********************" + ex.getMessage());
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), resource.getString("PartnerDlg.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block20;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private String getContactList(ReplicationPartnership partnership) {
        SiteContactArray contactArray = partnership.getSiteContactArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < contactArray.getHostAddressCount(); ++i) {
            if (i > 0) {
                buf.append("\n");
            }
            HostAddress hostAddress = contactArray.getHostAddress(i);
            buf.append(hostAddress.getContent());
            Integer port = hostAddress.getOptPort();
            if (port == null || port == Env.getSEM_PORT()) continue;
            buf.append(":").append(port);
        }
        return buf.toString();
    }

    private void saveOriginalValues() {
        ReplicationContent remotePartnerReplicationContent = this.remotePartnerShip.getOptReplicationContent();
        this.replicateLogsFromRemotePartner = remotePartnerReplicationContent.getOptReplicateLogs();
        this.replicateClientPackages = remotePartnerReplicationContent.getOptReplicateClientPackages();
        this.replicateLuContents = remotePartnerReplicationContent.getOptReplicateLuContents();
        ReplicationContent localPartnerReplicationContent = this.localPartnerShip.getOptReplicationContent();
        this.replicateLogsToRemotePartner = localPartnerReplicationContent.getOptReplicateLogs();
        this.disableHostnameValidation = this.remotePartnerShip.getOptDisableHostnameValidation();
        Schedule schedule = this.remotePartnerShip.getOptSchedule();
        this.enableSchedule = schedule.getOptEnable();
        this.simpleFrequency = schedule.getOptSimpleFrequency();
        this.startYear = schedule.getOptStartYear();
        this.startMonth = schedule.getOptStartMonth();
        this.startDayOfMonth = schedule.getOptStartDayOfMonth();
        this.startMinute = schedule.getOptStartMinute();
        this.startHour = schedule.getOptStartHour();
        this.startDayOfWeek = schedule.getOptStartDayOfWeek();
        this.startSecond = schedule.getOptStartSecond();
        this.hourlyFrequency = schedule.getOptHourlyFrequency();
        this.timeFrame = schedule.getOptTimeFrame();
    }

    private boolean isScheduleChanged() {
        boolean isScheduleChanged = false;
        Schedule schedule = this.remotePartnerShip.getOptSchedule();
        if (schedule != null) {
            if (this.isObjectEqual(schedule.getOptEnable(), this.enableSchedule)) {
                if (!this.enableSchedule.booleanValue()) {
                    isScheduleChanged = false;
                } else if (schedule.getOptStartDayOfWeek() != null) {
                    isScheduleChanged = !this.isObjectEqual(schedule.getOptSimpleFrequency(), this.simpleFrequency) || !this.isObjectEqual(schedule.getOptStartYear(), this.startYear) || !this.isObjectEqual(schedule.getOptStartMonth(), this.startMonth) || !this.isObjectEqual(schedule.getOptStartDayOfMonth(), this.startDayOfMonth) || !this.isObjectEqual(schedule.getOptStartDayOfWeek(), this.startDayOfWeek) || !this.isObjectEqual(schedule.getOptStartHour(), this.startHour) || !this.isObjectEqual(schedule.getOptStartMinute(), this.startMinute) || !this.isObjectEqual(schedule.getOptStartSecond(), this.startSecond);
                } else if (schedule.getOptHourlyFrequency() == null) {
                    isScheduleChanged = !this.isObjectEqual(schedule.getOptSimpleFrequency(), this.simpleFrequency) || !this.isObjectEqual(schedule.getOptStartYear(), this.startYear) || !this.isObjectEqual(schedule.getOptStartMonth(), this.startMonth) || !this.isObjectEqual(schedule.getOptStartDayOfMonth(), this.startDayOfMonth) || !this.isObjectEqual(null, this.startDayOfWeek) || !this.isObjectEqual(schedule.getOptStartHour(), this.startHour) || !this.isObjectEqual(schedule.getOptStartMinute(), this.startMinute) || !this.isObjectEqual(schedule.getOptStartSecond(), this.startSecond);
                } else {
                    boolean bl = isScheduleChanged = !this.isObjectEqual(schedule.getOptSimpleFrequency(), this.simpleFrequency) || !this.isObjectEqual(schedule.getOptStartYear(), this.startYear) || !this.isObjectEqual(schedule.getOptStartMonth(), this.startMonth) || !this.isObjectEqual(schedule.getOptStartDayOfMonth(), this.startDayOfMonth) || !this.isObjectEqual(null, this.startDayOfWeek) || !this.isObjectEqual(schedule.getOptStartHour(), this.startHour) || !this.isObjectEqual(schedule.getOptStartMinute(), this.startMinute) || !this.isObjectEqual(schedule.getOptStartSecond(), this.startSecond) || !this.isObjectEqual(schedule.getOptHourlyFrequency(), this.hourlyFrequency);
                    if (!isScheduleChanged) {
                        boolean bl2 = isScheduleChanged = schedule.getOptTimeFrame() != this.timeFrame;
                        if (!isScheduleChanged && schedule.getOptTimeFrame() != null && this.timeFrame != null) {
                            isScheduleChanged = !this.isObjectEqual(schedule.getOptTimeFrame().getOptStartHour(), this.timeFrame.getOptStartHour()) || !this.isObjectEqual(schedule.getOptTimeFrame().getOptStartMin(), this.timeFrame.getOptStartMin()) || !this.isObjectEqual(schedule.getOptTimeFrame().getOptEndHour(), this.timeFrame.getOptEndHour()) || !this.isObjectEqual(schedule.getOptTimeFrame().getOptEndMin(), this.timeFrame.getOptEndMin());
                        }
                    }
                }
            } else {
                isScheduleChanged = true;
            }
        }
        return isScheduleChanged;
    }

    private boolean isOtherSettingChanged() {
        ReplicationContent localPartnerReplicationContent;
        boolean isSettingChanged = false;
        ReplicationContent remotePartnerReplicationContent = this.remotePartnerShip.getOptReplicationContent();
        if (remotePartnerReplicationContent != null) {
            if (remotePartnerReplicationContent.getOptReplicateLogs() != null && !this.isObjectEqual(remotePartnerReplicationContent.getOptReplicateLogs(), this.replicateLogsFromRemotePartner)) {
                return true;
            }
            if (remotePartnerReplicationContent.getOptReplicateClientPackages() != null && !this.isObjectEqual(remotePartnerReplicationContent.getOptReplicateClientPackages(), this.replicateClientPackages)) {
                return true;
            }
            if (remotePartnerReplicationContent.getOptReplicateLuContents() != null && !this.isObjectEqual(remotePartnerReplicationContent.getOptReplicateLuContents(), this.replicateLuContents)) {
                return true;
            }
        }
        if ((localPartnerReplicationContent = this.localPartnerShip.getOptReplicationContent()) != null && localPartnerReplicationContent.getOptReplicateLogs() != null && !this.isObjectEqual(localPartnerReplicationContent.getOptReplicateLogs(), this.replicateLogsToRemotePartner)) {
            return true;
        }
        if (Optional.ofNullable(this.remotePartnerShip.getOptDisableHostnameValidation()).filter(b -> !this.isObjectEqual(b, this.disableHostnameValidation)).isPresent()) {
            return true;
        }
        if (this.isScheduleChanged()) {
            return true;
        }
        return isSettingChanged;
    }

    private boolean isObjectEqual(Object obj1, Object obj2) {
        boolean isEqual = false;
        isEqual = obj1 == null && obj2 == null || obj1 != null && obj1.equals(obj2);
        return isEqual;
    }

    static {
        timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    }

    private static class SchBetweenPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel lableStartTime = new JLabel(resource.getString("PartnerDlg.label.starting.at"));
        private JLabel lableEndTime = new JLabel(resource.getString("PartnerDlg.label.ending.at"));
        private TimeSpinner1 startSpinner1 = new TimeSpinner1(timePattern);
        private TimeSpinner1 endSpinner1 = new TimeSpinner1(timePattern);

        public SchBetweenPanel() {
            this.setLayout(new GridBagLayout());
            PartnerDlg.parseTimePattern(timePattern, this.startSpinner1, this.endSpinner1);
            this.endSpinner1.setHour(23);
            this.endSpinner1.setMinute(59);
            this.add((Component)this.lableStartTime, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 57, 0, 0), 0, 0));
            this.add((Component)this.startSpinner1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 37, 0, 0), 0, 0));
            this.add((Component)this.lableEndTime, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 57, 0, 0), 0, 0));
            this.add((Component)this.endSpinner1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 37, 0, 0), 0, 0));
        }

        public Integer getStartHour() {
            return this.startSpinner1.getHour();
        }

        public Integer getStartMinute() {
            return this.startSpinner1.getMinute();
        }

        public Integer getEndHour() {
            return this.endSpinner1.getHour();
        }

        public Integer getEndMinute() {
            return this.endSpinner1.getMinute();
        }

        public void setStartHour(Integer value) {
            this.startSpinner1.setHour(value);
        }

        public void setStartMinute(Integer value) {
            this.startSpinner1.setMinute(value);
        }

        public void setEndHour(Integer value) {
            this.endSpinner1.setHour(value);
        }

        public void setEndMinute(Integer value) {
            this.endSpinner1.setMinute(value);
        }

        public void enableAmpm(boolean hasAmpm, int ampm) {
            if (hasAmpm) {
                this.startSpinner1.setAmpm(ampm);
            }
        }

        public int getAmpm() {
            return this.startSpinner1.getAmpm();
        }

        @Override
        public void setEnabled(boolean value) {
            this.startSpinner1.setEnabled(value);
            this.endSpinner1.setEnabled(value);
            this.lableStartTime.setEnabled(value);
            this.lableEndTime.setEnabled(value);
        }
    }
}

