/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.console.ui.util.StyledTextEditorDlg;
import com.sygate.scm.console.ui.util.TextValidator;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class IpEditAllDlg
extends StyledTextEditorDlg {
    private static final long serialVersionUID = 1L;

    public IpEditAllDlg(String instruction, TextValidator validator) {
        super(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "IpEditAllDlg.title.IPAddrEditor"), instruction, validator);
    }

    public void exportContent() {
        if (this.validator != null) {
            this.validator.exportContent(this.getDocumentText());
        }
    }

    @Override
    protected void initializeData() {
        String content;
        this.jTPEditor.setStyledDocument(new IpEditDocument());
        this.jTPEditor.setBorder(CustomLookAndFeel.DEFAULT_BORDER);
        if (this.validator != null && (content = this.validator.importContent()) != null && content.length() > 0) {
            this.jTPEditor.setText(content);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_general_edit_ip_all";
    }

    private static class IpEditDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;

        private IpEditDocument() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
            Element startElement = this.getParagraphElement(offset);
            Element endElement = this.getParagraphElement(offset + str.length() - 1);
            this.writeLock();
            try {
                int endOffset = offset;
                while (startElement != endElement) {
                    endOffset = this.updateDocumentElement(startElement);
                    startElement = this.getParagraphElement(endOffset);
                }
                this.updateDocumentElement(endElement);
            }
            finally {
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(int offset, int length) throws BadLocationException {
            super.remove(offset, length);
            this.writeLock();
            try {
                int endOffset = this.updateDocumentElement(this.getParagraphElement(offset));
                this.updateDocumentElement(this.getParagraphElement(endOffset));
            }
            finally {
                this.writeUnlock();
            }
        }

        private int updateDocumentElement(Element element) {
            int length;
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            endOffset = endOffset > (length = this.getLength()) ? length : endOffset;
            boolean isComment = false;
            try {
                isComment = this.getText(startOffset, endOffset - startOffset).startsWith("#");
            }
            catch (BadLocationException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            AttributeSet attr = element.getAttributes();
            if (!(attr instanceof MutableAttributeSet)) {
                return endOffset;
            }
            Color color = isComment ? Color.blue : Color.black;
            StyleConstants.setForeground((MutableAttributeSet)element.getAttributes(), color);
            return endOffset;
        }
    }
}

