/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.FolderFilter;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.WizardBase;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ServerCertUtil;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class ImportCertificateWizard
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final int V_GAP = 80;
    public static final int WELCOME_STAGE = 0;
    public static final int MANAGE_STAGE = 1;
    public static final int TYPE_STAGE = 2;
    public static final int PFX_STAGE = 3;
    public static final int COMPLETE_STAGE = 4;
    public static final int JKS_STAGE = 5;
    public static final int PEM_STAGE = 6;
    public static final int BACKUP_STAGE = 7;
    public static final int GENERATE_STAGE = 8;
    private static final int STAGE_COUNT = 5;
    private static final String SINGLE_ZIP_FILE_NAME = "ServerCertBackup_";
    private static final String WELCOME_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.heading.manageSvrCertWelcome");
    private static final String WELCOME_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.html.ManageSvrCerts");
    private static final String COMPLETE_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.heading.manageSvrCertComplete");
    private static MessageResourcesFile SERVERDIALOGMSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private static final String ADD_OR_UPDATE_CERTIFICATE_URL = "ImportCertificateWizard.html.addOrUpdateCertificateURL";
    private static final String COMPLETE_UPDATE_INSTRUCTION = ImportCertificateWizard.getCertificateMsg(SERVERDIALOGMSGRES, "ImportCertificateWizard.html.addOrUpdateCertificateURL", "ImportCertificateWizard.html.InfoUpdateSvrCert", 2406061);
    private static final String COMPLETE_UPDATE_RENAME_SERVER_INSTRUCTION = ImportCertificateWizard.getCertificateMsg(SERVERDIALOGMSGRES, "ImportCertificateWizard.html.addOrUpdateCertificateURL", "ImportCertificateWizard.html.InfoUpdateSvrCertRenameServer", 2406061);
    private static final String COMPLETE_BACKUP_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.html.InfoBackupSvrCert");
    private static final String COMPLETE_BACKUP_INSTRUCTION_WEB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.html.InfoBackupSvrCertWeb");
    private static final String COMPLETE_CERTIFICATE_GENERATION = ImportCertificateWizard.getCertificateMsg(SERVERDIALOGMSGRES, "ImportCertificateWizard.html.addOrUpdateCertificateURL", "ImportCertificateWizard.html.CertificateGeneration", 2406061);
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.DescCerts");
    private static final String NOTE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.BackupCertNote");
    private WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, WELCOME_HEADING, WELCOME_INSTRUCTION);
    private JEditorPane confirmDialogEditorPane = new JEditorPane("text/html", null);
    private ManagePanel managePanel = new ManagePanel();
    protected BackupPanel backupPanel = new BackupPanel();
    private TypePanel typePanel = new TypePanel();
    protected PfxPanel pfxPanel = new PfxPanel();
    protected JksPanel jksPanel = new JksPanel();
    protected PemPanel pemPanel = new PemPanel();
    private WizardBase.WelcomeAndFinishPanel completePanel;
    private int actionStage = 2;
    private boolean generateNewKey = true;
    protected int typeStage = 5;
    private static String dirBackupPath = System.getProperty("catalina.home") + File.separator + ".." + File.separator + "Server Private Key Backup";
    private static final String kKeystorePass = "keystore.password";
    private static final String SETTINGS_FILE = "settings.properties";

    public ImportCertificateWizard(String server) {
        super(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.ManageSvrCertFor"), server), true, WizardBase.HelpButtonState.OFF);
        this.confirmDialogEditorPane.addHyperlinkListener(e -> {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                Utility.showURL((String)e.getURL().toString());
            }
        });
        this.confirmDialogEditorPane.setEditable(false);
        this.addStage(this.welcomePanel, 0);
        this.addStage(this.managePanel, 1);
        this.addStage(this.backupPanel, 7);
        this.addStage(this.typePanel, 2);
        this.addStage(this.pfxPanel, 3);
        this.addStage(this.jksPanel, 5);
        this.addStage(this.pemPanel, 6);
        Dimension size = this.welcomePanel.getPreferredSize();
        this.welcomePanel.setPreferredSize(new Dimension(size.width, size.height));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public int getActionStage() {
        return this.actionStage;
    }

    public void setActionStage(int actionStage) {
        this.actionStage = actionStage;
    }

    private static String getCertificateMsg(MessageResourcesFile MSGRES, String urlResKey, String msgResKey, int errorID) {
        String errorCode = String.valueOf(errorID);
        Object[] obj1 = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage(), errorCode};
        String urlLink = MessageFormat.format(MSGRES.getString(urlResKey), obj1);
        Object[] obj2 = new Object[]{urlLink};
        return MessageFormat.format(MSGRES.getString(msgResKey), obj2);
    }

    @Override
    protected int getPreviousStage(int currentStage) {
        if (currentStage == 4 && this.actionStage == 7) {
            return 2;
        }
        return super.getPreviousStage(currentStage);
    }

    @Override
    protected int getNextStage(int currentStage) {
        if (currentStage == 2 && this.actionStage == 7) {
            String backupPath = this.backupPanel.getFinalBackupPath();
            String backupURL = new File(backupPath).toURI().toString();
            String msg = AjaxSwingCommonUtil.isAjaxSwingRunning() ? COMPLETE_BACKUP_INSTRUCTION_WEB : StringUtilities.formatHTML((String)COMPLETE_BACKUP_INSTRUCTION, (String[])new String[]{backupURL, backupPath});
            this.completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, COMPLETE_HEADING, msg);
            this.addStage(this.completePanel, 4);
            Dimension size = this.welcomePanel.getPreferredSize();
            this.completePanel.setPreferredSize(new Dimension(size.width, size.height));
            return 4;
        }
        if (currentStage == 1 && this.actionStage == 8) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.ConfirmCertificateGeneration");
            String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.message.ConfirmCertificateGeneration");
            if (this.generateNewKey) {
                message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.message.ConfirmNewKeyCertificateGeneration");
            }
            this.confirmDialogEditorPane.setText(message);
            if (JOptionPane.showConfirmDialog(null, this.confirmDialogEditorPane, title, 0) != 0) {
                return currentStage;
            }
            try {
                GUIManager.generateServerCertificate(this.generateNewKey);
                ConsoleLogger.logAdminEvent(16405);
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessageString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.CertificateGenerationError"), 0);
                return currentStage;
            }
            this.completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, COMPLETE_HEADING, COMPLETE_CERTIFICATE_GENERATION);
            this.addStage(this.completePanel, 4);
            return 4;
        }
        if (currentStage == 1 && this.actionStage == 2) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.ConfirmCertificateUpdate");
            String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.message.ConfirmCertificateUpdate");
            this.confirmDialogEditorPane.setText(message);
            if (JOptionPane.showConfirmDialog(null, this.confirmDialogEditorPane, title, 0) != 0) {
                return currentStage;
            }
        }
        if (currentStage == 3) {
            GUIManager.UpdateServerCertificateServerNameCheckResult serverNameCheckResult;
            this.validatePanel(currentStage);
            switch (this.typeStage) {
                case 3: {
                    serverNameCheckResult = this.pfxPanel.serverNameCheckResult;
                    break;
                }
                case 5: {
                    serverNameCheckResult = this.jksPanel.serverNameCheckResult;
                    break;
                }
                default: {
                    serverNameCheckResult = this.pemPanel.serverNameCheckResult;
                }
            }
            this.completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, COMPLETE_HEADING, serverNameCheckResult == GUIManager.UpdateServerCertificateServerNameCheckResult.MATCH ? COMPLETE_UPDATE_INSTRUCTION : COMPLETE_UPDATE_RENAME_SERVER_INSTRUCTION);
            this.addStage(this.completePanel, 4);
            Dimension size = this.welcomePanel.getPreferredSize();
            this.completePanel.setPreferredSize(new Dimension(size.width, size.height));
        }
        return super.getNextStage(currentStage);
    }

    @Override
    protected boolean validatePanel(int stage) {
        if (stage == 3) {
            if (this.typeStage == 3) {
                return this.pfxPanel.validatePanel();
            }
            if (this.typeStage == 5) {
                return this.jksPanel.validatePanel();
            }
            return this.pemPanel.validatePanel();
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning() && stage == 1 && this.actionStage == 7) {
            this.backupPanel.browseBackupPath();
            return true;
        }
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && stage == 2 && this.actionStage == 7) {
            return this.backupPanel.validatePanel();
        }
        return true;
    }

    @Override
    protected int getStageCount() {
        return 5;
    }

    @Override
    protected boolean disableBackButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected void showStage(int stage) {
        int currentStage = stage;
        if (stage == 2) {
            currentStage = this.actionStage;
        } else if (stage == 3) {
            currentStage = this.typeStage;
        }
        super.showStage(currentStage);
    }

    public byte[] getKeyStoreFileDataFromZip(String zipFile, int typeStage) {
        String fileName = null;
        File zFile = new File(zipFile);
        byte[] data = null;
        try (FileInputStream fis = new FileInputStream(zFile.getAbsoluteFile());
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry = null;
            boolean isValid = false;
            while (!isValid && (entry = zis.getNextEntry()) != null) {
                int dataByte;
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                switch (typeStage) {
                    case 3: {
                        if (!name.toLowerCase().endsWith(".pfx") && !name.toLowerCase().endsWith(".p12")) break;
                        fileName = name;
                        isValid = true;
                        break;
                    }
                    case 5: {
                        if (!name.toLowerCase().endsWith(".jks")) break;
                        fileName = name;
                        isValid = true;
                        break;
                    }
                    case 6: {
                        if (!name.toLowerCase().endsWith(".pem") && !name.toLowerCase().endsWith(".der")) break;
                        fileName = name;
                        isValid = true;
                        break;
                    }
                }
                if (!isValid) continue;
                long BUFFER = 4096L;
                byte[] temp = new byte[4096];
                int len = 0;
                while ((dataByte = zis.read()) != -1) {
                    temp[len++] = (byte)dataByte;
                }
                data = Arrays.copyOf(temp, len);
            }
        }
        catch (Exception e1) {
            ConsoleLogger.log(e1);
            String fileNameDisplay = AjaxSwingUtil.getDisplayFileName(new File(fileName));
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.ReadFromSelectedFile"), fileNameDisplay), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
        }
        return data;
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_manage_server_certificate";
    }

    class PemPanel
    extends UpdateCertificatePanel {
        private static final long serialVersionUID = 1L;
        protected JTextField jTFFile = new JTextField();
        private String tFFilePath = "";
        private JButton jBFileBrowse = new JButton(UIText.get(257));
        private JTextField jTFKey = new JTextField();
        protected String tFKeyPath = "";
        private JButton jBKeyBrowse = new JButton(UIText.get(257));

        public PemPanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.CertFile");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.SpecifyCertAndPrivKeyFiles");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            this.jBFileBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PemPanel.this.browsePemFile();
                }
            });
            ComponentUtils.setFileOpener((JComponent)this.jBFileBrowse, (FileOpener)new FileOpener(){

                public void openFile(File arg0) {
                    if (arg0 == null) {
                        return;
                    }
                    PemPanel.this.tFFilePath = arg0.getAbsolutePath();
                    PemPanel.this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(arg0));
                }
            });
            this.jBKeyBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PemPanel.this.browsePemPrivateFile();
                }
            });
            ComponentUtils.setFileOpener((JComponent)this.jBKeyBrowse, (FileOpener)new FileOpener(){

                public void openFile(File arg0) {
                    if (arg0 == null) {
                        return;
                    }
                    PemPanel.this.tFKeyPath = arg0.getAbsolutePath();
                    PemPanel.this.jTFKey.setText(AjaxSwingUtil.getDisplayFileName(arg0));
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.CertFile")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBFileBrowse, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.PrivKey")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFKey, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBKeyBrowse, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 20, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private void browsePemFile() {
            File selection;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.SelectCertFile"));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".pem") || f.getName().toLowerCase().endsWith(".der") || f.getName().toLowerCase().endsWith(".crt") || f.getName().toLowerCase().endsWith(".cer");
                }

                @Override
                public String getDescription() {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.DescPemFiles");
                }
            });
            if (0 == fileChooser.showOpenDialog(Manager.getFrame()) && (selection = fileChooser.getSelectedFile()) != null) {
                this.tFFilePath = selection.getAbsolutePath();
                this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(selection));
            }
        }

        private void browsePemPrivateFile() {
            File selection;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.SelectPrivKeyFile"));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".pem") || f.getName().toLowerCase().endsWith(".der");
                }

                @Override
                public String getDescription() {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.DescPrivKeyFiles");
                }
            });
            if (0 == fileChooser.showOpenDialog(Manager.getFrame()) && (selection = fileChooser.getSelectedFile()) != null) {
                this.tFKeyPath = selection.getAbsolutePath();
                this.jTFKey.setText(AjaxSwingUtil.getDisplayFileName(selection));
            }
        }

        private boolean validatePanel() {
            String fileName = this.jTFFile.getText();
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                fileName = this.tFFilePath;
            }
            if (fileName == null || fileName.trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.NoPemFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            String privateFileName = this.tFKeyPath;
            if (privateFileName == null || privateFileName.trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.NoPrivKeyFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            byte[] buffer = null;
            if (fileName.toLowerCase().endsWith(".zip")) {
                buffer = ImportCertificateWizard.this.getKeyStoreFileDataFromZip(fileName, 6);
            } else {
                File file = new File(fileName);
                try (FileInputStream fis = new FileInputStream(fileName);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    long length = file.length();
                    buffer = new byte[(int)length];
                    int bytesRead = bis.read(buffer);
                    ConsoleLogger.log("ImportCertificateWizard>PemPanel->validatePanel>>read " + bytesRead + " bytes");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.ReadFromSelectedFile"), this.jTFFile.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                    return false;
                }
            }
            if (buffer == null || buffer.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyFile"), this.jTFFile.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            byte[] privateBuffer = null;
            if (privateFileName.toLowerCase().endsWith(".zip")) {
                privateBuffer = ImportCertificateWizard.this.getKeyStoreFileDataFromZip(privateFileName, 6);
            } else {
                try (FileInputStream privateFis = new FileInputStream(privateFileName);
                     BufferedInputStream privateBis = new BufferedInputStream(privateFis);){
                    File privateFile = new File(privateFileName);
                    long length = privateFile.length();
                    privateBuffer = new byte[(int)length];
                    privateBis.read(privateBuffer);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.ReadFromSelectedFile"), this.jTFKey.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                    return false;
                }
            }
            if (privateBuffer == null || privateBuffer.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyFile"), this.jTFKey.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            try {
                Hashtable<String, byte[]> data = new Hashtable<String, byte[]>();
                data.put("CERT", buffer);
                data.put("PRIV", privateBuffer);
                this.serverNameCheckResult = GUIManager.updateServerCertificate("CertPrivKey", null, null, data);
                ConsoleLogger.logAdminEvent(16405);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.UpdateSvrCert"), 0);
                return false;
            }
            return true;
        }
    }

    private class JksPanel
    extends UpdateCertificatePanel
    implements FileOpener {
        private static final long serialVersionUID = 1L;
        private JTextField jTFFile = new JTextField();
        private String zipFilePath = null;
        private JButton jBBrowse = new JButton(UIText.get(257));
        private JPasswordField jPFKeyStore = new JPasswordField();
        private JPasswordField jPFKey = new JPasswordField();

        public JksPanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.JksKeystore");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.SpecifyJksKeystore");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            this.jBBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JksPanel.this.browseJksFile();
                }
            });
            ComponentUtils.setFileOpener((JComponent)this.jBBrowse, (FileOpener)this);
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.jTFFile.setEnabled(false);
            }
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.JksKeystore")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBBrowse, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.KeystorePwd")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jPFKeyStore, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.KeyPwd")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jPFKey, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 20, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private void browseJksFile() {
            File selection;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.SelectJavaKeystoreFile"));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".jks") || f.getName().toLowerCase().endsWith(".zip");
                }

                @Override
                public String getDescription() {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.JksFileDesc");
                }
            });
            if (0 == fileChooser.showOpenDialog(Manager.getFrame()) && (selection = fileChooser.getSelectedFile()) != null) {
                this.zipFilePath = selection.getAbsolutePath();
                this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(selection));
                if (this.zipFilePath.trim().toLowerCase().endsWith(".zip")) {
                    this.setKeyStorePassDataFromZip(this.zipFilePath);
                    fileChooser.updateUI();
                }
            }
        }

        private boolean validatePanel() {
            String inputFileName = this.jTFFile.getText();
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                inputFileName = this.zipFilePath;
            }
            byte[] buffer = null;
            File file = null;
            if (StringUtilities.isEmpty((String)inputFileName)) {
                JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.NoValidJavaKeystoreFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            if (inputFileName.toLowerCase().endsWith(".zip")) {
                file = new File(inputFileName);
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.InvalidFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                    return false;
                }
                buffer = ImportCertificateWizard.this.getKeyStoreFileDataFromZip(inputFileName, 5);
            } else {
                file = new File(inputFileName);
                try (FileInputStream fis = new FileInputStream(inputFileName);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    long length = file.length();
                    buffer = new byte[(int)length];
                    int bytesRead = bis.read(buffer);
                    ConsoleLogger.log("ImportCertificateWizard>JksPanel->validatePanel>>read " + bytesRead + " bytes");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.ReadFromSelectedFile"), this.jTFFile.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                    return false;
                }
            }
            if (buffer == null || buffer.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyFile"), this.jTFFile.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            char[] password = this.jPFKeyStore.getPassword();
            char[] keyPassword = this.jPFKey.getPassword();
            if (password.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyJksKeystorePwd"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.EmptyPwd"), 0);
                return false;
            }
            if (keyPassword.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyJksKeyPwd"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.EmptyPwd"), 0);
                return false;
            }
            try {
                Hashtable<String, byte[]> data = new Hashtable<String, byte[]>();
                data.put("JKS", buffer);
                this.serverNameCheckResult = GUIManager.updateServerCertificate("JKS", new String(password), new String(keyPassword), data);
                ConsoleLogger.logAdminEvent(16405);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessageString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.UpdateSvrCert"), 0);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setKeyStorePassDataFromZip(String zipFile) {
            File zFile = new File(zipFile);
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            ZipInputStream zis = null;
            try {
                fis = new FileInputStream(zFile.getAbsoluteFile());
                bis = new BufferedInputStream(fis);
                zis = new ZipInputStream(bis);
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String keyStorePassword;
                    Properties sepm_prop;
                    block22: {
                        String name = entry.getName();
                        if (!entry.isDirectory() && name.toLowerCase().endsWith(".xml")) {
                            try (ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();){
                                int end;
                                int start;
                                int dataByte = 0;
                                while ((dataByte = zis.read()) != -1) {
                                    xmlStream.write(dataByte);
                                }
                                byte[] xmlByte = xmlStream.toByteArray();
                                String xmlStr = new String(xmlByte, "UTF-8");
                                int storePass = xmlStr.toLowerCase().indexOf("keystorepass");
                                int keyPass = xmlStr.toLowerCase().indexOf("keypass");
                                String keyStorePassword2 = null;
                                String keyPassword = null;
                                if (storePass != -1) {
                                    start = xmlStr.substring(storePass + "keystorepass".length()).indexOf(34) + 1;
                                    end = xmlStr.substring(storePass + "keystorepass".length()).indexOf(34, start);
                                    keyStorePassword2 = xmlStr.substring(storePass + "keystorepass".length()).substring(start, end);
                                    this.jPFKeyStore.setText(keyStorePassword2);
                                    this.jPFKeyStore.updateUI();
                                }
                                if (keyPass != -1) {
                                    start = xmlStr.substring(keyPass + "keypass".length()).indexOf(34) + 1;
                                    end = xmlStr.substring(storePass + "keypass".length()).indexOf(34, start);
                                    keyPassword = xmlStr.substring(storePass + "keypass".length()).substring(start, end);
                                    this.jPFKey.setText(keyPassword);
                                } else if (keyStorePassword2 != null) {
                                    this.jPFKey.setText(keyStorePassword2);
                                }
                                this.jPFKey.updateUI();
                                break;
                            }
                        }
                        if (entry.isDirectory() || !name.toLowerCase().equals(ImportCertificateWizard.SETTINGS_FILE)) continue;
                        ConsoleLogger.log("Found Settings file");
                        BufferedOutputStream dest = null;
                        int BUFFER_SIZE = 1024;
                        byte[] data = new byte[1024];
                        File tmpFile = null;
                        sepm_prop = null;
                        BufferedInputStream is1 = null;
                        try {
                            int count;
                            tmpFile = File.createTempFile("temp_", entry.getName());
                            FileOutputStream fos = new FileOutputStream(tmpFile);
                            dest = new BufferedOutputStream(fos, 1024);
                            while ((count = zis.read(data, 0, 1024)) != -1) {
                                dest.write(data, 0, count);
                            }
                            IOUtilities.closeOutputStream((OutputStream)dest);
                            sepm_prop = new Properties();
                            is1 = new BufferedInputStream(new FileInputStream(tmpFile));
                            sepm_prop.load(is1);
                            IOUtilities.closeOutputStream((OutputStream)dest);
                        }
                        catch (Exception e) {
                            ConsoleLogger.log("Exception while reading settings file: " + e.getMessage());
                            break block22;
                        }
                        finally {
                            IOUtilities.closeOutputStream(dest);
                            IOUtilities.closeInputStream(is1);
                            IOUtilities.deleteFile((File)tmpFile);
                        }
                        IOUtilities.closeInputStream((InputStream)is1);
                        IOUtilities.deleteFile((File)tmpFile);
                    }
                    if (sepm_prop == null || (keyStorePassword = sepm_prop.getProperty(ImportCertificateWizard.kKeystorePass)) == null) continue;
                    ConsoleLogger.log("setting password to the fields");
                    this.jPFKeyStore.setText(keyStorePassword);
                    this.jPFKey.setText(keyStorePassword);
                    this.jPFKeyStore.updateUI();
                    this.jPFKey.updateUI();
                    break;
                }
            }
            catch (IOException e) {
                try {
                    LoggerUtilities.logException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeInputStream(fis);
                    IOUtilities.closeInputStream(bis);
                    IOUtilities.closeInputStream(zis);
                    throw throwable;
                }
                IOUtilities.closeInputStream((InputStream)fis);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(zis);
            }
            IOUtilities.closeInputStream((InputStream)fis);
            IOUtilities.closeInputStream((InputStream)bis);
            IOUtilities.closeInputStream((InputStream)zis);
        }

        public void openFile(File arg0) {
            this.zipFilePath = arg0.getAbsolutePath();
            this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(arg0));
            System.out.println("Zip File Path: " + this.zipFilePath);
            if (this.zipFilePath.trim().toLowerCase().endsWith(".zip")) {
                System.out.println("Populating the UI input fields:");
                this.setKeyStorePassDataFromZip(this.zipFilePath);
            }
        }
    }

    class PfxPanel
    extends UpdateCertificatePanel
    implements FileOpener {
        private static final long serialVersionUID = 1L;
        protected JTextField jTFFile = new JTextField();
        private String zipFilePath = null;
        private JButton jBBrowse = new JButton(UIText.get(257));
        protected JPasswordField jPFKeyStore = new SEPMPasswordField();

        public PfxPanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.PfxP12Keystore");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.SpecifyPathPwdForKeystore");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            this.jBBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PfxPanel.this.browsePfxFile();
                }
            });
            ComponentUtils.setFileOpener((JComponent)this.jBBrowse, (FileOpener)this);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.PfxP12Keystore")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBBrowse, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.KeystorePwd")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 0), 0, 0));
            panel.add((Component)this.jPFKeyStore, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 20, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private void browsePfxFile() {
            File selection;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.SelectPfxP12File"));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".pfx") || f.getName().toLowerCase().endsWith(".p12");
                }

                @Override
                public String getDescription() {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.PfxP12FileDesc");
                }
            });
            if (0 == fileChooser.showOpenDialog(Manager.getFrame()) && (selection = fileChooser.getSelectedFile()) != null && (selection.getName().toLowerCase().endsWith(".pfx") || selection.getName().toLowerCase().endsWith(".p12"))) {
                this.zipFilePath = selection.getAbsolutePath();
                this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(selection));
            }
        }

        private boolean validatePanel() {
            String inputFileName = this.jTFFile.getText();
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                inputFileName = this.zipFilePath;
            }
            String fileName = null;
            byte[] buffer = null;
            if (inputFileName != null && inputFileName.toLowerCase().endsWith(".zip")) {
                buffer = ImportCertificateWizard.this.getKeyStoreFileDataFromZip(inputFileName, 3);
            } else {
                fileName = inputFileName;
                if (StringUtilities.isEmpty((String)fileName)) {
                    JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.NoPfxP12File"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                    return false;
                }
                File file = new File(fileName);
                try (FileInputStream fis = new FileInputStream(fileName);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    long length = file.length();
                    buffer = new byte[(int)length];
                    int bytesRead = bis.read(buffer);
                    ConsoleLogger.log("ImportCertificateWizard>PfxPanel->validatePanel>>read " + bytesRead + " bytes");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.ReadFromSelectedFile"), this.jTFFile.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                    return false;
                }
            }
            if (buffer == null || buffer.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyFile"), this.jTFFile.getText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidFile"), 0);
                return false;
            }
            char[] password = this.jPFKeyStore.getPassword();
            if (password.length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.EmptyPwd"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.InvalidPwd"), 0);
                return false;
            }
            try {
                Hashtable<String, byte[]> data = new Hashtable<String, byte[]>();
                data.put("PFX", buffer);
                this.serverNameCheckResult = GUIManager.updateServerCertificate("PFX", new String(password), null, data);
                ConsoleLogger.logAdminEvent(16405);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessageString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.SvrCertUpdate"), 0);
                return false;
            }
            return true;
        }

        public void openFile(File arg0) {
            if (arg0 == null) {
                return;
            }
            this.zipFilePath = arg0.getAbsolutePath();
            this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(arg0));
        }
    }

    private static class UpdateCertificatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected GUIManager.UpdateServerCertificateServerNameCheckResult serverNameCheckResult = GUIManager.UpdateServerCertificateServerNameCheckResult.MATCH;

        private UpdateCertificatePanel() {
        }
    }

    private class TypePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextArea jTADescription = new DescriptionTextArea(DESCRIPTION);
        private JRadioButton jRBPfx = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.radio.Pfx"), true);
        private JRadioButton jRBJks = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.radio.Jks"));
        private JRadioButton jRBPem = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.radio.DerPem"));

        public TypePanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.CertType");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.SpecifySvrCertType");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            ButtonGroup group = new ButtonGroup();
            group.add(this.jRBPfx);
            group.add(this.jRBJks);
            group.add(this.jRBPem);
            this.jRBPfx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypePanel.this.typeChanged();
                }
            });
            this.jRBJks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypePanel.this.typeChanged();
                }
            });
            this.jRBPem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypePanel.this.typeChanged();
                }
            });
            JPanel typePanel = new JPanel(new VerticalFlowLayout());
            typePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            typePanel.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.SelectCertTypeToImport")));
            typePanel.add(this.jRBJks);
            typePanel.add(this.jRBPfx);
            typePanel.add(this.jRBPem);
            this.jRBJks.setSelected(true);
            JPanel wrapPanel = new JPanel(new VerticalFlowLayout());
            wrapPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 20));
            wrapPanel.add(this.jTADescription);
            wrapPanel.add(typePanel);
            this.setLayout(new BorderLayout());
            this.add((Component)headPanel, "North");
            this.add((Component)wrapPanel, "Center");
        }

        private void typeChanged() {
            ImportCertificateWizard.this.typeStage = this.jRBPfx.isSelected() ? 3 : (this.jRBJks.isSelected() ? 5 : 6);
        }
    }

    protected static class BackupPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField jTFBackupPath = new JTextField();
        private JButton jBBrowse = new JButton(UIText.get(257));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        protected String backupPath = null;
        String timeStamp = this.sdf.format(new Date());
        String zipFileName = "ServerCertBackup_" + this.timeStamp + ".zip";
        String tempDirPath = Utility.getTempDir() + File.separator + "ServerCertBackup_" + this.timeStamp;

        public BackupPanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.BackupCert");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.SpecifyBackupPath");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            String dirPath = dirBackupPath;
            boolean result = false;
            if (dirPath != null && dirPath.length() > 0) {
                result = new File(dirPath).isDirectory();
            }
            if (result && !AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                try {
                    String path = new File(dirPath).getCanonicalPath();
                    this.jTFBackupPath.setText(path);
                }
                catch (IOException e1) {
                    ConsoleLogger.log(e1);
                    this.jTFBackupPath.setText(dirPath);
                }
            }
            this.jBBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.browseBackupPath();
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 40, 10, 40));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.BackupCertInfo")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFBackupPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBBrowse, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(NOTE), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        protected void browseBackupPath() {
            int option;
            JFileChooser dirChooser;
            String dirPath = dirBackupPath;
            boolean result = false;
            if (dirPath != null && dirPath.length() > 0) {
                result = new File(dirPath).isDirectory();
            }
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                dirChooser = result ? new JFileChooser(dirPath) : new JFileChooser();
            } else {
                dirChooser = new JFileChooser();
                dirChooser.setDialogType(1);
            }
            dirChooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.SelectBackupPath"));
            dirChooser.setAcceptAllFileFilterUsed(false);
            dirChooser.setFileFilter((FileFilter)new FolderFilter());
            dirChooser.setFileSelectionMode(2);
            ((BasicFileChooserUI)dirChooser.getUI()).setFileName(dirChooser.getCurrentDirectory().getAbsolutePath());
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                dirChooser.setSelectedFile(new File(this.zipFileName));
                option = dirChooser.showSaveDialog(Manager.getFrame());
            } else {
                option = dirChooser.showOpenDialog(Manager.getFrame());
            }
            if (option == 0) {
                this.backupPath = dirChooser.getSelectedFile().getAbsolutePath();
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    this.downloadCertFiles(this.backupPath);
                }
                File dir = dirChooser.getSelectedFile();
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    this.jTFBackupPath.setText(dirChooser.getSelectedFile().getName());
                } else {
                    this.jTFBackupPath.setText(this.backupPath);
                    if (!dir.exists() || !dir.isDirectory()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.BackupPathInvalid"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.Error"), 0);
                        this.jTFBackupPath.requestFocus();
                    }
                }
            }
        }

        private String getFinalBackupPath() {
            try {
                return new File(this.getKeystoreBackupPath()).getCanonicalPath();
            }
            catch (IOException iOException) {
                return this.getKeystoreBackupPath();
            }
        }

        private String getKeystoreBackupPath() {
            return this.jTFBackupPath.getText().trim();
        }

        private boolean validatePanel() {
            this.backupPath = this.getKeystoreBackupPath();
            if (this.backupPath.isEmpty()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.BackupPathIsEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.Error"), 0);
                this.jTFBackupPath.requestFocus();
                return false;
            }
            return this.downloadCertFiles(this.backupPath);
        }

        private boolean downloadCertFiles(String certPath) {
            int result;
            File zipFile = null;
            zipFile = AjaxSwingCommonUtil.isAjaxSwingRunning() ? new File(certPath) : new File(certPath + File.separator, ImportCertificateWizard.SINGLE_ZIP_FILE_NAME + this.timeStamp + ".zip");
            Utility.delete((File)zipFile);
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                certPath = this.tempDirPath;
            }
            if ((result = Utility.createDir((String)certPath)) != 0) {
                if (result == 1) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.BackupPathIsFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.Error"), 0);
                } else {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.BackupPathInvalid"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.Error"), 0);
                }
                this.jTFBackupPath.requestFocus();
                return false;
            }
            String serverXmlBackupPath = certPath + File.separator + "server_" + this.timeStamp + ".xml";
            String keystoreBackupPath = certPath + File.separator + "keystore_" + this.timeStamp + ".jks";
            if (!GUIManager.downloadFile(ServerCertUtil.STORE_PASSWD_RELATIVE_PATH, 1, serverXmlBackupPath) || !GUIManager.downloadFile(ServerCertUtil.STORE_RELATIVE_PATH, 1, keystoreBackupPath)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.error.retrieve.file"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.Error"), 0);
                return false;
            }
            TimeCounter counter = new TimeCounter();
            try {
                counter.start();
                System.out.println("Begin Zip...");
                ZipUtil.zipData((int)-1, (String[])new String[]{serverXmlBackupPath, keystoreBackupPath}, (String)certPath, (String)zipFile.getAbsolutePath(), (boolean)true);
                counter.stop();
                System.out.println("Done Zip: " + this.zipFileName + ", elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
            }
            catch (Throwable ex) {
                System.out.println("ImportCertificateWizard>> createSingleZip: Error-> Failed to create single zip: " + zipFile.getAbsolutePath());
                LoggerUtilities.logException((Throwable)ex);
                return false;
            }
            File serverFile = new File(serverXmlBackupPath);
            File keyStoreFile = new File(keystoreBackupPath);
            if (serverFile.exists() && !serverFile.delete()) {
                System.out.println("ImportCertificateWizard>> Warning: Failed to delete serverFile: " + serverFile.getAbsolutePath());
            }
            if (keyStoreFile.exists() && !keyStoreFile.delete()) {
                System.out.println("ImportCertificateWizard>> Warning: Failed to delete keyStoreFile: " + keyStoreFile.getAbsolutePath());
            }
            return true;
        }
    }

    private class ManagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JRadioButton jRBUpdate = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.radio.UpdateCert"), true);
        private JRadioButton jRBBackup = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.radio.BackupCert"));
        private JRadioButton jRBGenerate = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.radio.GenerateCert"));
        private JCheckBox JCBGenerateKey = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.checkbox.GenerateNewKey"), true);
        private HTMLEditorPane generateKeyDesc = new HTMLEditorPane();
        private JPanel generateNewCertPanel = new JPanel(new VerticalFlowLayout(20, 0));

        public ManagePanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.title.ManageCert");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.SpecifyManageAction");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            ButtonGroup group = new ButtonGroup();
            group.add(this.jRBUpdate);
            group.add(this.jRBBackup);
            group.add(this.jRBGenerate);
            this.jRBUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagePanel.this.actionChanged();
                }
            });
            this.jRBBackup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagePanel.this.actionChanged();
                }
            });
            this.jRBGenerate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagePanel.this.actionChanged();
                }
            });
            this.JCBGenerateKey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagePanel.this.generateKeyActionChanged();
                }
            });
            JPanel managePanel = new JPanel(new VerticalFlowLayout());
            managePanel.setBorder(BorderFactory.createEmptyBorder(30, 10, 0, 10));
            managePanel.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.label.SelectManageAction")));
            managePanel.add(this.jRBUpdate);
            managePanel.add(this.jRBBackup);
            managePanel.add(this.jRBGenerate);
            managePanel.add(this.generateNewCertPanel);
            managePanel.add(this.generateKeyDesc);
            this.generateNewCertPanel.add(this.JCBGenerateKey);
            this.generateKeyDesc.setEditable(false);
            this.generateKeyDesc.setBackground(managePanel.getBackground());
            String strMsg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ImportCertificateWizard.checkbox.html.description"), ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage());
            this.generateKeyDesc.setText(strMsg);
            this.enableKeyChange();
            JPanel wrapPanel = new JPanel(new VerticalFlowLayout());
            wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
            wrapPanel.add(managePanel);
            this.setLayout(new BorderLayout());
            this.add((Component)headPanel, "North");
            this.add((Component)wrapPanel, "Center");
        }

        private void actionChanged() {
            if (this.jRBUpdate.isSelected()) {
                ImportCertificateWizard.this.actionStage = 2;
                this.enableKeyChange();
            } else if (this.jRBBackup.isSelected()) {
                ImportCertificateWizard.this.actionStage = 7;
                this.enableKeyChange();
            } else if (this.jRBGenerate.isSelected()) {
                ImportCertificateWizard.this.actionStage = 8;
                this.enableKeyChange();
            }
        }

        private void enableKeyChange() {
            this.generateKeyDesc.setEnabled(this.jRBUpdate.isSelected() || this.jRBGenerate.isSelected() && this.JCBGenerateKey.isSelected());
            this.JCBGenerateKey.setEnabled(this.jRBGenerate.isSelected());
        }

        private void generateKeyActionChanged() {
            this.enableKeyChange();
            ImportCertificateWizard.this.generateNewKey = this.JCBGenerateKey.isSelected();
        }
    }
}

