/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.FullContentsDistributionConfig;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FullContentDistributionConfigPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private JCheckBox jCbxDisableFullContentDownload = new JCheckBox(resource.getString("FullContentDistributionConfigPanel.checkbox.disableFullContentDownload"));
    private static final long serialVersionUID = -1610579372593069032L;
    private static MessageResourcesFile resource = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    protected boolean readOnly = false;
    protected boolean localServer = false;
    private boolean downloadFullContentOptionChanged = false;
    private boolean startUp = true;
    private ServerObject model;

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_full_definitions_download";
    }

    public FullContentDistributionConfigPanel(boolean readOnly, boolean localServer) {
        this.readOnly = readOnly;
        this.localServer = localServer;
        this.initialize();
        this.setVisible(true);
        this.setReadOnlyStatus();
    }

    public void setModel(ServerObject model) {
        this.model = model;
        this.jCbxDisableFullContentDownload.setSelected(model.getBlockFullContentsOption());
        this.startUp = false;
    }

    public void updateModel() {
        if (this.downloadFullContentOptionChanged) {
            SemServer server = this.model.getSemServer();
            FullContentsDistributionConfig fullContentsDistributionConfig = server.getOptFullContentsDistributionConfig();
            if (fullContentsDistributionConfig == null) {
                fullContentsDistributionConfig = new FullContentsDistributionConfig();
            }
            fullContentsDistributionConfig.setOptBlockFullContents(Boolean.valueOf(this.jCbxDisableFullContentDownload.isSelected()));
            server.setOptFullContentsDistributionConfig(fullContentsDistributionConfig);
            int event = this.jCbxDisableFullContentDownload.isSelected() ? 16408 : 16409;
            ConsoleLogger.logAdminEvent(event, LogEventDescription.getDescription((String)"ServerAdminLog", (Integer)event));
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        UiUtilities.setupTitledPanel((JPanel)this, (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerPropertiesDlg.title.FullContentDistributionConfig"));
        this.add((Component)this.getSettingsPanel(), "North");
    }

    private JPanel getSettingsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getOptionsPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.jCbxDisableFullContentDownload.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (!FullContentDistributionConfigPanel.this.startUp) {
                    FullContentDistributionConfigPanel.this.downloadFullContentOptionChanged = true;
                }
            }
        });
        panel.add((Component)this.jCbxDisableFullContentDownload, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 5), 0, 0));
        return panel;
    }

    private void setReadOnlyStatus() {
        this.jCbxDisableFullContentDownload.setEnabled(!this.readOnly && this.localServer);
    }

    public boolean isValidState() {
        if (this.downloadFullContentOptionChanged && this.jCbxDisableFullContentDownload.isSelected()) {
            String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "FullContentDistributionConfigPanel.disableFullContentDownload.confirmation.message");
            MultiLineLabel multiL = new MultiLineLabel(message);
            if (1 == JOptionPane.showConfirmDialog(Manager.getFrame(), multiL, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "FullContentDistributionConfigPanel.disableFullContentDownload.confirmation.title"), 0)) {
                return false;
            }
        }
        return true;
    }
}

