/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.ExternalLogging;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.ExternalLoggingObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.server.dlg.ExternalLoggingGeneralPanel;
import com.sygate.scm.console.ui.server.dlg.ExternalLoggingLogFilterPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ExternalLoggingPropertiesDlg
extends DialogBase {
    private static final long serialVersionUID = 7312918364384439614L;
    private JTabbedPane jTabPane = new JTabbedPane();
    private ExternalLoggingGeneralPanel generalPanel = null;
    private ExternalLoggingLogFilterPanel logFilterPanel = null;

    public ExternalLoggingPropertiesDlg(SiteObject siteObject, boolean readOnly) throws ConsoleException {
        super(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingPropertiesDlg.title.ExternalLogging"), siteObject), true);
        if (siteObject == null || siteObject.getSemSite() == null) {
            throw new ConsoleException("The parameter SiteObject cannot be null!");
        }
        this.readOnly = readOnly;
        this.initialize();
        this.setModel(siteObject);
        UiUtilities.centerComponent((Component)this);
        this.pack();
        this.setReadOnlyStatus();
        this.setVisible(true);
    }

    public ExternalLoggingPropertiesDlg(SiteObject siteObject) throws ConsoleException {
        this(siteObject, false);
    }

    public boolean updateModel(SiteObject siteObj) throws ConsoleException {
        if (siteObj == null) {
            return false;
        }
        ExternalLoggingObject externalLoggingObj = new ExternalLoggingObject(siteObj.getOrCreateExternalLogging());
        if (!externalLoggingObj.isValid()) {
            return false;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            PrintStream ps = new PrintStream((OutputStream)bs, false, "UTF-8");
            ExternalLogging extLoggingCopy = (ExternalLogging)externalLoggingObj.getExternalLogging().clone();
            ExternalLoggingObject extLoggingObjCopy = new ExternalLoggingObject(extLoggingCopy);
            ExternalLoggingObject.print(extLoggingObjCopy, ps);
            String strBefore = bs.toString("UTF-8");
            bs.reset();
            this.generalPanel.updateModel(extLoggingObjCopy);
            this.logFilterPanel.updateModel(extLoggingObjCopy);
            ExternalLoggingObject.print(extLoggingObjCopy, ps);
            String strAfter = bs.toString("UTF-8");
            if (!strAfter.equals(strBefore)) {
                this.generalPanel.updateModel(externalLoggingObj);
                this.logFilterPanel.updateModel(externalLoggingObj);
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConsoleException(e);
        }
        return false;
    }

    @Override
    protected boolean isValidate() {
        if (!this.generalPanel.validateInput()) {
            return false;
        }
        return this.logFilterPanel.validateInput();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.jTabPane.getSelectedComponent());
    }

    private void initialize() {
        this.generalPanel = new ExternalLoggingGeneralPanel(this.readOnly);
        this.logFilterPanel = new ExternalLoggingLogFilterPanel(this.readOnly);
        this.jTabPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingPropertiesDlg.title.General"), new JScrollPane(this.generalPanel));
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingPropertiesDlg.title.LogFilter"), new JScrollPane(this.logFilterPanel));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jTabPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private void setModel(SiteObject siteObj) throws ConsoleException {
        if (siteObj != null) {
            this.generalPanel.setModel(siteObj);
            this.logFilterPanel.setModel(new ExternalLoggingObject(siteObj.getExternalLogging()));
        }
    }
}

