/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.ExtLogContentEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalLoggingObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExternalLoggingLogFilterPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -1922311255631718616L;
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.LogFilterDesc");
    private JCheckBox jCbxServerAdmin = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.AdmLog"));
    private JCheckBox jCbxServerClient = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.ClientLog"));
    private JCheckBox jCbxServerEnforcer = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.EnforcerLog"));
    private JCheckBox jCbxServerPolicy = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.PolicyLog"));
    private JCheckBox jCbxServerSystem = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.SysLog"));
    private JCheckBox jCbxSSSevere = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Error"));
    private JCheckBox jCbxSSWarn = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Warning"));
    private JCheckBox jCbxSSInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private JCheckBox jCbxSASevere = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Error"));
    private JCheckBox jCbxSAWarn = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Warning"));
    private JCheckBox jCbxSAInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private JCheckBox jCbxAgentPacket = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.PacketLog"));
    private JCheckBox jCbxAgentSecurity = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.SecLog"));
    private JCheckBox jCbxAgentSystem = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.AgtSysLog"));
    private JCheckBox jCbxAgentTraffic = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.TrafficLog"));
    private JCheckBox jCbxAgentBehavior = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.BehaviorLog"));
    private JCheckBox jCbxAgentScan = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.ScanLog"));
    private JCheckBox jCbxAgentRisk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.RiskLog"));
    private JCheckBox jCbxAgentProActDetect = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.ProActDetectLog"));
    private JCheckBox jCbxACCritical = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Critical"));
    private JCheckBox jCbxACMajor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Major"));
    private JCheckBox jCbxACMinor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Minor"));
    private JCheckBox jCbxACInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private JCheckBox jCbxASFatal = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Fatal"));
    private JCheckBox jCbxASError = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Error"));
    private JCheckBox jCbxASWarn = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Warning"));
    private JCheckBox jCbxASInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private JCheckBox jCbxATCritical = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Critical"));
    private JCheckBox jCbxATMajor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Major"));
    private JCheckBox jCbxATMinor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Minor"));
    private JCheckBox jCbxATInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private JCheckBox jCbxABCritical = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Critical"));
    private JCheckBox jCbxABMajor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Major"));
    private JCheckBox jCbxABMinor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Minor"));
    private JCheckBox jCbxABInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private JCheckBox jCbxEnforcerClient = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.EnforcerClientLog"));
    private JCheckBox jCbxEnforcerSystem = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.EnforcerServerLog"));
    private JCheckBox jCbxEnforcerTraffic = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.EnforcerTrafficLog"));
    private JCheckBox jCbxESFatal = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Fatal"));
    private JCheckBox jCbxESError = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Error"));
    private JCheckBox jCbxESWarn = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Warning"));
    private JCheckBox jCbxESInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.checkbox.Info"));
    private boolean isFirewallPolicy;
    private boolean isSNACEnabled;
    private boolean isSNAConly;
    private boolean readOnly;

    public ExternalLoggingLogFilterPanel(boolean readOnly) {
        LicenseObject license = LicenseObject.getInstance();
        this.isFirewallPolicy = license.isFirewallPolicy();
        this.isSNAConly = license.isSNACOnlyProduct();
        this.isSNACEnabled = license.isALLProduct() || this.isSNAConly;
        this.readOnly = readOnly;
        this.initialize();
    }

    public void setModel(ExternalLoggingObject externalLoggingObj) throws ConsoleException {
        if (externalLoggingObj != null) {
            Vector<ExtLogContentEntity> logEntities = externalLoggingObj.getExtLogContentEntities();
            this.selectLogCheckBox(ExternalLoggingObject.getExtLogContentEntityForServerSystemLog(logEntities), this.jCbxServerSystem, this.jCbxSSSevere, this.jCbxSSWarn, this.jCbxSSInfo, null);
            this.selectLogCheckBox(ExternalLoggingObject.getExtLogContentEntityForServerAdminLog(logEntities), this.jCbxServerAdmin, this.jCbxSASevere, this.jCbxSAWarn, this.jCbxSAInfo, null);
            this.jCbxServerClient.setSelected(ExternalLoggingObject.getExtLogContentEntityForServerClientActivityLog(logEntities));
            this.jCbxServerEnforcer.setSelected(ExternalLoggingObject.getExtLogContentEntityForServerEnforcerActivityLog(logEntities));
            this.jCbxServerPolicy.setSelected(ExternalLoggingObject.getExtLogContentEntityForServerPolicyLog(logEntities));
            boolean[] enableAgentSecurityLog = ExternalLoggingObject.getExtLogContentEntityForAgentSecurityLog(logEntities);
            this.jCbxAgentSecurity.setSelected(enableAgentSecurityLog[0]);
            this.jCbxACCritical.setSelected(enableAgentSecurityLog[1]);
            this.jCbxACMajor.setSelected(enableAgentSecurityLog[2]);
            this.jCbxACMinor.setSelected(enableAgentSecurityLog[3]);
            this.jCbxACInfo.setSelected(enableAgentSecurityLog[4]);
            if (this.isFirewallPolicy) {
                this.selectLogCheckBox(ExternalLoggingObject.getExtLogContentEntityForAgentTrafficLog(logEntities), this.jCbxAgentTraffic, this.jCbxATCritical, this.jCbxATMajor, this.jCbxATMinor, this.jCbxATInfo);
            }
            if (this.isFirewallPolicy) {
                this.jCbxAgentPacket.setSelected(ExternalLoggingObject.getExtLogContentEntityForAgentPacketLog(logEntities));
            }
            this.selectLogCheckBox(ExternalLoggingObject.getExtLogContentEntityForAgentSystemLog(logEntities), this.jCbxAgentSystem, this.jCbxASFatal, this.jCbxASError, this.jCbxASWarn, this.jCbxASInfo);
            if (!this.isSNAConly) {
                this.selectLogCheckBox(ExternalLoggingObject.getExtLogContentEntityForAgentBehaviorLog(logEntities), this.jCbxAgentBehavior, this.jCbxABCritical, this.jCbxABMajor, this.jCbxABMinor, this.jCbxABInfo);
                this.jCbxAgentScan.setSelected(ExternalLoggingObject.getExtLogContentEntityForAgentScanLog(logEntities));
                this.jCbxAgentRisk.setSelected(ExternalLoggingObject.getExtLogContentEntityForAgentRiskLog(logEntities));
                this.jCbxAgentProActDetect.setSelected(ExternalLoggingObject.getExtLogContentEntityForAgentProActDetectLog(logEntities));
            }
            this.selectLogCheckBox(ExternalLoggingObject.getExtLogContentEntityForEnforcerSystemLog(logEntities), this.jCbxEnforcerSystem, this.jCbxESFatal, this.jCbxESError, this.jCbxESWarn, this.jCbxESInfo);
            this.jCbxEnforcerTraffic.setSelected(ExternalLoggingObject.getExtLogContentEntityForEnforcerTrafficLog(logEntities));
            this.jCbxEnforcerClient.setSelected(ExternalLoggingObject.getExtLogContentEntityForEnforcerClientActivityLog(logEntities));
        }
        this.serverSystemEnabled();
        this.serverAdminEnabled();
        this.agentSecurityEnabled();
        this.agentSystemEnabled();
        this.agentTrafficEnabled();
        this.agentBehaviorEnabled();
        this.enforcerSystemEnabled();
        this.setReadOnlyStatus();
    }

    public void updateModel(ExternalLoggingObject externalLoggingObj) {
        if (externalLoggingObj == null) {
            return;
        }
        externalLoggingObj.setExtLogContentEntityForServerSystemLog(this.jCbxServerSystem.isSelected(), this.jCbxSSSevere.isSelected(), this.jCbxSSWarn.isSelected(), this.jCbxSSInfo.isSelected());
        externalLoggingObj.setExtLogContentEntityForServerAdminLog(this.jCbxServerAdmin.isSelected(), this.jCbxSASevere.isSelected(), this.jCbxSAWarn.isSelected(), this.jCbxSAInfo.isSelected());
        externalLoggingObj.setExtLogContentEntityForServerClientActivityLog(this.jCbxServerClient.isSelected());
        externalLoggingObj.setExtLogContentEntityForServerEnforcerActivityLog(this.jCbxServerEnforcer.isSelected());
        externalLoggingObj.setExtLogContentEntityForServerPolicyLog(this.jCbxServerPolicy.isSelected());
        externalLoggingObj.setExtLogContentEntityForAgentSecurityLog(this.jCbxAgentSecurity.isSelected(), this.jCbxACCritical.isSelected(), this.jCbxACMajor.isSelected(), this.jCbxACMinor.isSelected(), this.jCbxACInfo.isSelected());
        if (this.isFirewallPolicy) {
            externalLoggingObj.setExtLogContentEntityForAgentTrafficLog(this.jCbxAgentTraffic.isSelected(), this.jCbxATCritical.isSelected(), this.jCbxATMajor.isSelected(), this.jCbxATMinor.isSelected(), this.jCbxATInfo.isSelected());
        }
        if (this.isFirewallPolicy) {
            externalLoggingObj.setExtLogContentEntityForAgentPacketLog(this.jCbxAgentPacket.isSelected());
        }
        externalLoggingObj.setExtLogContentEntityForAgentSystemLog(this.jCbxAgentSystem.isSelected(), this.jCbxASFatal.isSelected(), this.jCbxASError.isSelected(), this.jCbxASWarn.isSelected(), this.jCbxASInfo.isSelected());
        if (!this.isSNAConly) {
            externalLoggingObj.setExtLogContentEntityForAgentBehaviorLog(this.jCbxAgentBehavior.isSelected(), this.jCbxABCritical.isSelected(), this.jCbxABMajor.isSelected(), this.jCbxABMinor.isSelected(), this.jCbxABInfo.isSelected());
            externalLoggingObj.setExtLogContentEntityForAgentScanLog(this.jCbxAgentScan.isSelected());
            externalLoggingObj.setExtLogContentEntityForAgentRiskLog(this.jCbxAgentRisk.isSelected());
            externalLoggingObj.setExtLogContentEntityForAgentProActDetectLog(this.jCbxAgentProActDetect.isSelected());
        }
        externalLoggingObj.setExtLogContentEntityForEnforcerSystemLog(this.jCbxEnforcerSystem.isSelected(), this.jCbxESFatal.isSelected(), this.jCbxESError.isSelected(), this.jCbxESWarn.isSelected(), this.jCbxESInfo.isSelected());
        externalLoggingObj.setExtLogContentEntityForEnforcerTrafficLog(this.jCbxEnforcerTraffic.isSelected());
        externalLoggingObj.setExtLogContentEntityForEnforcerClientActivityLog(this.jCbxEnforcerClient.isSelected());
    }

    public boolean validateInput() {
        if (this.jCbxServerAdmin.isSelected() && !this.jCbxSASevere.isSelected() && !this.jCbxSAWarn.isSelected() && !this.jCbxSAInfo.isSelected()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectSvrAdmLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        if (this.jCbxServerSystem.isSelected() && !this.jCbxSSSevere.isSelected() && !this.jCbxSSWarn.isSelected() && !this.jCbxSSInfo.isSelected()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectSysLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        if (!(!this.jCbxAgentSystem.isSelected() || this.jCbxASFatal.isSelected() || this.jCbxASError.isSelected() || this.jCbxASWarn.isSelected() || this.jCbxASInfo.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectAgtSysLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        if (!(!this.jCbxEnforcerSystem.isSelected() || this.jCbxESFatal.isSelected() || this.jCbxESError.isSelected() || this.jCbxESWarn.isSelected() || this.jCbxESInfo.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectEnforcerSysLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        if (!(!this.jCbxAgentSecurity.isSelected() || this.jCbxACCritical.isSelected() || this.jCbxACMajor.isSelected() || this.jCbxACMinor.isSelected() || this.jCbxACInfo.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectAgtSecLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        if (!(!this.jCbxAgentTraffic.isSelected() || this.jCbxATCritical.isSelected() || this.jCbxATMajor.isSelected() || this.jCbxATMinor.isSelected() || this.jCbxATInfo.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectAgtTraLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        if (!(!this.jCbxAgentBehavior.isSelected() || this.jCbxABCritical.isSelected() || this.jCbxABMajor.isSelected() || this.jCbxABMinor.isSelected() || this.jCbxABInfo.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.error.SelectAgtBehLogLevel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.Error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_external_log_filter";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(DESCRIPTION), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 10, 5), 0, 0));
        panel.add((Component)this.getServerLogPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.getAgentLogPanel(), new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getEnforcerLogPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        return panel;
    }

    private JPanel getServerLogPanel() {
        this.jCbxServerAdmin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.serverAdminEnabled();
            }
        });
        this.jCbxServerSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.serverSystemEnabled();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        this.addLog(panel, this.jCbxServerAdmin, this.jCbxSASevere, this.jCbxSAWarn, this.jCbxSAInfo, null, 0, 6);
        this.addLog(panel, this.jCbxServerClient, null, null, null, null, 2, 6);
        if (this.isSNACEnabled) {
            this.addLog(panel, this.jCbxServerEnforcer, null, null, null, null, 3, 6);
        }
        this.addLog(panel, this.jCbxServerPolicy, null, null, null, null, 4, 6);
        this.addLog(panel, this.jCbxServerSystem, this.jCbxSSSevere, this.jCbxSSWarn, this.jCbxSSInfo, null, 5, 6);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.SvrLogs")));
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private JPanel getAgentLogPanel() {
        this.jCbxAgentSecurity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.agentSecurityEnabled();
            }
        });
        this.jCbxAgentSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.agentSystemEnabled();
            }
        });
        this.jCbxAgentTraffic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.agentTrafficEnabled();
            }
        });
        this.jCbxAgentBehavior.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.agentBehaviorEnabled();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        this.addLog(panel, this.jCbxAgentSystem, this.jCbxASFatal, this.jCbxASError, this.jCbxASWarn, this.jCbxASInfo, 0, 11);
        this.addLog(panel, this.jCbxAgentSecurity, this.jCbxACCritical, this.jCbxACMajor, this.jCbxACMinor, this.jCbxACInfo, 2, 11);
        if (this.isFirewallPolicy) {
            this.addLog(panel, this.jCbxAgentTraffic, this.jCbxATCritical, this.jCbxATMajor, this.jCbxATMinor, this.jCbxATInfo, 4, 11);
            this.addLog(panel, this.jCbxAgentPacket, null, null, null, null, 6, 11);
        }
        if (!this.isSNAConly) {
            this.addLog(panel, this.jCbxAgentBehavior, this.jCbxABCritical, this.jCbxABMajor, this.jCbxABMinor, this.jCbxABInfo, 7, 11);
            this.addLog(panel, this.jCbxAgentScan, null, null, null, null, 9, 11);
            this.addLog(panel, this.jCbxAgentRisk, null, null, null, null, 10, 11);
            this.addLog(panel, this.jCbxAgentProActDetect, null, null, null, null, 11, 11);
        }
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.AgtLogs")));
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private JPanel getEnforcerLogPanel() {
        if (!this.isSNACEnabled) {
            return new JPanel();
        }
        this.jCbxEnforcerSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalLoggingLogFilterPanel.this.enforcerSystemEnabled();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        this.addLog(panel, this.jCbxEnforcerClient, null, null, null, null, 0, 3);
        this.addLog(panel, this.jCbxEnforcerSystem, this.jCbxESFatal, this.jCbxESError, this.jCbxESWarn, this.jCbxESInfo, 1, 3);
        this.addLog(panel, this.jCbxEnforcerTraffic, null, null, null, null, 3, 3);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingLogFilterPanel.title.EnforcerLogs")));
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private void addLog(JPanel panel, JCheckBox log, JCheckBox filter1, JCheckBox filter2, JCheckBox filter3, JCheckBox filter4, int y, int totalY) {
        int bottom = y == totalY ? 5 : 0;
        panel.add((Component)log, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, bottom, 0), 0, 0));
        int n = bottom = ++y == totalY ? 5 : 0;
        if (filter1 != null) {
            JPanel optPanel = new JPanel(new GridBagLayout());
            optPanel.add((Component)filter1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 18, 0, 0), 0, 0));
            optPanel.add((Component)filter2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            optPanel.add((Component)filter3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            if (filter4 != null) {
                optPanel.add((Component)filter4, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            }
            panel.add((Component)optPanel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, bottom, 0), 0, 0));
        }
    }

    private void serverAdminEnabled() {
        boolean isEnabled = this.jCbxServerAdmin.isSelected();
        this.jCbxSASevere.setEnabled(isEnabled);
        this.jCbxSAWarn.setEnabled(isEnabled);
        this.jCbxSAInfo.setEnabled(isEnabled);
    }

    private void serverSystemEnabled() {
        boolean isEnabled = this.jCbxServerSystem.isSelected();
        this.jCbxSSSevere.setEnabled(isEnabled);
        this.jCbxSSWarn.setEnabled(isEnabled);
        this.jCbxSSInfo.setEnabled(isEnabled);
    }

    private void agentSecurityEnabled() {
        boolean isEnabled = this.jCbxAgentSecurity.isSelected();
        this.jCbxACCritical.setEnabled(isEnabled);
        this.jCbxACMajor.setEnabled(isEnabled);
        this.jCbxACMinor.setEnabled(isEnabled);
        this.jCbxACInfo.setEnabled(isEnabled);
    }

    private void agentSystemEnabled() {
        boolean isEnabled = this.jCbxAgentSystem.isSelected();
        this.jCbxASFatal.setEnabled(isEnabled);
        this.jCbxASError.setEnabled(isEnabled);
        this.jCbxASWarn.setEnabled(isEnabled);
        this.jCbxASInfo.setEnabled(isEnabled);
    }

    private void agentTrafficEnabled() {
        if (this.isFirewallPolicy) {
            boolean isEnabled = this.jCbxAgentTraffic.isSelected();
            this.jCbxATCritical.setEnabled(isEnabled);
            this.jCbxATMajor.setEnabled(isEnabled);
            this.jCbxATMinor.setEnabled(isEnabled);
            this.jCbxATInfo.setEnabled(isEnabled);
        }
    }

    private void agentBehaviorEnabled() {
        boolean isEnabled = this.jCbxAgentBehavior.isSelected();
        this.jCbxABCritical.setEnabled(isEnabled);
        this.jCbxABMajor.setEnabled(isEnabled);
        this.jCbxABMinor.setEnabled(isEnabled);
        this.jCbxABInfo.setEnabled(isEnabled);
    }

    private void enforcerSystemEnabled() {
        boolean isEnabled = this.jCbxEnforcerSystem.isSelected();
        this.jCbxESFatal.setEnabled(isEnabled);
        this.jCbxESError.setEnabled(isEnabled);
        this.jCbxESWarn.setEnabled(isEnabled);
        this.jCbxESInfo.setEnabled(isEnabled);
    }

    private void selectLogCheckBox(boolean[] values, JCheckBox log, JCheckBox severity1, JCheckBox severity2, JCheckBox severity3, JCheckBox severity4) {
        log.setSelected(values[0]);
        severity1.setSelected(values[1]);
        severity2.setSelected(values[2]);
        severity3.setSelected(values[3]);
        if (severity4 != null) {
            severity4.setSelected(values[4]);
        }
    }

    private void setReadOnlyStatus() {
        this.jCbxServerAdmin.setEnabled(!this.readOnly);
        this.jCbxServerClient.setEnabled(!this.readOnly);
        this.jCbxServerEnforcer.setEnabled(!this.readOnly);
        this.jCbxServerPolicy.setEnabled(!this.readOnly);
        this.jCbxServerSystem.setEnabled(!this.readOnly);
        this.jCbxSSSevere.setEnabled(!this.readOnly);
        this.jCbxSSWarn.setEnabled(!this.readOnly);
        this.jCbxSSInfo.setEnabled(!this.readOnly);
        this.jCbxSASevere.setEnabled(!this.readOnly);
        this.jCbxSAWarn.setEnabled(!this.readOnly);
        this.jCbxSAInfo.setEnabled(!this.readOnly);
        this.jCbxAgentPacket.setEnabled(!this.readOnly);
        this.jCbxAgentSecurity.setEnabled(!this.readOnly);
        this.jCbxAgentSystem.setEnabled(!this.readOnly);
        this.jCbxAgentTraffic.setEnabled(!this.readOnly);
        this.jCbxAgentBehavior.setEnabled(!this.readOnly);
        this.jCbxAgentScan.setEnabled(!this.readOnly);
        this.jCbxAgentRisk.setEnabled(!this.readOnly);
        this.jCbxAgentProActDetect.setEnabled(!this.readOnly);
        this.jCbxACCritical.setEnabled(!this.readOnly);
        this.jCbxACMajor.setEnabled(!this.readOnly);
        this.jCbxACMinor.setEnabled(!this.readOnly);
        this.jCbxACInfo.setEnabled(!this.readOnly);
        this.jCbxASFatal.setEnabled(!this.readOnly);
        this.jCbxASError.setEnabled(!this.readOnly);
        this.jCbxASWarn.setEnabled(!this.readOnly);
        this.jCbxASInfo.setEnabled(!this.readOnly);
        this.jCbxATCritical.setEnabled(!this.readOnly);
        this.jCbxATMajor.setEnabled(!this.readOnly);
        this.jCbxATMinor.setEnabled(!this.readOnly);
        this.jCbxATInfo.setEnabled(!this.readOnly);
        this.jCbxABCritical.setEnabled(!this.readOnly);
        this.jCbxABMajor.setEnabled(!this.readOnly);
        this.jCbxABMinor.setEnabled(!this.readOnly);
        this.jCbxABInfo.setEnabled(!this.readOnly);
        this.jCbxEnforcerClient.setEnabled(!this.readOnly);
        this.jCbxEnforcerSystem.setEnabled(!this.readOnly);
        this.jCbxEnforcerTraffic.setEnabled(!this.readOnly);
        this.jCbxESFatal.setEnabled(!this.readOnly);
        this.jCbxESError.setEnabled(!this.readOnly);
        this.jCbxESWarn.setEnabled(!this.readOnly);
        this.jCbxESInfo.setEnabled(!this.readOnly);
    }
}

