/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.ExtLogFileEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalLoggingObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExternalLoggingGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1506709965320367631L;
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.DescSendLogs");
    private static final String[] UPDATE_FREQUENCY_STRING = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.30Sec"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.45Sec"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.1Min"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.10Min"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.14Min"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.30Min"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.combo.1Hr")};
    private static final int[] UPDATE_FREQUENCY = new int[]{30, 45, 60, 600, 900, 1800, 3600};
    private static final String[] PROTOCOL_STRING = new String[]{"UDP", "TCP", "TLS"};
    private static final String[] LINE_SEPARATOR_STRING = new String[]{"CR", "LF", "NULL"};
    private final JComboBox<String> jCmbUpdate = new JComboBox<String>(UPDATE_FREQUENCY_STRING);
    private final JComboBox<String> jCmbServer = new JComboBox();
    private final JComboBox<String> jCmbProtocol = new JComboBox<String>(PROTOCOL_STRING);
    private final JCheckBox jCbxSyslog = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.checkbox.EnableLogTx"));
    private final JLabel lblSysLogServer = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.SyslogSvr"));
    private final JLabel lblDestinationPort = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.DestPort"));
    private final JLabel lblLogFacility = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.LogFacility"));
    private final JLabel lblLogLineSeparator = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.LogLineSeparator"));
    private final JComboBox<String> jCmbLineSeparator = new JComboBox<String>(LINE_SEPARATOR_STRING);
    private final JTextField jTFServer = new JTextField();
    private final JTextField jTFPort = new JTextField();
    private final JTextField jTFFacilityNumber = new JTextField(new NumberPlainDocument(23L), "6", 5);
    private final JCheckBox jCbxEventLogger = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.checkbox.ExportLogsToFile"));
    private final JCheckBox jCbxDump = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.checkbox.LimitDump"));
    private final JTextField jTFServerSystem = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFServerAdmin = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFServerPolicy = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFServerEnforcer = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFServerClient = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentSecurity = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentTraffic = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentPacket = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentSystem = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentBehavior = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentScan = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentRisk = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFAgentProActDetect = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFEnforcerSystem = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFEnforcerClient = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JTextField jTFEnforcerTraffic = new JTextField(new NumberPlainDocument(Integer.MAX_VALUE, true), "", 5);
    private final JPanel jSyslogPanel = new JPanel(new GridBagLayout());
    private final JPanel jServerLogPanel = new JPanel(new GridBagLayout());
    private final JPanel jAgentLogPanel = new JPanel(new GridBagLayout());
    private final JPanel jEnforcerLogPanel = new JPanel(new GridBagLayout());
    private Hashtable<Integer, Object> tableExtLogFileEntityMaxLogSizes = new Hashtable();
    private int syslogServerPort = 0;
    private final boolean isEventLoggerEnabled;
    private final boolean isFirewallPolicy;
    private final boolean isSNACEnabled;
    private final boolean isSNAConly;
    private final boolean readOnly;
    public static final String PAGE_NAME = "externallogging";
    public static final String SYSLOG_PROTOCOL_NAME = UIUtilities.getName("externallogging", UIUtilities.ComponentType.COMBOBOX, "syslogprotocol");

    public ExternalLoggingGeneralPanel(boolean readOnly) {
        UIUtilities.setName(this.jCmbProtocol, SYSLOG_PROTOCOL_NAME);
        this.isEventLoggerEnabled = this.getEventLoggerEnability();
        LicenseObject license = LicenseObject.getInstance();
        this.isFirewallPolicy = license.isFirewallPolicy();
        this.isSNAConly = license.isSNACOnlyProduct();
        this.isSNACEnabled = license.isALLProduct() || this.isSNAConly;
        this.readOnly = readOnly;
        this.initialize();
    }

    public void updateModel(ExternalLoggingObject externalLoggingObj) {
        if (externalLoggingObj == null) {
            return;
        }
        int updateFrequency = UPDATE_FREQUENCY[this.jCmbUpdate.getSelectedIndex()];
        externalLoggingObj.setUpdateFrequency(updateFrequency);
        externalLoggingObj.setMasterLoggingServer(this.getMasterLoggingServer());
        String facilityNumber = this.jTFFacilityNumber.getText();
        boolean isFacilityNumberValid = facilityNumber != null && facilityNumber.trim().length() != 0;
        externalLoggingObj.setSyslog(this.jCbxSyslog.isSelected(), this.jTFServer.getText().trim(), PROTOCOL_STRING[this.jCmbProtocol.getSelectedIndex()], this.syslogServerPort, isFacilityNumberValid ? Integer.parseInt(facilityNumber.trim()) : 0);
        if (this.jCmbLineSeparator.getSelectedIndex() != -1 && this.jCmbLineSeparator.getSelectedIndex() <= LINE_SEPARATOR_STRING.length - 1) {
            externalLoggingObj.setSyslogServerLineSeparator(LINE_SEPARATOR_STRING[this.jCmbLineSeparator.getSelectedIndex()]);
        }
        externalLoggingObj.setExtLogFileDump(this.jCbxEventLogger.isSelected(), this.jCbxDump.isSelected());
        if (this.jCbxEventLogger.isSelected()) {
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_SCM_SYSTEM_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_SCM_SYSTEM_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_SCM_ADMIN_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_SCM_ADMIN_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_SCM_POLICY_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_SCM_POLICY_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_SCM_ENFORCER_ACT_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_SCM_ENFORCER_ACT_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_SCM_AGENT_ACT_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_SCM_AGENT_ACT_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_SYSTEM_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_SYSTEM_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_BEHAVIOR_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_BEHAVIOR_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_SECURITY_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_SECURITY_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_TRAFFIC_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_TRAFFIC_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_PACKET_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_PACKET_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_SCAN_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_SCAN_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_RISK_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_RISK_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_AGT_PROACTIVE_DETECT_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_AGT_PROACTIVE_DETECT_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_ENF_SYSTEM_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_ENF_SYSTEM_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_ENF_CLIENT_ACT_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_ENF_CLIENT_ACT_LOG));
            externalLoggingObj.setExtLogFileEntity(ExtLogFileEntity.LT_ENF_TRAFFIC_LOG, this.getExtLogFileEntityMaxLogSize(ExtLogFileEntity.LT_ENF_TRAFFIC_LOG));
        }
    }

    public boolean validateInput() {
        if (this.jCbxSyslog.isSelected()) {
            String syslogServerAddress = this.jTFServer.getText().trim();
            if (syslogServerAddress == null || syslogServerAddress.length() == 0 || !Utility.isValidIPAddressOrHostName((String)syslogServerAddress, (boolean)false)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.error.SyslogSvrAddr"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.title.Error"), 0);
                return false;
            }
            String syslogServerFacilityNumber = this.jTFFacilityNumber.getText().trim();
            if (syslogServerFacilityNumber == null || syslogServerFacilityNumber.length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.error.SyslogLogFacility"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.title.Error"), 0);
                return false;
            }
            if (!this.validateSyslogServerPort()) {
                return false;
            }
        }
        if (this.jCbxEventLogger.isSelected()) {
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFServerSystem, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SvrSysLog"), ExtLogFileEntity.LT_SCM_SYSTEM_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFServerAdmin, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SvrAdminLog"), ExtLogFileEntity.LT_SCM_ADMIN_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFServerPolicy, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SvrPolLog"), ExtLogFileEntity.LT_SCM_POLICY_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFServerEnforcer, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SvrEnforcerActivityLog"), ExtLogFileEntity.LT_SCM_ENFORCER_ACT_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFServerClient, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SvrClientActivityLog"), ExtLogFileEntity.LT_SCM_AGENT_ACT_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFAgentSystem, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtSysLog"), ExtLogFileEntity.LT_AGT_SYSTEM_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFAgentSecurity, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.42"), ExtLogFileEntity.LT_AGT_SECURITY_LOG)) {
                return false;
            }
            if (this.isFirewallPolicy && !this.validateExtLogFileEntityMaxLogSize(this.jTFAgentTraffic, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtTrafficLog"), ExtLogFileEntity.LT_AGT_TRAFFIC_LOG)) {
                return false;
            }
            if (this.isFirewallPolicy && !this.validateExtLogFileEntityMaxLogSize(this.jTFAgentPacket, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtPacketLog"), ExtLogFileEntity.LT_AGT_PACKET_LOG)) {
                return false;
            }
            if (!this.isSNAConly && !this.validateExtLogFileEntityMaxLogSize(this.jTFAgentBehavior, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtBehaviorLog"), ExtLogFileEntity.LT_AGT_BEHAVIOR_LOG)) {
                return false;
            }
            if (!this.isSNAConly && !this.validateExtLogFileEntityMaxLogSize(this.jTFAgentScan, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtScanLog"), ExtLogFileEntity.LT_AGT_SCAN_LOG)) {
                return false;
            }
            if (!this.isSNAConly && !this.validateExtLogFileEntityMaxLogSize(this.jTFAgentRisk, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtRiskLog"), ExtLogFileEntity.LT_AGT_RISK_LOG)) {
                return false;
            }
            if (!this.isSNAConly && !this.validateExtLogFileEntityMaxLogSize(this.jTFAgentProActDetect, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtProActLog"), ExtLogFileEntity.LT_AGT_PROACTIVE_DETECT_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFEnforcerSystem, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerSysLog"), ExtLogFileEntity.LT_ENF_SYSTEM_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFEnforcerClient, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerClientActivityLog"), ExtLogFileEntity.LT_ENF_CLIENT_ACT_LOG)) {
                return false;
            }
            if (!this.validateExtLogFileEntityMaxLogSize(this.jTFEnforcerTraffic, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerTrafficLog"), ExtLogFileEntity.LT_ENF_TRAFFIC_LOG)) {
                return false;
            }
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        this.jCbxSyslog.setFont(this.jCbxSyslog.getFont().deriveFont(1));
        this.jCbxSyslog.addActionListener(e -> this.syslogEnabled());
        this.jCbxEventLogger.setFont(this.jCbxSyslog.getFont().deriveFont(1));
        this.jCbxEventLogger.addActionListener(e -> this.eventLoggingEnabled());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(DESCRIPTION), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 10, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.UpdateFreq")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 0, 0), 0, 0));
        panel.add(this.jCmbUpdate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.PrimaryLogSvr")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 50, 0, 0), 0, 0));
        panel.add(this.jCmbServer, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.jCbxSyslog, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
        panel.add((Component)this.getSysLogPanel(), new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.jCbxEventLogger, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
        panel.add((Component)this.getEventLoggingPanel(), new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 5, 5), 0, 0));
        this.alignEventLogTextFields();
        return panel;
    }

    private JPanel getSysLogPanel() {
        this.jSyslogPanel.setBorder(BorderFactory.createTitledBorder(" "));
        this.jTFPort.setEditable(true);
        this.jSyslogPanel.add((Component)this.lblSysLogServer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.jSyslogPanel.add((Component)this.lblDestinationPort, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.jSyslogPanel.add((Component)this.jTFServer, new GridBagConstraints(1, 0, 8, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.jSyslogPanel.add(this.jCmbProtocol, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jCmbProtocol.addActionListener(e -> {
            switch (this.jCmbProtocol.getSelectedIndex()) {
                case 1: {
                    this.jTFPort.setText("1468");
                    break;
                }
                case 2: {
                    this.jTFPort.setText("6514");
                    break;
                }
                default: {
                    this.jTFPort.setText("514");
                }
            }
        });
        this.jSyslogPanel.add((Component)this.jTFPort, new GridBagConstraints(2, 1, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jSyslogPanel.add((Component)this.lblLogFacility, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.jSyslogPanel.add((Component)this.jTFFacilityNumber, new GridBagConstraints(1, 2, 8, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jSyslogPanel.add((Component)this.lblLogLineSeparator, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.jSyslogPanel.add(this.jCmbLineSeparator, new GridBagConstraints(1, 3, 8, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return this.jSyslogPanel;
    }

    private JPanel getEventLoggingPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" "));
        panel.add((Component)this.jCbxDump, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.getServerLogPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.getAgentLogPanel(), new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.getEnforcerLogPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.jCbxDump.addActionListener(e -> this.eventLoggingEnabled());
        return panel;
    }

    private JPanel getServerLogPanel() {
        int i = 0;
        this.jServerLogPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.SvrLogs")));
        this.addLog(this.jServerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AdminLogLim"), this.jTFServerAdmin, i++, 4);
        this.addLog(this.jServerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.ClientLogLim"), this.jTFServerClient, i++, 4);
        if (this.isSNACEnabled) {
            this.addLog(this.jServerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerLogLim"), this.jTFServerEnforcer, i++, 4);
        }
        this.addLog(this.jServerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.PolLogLim"), this.jTFServerPolicy, i++, 4);
        this.addLog(this.jServerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SysLogLim"), this.jTFServerSystem, i++, 4);
        return this.jServerLogPanel;
    }

    private JPanel getAgentLogPanel() {
        this.jAgentLogPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtLogs")));
        this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.AgtSysLogLim"), this.jTFAgentSystem, 0, 7);
        this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.SecLogLim"), this.jTFAgentSecurity, 1, 7);
        if (this.isFirewallPolicy) {
            this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.TrafficLogLim"), this.jTFAgentTraffic, 2, 7);
            this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.PacketLogLim"), this.jTFAgentPacket, 3, 7);
        }
        if (!this.isSNAConly) {
            this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.BehaviorLogLim"), this.jTFAgentBehavior, 4, 7);
            this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.ScanLogLim"), this.jTFAgentScan, 5, 7);
            this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.RiskLogLim"), this.jTFAgentRisk, 6, 7);
            this.addLog(this.jAgentLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.ProActDetectLim"), this.jTFAgentProActDetect, 7, 7);
        }
        return this.jAgentLogPanel;
    }

    private JPanel getEnforcerLogPanel() {
        if (!this.isSNACEnabled) {
            return new JPanel();
        }
        this.jEnforcerLogPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerLogs")));
        this.addLog(this.jEnforcerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerClientLogLim"), this.jTFEnforcerClient, 0, 2);
        this.addLog(this.jEnforcerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerServerLogLim"), this.jTFEnforcerSystem, 1, 2);
        this.addLog(this.jEnforcerLogPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.EnforcerTrafficLogLim"), this.jTFEnforcerTraffic, 2, 2);
        return this.jEnforcerLogPanel;
    }

    private void addLog(JPanel panel, String label, JTextField log, int yvalue, int totalY) {
        int top = yvalue == 0 ? 0 : 5;
        int bottom = yvalue == totalY ? 5 : 0;
        panel.add((Component)new JLabel(label), new GridBagConstraints(0, yvalue, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 5, bottom, 0), 0, 0));
        panel.add((Component)log, new GridBagConstraints(1, yvalue, 1, 1, 1.0, 0.0, 13, 0, new Insets(top, 0, bottom, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.label.Records")), new GridBagConstraints(2, yvalue, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 3, bottom, 5), 0, 0));
    }

    private void alignEventLogTextFields() {
        this.jTFServerSystem.setHorizontalAlignment(4);
        this.jTFServerAdmin.setHorizontalAlignment(4);
        this.jTFServerPolicy.setHorizontalAlignment(4);
        this.jTFServerEnforcer.setHorizontalAlignment(4);
        this.jTFServerClient.setHorizontalAlignment(4);
        this.jTFAgentSecurity.setHorizontalAlignment(4);
        this.jTFAgentTraffic.setHorizontalAlignment(4);
        this.jTFAgentPacket.setHorizontalAlignment(4);
        this.jTFAgentSystem.setHorizontalAlignment(4);
        this.jTFAgentBehavior.setHorizontalAlignment(4);
        this.jTFAgentScan.setHorizontalAlignment(4);
        this.jTFAgentRisk.setHorizontalAlignment(4);
        this.jTFAgentProActDetect.setHorizontalAlignment(4);
        this.jTFEnforcerSystem.setHorizontalAlignment(4);
        this.jTFEnforcerClient.setHorizontalAlignment(4);
        this.jTFEnforcerTraffic.setHorizontalAlignment(4);
    }

    private boolean getEventLoggerEnability() {
        try {
            return LicenseObject.getInstance().isExternalLogging();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
    }

    private void syslogEnabled() {
        boolean isSyslog = this.jCbxSyslog.isSelected();
        for (int i = 0; i < this.jSyslogPanel.getComponentCount(); ++i) {
            this.jSyslogPanel.getComponent(i).setEnabled(isSyslog);
        }
    }

    private void eventLoggingEnabled() {
        int i;
        boolean isDumpEnabled = this.jCbxEventLogger.isSelected();
        this.jCbxDump.setEnabled(isDumpEnabled);
        boolean isEnabled = isDumpEnabled && this.jCbxDump.isEnabled() && this.jCbxDump.isSelected();
        for (i = 0; i < this.jServerLogPanel.getComponentCount(); ++i) {
            this.jServerLogPanel.getComponent(i).setEnabled(isEnabled);
        }
        for (i = 0; i < this.jAgentLogPanel.getComponentCount(); ++i) {
            this.jAgentLogPanel.getComponent(i).setEnabled(isEnabled);
        }
        if (this.isSNACEnabled) {
            for (i = 0; i < this.jEnforcerLogPanel.getComponentCount(); ++i) {
                this.jEnforcerLogPanel.getComponent(i).setEnabled(isEnabled);
            }
        }
    }

    private void initExtLogFileEntityMaxLogSize(JTextField tf, Integer logType, Vector<ExtLogFileEntity> extLogFileEntities) {
        if (extLogFileEntities == null) {
            tf.setText(String.valueOf(1000));
            return;
        }
        tf.setText(String.valueOf(ExternalLoggingObject.getExtLogFileEntityMaxLogSize(extLogFileEntities, logType)));
    }

    private Integer getExtLogFileEntityMaxLogSize(Integer logType) {
        Object o = this.tableExtLogFileEntityMaxLogSizes.get(logType);
        if (o == null) {
            return 1000;
        }
        return (Integer)o;
    }

    private boolean validateExtLogFileEntityMaxLogSize(JTextField tf, String logName, Integer logType) {
        int value = Integer.parseInt(tf.getText().trim());
        if (value < 10) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.error.MaxLogSize"), logName, 10, Integer.MAX_VALUE), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.title.Error"), 0);
            return false;
        }
        this.tableExtLogFileEntityMaxLogSizes.put(logType, value);
        return true;
    }

    private void initMasterLoggingServer(SiteObject siteObj) throws ConsoleException {
        if (siteObj == null) {
            return;
        }
        ArrayList<String> listServerNames = ServerHandler.getServerNameList(siteObj.getSemSite());
        if (listServerNames == null) {
            return;
        }
        for (int i = 0; i < listServerNames.size(); ++i) {
            this.jCmbServer.addItem(listServerNames.get(i));
        }
    }

    private String getMasterLoggingServer() {
        Object o = this.jCmbServer.getSelectedItem();
        if (o == null || !(o instanceof String)) {
            return "";
        }
        return (String)o;
    }

    private void setSelectedUpdateFrequency(int seconds) {
        for (int i = 0; i < UPDATE_FREQUENCY.length; ++i) {
            if (UPDATE_FREQUENCY[i] != seconds) continue;
            this.jCmbUpdate.setSelectedIndex(i);
            break;
        }
        if (this.jCmbUpdate.getSelectedIndex() < 0) {
            this.jCmbUpdate.setSelectedIndex(0);
        }
    }

    private boolean validateSyslogServerPort() {
        String o = this.jTFPort.getText();
        try {
            this.syslogServerPort = Integer.parseInt(o);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.error.SyslogSvrPort"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.title.Error"), 0);
            return false;
        }
        if (this.syslogServerPort > 65535 || this.syslogServerPort < 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.error.SyslogSvrPortRange"), 0, 65535), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ExternalLoggingGeneralPanel.title.Error"), 0);
            return false;
        }
        return true;
    }

    private void setReadOnlyStatus() {
        if (this.readOnly) {
            this.jCmbUpdate.setEnabled(!this.readOnly);
            this.jCmbServer.setEnabled(!this.readOnly);
            this.jCmbProtocol.setEnabled(!this.readOnly);
            this.jCbxSyslog.setEnabled(!this.readOnly);
            this.jTFServer.setEnabled(!this.readOnly);
            this.jTFPort.setEnabled(!this.readOnly);
            this.jTFFacilityNumber.setEnabled(!this.readOnly);
            this.jCmbLineSeparator.setEnabled(!this.readOnly);
            this.jCbxEventLogger.setEnabled(!this.readOnly);
            this.jCbxDump.setEnabled(!this.readOnly);
            this.jTFServerSystem.setEnabled(!this.readOnly);
            this.jTFServerAdmin.setEnabled(!this.readOnly);
            this.jTFServerPolicy.setEnabled(!this.readOnly);
            this.jTFServerEnforcer.setEnabled(!this.readOnly);
            this.jTFServerClient.setEnabled(!this.readOnly);
            this.jTFAgentSecurity.setEnabled(!this.readOnly);
            this.jTFAgentTraffic.setEnabled(!this.readOnly);
            this.jTFAgentPacket.setEnabled(!this.readOnly);
            this.jTFAgentSystem.setEnabled(!this.readOnly);
            this.jTFAgentBehavior.setEnabled(!this.readOnly);
            this.jTFAgentScan.setEnabled(!this.readOnly);
            this.jTFAgentRisk.setEnabled(!this.readOnly);
            this.jTFAgentProActDetect.setEnabled(!this.readOnly);
            this.jTFEnforcerSystem.setEnabled(!this.readOnly);
            this.jTFEnforcerClient.setEnabled(!this.readOnly);
            this.jTFEnforcerTraffic.setEnabled(!this.readOnly);
        }
    }

    public void setModel(SiteObject siteObj) throws ConsoleException {
        ExternalLoggingObject externalLoggingObj = new ExternalLoggingObject(siteObj.getExternalLogging());
        this.jTFPort.setText("514");
        this.initMasterLoggingServer(siteObj);
        int seconds = externalLoggingObj.getUpdateFrequency();
        this.setSelectedUpdateFrequency(seconds);
        String masterLoggingServer = externalLoggingObj.getMasterLoggingServer();
        if (masterLoggingServer != null && masterLoggingServer.length() > 0) {
            this.jCmbServer.setSelectedItem(masterLoggingServer);
        }
        this.jCbxSyslog.setSelected(externalLoggingObj.isSyslogServerEnabled());
        this.jCbxSyslog.setEnabled(this.isEventLoggerEnabled || this.jCbxSyslog.isSelected());
        this.jTFServer.setText(externalLoggingObj.getSyslogServerAddress());
        this.jCmbProtocol.setSelectedItem(externalLoggingObj.getSyslogServerPotocolDisplayString());
        this.jTFPort.setText("" + externalLoggingObj.getSyslogServerPort());
        if (externalLoggingObj.getSyslogServerFacilityNumber() != 6) {
            this.jTFFacilityNumber.setText("" + externalLoggingObj.getSyslogServerFacilityNumber());
        }
        this.jCmbLineSeparator.setSelectedItem(externalLoggingObj.getSyslogServerLineSeparatorlDisplayString());
        this.jCbxEventLogger.setSelected(externalLoggingObj.isExtLogFileDumpEnabled());
        this.jCbxEventLogger.setEnabled(this.isEventLoggerEnabled || this.jCbxEventLogger.isSelected());
        this.jCbxDump.setSelected(externalLoggingObj.isLimitDumpFileRecords());
        Vector<ExtLogFileEntity> extLogFileEntities = externalLoggingObj.getExtLogFileEntities();
        this.initExtLogFileEntityMaxLogSize(this.jTFServerSystem, ExtLogFileEntity.LT_SCM_SYSTEM_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFServerAdmin, ExtLogFileEntity.LT_SCM_ADMIN_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFServerPolicy, ExtLogFileEntity.LT_SCM_POLICY_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFServerEnforcer, ExtLogFileEntity.LT_SCM_ENFORCER_ACT_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFServerClient, ExtLogFileEntity.LT_SCM_AGENT_ACT_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFAgentSystem, ExtLogFileEntity.LT_AGT_SYSTEM_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFAgentSecurity, ExtLogFileEntity.LT_AGT_SECURITY_LOG, extLogFileEntities);
        if (this.isFirewallPolicy) {
            this.initExtLogFileEntityMaxLogSize(this.jTFAgentTraffic, ExtLogFileEntity.LT_AGT_TRAFFIC_LOG, extLogFileEntities);
        }
        if (this.isFirewallPolicy) {
            this.initExtLogFileEntityMaxLogSize(this.jTFAgentPacket, ExtLogFileEntity.LT_AGT_PACKET_LOG, extLogFileEntities);
        }
        if (!this.isSNAConly) {
            this.initExtLogFileEntityMaxLogSize(this.jTFAgentBehavior, ExtLogFileEntity.LT_AGT_BEHAVIOR_LOG, extLogFileEntities);
            this.initExtLogFileEntityMaxLogSize(this.jTFAgentScan, ExtLogFileEntity.LT_AGT_SCAN_LOG, extLogFileEntities);
            this.initExtLogFileEntityMaxLogSize(this.jTFAgentRisk, ExtLogFileEntity.LT_AGT_RISK_LOG, extLogFileEntities);
            this.initExtLogFileEntityMaxLogSize(this.jTFAgentProActDetect, ExtLogFileEntity.LT_AGT_PROACTIVE_DETECT_LOG, extLogFileEntities);
        }
        this.initExtLogFileEntityMaxLogSize(this.jTFEnforcerSystem, ExtLogFileEntity.LT_ENF_SYSTEM_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFEnforcerClient, ExtLogFileEntity.LT_ENF_CLIENT_ACT_LOG, extLogFileEntities);
        this.initExtLogFileEntityMaxLogSize(this.jTFEnforcerTraffic, ExtLogFileEntity.LT_ENF_TRAFFIC_LOG, extLogFileEntities);
        this.syslogEnabled();
        this.eventLoggingEnabled();
        this.setReadOnlyStatus();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_external_log_general";
    }
}

