/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.DirectoryServerIntegration;
import com.sygate.scm.common.configobject.schema.ReplicationDirectoryServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DirectoryServerDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int TAB_PANEL_PREFERRED_WIDTH = 360;
    private static final int TAB_PANEL_PREFERRED_HEIGHT = 365;
    private final DirectoryServer model;
    private final DirectoryServerIntegration directoryServerIntegration;
    private final boolean isNew;
    GeneralPanel generalPanel;
    private ReplicationPanel replicationPanel;
    private JTabbedPane tabbedPane;
    private final boolean forReplicationDirServer;
    private List<DirectoryServer> replicationDirServerList = null;

    public DirectoryServerDialog(DirectoryServer server, List<DirectoryServer> replicationDirServerList) {
        this(server, null, true, replicationDirServerList, false);
    }

    public DirectoryServerDialog(DirectoryServer server, DirectoryServerIntegration directoryServerIntegration) {
        this(server, directoryServerIntegration, false, null, true);
    }

    private DirectoryServerDialog(DirectoryServer server, DirectoryServerIntegration directoryServerIntegration, boolean forReplicationDirServer, List<DirectoryServer> replicationDirServerList, boolean hasHelp) {
        super(Manager.getFrame(), hasHelp ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.addDirectoryServer") : (server == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.addReplicationServer") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.editReplicationServer")), true, hasHelp);
        this.directoryServerIntegration = directoryServerIntegration;
        this.forReplicationDirServer = forReplicationDirServer;
        this.replicationDirServerList = replicationDirServerList;
        boolean bl = this.isNew = server == null;
        if (this.isNew) {
            server = new DirectoryServer();
            GUIDGenerator guidgen = GUIDGenerator.getInstance();
            server.setOptGuid(guidgen.getGUIDString());
            if (forReplicationDirServer) {
                server.setName("Replication Server" + guidgen.getGUIDString());
                server.setType(DirectoryServer.LDAP);
            }
        }
        this.model = server;
        this.createGUI();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    void updateDirectoryServer() {
        this.generalPanel.updateModel();
        if (!this.forReplicationDirServer) {
            this.replicationPanel.updateModel();
        }
    }

    DirectoryServer getDirectoryServer() {
        return this.model;
    }

    public static boolean shouldCertWarningEnable(boolean useSsl, boolean disCertValidate) {
        return useSsl && disCertValidate;
    }

    @Override
    protected boolean ok() {
        boolean hasValidData = this.generalPanel.validateData();
        if (!hasValidData && this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(0);
        }
        if (hasValidData && !this.forReplicationDirServer && !(hasValidData = this.replicationPanel.validateData()) && this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(1);
        }
        return hasValidData;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (!this.forReplicationDirServer) {
            Component component = this.tabbedPane.getSelectedComponent();
            Component childComp = ((JScrollPane)component).getViewport().getView();
            return ((ContentSensitiveHelpPage)((Object)childComp)).getContentSensitiveHelpToken();
        }
        return this.generalPanel.getContentSensitiveHelpToken();
    }

    private void createGUI() {
        this.generalPanel = new GeneralPanel();
        if (!this.forReplicationDirServer) {
            this.replicationPanel = new ReplicationPanel(this.model);
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.generalPanel), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.tab.general"));
            this.tabbedPane.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.replicationPanel), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.tab.replication"));
            this.tabbedPane.setPreferredSize(new Dimension(360, 365));
            this.getContentPane().add((Component)this.tabbedPane, "Center");
        } else {
            this.getContentPane().add((Component)this.generalPanel, "Center");
        }
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        Dimension size = this.getPreferredSize();
        this.setSize(new Dimension(size.width + 150, size.height + 50));
    }

    private static class ReplicationPanel
    extends JPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;
        private JButton jBAdd;
        private JButton jBEdit;
        private JButton jBDelete;
        private JList<DirectoryServer> repDirList;
        private DefaultListModel<DirectoryServer> repDirListModel;
        private final DirectoryServer mainServer;

        ReplicationPanel(DirectoryServer mainServer) {
            this.mainServer = mainServer;
            this.createGUI();
            this.updateGUI();
        }

        void updateModel() {
            ReplicationDirectoryServer repServer = this.mainServer.getOptReplicationDirectoryServer();
            int count = this.repDirListModel.size();
            if (repServer == null && count > 0) {
                repServer = new ReplicationDirectoryServer();
                this.mainServer.setOptReplicationDirectoryServer(repServer);
            }
            if (repServer != null) {
                for (DirectoryServer directoryServer : repServer.getDirectoryServer()) {
                    repServer.removeDirectoryServer(directoryServer);
                }
            }
            for (int index = 0; index < count; ++index) {
                repServer.addDirectoryServer(this.repDirListModel.get(index));
            }
        }

        boolean validateData() {
            return true;
        }

        private void createGUI() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.title.replicationDirSvrs")));
            this.repDirListModel = new DefaultListModel();
            this.repDirList = new JList<DirectoryServer>(this.repDirListModel);
            this.repDirList.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    DirectoryServer server = (DirectoryServer)value;
                    label.setText(server.getServerAddress());
                    return label;
                }
            });
            this.repDirList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    this.showPopup(event);
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    this.showPopup(event);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        this.edit();
                    }
                }
            });
            this.repDirList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.listSelectionChanged();
                }
            });
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, this.repDirList);
            this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void updateGUI() {
            ReplicationDirectoryServer repServer = this.mainServer.getOptReplicationDirectoryServer();
            if (repServer != null) {
                for (DirectoryServer directoryServer : repServer.getDirectoryServer()) {
                    this.repDirListModel.addElement(directoryServer);
                }
            }
            this.listSelectionChanged();
        }

        private JPanel getButtonPanel() {
            this.jBAdd = new JButton(UIText.get(5));
            this.jBEdit = new JButton(UIText.get(1024));
            this.jBDelete = new JButton(UIText.get(769));
            this.jBAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.add();
                }
            });
            this.jBEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.edit();
                }
            });
            this.jBDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.delete();
                }
            });
            JPanel panel = new JPanel();
            UIUtilities.layoutButtonPanel(panel, new JButton[]{this.jBAdd, this.jBEdit, this.jBDelete}, 1, 1, true);
            return panel;
        }

        private List<DirectoryServer> getDirectoryServerList(DirectoryServer exception) {
            ArrayList<DirectoryServer> list = new ArrayList<DirectoryServer>();
            Enumeration elments = (Enumeration)Cast.cast(this.repDirListModel.elements());
            while (elments.hasMoreElements()) {
                DirectoryServer e = (DirectoryServer)elments.nextElement();
                if (e == exception) continue;
                list.add(e);
            }
            return list;
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_server_properties_directory_servers_add";
        }

        private void add() {
            DirectoryServerDialog dialog = new DirectoryServerDialog(null, this.getDirectoryServerList(null));
            if (dialog.isOk()) {
                DirectoryServer server = dialog.getDirectoryServer();
                dialog.updateDirectoryServer();
                this.repDirListModel.addElement(server);
            }
            dialog.dispose();
        }

        private void edit() {
            int selectedRow = this.repDirList.getSelectedIndex();
            if (selectedRow == -1) {
                return;
            }
            DirectoryServer server = this.repDirListModel.getElementAt(selectedRow);
            if (server == null) {
                return;
            }
            DirectoryServerDialog dialog = new DirectoryServerDialog(server, this.getDirectoryServerList(server));
            if (dialog.isOk()) {
                dialog.updateDirectoryServer();
            }
            dialog.dispose();
        }

        private void delete() {
            int selectedRow = this.repDirList.getSelectedIndex();
            if (selectedRow == -1) {
                return;
            }
            DirectoryServer server = this.repDirListModel.get(selectedRow);
            if (server == null) {
                return;
            }
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.confirmDelDirSvr"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.title.confirmDel"), 0)) {
                return;
            }
            this.repDirListModel.remove(selectedRow);
        }

        private void showPopup(MouseEvent event) {
            int row = this.repDirList.locationToIndex(event.getPoint());
            if (row != -1) {
                this.repDirList.setSelectedIndex(row);
            }
            if (event.isPopupTrigger()) {
                this.getPopupMenu().show(event.getComponent(), event.getX(), event.getY());
            }
        }

        private JPopupMenu getPopupMenu() {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem addMenu = new JMenuItem(UIText.get(5));
            addMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.add();
                }
            });
            JMenuItem editMenu = new JMenuItem(UIText.get(1024));
            editMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.edit();
                }
            });
            JMenuItem deleteMenu = new JMenuItem(UIText.get(769));
            deleteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.delete();
                }
            });
            popupMenu.add(addMenu);
            popupMenu.add(editMenu);
            popupMenu.add(deleteMenu);
            boolean isEnabled = this.repDirList.getSelectedIndex() != -1;
            editMenu.setEnabled(isEnabled);
            deleteMenu.setEnabled(isEnabled);
            return popupMenu;
        }

        private void listSelectionChanged() {
            boolean isEnabled = this.repDirList.getSelectedIndex() != -1;
            this.jBEdit.setEnabled(isEnabled);
            this.jBDelete.setEnabled(isEnabled);
        }
    }

    class GeneralPanel
    extends JPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;
        private static final String INVALID_COMPUTER_NAME_CHARACTERS = "/\\[]\";|<>+=,?* _";
        private static final String DEFAULT_PORT = "389";
        private static final String DEFAULT_PORT_SSL = "636";
        private JTextField jTFName;
        private Box jBReason;
        private JTextField jTFIpName;
        private JTextField jTFPort;
        private JTextField jTFBaseDN;
        private JTextField jTFUser;
        private JPasswordField jPFWord;
        private String currPassword;
        private JLabel jLPort;
        private JLabel jLBaseDN;
        private JRadioButton jRBAd;
        private JRadioButton jRBLdap;
        private JCheckBox jCBSsl;
        private JCheckBox jCBDisableCertValidation;
        protected final JLabel disableCertValidationWarningIcon = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconWarning.png"))));
        protected final JTextArea disableCertValidationWarningText = new JTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.ckbox.disableCertValidate.warning"));
        private boolean passwordChanged = false;

        GeneralPanel() {
            this.createGUI();
            this.updateGUI();
        }

        void updateModel() {
            DirectoryServerDialog.this.model.setServerAddress(this.jTFIpName.getText().trim());
            if (!DirectoryServerDialog.this.forReplicationDirServer) {
                DirectoryServerDialog.this.model.setName(this.jTFName.getText().trim());
                DirectoryServerDialog.this.model.setOptUsername(this.jTFUser.getText().trim());
                if (DirectoryServerDialog.this.isNew) {
                    DirectoryServerDialog.this.model.setOptPassword(new String(this.jPFWord.getPassword()));
                } else if (this.passwordChanged) {
                    DirectoryServerDialog.this.model.setOptPassword(new String(this.jPFWord.getPassword()));
                } else {
                    DirectoryServerDialog.this.model.setOptPassword(this.currPassword);
                }
                DirectoryServerDialog.this.model.setType(this.jRBLdap.isSelected() ? DirectoryServer.LDAP : DirectoryServer.ADDC);
                DirectoryServerDialog.this.model.setOptPort(this.getPort());
                DirectoryServerDialog.this.model.setOptBaseDN(this.getBaseDN(true));
                DirectoryServerDialog.this.model.setOptUseSSL(Boolean.valueOf(this.useSSL()));
                DirectoryServerDialog.this.model.setOptDisableCertValidate(Boolean.valueOf(this.disableCertValidation()));
            }
        }

        boolean validateData() {
            String serverIpOrName;
            DirectoryServer tempServer = null;
            if (!DirectoryServerDialog.this.forReplicationDirServer) {
                String name = this.jTFName.getText().trim();
                if (name.length() == 0) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.pleaseProvideValidName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.error"), 0);
                    this.jTFName.requestFocus();
                    return false;
                }
                if (!DirectoryServerDialog.this.validateInputFullCheck(name)) {
                    this.jTFName.requestFocus();
                    return false;
                }
                tempServer = this.getDirectoryServerByName(name);
                if (!(tempServer == null || DirectoryServerDialog.this.model != null && tempServer.getI().equals(DirectoryServerDialog.this.model.getI()))) {
                    Object[] obj = new Object[]{name};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.directoryServerIsAlreadyInUse");
                    String fm = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.error"), 0);
                    this.jTFName.selectAll();
                    this.jTFName.requestFocus();
                    return false;
                }
            }
            if ((serverIpOrName = this.jTFIpName.getText().trim()).length() == 0 || !Utility.isValidIPAddressOrHostName((String)serverIpOrName, (boolean)false)) {
                String errorMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.pleaseEnterValidServerIP");
                String errorTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.error");
                JOptionPane.showMessageDialog(this, errorMsg, errorTitle, 0);
                this.jTFIpName.requestFocus();
                return false;
            }
            if (DirectoryServerDialog.this.forReplicationDirServer && DirectoryServerDialog.this.replicationDirServerList != null) {
                boolean isAlreadyInUse = false;
                for (DirectoryServer server : DirectoryServerDialog.this.replicationDirServerList) {
                    if (!server.getServerAddress().equals(serverIpOrName)) continue;
                    isAlreadyInUse = true;
                    break;
                }
                if (isAlreadyInUse) {
                    String errorMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.theDirectoryServerInformationIsAlreadyInUse");
                    String errorTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.error");
                    JOptionPane.showMessageDialog(this, errorMsg, errorTitle, 0);
                    this.jTFIpName.selectAll();
                    this.jTFIpName.requestFocus();
                    return false;
                }
            }
            if (!DirectoryServerDialog.this.forReplicationDirServer) {
                final String userName = this.jTFUser.getText().trim();
                char[] pwd = this.jPFWord.getPassword();
                String password = new String(pwd);
                if ((userName.length() == 0 || pwd.length == 0) && 0 == JOptionPane.showConfirmDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.userNameAndPasswordAreEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.warning"), 0)) {
                    if (userName.length() == 0) {
                        this.jTFUser.requestFocus();
                    } else {
                        this.jPFWord.requestFocus();
                    }
                    return false;
                }
                if (!DirectoryServerDialog.this.isNew) {
                    int result;
                    if (!password.equals("********") && (result = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.confirmPasswordChangeMessage"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerEMailPanel.confirmPasswordChangeTitle"), 0)) == 0) {
                        this.passwordChanged = true;
                        this.currPassword = password;
                    }
                } else {
                    this.currPassword = password;
                }
                final boolean useSsl = DirectoryServerDialog.this.generalPanel.useSSL();
                tempServer = this.getDirectoryServerByLdapInfo(serverIpOrName, this.getPort(), this.getBaseDN(true), this.jTFUser.getText().trim());
                if (!(tempServer == null || DirectoryServerDialog.this.model != null && tempServer.getI().equals(DirectoryServerDialog.this.model.getI()))) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.theDirectoryServerInformationIsAlreadyInUse"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.error"), 0);
                    this.jTFIpName.selectAll();
                    this.jTFIpName.requestFocus();
                    return false;
                }
                SwingWorker worker = new SwingWorker(){
                    private final String title;
                    private final String message;
                    private final SimpleProgressDlg dlg;
                    private ConsoleException consoleEx;
                    {
                        this.title = DirectoryServerDialog.this.isNew ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.addingDirectoryServer") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.editingDirectoryServer");
                        this.message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.message");
                        this.dlg = new SimpleProgressDlg((Frame)Manager.getFrame(), this.title, this.message, true);
                    }

                    public Object construct() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dlg.setCursor(Cursor.getPredefinedCursor(3));
                                dlg.setVisible(true);
                            }
                        });
                        try {
                            int ldapType = GeneralPanel.this.jRBLdap.isSelected() ? DirectoryServer.LDAP : DirectoryServer.ADDC;
                            String baseDN = GeneralPanel.this.jRBLdap.isSelected() ? GeneralPanel.this.jTFBaseDN.getText().trim() : null;
                            String port = GeneralPanel.this.jTFPort.getText().trim();
                            GUIManager.testDirectoryServerConnection(serverIpOrName, port, baseDN, userName, GeneralPanel.this.currPassword, ldapType, useSsl, DirectoryServerDialog.this.generalPanel.disableCertValidation());
                        }
                        catch (ConsoleException e) {
                            this.consoleEx = e;
                        }
                        return null;
                    }

                    public void finished() {
                        this.dlg.dispose();
                        if (DataobjectManager.getInstance().getLoginInformation() == null) {
                            DirectoryServerDialog.this.setVisible(false);
                            return;
                        }
                        if (this.consoleEx != null) {
                            AjaxSwingManager.endOperation((boolean)true);
                            if (this.consoleEx.needRelogin()) {
                                JOptionPane.showMessageDialog(Manager.getFrame(), this.consoleEx.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.consoleError"), 0);
                                Manager.getFrame().showLoginPanel();
                                return;
                            }
                            Object[] obj = new Object[]{this.consoleEx.getMessage(), DirectoryServerDialog.this.isNew ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.add") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.update")};
                            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.theServerFailedToConnect");
                            String fm = MessageFormat.format(str, obj);
                            AjaxSwingManager.endOperation((boolean)true);
                            int option = JOptionPane.showConfirmDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.msg.warning"), 1);
                            if (option == 2) {
                                return;
                            }
                            if (option != 0) {
                                DirectoryServerDialog.this.setVisible(false);
                                return;
                            }
                        }
                        DirectoryServerDialog.this.isOk = true;
                        DirectoryServerDialog.this.setVisible(false);
                        AjaxSwingManager.endOperation();
                    }
                };
                AjaxSwingManager.beginOperation();
                worker.start();
            }
            if (DirectoryServerDialog.this.forReplicationDirServer) {
                DirectoryServerDialog.this.isOk = true;
                DirectoryServerDialog.this.setVisible(false);
            }
            return true;
        }

        private DirectoryServer getDirectoryServerByName(String name) {
            DirectoryServer directoryServer = null;
            if (name != null && name.trim().length() != 0 && DirectoryServerDialog.this.directoryServerIntegration != null) {
                for (int i = 0; i < DirectoryServerDialog.this.directoryServerIntegration.getDirectoryServerCount(); ++i) {
                    DirectoryServer dserver = DirectoryServerDialog.this.directoryServerIntegration.getDirectoryServer(i);
                    if (!name.equalsIgnoreCase(dserver.getName())) continue;
                    directoryServer = dserver;
                }
            }
            return directoryServer;
        }

        private DirectoryServer getDirectoryServerByLdapInfo(String hostName, Long port, String searchBase, String userName) {
            DirectoryServer directoryServer = null;
            if (hostName == null) {
                hostName = "";
            }
            if (searchBase == null) {
                searchBase = "";
            }
            if (userName == null) {
                userName = "";
            }
            if (DirectoryServerDialog.this.directoryServerIntegration != null) {
                for (int i = 0; i < DirectoryServerDialog.this.directoryServerIntegration.getDirectoryServerCount(); ++i) {
                    DirectoryServer dserver = DirectoryServerDialog.this.directoryServerIntegration.getDirectoryServer(i);
                    Long port0 = dserver.getOptPort();
                    if (port == null ? port0 != null : !port.equals(port0)) continue;
                    String basedn = dserver.getOptBaseDN();
                    if (basedn == null) {
                        basedn = "";
                    }
                    if (!hostName.equalsIgnoreCase(dserver.getServerAddress()) || !searchBase.equalsIgnoreCase(basedn) || !userName.equals(dserver.getOptUsername())) continue;
                    directoryServer = dserver;
                }
            }
            return directoryServer;
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_dialog_server_properties_directory_servers_add_gernal";
        }

        private String getBaseDN(boolean checkLdapType) {
            if (checkLdapType && !this.jRBLdap.isSelected()) {
                return null;
            }
            return this.jTFBaseDN.getText().trim();
        }

        private String getPortString() {
            return this.jTFPort.getText().trim();
        }

        private Long getPort() {
            Long port = null;
            try {
                port = Long.valueOf(this.getPortString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return port;
        }

        private boolean useSSL() {
            return this.jCBSsl.isSelected();
        }

        private boolean disableCertValidation() {
            return this.jCBDisableCertValidation.isSelected();
        }

        private void createGUI() {
            int maxCharsAllowed = 256;
            this.jBReason = this.getReasonBox();
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new GridBagLayout());
            if (!DirectoryServerDialog.this.forReplicationDirServer) {
                panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.name")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.jTFName = new JTextField();
                this.jTFName.setDocument(new RestrictedPlainDocument(maxCharsAllowed));
                panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
                panel.add((Component)this.jBReason, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
                panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.serverType")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.jRBAd = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.button.activeDirectory"), true);
                panel.add((Component)this.jRBAd, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.jRBLdap = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.LDAP"));
                panel.add((Component)this.jRBLdap, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            }
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.serverIPorName")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.jTFIpName = new JTextField(20);
            RestrictedPlainDocument restrictedDoc = new RestrictedPlainDocument(maxCharsAllowed);
            restrictedDoc.setValidator(INVALID_COMPUTER_NAME_CHARACTERS, false);
            this.jTFIpName.setDocument(restrictedDoc);
            panel.add((Component)this.jTFIpName, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            if (!DirectoryServerDialog.this.forReplicationDirServer) {
                this.jLPort = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.LDAPPort"));
                panel.add((Component)this.jLPort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.jTFPort = new JTextField(new NumberPlainDocument(65535L), DEFAULT_PORT, 5);
                panel.add((Component)this.jTFPort, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
                this.jLBaseDN = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.LDAPBaseDN"));
                panel.add((Component)this.jLBaseDN, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.jTFBaseDN = new JTextField();
                panel.add((Component)this.jTFBaseDN, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
                panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.userName")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.jTFUser = new JTextField();
                this.jTFUser.setDocument(new RestrictedPlainDocument(maxCharsAllowed));
                panel.add((Component)this.jTFUser, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
                panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.label.password")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
                this.jPFWord = new SEPMPasswordField();
                this.jPFWord.setDocument(new RestrictedPlainDocument(maxCharsAllowed));
                panel.add((Component)this.jPFWord, new GridBagConstraints(1, 7, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
                this.jCBSsl = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.ckbox.useSecureConnection"));
                this.jCBSsl.setSelected(new DirectoryServer().getDefUseSSL());
                panel.add((Component)this.jCBSsl, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
                this.jCBDisableCertValidation = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.ckbox.disableCertValidate"));
                this.jCBDisableCertValidation.setSelected(new DirectoryServer().getDefDisableCertValidate());
                panel.add((Component)this.jCBDisableCertValidation, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
                panel.add((Component)this.getDisableCertValidationWarningBox(), new GridBagConstraints(0, 10, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 5, 0), 0, 0));
                ButtonGroup group = new ButtonGroup();
                group.add(this.jRBAd);
                group.add(this.jRBLdap);
                this.jRBAd.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            GeneralPanel.this.serverTypeChanged();
                        }
                    }
                });
                this.jRBLdap.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            GeneralPanel.this.serverTypeChanged();
                        }
                    }
                });
                this.jCBSsl.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean ldap = GeneralPanel.this.jRBLdap.isSelected();
                        boolean ssl = GeneralPanel.this.useSSL();
                        if (!ldap) {
                            GeneralPanel.this.jTFPort.setText(ssl ? GeneralPanel.DEFAULT_PORT_SSL : GeneralPanel.DEFAULT_PORT);
                        } else {
                            String port_s = GeneralPanel.this.getPortString();
                            if (port_s.equals(GeneralPanel.DEFAULT_PORT_SSL) && !ssl) {
                                GeneralPanel.this.jTFPort.setText(GeneralPanel.DEFAULT_PORT);
                            } else if (port_s.equals(GeneralPanel.DEFAULT_PORT) && ssl) {
                                GeneralPanel.this.jTFPort.setText(GeneralPanel.DEFAULT_PORT_SSL);
                            }
                        }
                        GeneralPanel.this.jCBDisableCertValidation.setEnabled(ssl);
                    }
                });
                this.jCBDisableCertValidation.addItemListener(event -> {
                    boolean showWarn = DirectoryServerDialog.shouldCertWarningEnable(this.useSSL(), this.disableCertValidation());
                    this.disableCertValidationWarningIcon.setEnabled(showWarn);
                    this.disableCertValidationWarningText.setEnabled(showWarn);
                });
            }
            this.add((Component)panel, "North");
        }

        private void updateGUI() {
            if (DirectoryServerDialog.this.model.getName() != null) {
                this.jTFIpName.setText(DirectoryServerDialog.this.model.getServerAddress());
                if (!DirectoryServerDialog.this.forReplicationDirServer) {
                    this.jTFName.setText(DirectoryServerDialog.this.model.getName());
                    this.jTFName.setEnabled(!ServerHandler.isDirectoryServerInUse(DirectoryServerDialog.this.model.getOptGuid(), true));
                    this.jBReason.setVisible(!this.jTFName.isEnabled());
                    this.jTFUser.setText(DirectoryServerDialog.this.model.getOptUsername());
                    this.currPassword = DirectoryServerDialog.this.model.getOptPassword();
                    if (!StringUtilities.isEmpty((String)DirectoryServerDialog.this.model.getOptPassword())) {
                        this.jPFWord.setText("********");
                    } else {
                        this.jPFWord.setText(DirectoryServerDialog.this.model.getOptPassword());
                    }
                    Long port = DirectoryServerDialog.this.model.getOptPort();
                    this.jTFPort.setText(port == null ? "" : String.valueOf(port));
                    Integer protocol = DirectoryServerDialog.this.model.getType();
                    if (DirectoryServer.LDAP.equals(protocol)) {
                        this.jRBLdap.setSelected(true);
                        String baseDN = DirectoryServerDialog.this.model.getOptBaseDN();
                        this.jTFBaseDN.setText(baseDN == null ? "" : String.valueOf(baseDN));
                    } else if (DirectoryServer.ADDC.equals(protocol)) {
                        this.jRBAd.setSelected(true);
                    }
                    boolean ssl = DirectoryServerDialog.this.model.getOptUseSSL() != null ? DirectoryServerDialog.this.model.getOptUseSSL() : DirectoryServerDialog.this.model.getDefUseSSL();
                    this.jCBSsl.setSelected(ssl);
                    boolean disableCertValidation = Optional.ofNullable(DirectoryServerDialog.this.model.getOptDisableCertValidate()).orElse(DirectoryServerDialog.this.model.getDefDisableCertValidate());
                    this.jCBDisableCertValidation.setSelected(disableCertValidation);
                    this.jCBDisableCertValidation.setEnabled(ssl);
                    boolean showWarn = DirectoryServerDialog.shouldCertWarningEnable(this.useSSL(), this.disableCertValidation());
                    this.disableCertValidationWarningIcon.setEnabled(showWarn);
                    this.disableCertValidationWarningText.setEnabled(showWarn);
                    this.serverTypeChanged();
                }
            } else {
                this.jBReason.setVisible(false);
                boolean showWarn = DirectoryServerDialog.shouldCertWarningEnable(this.useSSL(), this.disableCertValidation());
                this.disableCertValidationWarningIcon.setEnabled(showWarn);
                this.disableCertValidationWarningText.setEnabled(showWarn);
                this.serverTypeChanged();
            }
        }

        private Box getDisableCertValidationWarningBox() {
            this.disableCertValidationWarningText.setEditable(false);
            this.disableCertValidationWarningText.setWrapStyleWord(true);
            this.disableCertValidationWarningText.setLineWrap(true);
            this.disableCertValidationWarningText.setOpaque(true);
            this.disableCertValidationWarningText.setAlignmentX(0.0f);
            this.disableCertValidationWarningText.setMargin(new Insets(0, 10, 0, 0));
            Box disableCertValidationWarningBox = Box.createHorizontalBox();
            disableCertValidationWarningBox.add(this.disableCertValidationWarningIcon);
            disableCertValidationWarningBox.add(this.disableCertValidationWarningText);
            return disableCertValidationWarningBox;
        }

        private Box getReasonBox() {
            JTextArea jTAReason = new JTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DirectoryServerDialog.textarea.reason"));
            jTAReason.setEditable(false);
            jTAReason.setWrapStyleWord(true);
            jTAReason.setLineWrap(true);
            jTAReason.setOpaque(true);
            jTAReason.setAlignmentX(0.0f);
            jTAReason.setMargin(new Insets(0, 10, 0, 0));
            JLabel jLReason = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconWarning.png"))));
            Box box = Box.createHorizontalBox();
            box.add(jLReason);
            box.add(jTAReason);
            return box;
        }

        private void serverTypeChanged() {
            boolean isEnabled = this.jRBLdap.isSelected();
            this.jTFPort.setEnabled(isEnabled);
            this.jTFBaseDN.setEnabled(isEnabled);
            this.jLPort.setEnabled(isEnabled);
            this.jLBaseDN.setEnabled(isEnabled);
            if (!isEnabled) {
                this.jTFPort.setText(this.useSSL() ? DEFAULT_PORT_SSL : DEFAULT_PORT);
            }
        }
    }
}

