/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.schema.Database;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.server.dlg.DatabaseBackupPanel;
import com.sygate.scm.console.ui.server.dlg.DatabaseGeneralPanel;
import com.sygate.scm.console.ui.server.dlg.DatabaseLogSettingsPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class DatabasePropertiesDialog
extends DialogBase {
    private static final long serialVersionUID = -8989914580932009773L;
    private JTabbedPane jTabPane = new JTabbedPane();
    private DatabaseGeneralPanel generalPanel = null;
    private DatabaseLogSettingsPanel logPanel = null;
    private DatabaseBackupPanel backupPanel = null;
    private Database database;
    private SemSite site;

    public DatabasePropertiesDialog(SemSite site, boolean readOnly) {
        super(Manager.getFrame(), "", true);
        this.site = site;
        this.database = SchemaHelper.getDatabase((SemSite)site);
        this.readOnly = readOnly;
        Object[] obj = new Object[]{this.database.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.title.databasePropertiesFor");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean isValidate() {
        if (!this.generalPanel.isValidate() || !this.logPanel.isValidate()) {
            return false;
        }
        return this.backupPanel == null || this.backupPanel.isValidate();
    }

    @Override
    protected void commit() {
        this.generalPanel.updateModel();
        this.logPanel.updateModel();
        if (this.backupPanel != null) {
            this.backupPanel.updateModel();
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.jTabPane.getSelectedComponent());
    }

    private void initialize() {
        this.generalPanel = new DatabaseGeneralPanel(this.site, this.database, this.readOnly);
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.general"), this.generalPanel);
        this.logPanel = new DatabaseLogSettingsPanel(this.site, this.readOnly);
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SitePropertiesDlg.title.LogSettings"), new JScrollPane(this.logPanel));
        this.backupPanel = new DatabaseBackupPanel(this.site, this.readOnly);
        this.jTabPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.backupSettings"), this.backupPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jTabPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }
}

