/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.LogSettingEntity;
import com.sygate.scm.common.configobject.schema.LogStorage;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DatabaseLogSettingsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 7139311938619265422L;
    private static final int MAX_LOG_SIZE = 999999999;
    private Integer[] LOG_TYPES;
    private Integer[] LOG_TYPES_ALL = new Integer[]{LogSettingEntity.LT_SCM_SYSTEM_LOG, LogSettingEntity.LT_SCM_ADMIN_LOG, LogSettingEntity.LT_SCM_POLICY_LOG, LogSettingEntity.LT_SCM_AGENT_ACT_LOG, LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG, LogSettingEntity.LT_AGT_SYSTEM_LOG, LogSettingEntity.LT_AGT_BEHAVIOR_LOG, LogSettingEntity.LT_AGT_SECURITY_LOG, LogSettingEntity.LT_AGT_TRAFFIC_LOG, LogSettingEntity.LT_AGT_PACKET_LOG, LogSettingEntity.LT_ENF_SYSTEM_LOG, LogSettingEntity.LT_ENF_CLIENT_ACT_LOG, LogSettingEntity.LT_ENF_TRAFFIC_LOG};
    private Integer[] LOG_TYPES_NO_FIREWALL = new Integer[]{LogSettingEntity.LT_SCM_SYSTEM_LOG, LogSettingEntity.LT_SCM_ADMIN_LOG, LogSettingEntity.LT_SCM_POLICY_LOG, LogSettingEntity.LT_SCM_AGENT_ACT_LOG, LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG, LogSettingEntity.LT_AGT_SYSTEM_LOG, LogSettingEntity.LT_AGT_BEHAVIOR_LOG, LogSettingEntity.LT_AGT_SECURITY_LOG, LogSettingEntity.LT_ENF_SYSTEM_LOG, LogSettingEntity.LT_ENF_CLIENT_ACT_LOG, LogSettingEntity.LT_ENF_TRAFFIC_LOG};
    private Integer[] LOG_TYPES_NO_OSPROTECTION = new Integer[]{LogSettingEntity.LT_SCM_SYSTEM_LOG, LogSettingEntity.LT_SCM_ADMIN_LOG, LogSettingEntity.LT_SCM_POLICY_LOG, LogSettingEntity.LT_SCM_AGENT_ACT_LOG, LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG, LogSettingEntity.LT_AGT_SYSTEM_LOG, LogSettingEntity.LT_AGT_SECURITY_LOG, LogSettingEntity.LT_AGT_TRAFFIC_LOG, LogSettingEntity.LT_AGT_PACKET_LOG, LogSettingEntity.LT_ENF_SYSTEM_LOG, LogSettingEntity.LT_ENF_CLIENT_ACT_LOG, LogSettingEntity.LT_ENF_TRAFFIC_LOG};
    private Integer[] LOG_TYPES_NO_FIREWALL_AND_OSPROTECTION = new Integer[]{LogSettingEntity.LT_SCM_SYSTEM_LOG, LogSettingEntity.LT_SCM_ADMIN_LOG, LogSettingEntity.LT_SCM_POLICY_LOG, LogSettingEntity.LT_SCM_AGENT_ACT_LOG, LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG, LogSettingEntity.LT_AGT_SYSTEM_LOG, LogSettingEntity.LT_AGT_SECURITY_LOG, LogSettingEntity.LT_ENF_SYSTEM_LOG, LogSettingEntity.LT_ENF_CLIENT_ACT_LOG, LogSettingEntity.LT_ENF_TRAFFIC_LOG};
    private JTextField jTFServerAdmin = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFServerClient = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFServerEnforcer = new JTextField(new NumberPlainDocument(999999999L, true), null, 0);
    private JTextField jTFServerPolicy = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFServerSystem = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFAgentPacket = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFAgentSecurity = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFAgentSystem = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFAgentTraffic = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFAgentBehavior = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFEnforcerClient = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFEnforcerSystem = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFEnforcerTraffic = new JTextField(new NumberPlainDocument(999999999L, true), null, 9);
    private JTextField jTFSAExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFSCExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFSEExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFSPExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFSSExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFAPExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFACExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFASExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFATExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFABExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFECExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFETExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JTextField jTFESExpire = new JTextField(new NumberPlainDocument(9999L, true), null, 4);
    private JLabel jLlogSize = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.SpecifyLogSize"));
    private JTextField jTFDelRisk = new JTextField(new NumberPlainDocument(9999L), null, 4);
    private JTextField jTFCompRisk = new JTextField(new NumberPlainDocument(9999L), null, 4);
    private JTextField jTFDelAckAlert = new JTextField(new NumberPlainDocument(9999L), null, 4);
    private JTextField jTFDelUnAckAlert = new JTextField(new NumberPlainDocument(9999L), null, 4);
    private JTextField jTFDelScans = new JTextField(new NumberPlainDocument(9999L), null, 4);
    private JTextField jTFDelCommands = new JTextField(new NumberPlainDocument(9999L), null, 4);
    private JCheckBox jCBDelVirus = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteUnusedVirus"));
    private JCheckBox jCBDelEicar = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteEicar"));
    private SemSite site;
    private boolean isFirewallPolicy;
    private boolean isOSProtectionPolicy;
    private boolean isSNACEnabled;
    private boolean readOnly;

    public DatabaseLogSettingsPanel(SemSite site, boolean readOnly) {
        this.readOnly = readOnly;
        this.site = site;
        this.initialize();
        this.setModel(site);
        this.setReadOnlyStatus();
    }

    public void setModel(SemSite site) {
        this.site = site;
        for (int i = 0; i < this.LOG_TYPES.length; ++i) {
            this.setFieldValuesForLogTypeWithIndex(i);
        }
        this.setDatabaseMaintenanceValues();
    }

    public void updateModel() {
        for (int i = 0; i < this.LOG_TYPES.length; ++i) {
            this.readFieldValuesForLogTypeWithIndex(i);
        }
        this.readDatabaseMaintenceValues();
    }

    public boolean isValidate() {
        boolean isValid = true;
        Integer days = null;
        Integer threshold = null;
        for (Integer element : this.LOG_TYPES) {
            days = null;
            threshold = null;
            LogSettingEntity entity = this.getLogSettingEntity(element);
            if (entity == null) continue;
            try {
                Integer logIndex = entity.getLogType();
                if (LogSettingEntity.LT_SCM_SYSTEM_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFServerSystem.getText().trim());
                    days = Integer.valueOf(this.jTFSSExpire.getText().trim());
                } else if (LogSettingEntity.LT_SCM_ADMIN_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFServerAdmin.getText().trim());
                    days = Integer.valueOf(this.jTFSAExpire.getText().trim());
                } else if (LogSettingEntity.LT_SCM_POLICY_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFServerPolicy.getText().trim());
                    days = Integer.valueOf(this.jTFSPExpire.getText().trim());
                } else if (LogSettingEntity.LT_SCM_AGENT_ACT_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFServerClient.getText().trim());
                    days = Integer.valueOf(this.jTFSCExpire.getText().trim());
                } else if (LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFServerEnforcer.getText().trim());
                    days = Integer.valueOf(this.jTFSEExpire.getText().trim());
                } else if (LogSettingEntity.LT_AGT_SYSTEM_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFAgentSystem.getText().trim());
                    days = Integer.valueOf(this.jTFASExpire.getText().trim());
                } else if (LogSettingEntity.LT_AGT_BEHAVIOR_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFAgentBehavior.getText().trim());
                    days = Integer.valueOf(this.jTFABExpire.getText().trim());
                } else if (LogSettingEntity.LT_AGT_SECURITY_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFAgentSecurity.getText().trim());
                    days = Integer.valueOf(this.jTFACExpire.getText().trim());
                } else if (LogSettingEntity.LT_AGT_TRAFFIC_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFAgentTraffic.getText().trim());
                    days = Integer.valueOf(this.jTFATExpire.getText().trim());
                } else if (LogSettingEntity.LT_AGT_PACKET_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFAgentPacket.getText().trim());
                    days = Integer.valueOf(this.jTFAPExpire.getText().trim());
                } else if (LogSettingEntity.LT_ENF_SYSTEM_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFEnforcerSystem.getText().trim());
                    days = Integer.valueOf(this.jTFESExpire.getText().trim());
                } else if (LogSettingEntity.LT_ENF_CLIENT_ACT_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFEnforcerClient.getText().trim());
                    days = Integer.valueOf(this.jTFECExpire.getText().trim());
                } else if (LogSettingEntity.LT_ENF_TRAFFIC_LOG.equals(logIndex)) {
                    threshold = Integer.valueOf(this.jTFEnforcerTraffic.getText().trim());
                    days = Integer.valueOf(this.jTFETExpire.getText().trim());
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
            if (days == null || days < 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.error.InvalidExpireDays"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.Error"), 0);
                isValid = false;
                break;
            }
            if (threshold != null && threshold >= 0) continue;
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.error.InvalidThreshold"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.Error"), 0);
            isValid = false;
            break;
        }
        try {
            if (Integer.valueOf(this.jTFDelRisk.getText().trim()) == null || Integer.valueOf(this.jTFCompRisk.getText().trim()) == null || Integer.valueOf(this.jTFDelAckAlert.getText().trim()) == null || Integer.valueOf(this.jTFDelUnAckAlert.getText().trim()) == null || Integer.valueOf(this.jTFDelScans.getText().trim()) == null || Integer.valueOf(this.jTFDelCommands.getText().trim()) == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.error.InvalidThreshold"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.Error"), 0);
                isValid = false;
            }
        }
        catch (NumberFormatException e) {
            isValid = false;
        }
        catch (HeadlessException e) {
            isValid = false;
        }
        return isValid;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_database_properties_log";
    }

    private void initialize() {
        LicenseObject license = LicenseObject.getInstance();
        this.isFirewallPolicy = license.isFirewallPolicy();
        this.isOSProtectionPolicy = license.isOSPretectionPolicy();
        boolean bl = this.isSNACEnabled = license.isALLProduct() || license.isSNACOnlyProduct();
        this.LOG_TYPES = this.isFirewallPolicy && this.isOSProtectionPolicy ? this.LOG_TYPES_ALL : (!this.isFirewallPolicy && this.isOSProtectionPolicy ? this.LOG_TYPES_NO_FIREWALL : (this.isFirewallPolicy && !this.isOSProtectionPolicy ? this.LOG_TYPES_NO_OSPROTECTION : this.LOG_TYPES_NO_FIREWALL_AND_OSPROTECTION));
        this.setAlignment();
        this.setLayout(new VerticalFlowLayout());
        this.add(this.jLlogSize);
        this.add(this.getServerLogPanel());
        this.add(this.getAgentLogPanel());
        if (!license.isSNACOnlyProduct()) {
            this.add(this.getDatabaseMaintenancePanel());
        }
        this.add(this.getEnforcerLogPanel());
    }

    private void readFieldValuesForLogTypeWithIndex(int index) {
        LogSettingEntity entity = this.getLogSettingEntity(this.LOG_TYPES[index]);
        if (entity != null) {
            Integer logIndex = entity.getLogType();
            if (LogSettingEntity.LT_SCM_SYSTEM_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFServerSystem.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFSSExpire.getText().trim()));
            } else if (LogSettingEntity.LT_SCM_ADMIN_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFServerAdmin.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFSAExpire.getText().trim()));
            } else if (LogSettingEntity.LT_SCM_POLICY_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFServerPolicy.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFSPExpire.getText().trim()));
            } else if (LogSettingEntity.LT_SCM_AGENT_ACT_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFServerClient.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFSCExpire.getText().trim()));
            } else if (LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFServerEnforcer.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFSEExpire.getText().trim()));
            } else if (LogSettingEntity.LT_AGT_SYSTEM_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFAgentSystem.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFASExpire.getText().trim()));
            } else if (LogSettingEntity.LT_AGT_BEHAVIOR_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFAgentBehavior.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFABExpire.getText().trim()));
            } else if (LogSettingEntity.LT_AGT_SECURITY_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFAgentSecurity.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFACExpire.getText().trim()));
            } else if (LogSettingEntity.LT_AGT_TRAFFIC_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFAgentTraffic.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFATExpire.getText().trim()));
            } else if (LogSettingEntity.LT_AGT_PACKET_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFAgentPacket.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFAPExpire.getText().trim()));
            } else if (LogSettingEntity.LT_ENF_SYSTEM_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFEnforcerSystem.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFESExpire.getText().trim()));
            } else if (LogSettingEntity.LT_ENF_CLIENT_ACT_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFEnforcerClient.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFECExpire.getText().trim()));
            } else if (LogSettingEntity.LT_ENF_TRAFFIC_LOG.equals(logIndex)) {
                entity.setOptMaxLogSize(Integer.valueOf(this.jTFEnforcerTraffic.getText().trim()));
                entity.setOptMaxLogDays(Integer.valueOf(this.jTFETExpire.getText().trim()));
            }
        }
    }

    private void setFieldValuesForLogTypeWithIndex(int index) {
        LogSettingEntity entity = this.getLogSettingEntity(this.LOG_TYPES[index]);
        if (entity != null) {
            Integer logIndex = entity.getLogType();
            if (LogSettingEntity.LT_SCM_SYSTEM_LOG.equals(logIndex)) {
                this.jTFServerSystem.setText(this.getMaxLogSize(entity));
                this.jTFSSExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_SCM_ADMIN_LOG.equals(logIndex)) {
                this.jTFServerAdmin.setText(this.getMaxLogSize(entity));
                this.jTFSAExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_SCM_POLICY_LOG.equals(logIndex)) {
                this.jTFServerPolicy.setText(this.getMaxLogSize(entity));
                this.jTFSPExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_SCM_AGENT_ACT_LOG.equals(logIndex)) {
                this.jTFServerClient.setText(this.getMaxLogSize(entity));
                this.jTFSCExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_SCM_ENFORCER_ACT_LOG.equals(logIndex)) {
                this.jTFServerEnforcer.setText(this.getMaxLogSize(entity));
                this.jTFSEExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_AGT_SYSTEM_LOG.equals(logIndex)) {
                this.jTFAgentSystem.setText(this.getMaxLogSize(entity));
                this.jTFASExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_AGT_BEHAVIOR_LOG.equals(logIndex)) {
                this.jTFAgentBehavior.setText(this.getMaxLogSize(entity));
                this.jTFABExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_AGT_SECURITY_LOG.equals(logIndex)) {
                this.jTFAgentSecurity.setText(this.getMaxLogSize(entity));
                this.jTFACExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_AGT_TRAFFIC_LOG.equals(logIndex)) {
                this.jTFAgentTraffic.setText(this.getMaxLogSize(entity));
                this.jTFATExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_AGT_PACKET_LOG.equals(logIndex)) {
                this.jTFAgentPacket.setText(this.getMaxLogSize(entity));
                this.jTFAPExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_ENF_SYSTEM_LOG.equals(logIndex)) {
                this.jTFEnforcerSystem.setText(this.getMaxLogSize(entity));
                this.jTFESExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_ENF_CLIENT_ACT_LOG.equals(logIndex)) {
                this.jTFEnforcerClient.setText(this.getMaxLogSize(entity));
                this.jTFECExpire.setText(this.getMaxLogDays(entity));
            } else if (LogSettingEntity.LT_ENF_TRAFFIC_LOG.equals(logIndex)) {
                this.jTFEnforcerTraffic.setText(this.getMaxLogSize(entity));
                this.jTFETExpire.setText(this.getMaxLogDays(entity));
            }
        }
    }

    private LogSettingEntity getLogSettingEntity(Integer type) {
        LogStorage logStorage = this.site.getLogStorage();
        Vector entities = logStorage.getLogSettingEntity();
        int entityCount = entities.size();
        for (int i = 0; i < entityCount; ++i) {
            LogSettingEntity thisEntity = (LogSettingEntity)entities.get(i);
            Integer thisType = thisEntity.getLogType();
            if (!type.equals(thisType)) continue;
            return thisEntity;
        }
        LogSettingEntity newEntity = new LogSettingEntity();
        newEntity.setLogType(type);
        newEntity.setOptMaxLogDays(newEntity.getDefMaxLogDays());
        newEntity.setOptMaxLogSize(newEntity.getDefMaxLogSize());
        logStorage.addLogSettingEntity(newEntity);
        return newEntity;
    }

    private String getMaxLogSize(LogSettingEntity entity) {
        Integer size = entity.getOptMaxLogSize();
        if (size == null) {
            size = entity.getDefMaxLogSize();
        }
        return String.valueOf(size);
    }

    private String getMaxLogDays(LogSettingEntity entity) {
        Integer days = entity.getOptMaxLogDays();
        if (days == null) {
            days = entity.getDefMaxLogDays();
        }
        return String.valueOf(days);
    }

    private JPanel getServerLogPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.title.SvrLogSettings")));
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.AdminLogLm"), this.jTFServerAdmin, this.jTFSAExpire, 0, 4);
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.ClientLogLm"), this.jTFServerClient, this.jTFSCExpire, 1, 4);
        if (this.isSNACEnabled) {
            this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.EnforcerLogLm"), this.jTFServerEnforcer, this.jTFSEExpire, 2, 4);
        }
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.PolicyLogLm"), this.jTFServerPolicy, this.jTFSPExpire, 3, 4);
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.SysLogLm"), this.jTFServerSystem, this.jTFSSExpire, 4, 4);
        return panel;
    }

    private JPanel getAgentLogPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.title.AgtLogSettings")));
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.ClientSysLogLm"), this.jTFAgentSystem, this.jTFASExpire, 0, 4);
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.SecLogLm"), this.jTFAgentSecurity, this.jTFACExpire, 1, 4);
        if (this.isFirewallPolicy) {
            this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.TrafficLogLm"), this.jTFAgentTraffic, this.jTFATExpire, 2, 4);
            this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.PacketLogLm"), this.jTFAgentPacket, this.jTFAPExpire, 3, 4);
        }
        if (this.isOSProtectionPolicy) {
            this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.BehaviorLogLm"), this.jTFAgentBehavior, this.jTFABExpire, 4, 4);
        }
        return panel;
    }

    private JPanel getDatabaseMaintenancePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.title.DatabaseMaintenance")));
        this.addDeleteConstraint(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteRisk"), this.jTFDelRisk, 0, 0, 9);
        this.addDeleteConstraint(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.CompressRisk"), this.jTFCompRisk, 3, 0, 9);
        this.addDeleteConstraint(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteAckAlerts"), this.jTFDelAckAlert, 0, 4, 9);
        this.addDeleteConstraint(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteUnAckAlerts"), this.jTFDelUnAckAlert, 3, 4, 9);
        this.addDeleteConstraint(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteScans"), this.jTFDelScans, 0, 5, 9);
        this.addDeleteConstraint(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteCommands"), this.jTFDelCommands, 3, 5, 9);
        this.addDeleteCheckbox(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteUnusedVirus"), this.jCBDelVirus, 0, 6, 9);
        this.addDeleteCheckbox(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.DeleteEicar"), this.jCBDelEicar, 3, 6, 9);
        return panel;
    }

    private void addDeleteConstraint(JPanel panel, String label, JTextField expire, int x, int y, int totalY) {
        int top = y == 0 ? 0 : 3;
        int bottom = y == totalY ? 3 : 0;
        JLabel lbdescLabel = new JLabel(label);
        panel.add((Component)lbdescLabel, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 3, bottom, 0), 0, 0));
        panel.add((Component)expire, new GridBagConstraints(x + 1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 0, bottom, 0), 0, 0));
        JLabel lbdays = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.Days"));
        panel.add((Component)lbdays, new GridBagConstraints(x + 2, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(top, 2, bottom, 3), 0, 0));
    }

    private void addDeleteCheckbox(JPanel panel, String label, JCheckBox delCheckBox, int x, int y, int totalY) {
        int top = y == 0 ? 0 : 3;
        int bottom = y == totalY ? 3 : 0;
        panel.add((Component)delCheckBox, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 0, bottom, 0), 0, 0));
    }

    private JPanel getEnforcerLogPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        if (!this.isSNACEnabled) {
            return panel;
        }
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.title.EnforcerLogSettings")));
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.EnforcerClientLogLm"), this.jTFEnforcerClient, this.jTFECExpire, 0, 2);
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.EnforcerServerLogLm"), this.jTFEnforcerSystem, this.jTFESExpire, 1, 2);
        this.addLog(panel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.EnforcerTrafficLogLm"), this.jTFEnforcerTraffic, this.jTFETExpire, 2, 2);
        return panel;
    }

    private void addLog(JPanel panel, String label, JTextField log, JTextField expire, int y, int totalY) {
        int top = y == 0 ? 0 : 5;
        int bottom = y == totalY ? 5 : 0;
        JLabel jLlog = new JLabel(label);
        panel.add((Component)jLlog, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(top, 5, bottom, 0), 0, 0));
        panel.add((Component)log, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 10, 2, new Insets(top, 0, bottom, 0), 0, 0));
        JLabel jLlogRecords = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.LogRecords"));
        panel.add((Component)jLlogRecords, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 2, bottom, 0), 0, 0));
        JLabel jLexpires = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.Expires"));
        panel.add((Component)jLexpires, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 30, bottom, 0), 0, 0));
        panel.add((Component)expire, new GridBagConstraints(4, y, 1, 1, 0.0, 0.0, 10, 2, new Insets(top, 0, bottom, 0), 0, 0));
        JLabel jLdays = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLogSettingsPanel.label.Days"));
        panel.add((Component)jLdays, new GridBagConstraints(5, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 2, bottom, 5), 0, 0));
    }

    private void setAlignment() {
        this.jTFServerSystem.setHorizontalAlignment(4);
        this.jTFServerAdmin.setHorizontalAlignment(4);
        this.jTFServerPolicy.setHorizontalAlignment(4);
        this.jTFServerClient.setHorizontalAlignment(4);
        this.jTFServerEnforcer.setHorizontalAlignment(4);
        this.jTFAgentSecurity.setHorizontalAlignment(4);
        this.jTFAgentTraffic.setHorizontalAlignment(4);
        this.jTFAgentPacket.setHorizontalAlignment(4);
        this.jTFAgentSystem.setHorizontalAlignment(4);
        this.jTFAgentBehavior.setHorizontalAlignment(4);
        this.jTFEnforcerSystem.setHorizontalAlignment(4);
        this.jTFEnforcerClient.setHorizontalAlignment(4);
        this.jTFEnforcerTraffic.setHorizontalAlignment(4);
        this.jTFSSExpire.setHorizontalAlignment(4);
        this.jTFSAExpire.setHorizontalAlignment(4);
        this.jTFSPExpire.setHorizontalAlignment(4);
        this.jTFSCExpire.setHorizontalAlignment(4);
        this.jTFSEExpire.setHorizontalAlignment(4);
        this.jTFACExpire.setHorizontalAlignment(4);
        this.jTFATExpire.setHorizontalAlignment(4);
        this.jTFAPExpire.setHorizontalAlignment(4);
        this.jTFASExpire.setHorizontalAlignment(4);
        this.jTFABExpire.setHorizontalAlignment(4);
        this.jTFESExpire.setHorizontalAlignment(4);
        this.jTFECExpire.setHorizontalAlignment(4);
        this.jTFETExpire.setHorizontalAlignment(4);
    }

    private void setReadOnlyStatus() {
        this.jTFServerAdmin.setEnabled(!this.readOnly);
        this.jTFServerClient.setEnabled(!this.readOnly);
        this.jTFServerEnforcer.setEnabled(!this.readOnly);
        this.jTFServerPolicy.setEnabled(!this.readOnly);
        this.jTFServerSystem.setEnabled(!this.readOnly);
        this.jTFAgentPacket.setEnabled(!this.readOnly);
        this.jTFAgentSecurity.setEnabled(!this.readOnly);
        this.jTFAgentSystem.setEnabled(!this.readOnly);
        this.jTFAgentTraffic.setEnabled(!this.readOnly);
        this.jTFAgentBehavior.setEnabled(!this.readOnly);
        this.jTFEnforcerClient.setEnabled(!this.readOnly);
        this.jTFEnforcerSystem.setEnabled(!this.readOnly);
        this.jTFEnforcerTraffic.setEnabled(!this.readOnly);
        this.jTFSAExpire.setEnabled(!this.readOnly);
        this.jTFSCExpire.setEnabled(!this.readOnly);
        this.jTFSEExpire.setEnabled(!this.readOnly);
        this.jTFSPExpire.setEnabled(!this.readOnly);
        this.jTFSSExpire.setEnabled(!this.readOnly);
        this.jTFAPExpire.setEnabled(!this.readOnly);
        this.jTFACExpire.setEnabled(!this.readOnly);
        this.jTFASExpire.setEnabled(!this.readOnly);
        this.jTFATExpire.setEnabled(!this.readOnly);
        this.jTFABExpire.setEnabled(!this.readOnly);
        this.jTFECExpire.setEnabled(!this.readOnly);
        this.jTFETExpire.setEnabled(!this.readOnly);
        this.jTFESExpire.setEnabled(!this.readOnly);
        this.jTFDelRisk.setEnabled(!this.readOnly);
        this.jTFCompRisk.setEnabled(!this.readOnly);
        this.jTFDelAckAlert.setEnabled(!this.readOnly);
        this.jTFDelUnAckAlert.setEnabled(!this.readOnly);
        this.jTFDelScans.setEnabled(!this.readOnly);
        this.jTFDelCommands.setEnabled(!this.readOnly);
        this.jCBDelVirus.setEnabled(!this.readOnly);
        this.jCBDelEicar.setEnabled(!this.readOnly);
    }

    private void readDatabaseMaintenceValues() {
        Integer compress = Integer.valueOf(this.jTFCompRisk.getText().trim());
        LogStorage logStorage = this.site.getLogStorage();
        logStorage.setOptDelEventsDaysOld(Integer.valueOf(this.jTFDelRisk.getText().trim()));
        logStorage.setOptCompressEventsDaysOld(compress);
        logStorage.setOptDelCompressEventsDaysOld(compress);
        logStorage.setOptDelAlertsDaysOld(Integer.valueOf(this.jTFDelAckAlert.getText().trim()));
        logStorage.setOptDelUnackAlertsDaysOld(Integer.valueOf(this.jTFDelUnAckAlert.getText().trim()));
        logStorage.setOptDelScansDaysOld(Integer.valueOf(this.jTFDelScans.getText().trim()));
        logStorage.setOptDelCommandsDaysOld(Integer.valueOf(this.jTFDelCommands.getText().trim()));
        logStorage.setOptDelUnusedPattern(Boolean.valueOf(this.jCBDelVirus.isSelected()));
        logStorage.setOptDelEicarEvents(Boolean.valueOf(this.jCBDelEicar.isSelected()));
    }

    private void setDatabaseMaintenanceValues() {
        Integer iValue = null;
        Boolean bValue = null;
        LogStorage logStorage = this.site.getLogStorage();
        iValue = logStorage.getOptDelEventsDaysOld();
        if (iValue == null) {
            iValue = logStorage.getDefDelEventsDaysOld();
        }
        this.jTFDelRisk.setText(iValue.toString());
        iValue = logStorage.getOptCompressEventsDaysOld();
        if (iValue == null) {
            iValue = logStorage.getDefCompressEventsDaysOld();
        }
        this.jTFCompRisk.setText(iValue.toString());
        iValue = logStorage.getOptDelAlertsDaysOld();
        if (iValue == null) {
            iValue = logStorage.getDefDelAlertsDaysOld();
        }
        this.jTFDelAckAlert.setText(iValue.toString());
        iValue = logStorage.getOptDelUnackAlertsDaysOld();
        if (iValue == null) {
            iValue = logStorage.getDefDelUnackAlertsDaysOld();
        }
        this.jTFDelUnAckAlert.setText(iValue.toString());
        iValue = logStorage.getOptDelScansDaysOld();
        if (iValue == null) {
            iValue = logStorage.getDefDelScansDaysOld();
        }
        this.jTFDelScans.setText(iValue.toString());
        iValue = logStorage.getOptDelCommandsDaysOld();
        if (iValue == null) {
            iValue = logStorage.getDefDelCommandsDaysOld();
        }
        this.jTFDelCommands.setText(iValue.toString());
        bValue = logStorage.getOptDelUnusedPattern();
        if (bValue == null) {
            bValue = logStorage.getDefDelUnusedPattern();
        }
        this.jCBDelVirus.setSelected(bValue);
        bValue = logStorage.getOptDelEicarEvents();
        if (bValue == null) {
            bValue = logStorage.getDefDelEicarEvents();
        }
        this.jCBDelEicar.setSelected(bValue);
        bValue = logStorage.getOptDelInfectedAlerts();
        if (bValue == null) {
            bValue = logStorage.getDefDelInfectedAlerts();
        }
    }
}

