/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.Database;
import com.sygate.scm.common.configobject.schema.ReIndexTaskSettings;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SiteDBMaintenance;
import com.sygate.scm.common.configobject.schema.TransactionLogTaskSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.server.dlg.ReIndexScheduleDlg;
import com.sygate.scm.console.ui.server.dlg.TxnLogScheduleDlg;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DatabaseGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -1578975185881791556L;
    private Database database;
    private SemSite site;
    private boolean readOnly;
    private Schedule schTruncLogs;
    private Schedule schReIndex;
    private JLabel name = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.name"));
    private JLabel description = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.description"));
    private JLabel truncLogSchLabel = new JLabel("");
    private JLabel reIndexSchLabel = new JLabel("");
    private JTextField jTFName = new JTextField(30);
    private JTextArea jTADesc = new JTextArea(5, 30);
    String scheduleTask = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.button.scheduleTask");
    private JButton btnScheduleTrunc = new JButton(this.scheduleTask);
    private JButton btnScheduleReIndex = new JButton(this.scheduleTask);
    private JCheckBox jCbxTruncLogs = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.checkbox.truncateLogs"));
    private JCheckBox jCbxReIndex = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.checkbox.reIndex"));
    private JPanel deletePanel = new JPanel();

    public DatabaseGeneralPanel(SemSite site, Database database, boolean readOnly) {
        try {
            this.site = site;
            this.database = database;
            this.readOnly = readOnly;
            this.initialize();
            this.setModel();
            this.setReadOnlyStatus();
        }
        catch (ConsoleException e) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Error");
            JOptionPane.showMessageDialog(this, e.getMessage(), title, 0);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_database_properties_general";
    }

    protected boolean isValidate() {
        if (this.jTFName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.pleaseEnterAValidName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.nameIsRequired"), 0);
            this.jTFName.requestFocus();
            return false;
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new VerticalFlowLayout());
        panel.add(this.getDBSettingsPanel());
        panel.add(this.getDBTasksPanel());
        return panel;
    }

    private JPanel getDBSettingsPanel() {
        RestrictedPlainDocument dbNameDoc = new RestrictedPlainDocument(60);
        this.jTFName.setDocument(dbNameDoc);
        RestrictedPlainDocument dbDescDoc = new RestrictedPlainDocument(1024);
        this.jTADesc.setDocument(dbDescDoc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.jTADesc);
        this.deletePanel.setLayout(new BoxLayout(this.deletePanel, 0));
        this.deletePanel.add(Box.createHorizontalStrut(10));
        this.deletePanel.add(Box.createGlue());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.name, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.description, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)jScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.deletePanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.dbSettings"))));
        return panel;
    }

    private JPanel getDBTasksPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.jCbxTruncLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataobjectManager.getInstance().getLoginInformation().getOptDatabaseProductName().equalsIgnoreCase("Microsoft SQL Server")) {
                    DatabaseGeneralPanel.this.processTruncateSelection();
                }
                DatabaseGeneralPanel.this.btnScheduleTrunc.setEnabled(DatabaseGeneralPanel.this.jCbxTruncLogs.isSelected());
            }
        });
        this.jCbxReIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseGeneralPanel.this.btnScheduleReIndex.setEnabled(DatabaseGeneralPanel.this.jCbxReIndex.isSelected());
            }
        });
        this.btnScheduleTrunc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseGeneralPanel.this.processTruncateLogTaskSchedule();
            }
        });
        this.btnScheduleReIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseGeneralPanel.this.processRebuildIndexTaskSchedule();
            }
        });
        panel.add((Component)this.jCbxTruncLogs, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.truncLogSchLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.btnScheduleTrunc, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.jCbxReIndex, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.reIndexSchLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.btnScheduleReIndex, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.dbTasks"))));
        return panel;
    }

    private void processTruncateSelection() {
        if (this.jCbxTruncLogs.isSelected()) {
            if (1 == JOptionPane.showConfirmDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.enableTruncate"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Warning"), 0)) {
                this.jCbxTruncLogs.setSelected(false);
            }
        } else if (1 == JOptionPane.showConfirmDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.disableTruncate"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ServerGeneralPanel.title.Warning"), 0)) {
            this.jCbxTruncLogs.setSelected(true);
        }
    }

    private void processTruncateLogTaskSchedule() {
        Schedule oldSchedule = (Schedule)this.schTruncLogs.clone();
        TxnLogScheduleDlg dialog = new TxnLogScheduleDlg(this.schTruncLogs, this.readOnly);
        dialog.setVisible(true);
        if (dialog.isOk() && !ConfigObjectUtils.isEqualObj((Object)this.schTruncLogs, (Object)oldSchedule)) {
            this.site.getOptSiteDBMaintenance().getTransactionLogTaskSettings().setOptScheduleModified(Boolean.valueOf(true));
        }
        dialog.dispose();
        this.displayTxnLogSchedule();
    }

    private void processRebuildIndexTaskSchedule() {
        Schedule oldSchedule = (Schedule)this.schReIndex.clone();
        ReIndexScheduleDlg dialog = new ReIndexScheduleDlg(this.schReIndex, this.readOnly);
        dialog.setVisible(true);
        if (dialog.isOk() && !ConfigObjectUtils.isEqualObj((Object)this.schReIndex, (Object)oldSchedule)) {
            this.site.getOptSiteDBMaintenance().getReIndexTaskSettings().setOptScheduleModified(Boolean.valueOf(true));
        }
        dialog.dispose();
        this.displayReIndexSchedule();
    }

    public void setModel() throws ConsoleException {
        this.jTFName.setText(this.database.getName());
        this.jTADesc.setText(this.database.getOptDescription());
        this.jTADesc.setCaretPosition(0);
        SiteDBMaintenance dbMaintenance = this.site.getOptSiteDBMaintenance();
        if (dbMaintenance == null) {
            throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.missingSetting"));
        }
        TransactionLogTaskSettings logTaskSettings = dbMaintenance.getTransactionLogTaskSettings();
        if (logTaskSettings == null) {
            throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.missingSetting"));
        }
        boolean truncLog = logTaskSettings.getOptEnable() == null ? logTaskSettings.getDefEnable().booleanValue() : logTaskSettings.getOptEnable().booleanValue();
        this.jCbxTruncLogs.setSelected(truncLog);
        this.schTruncLogs = logTaskSettings.getSchedule();
        if (this.schTruncLogs == null) {
            throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.missingSetting"));
        }
        this.displayTxnLogSchedule();
        ReIndexTaskSettings reIndexTaskSettings = dbMaintenance.getReIndexTaskSettings();
        if (reIndexTaskSettings == null) {
            throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.missingSetting"));
        }
        boolean reIndex = reIndexTaskSettings.getOptEnable() == null ? reIndexTaskSettings.getDefEnable().booleanValue() : reIndexTaskSettings.getOptEnable().booleanValue();
        this.jCbxReIndex.setSelected(reIndex);
        this.schReIndex = reIndexTaskSettings.getSchedule();
        if (this.schReIndex == null) {
            throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.msg.missingSetting"));
        }
        this.displayReIndexSchedule();
    }

    public void updateModel() {
        this.database.setName(this.jTFName.getText().trim());
        this.database.setOptDescription(this.jTADesc.getText().trim());
        this.site.getOptSiteDBMaintenance().getTransactionLogTaskSettings().setOptEnable(Boolean.valueOf(this.jCbxTruncLogs.isSelected()));
        this.site.getOptSiteDBMaintenance().getReIndexTaskSettings().setOptEnable(Boolean.valueOf(this.jCbxReIndex.isSelected()));
    }

    private void displayTxnLogSchedule() {
        if (this.schTruncLogs.getOptSimpleFrequency() != null && 0 == this.schTruncLogs.getOptSimpleFrequency()) {
            String schText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.hourlySchedule");
            Object[] obj = new Object[]{this.schTruncLogs.getOptFrequencyInterval()};
            String str = MessageFormat.format(schText, obj);
            this.truncLogSchLabel.setText(new StringBuffer("(").append(str).append(")").toString());
        } else {
            String startHour = this.schTruncLogs.getOptStartHour() == null ? this.schTruncLogs.getDefStartHour() : this.schTruncLogs.getOptStartHour();
            Integer startMinute = this.schTruncLogs.getOptStartMinute() == null ? this.schTruncLogs.getDefStartMinute() : this.schTruncLogs.getOptStartMinute();
            String minStr = Utility.formatNumberAsString((int)startMinute, (int)2);
            String time = new StringBuffer(startHour).append(":").append(minStr).append(" ").toString();
            String schText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.dailySchedule");
            Object[] obj = new Object[]{time};
            String str = MessageFormat.format(schText, obj);
            this.truncLogSchLabel.setText(new StringBuffer("(").append(str).append(")").toString());
        }
    }

    private void displayReIndexSchedule() {
        if (this.schReIndex.getOptSimpleFrequency() != null && 2 == this.schReIndex.getOptSimpleFrequency()) {
            String dayOfWeek = this.schReIndex.getOptStartDayOfWeek();
            String startHour = this.schReIndex.getOptStartHour();
            Integer startMinute = this.schReIndex.getOptStartMinute();
            String minStr = Utility.formatNumberAsString((int)startMinute, (int)2);
            String day = Utility.getDayOfWeek()[Integer.parseInt(dayOfWeek)];
            String time = new StringBuffer(startHour).append(":").append(minStr).append(" ").toString();
            String schText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.weeklySchedule");
            Object[] obj = new Object[]{time, day};
            String str = MessageFormat.format(schText, obj);
            this.reIndexSchLabel.setText(new StringBuffer("(").append(str).append(")").toString());
        } else {
            String startHour = this.schReIndex.getOptStartHour() == null ? this.schReIndex.getDefStartHour() : this.schReIndex.getOptStartHour();
            Integer startMinute = this.schReIndex.getOptStartMinute() == null ? this.schReIndex.getDefStartMinute() : this.schReIndex.getOptStartMinute();
            String minStr = Utility.formatNumberAsString((int)startMinute, (int)2);
            String time = new StringBuffer(startHour).append(":").append(minStr).append(" ").toString();
            String schText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "DatabasePropertiesDialog.label.dailySchedule");
            Object[] obj = new Object[]{time};
            String str = MessageFormat.format(schText, obj);
            this.reIndexSchLabel.setText(new StringBuffer("(").append(str).append(")").toString());
        }
    }

    private void setReadOnlyStatus() {
        this.jTFName.setEnabled(!this.readOnly);
        this.jTADesc.setEnabled(!this.readOnly);
        this.jCbxTruncLogs.setEnabled(!this.readOnly);
        this.jCbxReIndex.setEnabled(!this.readOnly);
        this.btnScheduleTrunc.setEnabled(this.jCbxTruncLogs.isSelected() && !this.readOnly);
        this.btnScheduleReIndex.setEnabled(this.jCbxReIndex.isSelected() && !this.readOnly);
    }
}

