/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.Backup;
import com.sygate.scm.common.configobject.schema.BackupContent;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.ServerBackupConfig;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DatabaseBackupPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String[] FREQUENCIES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.hourly"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.daily"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.weekly")};
    private static final String[] BACKUP_NUM = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static final int HOURLY = 0;
    private static final int DAILY = 1;
    private static final int WEEKLY = 2;
    private String bolded = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.ckbox.schedule");
    private JCheckBox jCbxEnable = new JCheckBox(this.bolded);
    private JComboBox<String> jCmbServer = new JComboBox();
    private JTextArea jLPath = new JTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.backupPath"));
    private JLabel jBackup = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.backupServer"));
    private JLabel JSchedule = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.frequency"));
    private JCheckBox jCbxLog = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.ckbox.backupLogs"));
    private JCheckBox jCbxNum = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.ckbox.onlyKeepLast"));
    private JComboBox<String> jCmbNum = new JComboBox<String>(BACKUP_NUM);
    private JComboBox<String> jCmbFrequency = new JComboBox<String>(FREQUENCIES);
    private TimeSpinner1 startSpinner;
    private boolean hasAmpm;
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private String hourPattern = "h";
    private JComboBox<String> jCmbDay;
    private JPanel jSettingsPanel = new JPanel(new GridBagLayout());
    private JPanel jSchedulePanel = new JPanel(new GridBagLayout());
    private SemSite site;
    private Vector<String> folders;
    private boolean readOnly;

    public DatabaseBackupPanel(SemSite siteObject, boolean readOnly) {
        this.readOnly = readOnly;
        this.site = siteObject;
        this.initialize();
        this.setModel();
        this.setReadOnlyStatus();
        this.setVisible(true);
    }

    public void updateModel() {
        if (this.readOnly) {
            return;
        }
        Backup backup = this.site.getBackup();
        String server = (String)this.jCmbServer.getSelectedItem();
        backup.setBackupMasterServer(server == null ? "" : server);
        if (this.jCbxLog.isSelected()) {
            backup.getBackupContent().setContent("100,110,200,210");
        } else {
            backup.getBackupContent().setContent("100,110,210");
        }
        if (this.jCbxNum.isSelected()) {
            int number = 0;
            number = Integer.parseInt(this.jCmbNum.getSelectedItem().toString());
            backup.setOptMaxBackupHistory(Integer.valueOf(number));
        } else {
            backup.setOptMaxBackupHistory(null);
        }
        Schedule schedule = backup.getSchedule();
        Boolean enableSchedule = this.jCbxEnable.isSelected();
        schedule.setOptEnable(enableSchedule);
        schedule.setOptStartYear(null);
        schedule.setOptStartMonth(null);
        schedule.setOptStartDayOfMonth(null);
        int frequency = this.jCmbFrequency.getSelectedIndex();
        int hour = this.startSpinner.getHour();
        int minute = this.startSpinner.getMinute();
        int ampm = this.startSpinner.getAmpm();
        int dayOfWeek = (this.jCmbDay.getSelectedIndex() + Utility.getCalendarInstance().getFirstDayOfWeek() - 1) % 7;
        schedule.setOptStartMinute(Integer.valueOf(minute));
        if (frequency == 0) {
            schedule.setOptStartHour(null);
            schedule.setOptStartDayOfWeek(null);
        } else {
            hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
            schedule.setOptStartHour(Integer.toString(hour));
            if (frequency == 1) {
                schedule.setOptStartDayOfWeek(null);
            } else if (frequency == 2) {
                schedule.setOptStartDayOfWeek(Integer.toString(dayOfWeek));
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_database_properties_backup";
    }

    protected boolean isValidate() {
        if (this.readOnly) {
            return true;
        }
        String server = (String)this.jCmbServer.getSelectedItem();
        if (server == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.youShallSelectAValidServer"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.invalidServer"), 0);
            return false;
        }
        if (this.jCbxNum.isSelected()) {
            Object object = this.jCmbNum.getSelectedItem();
            if (object != null) {
                String item = object.toString();
                boolean exceptionFlag = false;
                try {
                    int number = Integer.parseInt(item);
                    if (number < 1 || number > 9999) {
                        JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.numberOfBackupShallBeBetween"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.invalidNumberOfBackups"), 0);
                        return false;
                    }
                }
                catch (NumberFormatException ex) {
                    exceptionFlag = true;
                }
                catch (HeadlessException ex) {
                    exceptionFlag = true;
                }
                if (exceptionFlag) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.pleaseEnterValidNumberForBackup"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.invalidNumberOfBackups"), 0);
                    return false;
                }
            } else {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.pleaseSelectOrEnterVAlidNumberForBackupsToKeep"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.invalidNumberOfBackups"), 0);
                return false;
            }
        }
        return true;
    }

    private void setReadOnlyStatus() {
        if (this.readOnly) {
            this.jCbxEnable.setEnabled(!this.readOnly);
            this.jCmbNum.setEnabled(!this.readOnly);
            this.jCbxNum.setEnabled(!this.readOnly);
            if (this.startSpinner != null) {
                this.startSpinner.setEnabled(!this.readOnly);
            }
            this.jCmbFrequency.setEnabled(!this.readOnly);
            this.jCbxLog.setEnabled(!this.readOnly);
            if (this.jCmbDay != null) {
                this.jCmbDay.setEnabled(!this.readOnly);
            }
            this.jCmbServer.setEnabled(!this.readOnly);
        }
    }

    private void initialize() {
        this.jCbxEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseBackupPanel.this.scheduleEnabled();
            }
        });
        this.jCmbDay = new JComboBox<String>(Utility.getDayOfWeek());
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.getSettingsPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getSchedulePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        return panel;
    }

    private JPanel getSettingsPanel() {
        this.jCmbNum.setSelectedIndex(2);
        this.jCmbServer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DatabaseBackupPanel.this.serverChanged();
                }
            }
        });
        this.jCbxNum.setSelected(true);
        this.jCbxNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseBackupPanel.this.backupNumberEnabled();
            }
        });
        this.jCmbNum.setEditable(true);
        this.jSettingsPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.title.settings")));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 5, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.jSettingsPanel.add((Component)this.jBackup, constraints);
        constraints.gridx = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 0, 0, 5);
        constraints.anchor = 10;
        this.jSettingsPanel.add(this.jCmbServer, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.jSettingsPanel.add((Component)this.jLPath, constraints);
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 0, 0, 5);
        constraints.fill = 1;
        this.jSettingsPanel.add((Component)this.jCbxLog, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.ipadx = 50;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.fill = 2;
        JPanel numPanel = new JPanel(new BorderLayout());
        numPanel.setBorder(BorderFactory.createEmptyBorder());
        numPanel.add((Component)this.jCbxNum, "West");
        this.jSettingsPanel.add((Component)numPanel, constraints);
        this.jSettingsPanel.add(this.jCmbNum, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 15, 5), 0, 0));
        return this.jSettingsPanel;
    }

    private JPanel getSchedulePanel() {
        this.jCmbFrequency.setSelectedIndex(2);
        this.jCmbFrequency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DatabaseBackupPanel.this.frequencyChanged();
                }
            }
        });
        this.parseTimePattern(this.timePattern);
        this.jSchedulePanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.schedulePanel.title")));
        this.jSchedulePanel.add((Component)this.jCbxEnable, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.jSchedulePanel.add((Component)this.JSchedule, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.jSchedulePanel.add(this.jCmbFrequency, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jSchedulePanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.startTime")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.jSchedulePanel.add((Component)this.startSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jSchedulePanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.label.dayOfWeek")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 15, 0), 0, 0));
        this.jSchedulePanel.add(this.jCmbDay, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 15, 5), 0, 0));
        return this.jSchedulePanel;
    }

    private void serverChanged() {
        int index = this.jCmbServer.getSelectedIndex();
        Object[] obj = new Object[]{this.folders.get(index)};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.backupPath");
        String fm = MessageFormat.format(str, obj);
        String path = index == -1 ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.backupPathNotAvailable") : fm;
        this.jLPath.setText(path);
        this.jLPath.setToolTipText(path);
        this.jLPath.setLineWrap(true);
        this.jLPath.setEditable(false);
        this.jLPath.setBackground(this.jSchedulePanel.getBackground());
    }

    private void backupNumberEnabled() {
        this.jCmbNum.setEnabled(this.jCbxNum.isSelected());
    }

    private void scheduleEnabled() {
        boolean isEnabled = this.jCbxEnable.isSelected();
        for (int i = 1; i < this.jSchedulePanel.getComponentCount(); ++i) {
            this.jSchedulePanel.getComponent(i).setEnabled(isEnabled);
        }
        this.frequencyChanged();
    }

    private void frequencyChanged() {
        boolean isEnabled = this.jCbxEnable.isSelected();
        int frequency = this.jCmbFrequency.getSelectedIndex();
        if (frequency == 0) {
            this.startSpinner.enableHour(false);
            this.startSpinner.enableAmpm(false);
        } else {
            this.startSpinner.enableHour(true);
        }
        this.startSpinner.setEnabled(isEnabled);
        this.jCmbDay.setEnabled(isEnabled && frequency == 2);
    }

    private void parseTimePattern(String timePattern) {
        this.startSpinner = new TimeSpinner1(timePattern);
        if (timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
        }
        if (timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
        }
        if (timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
        }
        if (timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
        }
        if (timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
    }

    private void setModel() {
        ServerArray serverArray = this.site.getServerArray();
        Vector servers = serverArray.getSemServer();
        Vector<String> names = new Vector<String>();
        this.folders = new Vector();
        for (int i = 0; i < servers.size(); ++i) {
            SemServer server = (SemServer)servers.get(i);
            names.add(server.getName());
            ServerBackupConfig serverBackupConfig = server.getOptServerBackupConfig();
            if (serverBackupConfig == null) {
                this.folders.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.notAvailable"));
                continue;
            }
            String folderPath = serverBackupConfig.getBackupFolderPath();
            this.folders.add(folderPath == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "BackupSiteDialog.msg.notAvailable") : folderPath);
        }
        this.jCmbServer.setModel(new DefaultComboBoxModel(names));
        Backup backup = this.site.getBackup();
        BackupContent backupContent = backup.getBackupContent();
        String content = backupContent.getContent();
        if (content != null && content.indexOf("200") != -1) {
            this.jCbxLog.setSelected(true);
        }
        String server = backup.getBackupMasterServer();
        this.jCmbServer.setSelectedItem(server);
        Integer maxHistory = backup.getOptMaxBackupHistory();
        if (maxHistory != null) {
            this.jCbxNum.setSelected(true);
            this.jCmbNum.setSelectedItem(maxHistory.toString());
        } else {
            this.jCbxNum.setSelected(false);
        }
        Schedule schedule = backup.getSchedule();
        if (schedule == null) {
            schedule = new Schedule();
            schedule.setOptEnable(Boolean.FALSE);
            Random random = new Random();
            schedule.setOptStartMinute(Integer.valueOf(random.nextInt(60)));
            backup.setSchedule(schedule);
        }
        boolean enableSchedule = schedule.getOptEnable();
        this.jCbxEnable.setSelected(enableSchedule);
        String dayOfWeek = schedule.getOptStartDayOfWeek();
        String startHour = schedule.getOptStartHour();
        Integer startMinute = schedule.getOptStartMinute();
        int frequency = -1;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int ampm = 0;
        if (dayOfWeek != null && dayOfWeek.trim().length() > 0) {
            frequency = 2;
            hour = Utility.convertHourFrom_H_Pattern((int)Integer.parseInt(startHour), (String)this.hourPattern);
            int n = minute = startMinute == null ? 0 : startMinute;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)Integer.parseInt(startHour), (String)this.hourPattern);
            }
            day = Integer.parseInt(dayOfWeek);
        } else if (startHour != null && startHour.trim().length() > 0) {
            frequency = 1;
            hour = Utility.convertHourFrom_H_Pattern((int)Integer.parseInt(startHour), (String)this.hourPattern);
            int n = minute = startMinute == null ? 0 : startMinute;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)Integer.parseInt(startHour), (String)this.hourPattern);
            }
            day = 0;
        } else {
            frequency = 0;
            hour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
            int n = minute = startMinute == null ? 0 : startMinute;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)0, (String)this.hourPattern);
            }
            day = 0;
        }
        this.jCmbFrequency.setSelectedIndex(frequency);
        this.startSpinner.setHour(hour);
        this.startSpinner.setMinute(minute);
        if (this.hasAmpm) {
            this.startSpinner.setAmpm(ampm);
        }
        this.jCmbDay.setSelectedIndex((day - Utility.getCalendarInstance().getFirstDayOfWeek() + 1 + 7) % 7);
        this.serverChanged();
        this.backupNumberEnabled();
        this.scheduleEnabled();
    }
}

