/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.PasswordClearUtil;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.WizardBase;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConfigureRSAWizard
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final int V_GAP = 80;
    private static final int STAGE_COUNT = 4;
    private static final String RSA_WARNING_MESSAGE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.rsaWarningMessage");
    private static final String WELCOME_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.heading.configureWelcome");
    private static final String COMPLETE_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.heading.configureComplete");
    private static final String WELCOME_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.welcomeInstruction");
    private static final String COMPLETE_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.completeInstruction");
    private WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, WELCOME_HEADING, WELCOME_INSTRUCTION);
    private InfoPanel infoPanel = new InfoPanel();
    private FilePanel filePanel = new FilePanel();
    private CompletePanel completePanel = new CompletePanel();
    private boolean isChanged = true;
    private ServerObject server;
    private String realFileInAjaxswing = "";

    public ConfigureRSAWizard(ServerObject server) {
        super("Configure RSA ACE Client for: " + server, true, WizardBase.HelpButtonState.OFF);
        Object[] obj = new Object[]{server};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.title.configureRSAACEClient");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.server = server;
        this.addStage(this.welcomePanel, 0);
        this.addStage(this.infoPanel, 1);
        this.addStage(this.filePanel, 2);
        this.addStage(this.completePanel, 3);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            Map htmlAttributes = (Map)Cast.cast((Object)ComponentUtils.getHtmlAttributes((JComponent)this.welcomePanel));
            htmlAttributes.put("class", "wizardPane");
            htmlAttributes = (Map)Cast.cast((Object)ComponentUtils.getHtmlAttributes((JComponent)this.infoPanel));
            htmlAttributes.put("class", "wizardPane");
            htmlAttributes = (Map)Cast.cast((Object)ComponentUtils.getHtmlAttributes((JComponent)this.filePanel));
            htmlAttributes.put("class", "wizardPane");
            htmlAttributes = (Map)Cast.cast((Object)ComponentUtils.getHtmlAttributes((JComponent)this.completePanel));
            htmlAttributes.put("class", "wizardPane");
        }
        Dimension size = this.welcomePanel.getPreferredSize();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning() && size.width < 630) {
            size.width = 630;
        }
        this.welcomePanel.setPreferredSize(new Dimension(size.width, size.height));
        this.infoPanel.setPreferredSize(new Dimension(size.width, this.infoPanel.getPreferredSize().height));
        this.completePanel.setPreferredSize(new Dimension(size.width, size.height));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean ok() {
        if (this.isChanged) {
            this.server.getSemServer().setOptHasSecurId(Boolean.valueOf("true"));
        }
        return super.ok();
    }

    @Override
    protected int getStageCount() {
        return 4;
    }

    @Override
    protected boolean validatePanel(int stage) {
        if (stage == 2) {
            return this.filePanel.validatePanel();
        }
        return true;
    }

    @Override
    protected void jBNext_actionPerformed() {
        if (this.getCurrentStageIndex() == 1 && !this.willToChange()) {
            int finishStage = 3;
            this.setCurrentStageIndex(finishStage);
            this.updateButtons(finishStage);
            this.showNextPanel(finishStage);
            this.jBBack.setEnabled(false);
            this.isChanged = false;
        } else {
            super.jBNext_actionPerformed();
        }
    }

    protected boolean willToChange() {
        boolean willToChange = true;
        Boolean hasSecurId = this.server.getSemServer().getOptHasSecurId();
        if (hasSecurId != null && hasSecurId.booleanValue()) {
            Object[] obj = new Object[]{this.server};
            String fm = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.title.configureRSAACEClient"), obj);
            if (JOptionPane.showConfirmDialog(this, RSA_WARNING_MESSAGE, fm, 0, 2) != 0) {
                willToChange = false;
            }
        }
        return willToChange;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_configure_securid_authentication";
    }

    private static class TestDialog
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        private JTextField jTFName = new JTextField(30);
        private JPasswordField jPFCode = new SEPMPasswordField();
        private JLabel jLResult = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.NA"));

        public TestDialog() {
            super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.testConfiguration"), true);
            this.initialize();
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_servers_wizard_configure_rsa_test";
        }

        @Override
        protected String getOkButtonText() {
            return UIText.get(4865);
        }

        @Override
        protected String getCancelButtonText() {
            return UIText.get(519);
        }

        @Override
        protected boolean ok() {
            try {
                char[] pwd = this.jPFCode.getPassword();
                String enCryptedPwd = Utility.encryptLatest((char[])pwd);
                if (enCryptedPwd == null) {
                    this.jLResult.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.failed"));
                    this.jLResult.setForeground(Color.RED);
                    System.out.println("Password encryption failed");
                    PasswordClearUtil.clearPasswordInMemory(pwd, this.jPFCode);
                    return false;
                }
                PasswordClearUtil.clearPasswordInMemory(pwd, this.jPFCode);
                GUIManager.testSecurId(this.jTFName.getText(), enCryptedPwd);
            }
            catch (ConsoleException ex) {
                this.jLResult.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.failed"));
                this.jLResult.setForeground(Color.RED);
                return false;
            }
            this.jLResult.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.success"));
            return true;
        }

        private void initialize() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5), BorderFactory.createTitledBorder("")));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.userName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.passcode")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.jPFCode, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.testStatus")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.jLResult, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.pack();
            this.setResizable(false);
        }
    }

    private class CompletePanel
    extends WizardBase.WelcomeAndFinishPanel {
        private static final long serialVersionUID = 1L;
        private JButton jBTest;

        public CompletePanel() {
            super(ConfigureRSAWizard.this, 1, COMPLETE_HEADING, COMPLETE_INSTRUCTION);
            this.jBTest = null;
        }

        @Override
        protected JPanel getMiddlePanel() {
            this.jBTest = new JButton(UIText.get(4866));
            this.jBTest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompletePanel.this.jBTest_actionPerformed();
                }
            });
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.add(this.jBTest);
            return panel;
        }

        private void jBTest_actionPerformed() {
            new TestDialog();
        }
    }

    private class FilePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel jLName = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.label.path"));
        private JTextField jTFName = new JTextField();
        private JButton jBBrowse = new JButton(UIText.get(257));

        public FilePanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.title.uploadRSAFile");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.specifyThePathTo");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            this.jTFName.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilePanel.this.updateToolTip();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilePanel.this.updateToolTip();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilePanel.this.updateToolTip();
                }
            });
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.jTFName.setEditable(false);
            }
            this.jBBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilePanel.this.jBBrowse_actionPerformed();
                }
            });
            ComponentUtils.setFileOpener((JComponent)this.jBBrowse, (FileOpener)new FileOpener(){

                public void openFile(File arg0) {
                    try {
                        if (arg0 != null) {
                            ConfigureRSAWizard.this.realFileInAjaxswing = arg0.getAbsolutePath();
                            FilePanel.this.jTFName.setText(AjaxSwingUtil.getDisplayFileName(arg0));
                        }
                    }
                    catch (Exception ex) {
                        LoggerUtilities.logException((Throwable)ex);
                    }
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            panel.add((Component)this.jLName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBBrowse, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private void jBBrowse_actionPerformed() {
            JFileChooser fc = new JFileChooser();
            if (fc.showOpenDialog(this) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            if (file != null) {
                this.jTFName.setText(AjaxSwingUtil.getDisplayFileName(file));
                ConfigureRSAWizard.this.realFileInAjaxswing = file.getAbsolutePath();
                this.updateToolTip();
            }
        }

        private void updateToolTip() {
            this.jTFName.setToolTipText(this.jTFName.getText().trim());
        }

        private boolean validatePanel() {
            String config = this.jTFName.getText().trim();
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                config = ConfigureRSAWizard.this.realFileInAjaxswing;
            }
            if (config.length() == 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.pathEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.message"), 2);
                return false;
            }
            if (!new File(config).exists()) {
                Object[] obj = new Object[]{config};
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    obj[0] = this.jTFName.getText().trim();
                }
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.theFileDoesnotExist");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.message"), 2);
                return false;
            }
            try {
                GUIManager.uploadSecurIdFile(config);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                Object[] obj = new Object[]{config};
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    obj[0] = this.jTFName.getText().trim();
                }
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.theFileCannotBeUploaded");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.message"), 0);
                return false;
            }
            return true;
        }
    }

    private static class InfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public InfoPanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.title.Qualifications");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.msg.meetSystemRequirements");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            String message = HTMLUtilities.HTML_DOCUMENT_BEGIN + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.html.beforeConfiguringThePolicyManager") + "<ul>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.html.theRSAACEServerIsInstalled") + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.html.thePolicyManagerHostIsRegistered") + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.html.theSdconf.recFile") + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.html.aSynchronizedSecurIDCard") + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "ConfigureRSAWizard.html.theAdministratorHasTheRSAPIN") + "</ul></BODY></HTML>";
            JEditorPane pane = new JEditorPane("text/html", message){
                private static final long serialVersionUID = 1L;

                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning() && preferredSize.height < 300) {
                        preferredSize.height = 300;
                    }
                    return preferredSize;
                }
            };
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                pane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            }
            pane.setEditable(false);
            this.setLayout(new VerticalFlowLayout(0, 0));
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.setBackground(pane.getBackground());
            }
            this.add(headPanel);
            this.add((Component)pane);
        }
    }
}

