/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.configobject.schema.ReplicationContent;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.TimeFrame;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.WizardBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.ReplicationScheduleUtility;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class AddPartnerWizard
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final int V_GAP = 80;
    private static final int STAGE_COUNT = 5;
    private static final int STAGE_WELCOME = 0;
    private static final int STAGE_INFO = 1;
    private static final int STAGE_SCHEDULE = 2;
    private static final int STAGE_LOG = 3;
    private static final int STAGE_COMPLETE = 4;
    private static final String WELCOME_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.heading.addReplicationWelcome");
    private static final String COMPLETE_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.heading.addReplicationComplete");
    private static final String WELCOME_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.welcomeInstruction");
    private static final String COMPLETE_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.completeInstruction");
    private static final String CONSOLE_UI_DLG_PARNTNER_RESTORED_MESSAGE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.dlg.partner_restored_message");
    private static final String CONSOLE_UI_DLG_PARNTNER_RESTORED_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.dlg.partner_restored_title");
    private static final String CONSOLE_UI_DLG_PARNTNER_RESTORED_CHOICE_YES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.dlg.partner_restored_choice_yes");
    private static final String CONSOLE_UI_DLG_PARNTNER_RESTORED_CHOICE_NO = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.dlg.partner_restored_choice_no");
    private WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, WELCOME_HEADING, WELCOME_INSTRUCTION);
    protected InfoPanel infoPanel = new InfoPanel();
    protected SchedulePanel schedulePanel = new SchedulePanel();
    private LogPanel logPanel = new LogPanel();
    private WizardBase.WelcomeAndFinishPanel completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, COMPLETE_HEADING, COMPLETE_INSTRUCTION);
    private static MessageResourcesFile resource = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private static String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private static String hourPattern;
    private static boolean hasAmpm;
    private String siteName;
    private Partner partner;
    private SemSite localSite;
    private String certStr;

    public AddPartnerWizard(SemSite localSite, String title) {
        super(title, true, WizardBase.HelpButtonState.OFF);
        this.localSite = localSite;
        this.addStage(this.welcomePanel, 0);
        this.addStage(this.infoPanel, 1);
        this.addStage(this.schedulePanel, 2);
        this.addStage(this.logPanel, 3);
        this.addStage(this.completePanel, 4);
        Dimension size = this.welcomePanel.getPreferredSize();
        this.welcomePanel.setPreferredSize(new Dimension(size.width * 3 / 4, size.height));
        this.completePanel.setPreferredSize(new Dimension(size.width * 3 / 4, size.height));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public Partner getPartner() {
        return this.partner;
    }

    @Override
    protected void prepareNext(int stage) {
        if (stage == 2) {
            this.schedulePanel.prepare();
        }
    }

    @Override
    protected boolean validatePanel(int stage) {
        boolean valid = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (stage == 1) {
            valid = this.infoPanel.validatePanel();
        } else if (stage == 3) {
            valid = this.logPanel.validatePanel();
        }
        this.setCursor(Cursor.getDefaultCursor());
        return valid;
    }

    @Override
    protected int getStageCount() {
        return 5;
    }

    private static void parseTimePattern(String timePattern, TimeSpinner1 startSpinner1, TimeSpinner1 endSpinner1) {
        if (timePattern.indexOf("h") != -1) {
            hourPattern = "h";
        }
        if (timePattern.indexOf("H") != -1) {
            hourPattern = "H";
        }
        if (timePattern.indexOf("k") != -1) {
            hourPattern = "k";
        }
        if (timePattern.indexOf("K") != -1) {
            hourPattern = "K";
        }
        if (timePattern.indexOf("a") != -1) {
            hasAmpm = true;
        }
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_add_existing_replication_partner";
    }

    private class LogPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox jCbxLocalToPartnerLog = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.checkbox.ReplLocalToPartner"));
        private JCheckBox jCbxPartnerToLocalLog = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.checkbox.ReplPartnerToLocal"));
        private JCheckBox jCbxReplicateClientPackages = new JCheckBox("", true);

        public LogPanel() {
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.title.replicationOfLogFilesAndClientPackages");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.specifyWhetherOrNotToReplicateLogsAndClientPackages");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(30, 80, 10, 80));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.label.doYouWantToReplicateLogs")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jCbxLocalToPartnerLog, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 5), 0, 0));
            panel.add((Component)this.jCbxPartnerToLocalLog, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 5), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.label.doYouWantToReplicateClientPackages")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
            JPanel replicateClientAndContentPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 11;
            replicateClientAndContentPanel.add((Component)this.jCbxReplicateClientPackages, constraints);
            constraints.gridx = 1;
            constraints.insets.top = 3;
            replicateClientAndContentPanel.add((Component)new MultiLineLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.checkbox.ReplClientPackages")), constraints);
            panel.add((Component)replicateClientAndContentPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 5), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        public void init(ReplicationPartnership remotePartnership, ReplicationPartnership localPartnership) {
            if (remotePartnership == null) {
                System.out.println("=== new schedule ===");
                return;
            }
            if (localPartnership == null) {
                System.out.println("=== new schedule ===");
                return;
            }
            ReplicationContent remotePartnerReplicationContent = remotePartnership.getOptReplicationContent();
            this.jCbxPartnerToLocalLog.setSelected(remotePartnerReplicationContent.getDefReplicateLogs());
            this.jCbxReplicateClientPackages.setSelected(remotePartnerReplicationContent.getDefReplicateClientPackages());
            ReplicationContent localPartnerReplicationContent = localPartnership.getOptReplicationContent();
            this.jCbxLocalToPartnerLog.setSelected(localPartnerReplicationContent.getDefReplicateLogs());
        }

        private boolean validatePanel() {
            try {
                boolean replicateClientPackages;
                String contactServer = AddPartnerWizard.this.infoPanel.getServerName();
                if (Utility.isValidIpv6Address((String)contactServer)) {
                    contactServer = Utility.checkAndAddBrackets((String)contactServer);
                }
                String port = AddPartnerWizard.this.infoPanel.getPort();
                String adminName = AddPartnerWizard.this.infoPanel.getAdminName();
                String password = AddPartnerWizard.this.infoPanel.getPassword();
                boolean isAutoSchedule = AddPartnerWizard.this.schedulePanel.isAutoReplicateCheck();
                int frequency = AddPartnerWizard.this.schedulePanel.getFrequency();
                Object startTime = "";
                Object endTime = "";
                int dayOfWeek = AddPartnerWizard.this.schedulePanel.getDay();
                String hourlyRepeat = AddPartnerWizard.this.schedulePanel.getHourlyRepeat();
                int ampm = AddPartnerWizard.this.schedulePanel.getAmpm();
                int startHour = Utility.convertHourTo_H_Pattern((int)AddPartnerWizard.this.schedulePanel.getStartHour(), (String)hourPattern, (int)ampm);
                int endHour = Utility.convertHourTo_H_Pattern((int)AddPartnerWizard.this.schedulePanel.getEndHour(), (String)hourPattern, (int)ampm);
                Calendar startCalendar = Utility.changeTimeZoneToGMTForScheduleHour((int)dayOfWeek, (int)startHour, (int)AddPartnerWizard.this.schedulePanel.getStartMinute(), (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                startTime = (String)startTime + startCalendar.get(11) + ":";
                startTime = (String)startTime + startCalendar.get(12) + ":0:";
                dayOfWeek = startCalendar.get(7) - 1;
                Calendar endCalendar = Utility.changeTimeZoneToGMTForScheduleHour((int)dayOfWeek, (int)endHour, (int)AddPartnerWizard.this.schedulePanel.getEndMinute(), (Calendar)Utility.getCalendarInstance(), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                endTime = (String)endTime + endCalendar.get(11) + ":";
                endTime = (String)endTime + endCalendar.get(12) + ":0:";
                boolean replicateLogsToPartner = this.jCbxLocalToPartnerLog.isSelected();
                boolean replicateLogsFromPartner = this.jCbxPartnerToLocalLog.isSelected();
                boolean replicateLuContents = replicateClientPackages = this.jCbxReplicateClientPackages.isSelected();
                boolean isPartnerDbRestored = false;
                Object[] choice = new String[]{CONSOLE_UI_DLG_PARNTNER_RESTORED_CHOICE_YES, CONSOLE_UI_DLG_PARNTNER_RESTORED_CHOICE_NO};
                int result = JOptionPane.showOptionDialog(this, CONSOLE_UI_DLG_PARNTNER_RESTORED_MESSAGE, CONSOLE_UI_DLG_PARNTNER_RESTORED_TITLE, 0, 3, null, choice, choice[1]);
                if (result == 0) {
                    isPartnerDbRestored = true;
                }
                AddPartnerWizard.this.partner = ServerHandler.addPartner(AddPartnerWizard.this.siteName, contactServer, port, adminName, password, isAutoSchedule, frequency, (String)startTime, (String)endTime, hourlyRepeat, dayOfWeek, replicateLogsToPartner, replicateLogsFromPartner, replicateClientPackages, replicateLuContents, AddPartnerWizard.this.certStr, isPartnerDbRestored);
                ServerHandler.updatePartner(AddPartnerWizard.this.partner, replicateLogsToPartner, false, false);
                ReplicationScheduleUtility.ReplicationPartnerScheduleState rpuic = new ReplicationScheduleUtility.ReplicationPartnerScheduleState();
                HashMap map = ReplicationScheduleUtility.getSiteMap();
                if (map.containsKey(AddPartnerWizard.this.partner.getId())) {
                    ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(AddPartnerWizard.this.partner.getId())).setReplicationScheduleChanged(true);
                } else {
                    rpuic.setReplicationScheduleChanged(true);
                    map.put(AddPartnerWizard.this.partner.getId(), rpuic);
                }
                ConsoleLogger.logAdminEvent(16385, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.contactServer") + contactServer);
            }
            catch (ConsoleException ex) {
                int errorcode = ex.getErrorCode();
                if (errorcode == 0x18010000) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.theSiteYouWantToAddAsAPartner"));
                } else {
                    UIUtilities.showErrorDialog(ex.getMessageString());
                }
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
                return false;
            }
            return true;
        }
    }

    private class SchedulePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final String sHOURLY = resource.getString("PartnerDlg.combo.Hourly");
        private final String sDAILY = resource.getString("PartnerDlg.combo.Daily");
        private final String sWEEKLY = resource.getString("PartnerDlg.combo.Weekly");
        private final String sAUTO = resource.getString("PartnerDlg.checkbox.AutoRepl");
        private final String sMANUAL = resource.getString("PartnerDlg.checkbox.ManualRepl");
        private JTextArea jTADescription = new DescriptionTextArea("", 2, 30);
        private JRadioButton jRBAuto = new JRadioButton(resource.getString("PartnerDlg.checkbox.AutoRepl"));
        private JRadioButton jRBManual = new JRadioButton(resource.getString("PartnerDlg.checkbox.ManualRepl"));
        private JRadioButton jRBHourly = new JRadioButton(resource.getString("PartnerDlg.combo.Hourly"));
        private JRadioButton jRBDaily = new JRadioButton(resource.getString("PartnerDlg.combo.Daily"));
        private JRadioButton jRBWeekly = new JRadioButton(resource.getString("PartnerDlg.combo.Weekly"));
        private ButtonGroup autoManualGroup = new ButtonGroup();
        private ButtonGroup freqGroup = new ButtonGroup();
        private JSpinner jSpinnerhourSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
        private SchBetweenPanel schBetweenPanel = new SchBetweenPanel();
        JPanel jSchedulePanel = new JPanel(new GridBagLayout());
        private JComboBox<String> jCmbDay = new JComboBox<String>(Utility.getDayOfWeek());
        private static final int END_MINUTES_DEFAULT = 59;
        private static final int START_MINUTES_DEFAULT = 0;
        private static final int END_HOURS_DEFAULT = 23;
        private static final int HOURLY = 0;
        private static final int DAILY = 1;
        private static final int WEEKLY = 2;
        private JPanel autoPanel = null;
        private JPanel frequencyPanel = null;
        private JPanel weeklyPanel = null;
        private JPanel hourlyRepeat = null;
        private JPanel manualPanel = null;
        private JPanel scheduleBetweenPanel = null;

        public SchedulePanel() {
            this.initialize();
        }

        public boolean isAutoReplicateCheck() {
            return this.jRBAuto.isSelected();
        }

        public int getFrequency() {
            AbstractButton selectedFreq = this.getSelectedButton(this.freqGroup);
            if (selectedFreq == null) {
                return 0;
            }
            if (selectedFreq.equals(this.jRBHourly)) {
                return 0;
            }
            if (selectedFreq.equals(this.jRBDaily)) {
                return 1;
            }
            return 2;
        }

        public int getStartHour() {
            return this.schBetweenPanel.getStartHour();
        }

        public int getStartMinute() {
            return this.schBetweenPanel.getStartMinute();
        }

        public int getDay() {
            return this.jCmbDay.getSelectedIndex();
        }

        public int getEndHour() {
            return this.schBetweenPanel.getEndHour();
        }

        public int getEndMinute() {
            return this.schBetweenPanel.getEndMinute();
        }

        public String getHourlyRepeat() {
            return this.jSpinnerhourSpinner.getValue().toString();
        }

        public int getAmpm() {
            return this.schBetweenPanel.getAmpm();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.title.scheduleReplication");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.setupTheReplicationSchedule");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            this.jRBAuto.setName(this.sAUTO);
            this.jRBManual.setName(this.sMANUAL);
            this.jRBHourly.setName(this.sHOURLY);
            this.jRBDaily.setName(this.sDAILY);
            this.jRBWeekly.setName(this.sWEEKLY);
            this.autoManualGroup.add(this.jRBAuto);
            this.autoManualGroup.add(this.jRBManual);
            this.freqGroup.add(this.jRBHourly);
            this.freqGroup.add(this.jRBDaily);
            this.freqGroup.add(this.jRBWeekly);
            this.jRBAuto.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SchedulePanel.this.enableComponents(SchedulePanel.this.autoPanel);
                    SchedulePanel.this.freqGroup.clearSelection();
                    SchedulePanel.this.disableComponents(SchedulePanel.this.frequencyPanel);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.hourlyRepeat);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.weeklyPanel);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.scheduleBetweenPanel);
                    SchedulePanel.this.jRBHourly.setEnabled(false);
                    SchedulePanel.this.jRBDaily.setEnabled(false);
                    SchedulePanel.this.jRBWeekly.setEnabled(false);
                    SchedulePanel.this.schBetweenPanel.setEnabled(false);
                }
            });
            this.jRBManual.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SchedulePanel.this.schBetweenPanel.setEnabled(true);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.scheduleBetweenPanel);
                    SchedulePanel.this.jRBHourly.setEnabled(true);
                    SchedulePanel.this.jRBDaily.setEnabled(true);
                    SchedulePanel.this.jRBWeekly.setEnabled(true);
                    SchedulePanel.this.freqGroup.clearSelection();
                    SchedulePanel.this.freqGroup.setSelected(SchedulePanel.this.jRBHourly.getModel(), true);
                }
            });
            this.jRBHourly.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SchedulePanel.this.schBetweenPanel.setEnabled(true);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.scheduleBetweenPanel);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.hourlyRepeat);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.frequencyPanel);
                    SchedulePanel.this.jRBHourly.setEnabled(true);
                    SchedulePanel.this.jRBDaily.setEnabled(true);
                    SchedulePanel.this.jRBWeekly.setEnabled(true);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.weeklyPanel);
                }
            });
            this.jRBDaily.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SchedulePanel.this.schBetweenPanel.setEnabled(true);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.scheduleBetweenPanel);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.hourlyRepeat);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.weeklyPanel);
                    SchedulePanel.this.frequencyPanel.setEnabled(true);
                    SchedulePanel.this.jRBHourly.setEnabled(true);
                    SchedulePanel.this.jRBDaily.setEnabled(true);
                    SchedulePanel.this.jRBWeekly.setEnabled(true);
                }
            });
            this.jRBWeekly.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SchedulePanel.this.schBetweenPanel.setEnabled(true);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.scheduleBetweenPanel);
                    SchedulePanel.this.enableComponents(SchedulePanel.this.weeklyPanel);
                    SchedulePanel.this.frequencyPanel.setEnabled(true);
                    SchedulePanel.this.jRBHourly.setEnabled(true);
                    SchedulePanel.this.jRBDaily.setEnabled(true);
                    SchedulePanel.this.jRBWeekly.setEnabled(true);
                    SchedulePanel.this.disableComponents(SchedulePanel.this.hourlyRepeat);
                }
            });
            this.jSchedulePanel.setBorder(BorderFactory.createTitledBorder(resource.getString("PartnerDlg.title.Schedule")));
            this.autoPanel = new JPanel(new GridBagLayout());
            this.autoPanel.add((Component)this.jRBAuto, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JLabel autoReplDescription = new JLabel(resource.getString("PartnerDlg.label.Auto.Replication.Description"));
            this.autoPanel.add((Component)autoReplDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
            this.autoPanel.setVisible(true);
            this.autoPanel.setEnabled(false);
            this.jSchedulePanel.add((Component)this.autoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
            this.manualPanel = new JPanel(new GridBagLayout());
            this.manualPanel.add((Component)this.jRBManual, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
            this.frequencyPanel = new JPanel(new GridBagLayout());
            JLabel repFreqDescription = new JLabel(resource.getString("PartnerDlg.label.ReplFreq"));
            this.frequencyPanel.add((Component)repFreqDescription, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
            this.frequencyPanel.add((Component)this.jRBHourly, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 25, 0, 0), 0, 0));
            this.frequencyPanel.add((Component)this.jRBDaily, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 0, 0), 0, 0));
            this.frequencyPanel.add((Component)this.jRBWeekly, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 0, 0), 0, 0));
            this.frequencyPanel.setVisible(true);
            this.manualPanel.add((Component)this.frequencyPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.hourlyRepeat = new JPanel(new GridBagLayout());
            this.hourlyRepeat.add((Component)new JLabel(resource.getString("PartnerDlg.label.Every")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 10, new Insets(5, 48, 0, 0), 0, 0));
            this.hourlyRepeat.add((Component)this.jSpinnerhourSpinner, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 56, 0, 0), 0, 0));
            this.hourlyRepeat.add((Component)new JLabel(resource.getString("PartnerDlg.label.Hours")), new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
            this.hourlyRepeat.setVisible(true);
            this.manualPanel.add((Component)this.hourlyRepeat, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.weeklyPanel = new JPanel(new GridBagLayout());
            this.weeklyPanel.add((Component)new JLabel(resource.getString("PartnerDlg.label.DayOfWeek.On")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 10, new Insets(10, 48, 0, 0), 0, 0));
            this.weeklyPanel.add(this.jCmbDay, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 70, 0, 0), 0, 0));
            this.weeklyPanel.setVisible(true);
            this.manualPanel.add((Component)this.weeklyPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.scheduleBetweenPanel = new JPanel(new GridBagLayout());
            JLabel schdTimeFrameDescription = new JLabel(resource.getString("PartnerDlg.schBetweenPanel.description"));
            schdTimeFrameDescription.setForeground(UIColorUtilities.CONTROL_BACKGROUND);
            this.scheduleBetweenPanel.add((Component)schdTimeFrameDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 43, 0, 0), 0, 0));
            this.scheduleBetweenPanel.add((Component)this.schBetweenPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 10, new Insets(2, 2, 0, 0), 0, 0));
            this.scheduleBetweenPanel.setVisible(true);
            this.schBetweenPanel.setVisible(true);
            this.manualPanel.add((Component)this.scheduleBetweenPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.manualPanel.setVisible(true);
            this.jSchedulePanel.add((Component)this.manualPanel, new GridBagConstraints(0, 8, 5, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
            this.freqGroup.setSelected(this.jRBDaily.getModel(), true);
            this.disableComponents(this.hourlyRepeat);
            JPanel wrapPanel = new JPanel(new VerticalFlowLayout());
            wrapPanel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            wrapPanel.add(this.jTADescription);
            wrapPanel.add(this.jSchedulePanel);
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(wrapPanel);
        }

        private void disableComponents(JPanel jPanel) {
            for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                if (jPanel.getComponent(i) instanceof JPanel) {
                    this.disableComponents((JPanel)jPanel.getComponent(i));
                }
                if (jPanel instanceof SchBetweenPanel) continue;
                jPanel.getComponent(i).setEnabled(false);
            }
        }

        private void enableComponents(JPanel jPanel) {
            for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                if (jPanel.getComponent(i) instanceof JPanel) {
                    this.enableComponents((JPanel)jPanel.getComponent(i));
                }
                jPanel.getComponent(i).setEnabled(true);
            }
        }

        private AbstractButton getSelectedButton(ButtonGroup group) {
            Enumeration<AbstractButton> buttons = group.getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (!button.isSelected()) continue;
                return button;
            }
            return null;
        }

        public void init(ReplicationPartnership remotePartnershipForLocalSite) {
            if (remotePartnershipForLocalSite == null) {
                System.out.println("=== new schedule ===");
                return;
            }
            Schedule schedule = remotePartnershipForLocalSite.getOptSchedule();
            if (schedule == null) {
                schedule = new Schedule();
                schedule.setOptEnable(Boolean.TRUE);
                schedule.setOptStartHour(Utility.getMidnightHour((int)0));
                schedule.setOptStartMinute(Integer.valueOf(0));
                schedule.setOptHourlyFrequency(null);
                TimeFrame timeFrame = new TimeFrame();
                timeFrame.setOptStartHour(Integer.valueOf(Integer.parseInt(Utility.getMidnightHour((int)0))));
                timeFrame.setOptEndHour(Integer.valueOf(Integer.parseInt(Utility.getEndHourInGMT())));
                timeFrame.setOptStartMin(Integer.valueOf(0));
                timeFrame.setOptEndMin(Integer.valueOf(59));
                schedule.setOptTimeFrame(timeFrame);
            }
            String dayOfWeek = schedule.getOptStartDayOfWeek();
            String startHour = schedule.getOptStartHour();
            Integer startMinute = schedule.getOptStartMinute();
            if (startMinute == null) {
                startMinute = 0;
            }
            boolean hourlyUpgradeCase = false;
            if (startHour == null) {
                startHour = Utility.getMidnightHour((int)startMinute);
                startMinute = Utility.getMidnightMinute((int)startMinute);
                hourlyUpgradeCase = true;
            }
            Integer endHour = Integer.parseInt(startHour) % 24;
            Integer endMinute = startMinute % 60;
            if (endMinute == 0 && (endHour = Integer.valueOf(endHour - 1)) < 0) {
                endHour = Integer.parseInt(Utility.getEndHourInGMT());
            }
            endMinute = endMinute - 1 < 0 ? Integer.valueOf(59) : Integer.valueOf(endMinute - 1);
            boolean enableSchedule = schedule.getOptEnable();
            int day = 0;
            int startHourForPattern = 0;
            int startMinuteForPattern = 0;
            int endHourForPattern = 0;
            int endMinuteForPattern = 0;
            int ampm = 0;
            if (!enableSchedule) {
                this.autoManualGroup.setSelected(this.jRBAuto.getModel(), true);
                this.schBetweenPanel.setEnabled(false);
            } else if (dayOfWeek != null && dayOfWeek.trim().length() > 0) {
                this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
                this.freqGroup.setSelected(this.jRBWeekly.getModel(), true);
                this.schBetweenPanel.setEnabled(true);
                TimeFrame curFrame = schedule.getOptTimeFrame();
                if (curFrame != null) {
                    startHour = curFrame.getOptStartHour() == null ? curFrame.getDefStartHour().toString() : curFrame.getOptStartHour().toString();
                    startMinute = curFrame.getOptStartMin() == null ? curFrame.getDefStartMin() : curFrame.getOptStartMin();
                    endHour = curFrame.getOptEndHour() == null ? curFrame.getDefEndHour() : curFrame.getOptEndHour();
                    endMinute = curFrame.getOptEndMin() == null ? curFrame.getDefEndMin() : curFrame.getOptEndMin();
                }
                Calendar startCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)Integer.parseInt(dayOfWeek), (int)Integer.parseInt(startHour), (int)startMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                Calendar endCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)Integer.parseInt(dayOfWeek), (int)endHour, (int)endMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                startHourForPattern = Utility.convertHourFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                startMinute = startCal.get(12);
                startMinuteForPattern = startMinute;
                endHourForPattern = Utility.convertHourFrom_H_Pattern((int)endCal.get(11), (String)hourPattern);
                endMinute = endCal.get(12);
                endMinuteForPattern = endMinute;
                if (hasAmpm) {
                    ampm = Utility.getAmpmFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                }
                this.schBetweenPanel.setStartHour(startHourForPattern);
                this.schBetweenPanel.setEndHour(endHourForPattern);
                this.schBetweenPanel.setStartMinute(startMinuteForPattern);
                this.schBetweenPanel.setEndMinute(endMinuteForPattern);
                this.schBetweenPanel.enableAmpm(hasAmpm, ampm);
                day = startCal.get(7) - 1;
            } else if (schedule.getOptHourlyFrequency() == null && !hourlyUpgradeCase) {
                this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
                this.freqGroup.setSelected(this.jRBDaily.getModel(), true);
                this.schBetweenPanel.setEnabled(true);
                TimeFrame curFrame = schedule.getOptTimeFrame();
                if (curFrame != null) {
                    startHour = curFrame.getOptStartHour() == null ? curFrame.getDefStartHour().toString() : curFrame.getOptStartHour().toString();
                    startMinute = curFrame.getOptStartMin() == null ? curFrame.getDefStartMin() : curFrame.getOptStartMin();
                    endHour = curFrame.getOptEndHour() == null ? curFrame.getDefEndHour() : curFrame.getOptEndHour();
                    endMinute = curFrame.getOptEndMin() == null ? curFrame.getDefEndMin() : curFrame.getOptEndMin();
                }
                Calendar startCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)Integer.parseInt(startHour), (int)startMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                Calendar endCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)endHour, (int)endMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                startHourForPattern = Utility.convertHourFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                startMinute = startCal.get(12);
                startMinuteForPattern = startMinute;
                endHourForPattern = Utility.convertHourFrom_H_Pattern((int)endCal.get(11), (String)hourPattern);
                endMinute = endCal.get(12);
                endMinuteForPattern = endMinute;
                if (hasAmpm) {
                    ampm = Utility.getAmpmFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                }
                this.schBetweenPanel.setStartHour(startHourForPattern);
                this.schBetweenPanel.setEndHour(endHourForPattern);
                this.schBetweenPanel.setStartMinute(startMinuteForPattern);
                this.schBetweenPanel.setEndMinute(endMinuteForPattern);
                this.schBetweenPanel.enableAmpm(hasAmpm, ampm);
                day = 0;
            } else {
                this.autoManualGroup.setSelected(this.jRBManual.getModel(), true);
                this.freqGroup.setSelected(this.jRBHourly.getModel(), true);
                this.schBetweenPanel.setEnabled(true);
                day = 0;
                this.jSpinnerhourSpinner.setEnabled(true);
                Integer hourlyFrequency = schedule.getOptHourlyFrequency() == null ? schedule.getDefHourlyFrequency() : schedule.getOptHourlyFrequency();
                this.jSpinnerhourSpinner.setValue(hourlyFrequency);
                TimeFrame curFrame = schedule.getOptTimeFrame();
                if (curFrame != null) {
                    startHour = curFrame.getOptStartHour() == null ? curFrame.getDefStartHour().toString() : curFrame.getOptStartHour().toString();
                    startMinute = curFrame.getOptStartMin() == null ? curFrame.getDefStartMin() : curFrame.getOptStartMin();
                    endHour = curFrame.getOptEndHour() == null ? curFrame.getDefEndHour() : curFrame.getOptEndHour();
                    endMinute = curFrame.getOptEndMin() == null ? curFrame.getDefEndMin() : curFrame.getOptEndMin();
                }
                Calendar startCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)Integer.parseInt(startHour), (int)startMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                Calendar endCal = Utility.changeTimeZoneFromGMTForScheduleHour((int)(Calendar.getInstance().get(7) - 1), (int)endHour, (int)endMinute, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (Calendar)Utility.getCalendarInstance());
                startHourForPattern = Utility.convertHourFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                startMinute = startCal.get(12);
                startMinuteForPattern = startMinute;
                endHourForPattern = Utility.convertHourFrom_H_Pattern((int)endCal.get(11), (String)hourPattern);
                endMinute = endCal.get(12);
                endMinuteForPattern = endMinute;
                if (hasAmpm) {
                    ampm = Utility.getAmpmFrom_H_Pattern((int)startCal.get(11), (String)hourPattern);
                }
                this.schBetweenPanel.setStartHour(startHourForPattern);
                this.schBetweenPanel.setEndHour(endHourForPattern);
                this.schBetweenPanel.setStartMinute(startMinuteForPattern);
                this.schBetweenPanel.setEndMinute(endMinuteForPattern);
                this.schBetweenPanel.enableAmpm(hasAmpm, ampm);
            }
            this.jCmbDay.setSelectedIndex(day);
        }

        private void prepare() {
            Object[] obj = new Object[]{AddPartnerWizard.this.siteName};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.youAreTryingToAdd");
            String fm = MessageFormat.format(str, obj);
            this.jTADescription.setText(fm);
        }
    }

    private static class SchBetweenPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel lableStartTime = new JLabel(resource.getString("PartnerDlg.label.starting.at"));
        private JLabel lableEndTime = new JLabel(resource.getString("PartnerDlg.label.ending.at"));
        private TimeSpinner1 startSpinner1 = new TimeSpinner1(timePattern);
        private TimeSpinner1 endSpinner1 = new TimeSpinner1(timePattern);

        public SchBetweenPanel() {
            this.setLayout(new GridBagLayout());
            AddPartnerWizard.parseTimePattern(timePattern, this.startSpinner1, this.endSpinner1);
            this.endSpinner1.setHour(23);
            this.endSpinner1.setMinute(59);
            this.add((Component)this.lableStartTime, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 57, 0, 0), 0, 0));
            this.add((Component)this.startSpinner1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 37, 0, 0), 0, 0));
            this.add((Component)this.lableEndTime, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 57, 0, 0), 0, 0));
            this.add((Component)this.endSpinner1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 37, 0, 0), 0, 0));
        }

        public Integer getStartHour() {
            return this.startSpinner1.getHour();
        }

        public Integer getStartMinute() {
            return this.startSpinner1.getMinute();
        }

        public Integer getEndHour() {
            return this.endSpinner1.getHour();
        }

        public Integer getEndMinute() {
            return this.endSpinner1.getMinute();
        }

        public void setStartHour(Integer value) {
            this.startSpinner1.setHour(value);
        }

        public void setStartMinute(Integer value) {
            this.startSpinner1.setMinute(value);
        }

        public void setEndHour(Integer value) {
            this.endSpinner1.setHour(value);
        }

        public void setEndMinute(Integer value) {
            this.endSpinner1.setMinute(value);
        }

        public void enableAmpm(boolean hasAmpm, int ampm) {
            if (hasAmpm) {
                this.startSpinner1.setAmpm(ampm);
            }
        }

        public int getAmpm() {
            return this.startSpinner1.getAmpm();
        }

        @Override
        public void setEnabled(boolean value) {
            this.startSpinner1.setEnabled(value);
            this.endSpinner1.setEnabled(value);
            this.lableStartTime.setEnabled(value);
            this.lableEndTime.setEnabled(value);
        }
    }

    private class InfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField jTFServerName = new JTextField();
        private JTextField jTFPort = new JTextField(new NumberPlainDocument(), Integer.toString(Env.getSEM_PORT()), 10);
        private JTextField jTFAdminName = new JTextField();
        private JPasswordField jTFPassword = new SEPMPasswordField();

        public InfoPanel() {
            this.initialize();
        }

        public String getServerName() {
            return this.jTFServerName.getText().trim();
        }

        public String getPort() {
            return this.jTFPort.getText().trim();
        }

        public String getAdminName() {
            return this.jTFAdminName.getText().trim();
        }

        public String getPassword() {
            return new String(this.jTFPassword.getPassword()).trim();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.title.remoteSiteInformation");
            String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.specifyTheSite");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.label.enterRemoteServerIP")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFServerName, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.label.enterRemoteSererPort")), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFPort, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.label.enterSystemADministratorName")), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(30, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.lable.name")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFAdminName, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.label.password")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFPassword, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private boolean validatePanel() {
            try {
                String port;
                String contactServer = this.jTFServerName.getText().trim();
                if (contactServer.length() == 0) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.serverNameCannotBeEmpty"));
                    this.jTFServerName.requestFocus();
                    return false;
                }
                if (Utility.isValidIpv6Address((String)contactServer)) {
                    contactServer = Utility.checkAndAddBrackets((String)contactServer);
                }
                if ((port = this.jTFPort.getText().trim()).length() == 0) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.portNumberCannotBeEmpty"));
                    this.jTFPort.requestFocus();
                    return false;
                }
                String adminName = this.jTFAdminName.getText().trim();
                if (adminName.length() == 0) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.administratorNameCannotBeEmpty"));
                    this.jTFAdminName.requestFocus();
                    return false;
                }
                String password = new String(this.jTFPassword.getPassword()).trim();
                if (password.length() == 0) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.passwordCannotBeEmpty"));
                    this.jTFPassword.requestFocus();
                    return false;
                }
                HashMap<String, Object> htData = ServerHandler.getRemoteSiteName(contactServer, port, adminName, password);
                if (htData == null) {
                    return false;
                }
                String dbVersion = (String)htData.get("dbVersion");
                System.out.println("AddPartnerWizard->InfoPanel->validatePanel: Remote dbVersion:  [" + dbVersion + "]");
                if (!Env.getDbVersion().equals(dbVersion)) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.error.dismatchDbVersionBetweenSites"));
                    return false;
                }
                if (!ScmProperties.isReplicationEnrollmentEnabled() && "True".equalsIgnoreCase(htData.get("CLOUD_ENROLLED").toString())) {
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.errmsgRemoteSiteIsCloudEnrolled"));
                    return false;
                }
                AddPartnerWizard.this.certStr = (String)htData.get("ServerCertificateStr");
                AddPartnerWizard.this.siteName = (String)htData.get("RemoteSiteName");
                if (AddPartnerWizard.this.siteName != null) {
                    Object msgStr = null;
                    if (AddPartnerWizard.this.siteName.equals(AddPartnerWizard.this.localSite.getName())) {
                        msgStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.youCannotAddThisSiteToItself");
                    } else if (AddPartnerWizard.this.siteName.equalsIgnoreCase("Remote site's semsite object doesn't exist in local site")) {
                        msgStr = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.remoteSiteObjectNotExistInLocalSite"), AddPartnerWizard.this.localSite.getName());
                    } else if (AddPartnerWizard.this.siteName.equalsIgnoreCase("Local site's semsite object doesn't exist in remote site")) {
                        msgStr = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.localSiteObjectNotExistInRemoteSite"), AddPartnerWizard.this.localSite.getName());
                    }
                    if (msgStr != null) {
                        UIUtilities.showErrorDialog((String)msgStr);
                        this.jTFServerName.requestFocus();
                        return false;
                    }
                }
                for (ReplicationPartnership remotePartnership : AddPartnerWizard.this.localSite.getReplication().getReplicationPartnerArray().getReplicationPartnership()) {
                    String remoteSiteName = remotePartnership.getPartnerSiteName();
                    if (remoteSiteName == null || !remoteSiteName.equals(AddPartnerWizard.this.siteName) || remotePartnership.getOptEnable() != null && !remotePartnership.getOptEnable().booleanValue()) continue;
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.theSite"));
                    this.jTFServerName.requestFocus();
                    return false;
                }
                if (htData.containsKey("remoteReplicationPartnerShip")) {
                    ReplicationPartnership remotePartnership = (ReplicationPartnership)htData.get("remoteReplicationPartnerShip");
                    AddPartnerWizard.this.schedulePanel.init(remotePartnership);
                    SemSite remoteSite = ServerHandler.retrieveSite(AddPartnerWizard.this.siteName);
                    System.out.println(remoteSite.getName());
                    Partner localPartner = null;
                    Vector localPartnerShips = remoteSite.getReplication().getReplicationPartnerArray().getReplicationPartnership();
                    if (localPartnerShips != null) {
                        for (ReplicationPartnership localPartnership : remoteSite.getReplication().getReplicationPartnerArray().getReplicationPartnership()) {
                            if (!localPartnership.getPartnerSiteName().equals(AddPartnerWizard.this.localSite.getName())) continue;
                            localPartner = new Partner(localPartnership, AddPartnerWizard.this.localSite.getId());
                            System.out.println("Local partner name is:" + localPartner.getName());
                        }
                    }
                    if (localPartner != null) {
                        AddPartnerWizard.this.logPanel.init(remotePartnership, localPartner.getReplicationPartnership());
                    }
                } else {
                    System.out.println("=== No local parter in the remote site " + AddPartnerWizard.this.siteName + " ===");
                }
            }
            catch (ConsoleException ex) {
                String msg = ex.getMessageString();
                if (ex.getMessageId() == 68) {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.theSMSServerYouHaveloggedIntoIs");
                } else if (ex.getMessageId() == 154) {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddPartnerWizard.msg.dismatchDbVersionOnRemoteSite");
                }
                UIUtilities.showErrorDialog(msg);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
                return false;
            }
            return true;
        }
    }
}

