/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.console.ui.util.IPv6Field;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AddIpDlg
extends DialogBase {
    private static final long serialVersionUID = 2490647819495682266L;
    private static final String SINGLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.label.single");
    private static final String GROUP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.label.groupOfComputers");
    private static final String ERROR_IP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.errorIP");
    private static final String ERROR_SUBNET = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.errorSubnet");
    private static final String[] IP_VERSIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.combo.Ipv4Text"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.combo.Ipv6Text")};
    private IPField subnetFieldIpv4;
    private IPv6Field subnetFieldIpv6;
    private IPField ipField;
    private IPField ipFieldWithSubnet = new IPField();
    private IPv6Field ipv6Field;
    private IPv6Field ipv6FieldWithSubnet = new IPv6Field(false);
    private JRadioButton jRBSingle = new JRadioButton(SINGLE, true);
    private JRadioButton jRBGroup = new JRadioButton(GROUP);
    private Set<String> addresses;
    private String oldAddress;
    private JPanel displayPanel;
    private CardLayout displayPanelLayout;
    private JComboBox<String> ipVerCombo;
    private static int ID_IP_TYPE_V4 = 0;
    private JPanel comboPanel = null;
    private static final String ID_IPv4FIELDONLY = "ID_IPv4FIELDONLY";
    private static final String ID_IPv6FIELDONLY = "ID_IPv6FIELDONLY";
    private static final String ID_IPv4PANELWITHSUBNET = "ID_IPv4PANELWITHSUBNET";
    private static final String ID_IPv6PANELWITHSUBNET = "ID_IPv6PANELWITHSUBNET";
    private static final String IPv4_TEXT = "IPv4";
    private static final String IPv6_TEXT = "IPv6";
    private static final String IPv6_DELIMETER = ":";
    private String description;
    private static final int DEFAULT_IPV6_TEXTFIELD_WIDTH = 280;
    private static final int DEFAULT_TEXTFIELD_HEIGHT = 28;

    public AddIpDlg(String title, String ipAddress, String description, Set<String> addr) {
        super(Manager.getFrame(), title, true);
        this.description = description;
        this.initialize();
        this.setIP(ipAddress);
        UiUtilities.centerComponent((Component)this);
        this.addresses = addr;
        this.oldAddress = ipAddress;
        this.setVisible(true);
    }

    public String getIP() {
        String ipType = (String)this.ipVerCombo.getSelectedItem();
        boolean isGroupSelected = this.jRBGroup.isSelected();
        Object addr = null;
        if (ipType.equals(IPv4_TEXT) && !isGroupSelected) {
            addr = this.ipField.getText();
        } else if (ipType.equals(IPv4_TEXT) && isGroupSelected) {
            addr = this.ipFieldWithSubnet.getText() + "/" + this.subnetFieldIpv4.getText();
        } else if (ipType.equals(IPv6_TEXT) && !isGroupSelected) {
            addr = this.ipv6Field.getText();
        } else if (ipType.equals(IPv6_TEXT) && isGroupSelected) {
            addr = this.ipv6FieldWithSubnet.getText() + "/" + this.subnetFieldIpv6.getText();
        }
        return addr;
    }

    @Override
    protected boolean isValidate() {
        String ipType = (String)this.ipVerCombo.getSelectedItem();
        boolean isGroupSelected = this.jRBGroup.isSelected();
        boolean isValidSubnet = true;
        boolean isValidIP = true;
        switch (ipType) {
            case "IPv4": {
                if (isGroupSelected) {
                    isValidIP = this.ipFieldWithSubnet.isValid();
                    isValidSubnet = this.subnetFieldIpv4.isValid();
                } else {
                    isValidIP = this.ipField.isValid();
                }
                if (isValidIP && isValidSubnet) break;
                JOptionPane.showMessageDialog(this, isGroupSelected ? ERROR_SUBNET : ERROR_IP, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.error"), 0);
                return false;
            }
            case "IPv6": {
                if (isGroupSelected) {
                    isValidIP = this.ipv6FieldWithSubnet.isValidValue();
                    isValidSubnet = this.subnetFieldIpv6.isValidValue();
                } else {
                    isValidIP = this.ipv6Field.isValidValue();
                }
                if (isValidIP && isValidSubnet) break;
                JOptionPane.showMessageDialog(this, isGroupSelected ? ERROR_SUBNET : ERROR_IP, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.error"), 0);
                return false;
            }
        }
        String addr = this.getIP();
        if (this.isDuplicate(addr)) {
            String msg = "<html>" + MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.duplicateAddress"), "<b>" + addr + "</b>") + "</html>";
            JOptionPane.showMessageDialog(this, msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.msg.error"), 0);
            return false;
        }
        return isValidIP && isValidSubnet;
    }

    private boolean isDuplicate(String address) {
        boolean ret = false;
        if (null != this.addresses && !address.equals(this.oldAddress)) {
            ret = this.addresses.contains(Utility.getDecompressedIpv6Addr((String)address));
        }
        return ret;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_server_properties_general_add_ip";
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)this.getTypePanel(), "North");
        this.getContentPane().add((Component)this.getFieldPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.updateDisplay();
        this.setListener();
        this.pack();
    }

    private JPanel getTypePanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBSingle);
        group.add(this.jRBGroup);
        JPanel panel = new JPanel(new VerticalFlowLayout(3, 3));
        panel.add(new JLabel(this.description));
        this.ipVerCombo = new JComboBox<String>(IP_VERSIONS);
        this.ipVerCombo.setSelectedIndex(ID_IP_TYPE_V4);
        this.ipVerCombo.setVisible(true);
        JLabel typeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.label.address.type"));
        this.comboPanel = new JPanel(new GridBagLayout());
        this.comboPanel.add((Component)typeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.comboPanel.add(this.ipVerCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 88, 0, 0), 0, 0));
        panel.add(this.jRBSingle);
        panel.add(this.jRBGroup);
        panel.add(this.comboPanel);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getFieldPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.add(this.getDisplayPanel());
        return panel;
    }

    private void setIP(String ip) {
        if (ip != null) {
            if (ip.contains(IPv6_DELIMETER)) {
                this.ipVerCombo.setSelectedItem(IPv6_TEXT);
            } else {
                this.ipVerCombo.setSelectedItem(IPv4_TEXT);
            }
            String ipType = (String)this.ipVerCombo.getSelectedItem();
            try {
                switch (ipType) {
                    case "IPv4": {
                        if (ip.indexOf(47) == -1) {
                            this.ipField.setText(ip);
                            this.jRBSingle.setSelected(true);
                            break;
                        }
                        String ipPart = ip.substring(0, ip.indexOf(47)).trim();
                        String maskPart = ip.substring(ip.indexOf(47) + 1).trim();
                        this.ipFieldWithSubnet.setText(ipPart);
                        this.subnetFieldIpv4.setText(maskPart);
                        this.jRBGroup.setSelected(true);
                        break;
                    }
                    case "IPv6": {
                        if (ip.indexOf(47) == -1) {
                            this.ipv6Field.setText(ip);
                            this.jRBSingle.setSelected(true);
                            break;
                        }
                        String ipPart = ip.substring(0, ip.indexOf(47)).trim();
                        String maskPart = ip.substring(ip.indexOf(47) + 1).trim();
                        this.ipv6FieldWithSubnet.setText(ipPart);
                        this.subnetFieldIpv6.setText(maskPart);
                        this.jRBGroup.setSelected(true);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("AddIpDlg->setIP():Invalid value");
            }
        }
        this.updateDisplay();
    }

    private JPanel getDisplayPanel() {
        if (this.displayPanel == null) {
            this.displayPanel = new JPanel();
            this.displayPanelLayout = new CardLayout();
            this.displayPanel.setLayout(this.displayPanelLayout);
            this.displayPanel.add((Component)this.getPanelWithIpFieldOnly(false, false), ID_IPv4FIELDONLY);
            this.displayPanel.add((Component)this.getPanelWithSubnet(false), ID_IPv4PANELWITHSUBNET);
            this.displayPanel.add((Component)this.getPanelWithIpFieldOnly(true, false), ID_IPv6FIELDONLY);
            this.displayPanel.add((Component)this.getPanelWithSubnet(true), ID_IPv6PANELWITHSUBNET);
        }
        return this.displayPanel;
    }

    private void updateDisplay() {
        String ipType = (String)this.ipVerCombo.getSelectedItem();
        boolean isGroupSelected = this.jRBGroup.isSelected();
        if (ipType.equals(IPv4_TEXT) && !isGroupSelected) {
            this.displayPanelLayout.show(this.displayPanel, ID_IPv4FIELDONLY);
        } else if (ipType.equals(IPv4_TEXT) && isGroupSelected) {
            this.displayPanelLayout.show(this.displayPanel, ID_IPv4PANELWITHSUBNET);
        } else if (ipType.equals(IPv6_TEXT) && !isGroupSelected) {
            this.displayPanelLayout.show(this.displayPanel, ID_IPv6FIELDONLY);
        } else if (ipType.equals(IPv6_TEXT) && isGroupSelected) {
            this.displayPanelLayout.show(this.displayPanel, ID_IPv6PANELWITHSUBNET);
        }
    }

    private JPanel getPanelWithIpFieldOnly(boolean isIpv6, boolean isGroupSelected) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        ipPanel.add((Component)centerPanel, "Center");
        JPanel labelPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.label.ipAddress"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        labelPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 7, 0, 0), 0, 0));
        centerPanel.add((Component)labelPanel, "West");
        JPanel fieldPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)fieldPanel, "Center");
        if (isIpv6) {
            if (isGroupSelected) {
                this.ipv6FieldWithSubnet.setPreferredSize(new Dimension(280, 28));
                this.ipv6FieldWithSubnet.setMinimumSize(new Dimension(280, 28));
                fieldPanel.add((Component)this.ipv6FieldWithSubnet, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 9, 0, 0), 0, 0));
            } else {
                this.ipv6Field = new IPv6Field(false);
                this.ipv6Field.setPreferredSize(new Dimension(280, 28));
                this.ipv6Field.setMinimumSize(new Dimension(280, 28));
                fieldPanel.add((Component)this.ipv6Field, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 9, 0, 0), 0, 0));
            }
        } else if (isGroupSelected) {
            this.ipFieldWithSubnet.setPreferredSize(new Dimension(280, 28));
            this.ipFieldWithSubnet.setMinimumSize(new Dimension(280, 28));
            fieldPanel.add((Component)this.ipFieldWithSubnet, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 9, 0, 0), 0, 0));
        } else {
            this.ipField = new IPField();
            this.ipField.setPreferredSize(new Dimension(280, 28));
            this.ipField.setMinimumSize(new Dimension(280, 28));
            fieldPanel.add((Component)this.ipField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 9, 0, 0), 0, 0));
        }
        return panel;
    }

    private JPanel getPanelWithSubnet(boolean isIpv6) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        ipPanel.add((Component)centerPanel, "Center");
        JPanel labelPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "AddIpDlg.label.subnetMask"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        labelPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        centerPanel.add((Component)labelPanel, "West");
        JPanel fieldPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)fieldPanel, "Center");
        JPanel mainPanel = new JPanel(new VerticalFlowLayout(2, 2));
        mainPanel.add(this.getPanelWithIpFieldOnly(isIpv6, true));
        if (isIpv6) {
            this.subnetFieldIpv6 = new IPv6Field(false);
            this.subnetFieldIpv6.setPreferredSize(new Dimension(280, 28));
            this.subnetFieldIpv6.setMinimumSize(new Dimension(280, 28));
            fieldPanel.add((Component)this.subnetFieldIpv6, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.subnetFieldIpv4 = new IPField();
            this.subnetFieldIpv4.setPreferredSize(new Dimension(280, 28));
            this.subnetFieldIpv4.setMinimumSize(new Dimension(280, 28));
            fieldPanel.add((Component)this.subnetFieldIpv4, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        mainPanel.add(panel);
        return mainPanel;
    }

    private void setListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AddIpDlg.this.updateDisplay();
            }
        };
        this.jRBGroup.addActionListener(actionListener);
        this.jRBSingle.addActionListener(actionListener);
        this.ipVerCombo.addActionListener(actionListener);
    }
}

