/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.acl.SitePermission;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.lu.LuDownloadStatusDlg;
import com.sygate.scm.console.ui.server.ServerBasePanel;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class SiteStatusPanel
extends ServerBasePanel {
    private static final long serialVersionUID = -365758370349528410L;
    private static final int ADD_REPL_PARTER = 1;
    private static final int DEL_RMT_SITE = 2;
    private static final int EDIT_SITE = 3;
    private static final int CONFIG_EXT_LOG = 4;
    private static final int RUN_LIVEUPDATE = 5;
    private static final int SHOW_LIVEUPDATE_STATUS = 6;
    private static final int SHOW_LIVEUPDATE_LATEST = 8;
    private static final String AUTOMATION_TASK_ADD_REPL_PARTER = "ADD_REPL_PARTER";
    private static final String AUTOMATION_TASK_DEL_RMT_SITE = "DEL_RMT_SITE";
    private static final String AUTOMATION_TASK_EDIT_SITE = "EDIT_SITE";
    private static final String AUTOMATION_TASK_CONFIG_EXT_LOG = "CONFIG_EXT_LOG";
    private static final String AUTOMATION_TASK_RUN_LIVEUPDATE = "RUN_LIVEUPDATE";
    private static final String AUTOMATION_TASK_SHOW_LIVEUPDATE_STATUS = "SHOW_LIVEUPDATE_STATUS";
    private static final String AUTOMATION_TASK_SHOW_LIVEUPDATE_LATEST = "SHOW_LIVEUPDATE_LATEST";

    public SiteStatusPanel(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        ServersPanel serverPanel = this.getServerPanel();
        switch (taskIndex) {
            case 1: {
                serverPanel.addPartner();
                break;
            }
            case 2: {
                serverPanel.deleteSite();
                break;
            }
            case 3: {
                serverPanel.editSite();
                break;
            }
            case 4: {
                serverPanel.editExternalLogging();
                break;
            }
            case 5: {
                serverPanel.downloadLuContents();
                break;
            }
            case 6: {
                LuDownloadStatusDlg.setOnlyShowLUStatusButtonPressed(true);
                serverPanel.showLUStatus();
                break;
            }
            case 8: {
                serverPanel.showLULatestDownload();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    protected String getPanelName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.title.SiteMgmt");
    }

    @Override
    protected String getLeftTableContent(Object item) {
        URL action = ConsoleMain.actionURL;
        URL wizard = ConsoleMain.wizardURL;
        SiteObject site = (SiteObject)item;
        StringBuffer buffer = new StringBuffer("<TR><TD>" + HTMLUtilities.img((URL)wizard) + "<A href='http://localhost/a.html#ADD'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.AddReplPartner") + "</A></TD></TR>");
        if (!Manager.isLocalSite(site.getId())) {
            buffer.append("<TR><TD>" + HTMLUtilities.img((URL)action) + "<A href='http://localhost/a.html#DEL'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.DelRemoteSite") + "</A></TD></TR>");
        }
        buffer.append("<TR><TD>" + HTMLUtilities.img((URL)action) + "<A href='http://localhost/a.html#PROP'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.EditSiteProps") + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)action) + "<A href='http://localhost/a.html#EXTERNALLOGGING'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.ConfigExtLog") + "</A></TD></TR>");
        return buffer.toString();
    }

    @Override
    protected String getRightTableContent(Object item) {
        SiteObject site = (SiteObject)item;
        return this.trWithBackground() + "\t\t<TD width='" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.PanelTableWidth") + "'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.SiteName") + "</TD>\t\t<TD>" + HTMLUtilities.filter((String)site.getName()) + "</TD> </TR><TR>\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.SiteDesc") + "</TD>\t\t<TD>" + HTMLUtilities.filterAndConvertNewLines((String)site.getDescription()) + "</TD></TR>" + this.trWithBackground() + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.ReplSiteCount") + "</TD><TD>" + site.getPartnerCount() + "</TD></TR><TR>\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.CreationTime") + "</TD>\t\t<TD>" + Utility.getLongDateTimeString((long)site.getSemSite().getCreationTime(), null) + "</TD></TR>";
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        ServersPanel serverPanel = this.getServerPanel(e);
        if (serverPanel != null) {
            if ("ADD".equals(e.getURL().getRef())) {
                serverPanel.addPartner();
            } else if ("DEL".equals(e.getURL().getRef())) {
                serverPanel.deleteSite();
            } else if ("PROP".equals(e.getURL().getRef())) {
                serverPanel.editSite();
            } else if ("EXTERNALLOGGING".equals(e.getURL().getRef())) {
                serverPanel.editExternalLogging();
            }
        }
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_site";
    }

    @Override
    protected List<TaskObject> getRealTaskList(TreeItem item) {
        SiteObject siteItem = (SiteObject)item;
        SemSite site = siteItem.getSemSite();
        ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
        firstList.add(this.readOnly ? SiteTask.TASK_VIEW_LOCAL_SITE.getTaskObject() : SiteTask.TASK_EDIT_LOCAL_SITE.getTaskObject());
        firstList.add(this.readOnly ? SiteTask.TASK_VIEW_EXT_LOGGING.getTaskObject() : SiteTask.TASK_CONFIG_EXT_LOGGING.getTaskObject());
        this.addTaskDeleteRemoteSite(firstList, site);
        this.addTaskAddReplicationPartner(firstList, site);
        this.addTaskRunLU(firstList, site);
        this.addTaskShowLUStatus(firstList, site);
        this.addTaskShowLUDownloads(firstList, site);
        return firstList;
    }

    void addTaskDeleteRemoteSite(List<TaskObject> firstList, SemSite site) {
        if (!(this.readOnly || Manager.isLocalSite(site.getId()) || firstList.contains(SiteTask.TASK_DELETE_REMOTE_SITE.getTaskObject()))) {
            firstList.add(1, SiteTask.TASK_DELETE_REMOTE_SITE.getTaskObject());
        }
    }

    void addTaskAddReplicationPartner(List<TaskObject> firstList, SemSite site) {
        if (!this.readOnly && Manager.isLocalSite(site.getId()) && !firstList.contains(SiteTask.TASK_ADD_REP_PARTNER.getTaskObject())) {
            firstList.add(SiteTask.TASK_ADD_REP_PARTNER.getTaskObject());
        }
    }

    void addTaskRunLU(List<TaskObject> firstList, SemSite site) {
        if (!this.readOnly && Manager.isLocalSite(site.getId()) && this.checkSitePermission(site) && !firstList.contains(SiteTask.TASK_DOWNLOAD_LU_CONTENT.getTaskObject())) {
            firstList.add(SiteTask.TASK_DOWNLOAD_LU_CONTENT.getTaskObject());
        }
    }

    void addTaskShowLUStatus(List<TaskObject> firstList, SemSite site) {
        if (Manager.isLocalSite(site.getId()) && this.checkSitePermission(site) && !firstList.contains(SiteTask.TASK_SHOW_LU_STATUS.getTaskObject())) {
            firstList.add(SiteTask.TASK_SHOW_LU_STATUS.getTaskObject());
        }
    }

    void addTaskShowLUDownloads(List<TaskObject> firstList, SemSite site) {
        if (Manager.isLocalSite(site.getId()) && this.checkSitePermission(site) && !firstList.contains(SiteTask.TASK_SHOW_LU_DOWNLOADS.getTaskObject())) {
            firstList.add(SiteTask.TASK_SHOW_LU_DOWNLOADS.getTaskObject());
        }
    }

    boolean checkSitePermission(SemSite site) {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return manager.checkPermission(context, (Permission)new SitePermission(site, BasicPermission.AccessAction.FULL_ACCESS));
    }

    private static enum SiteTask {
        TASK_ADD_REP_PARTNER("SiteStatusPanel.html.AddReplPartner", "addReplicationPartner.png", 1, "ADD_REPL_PARTER"),
        TASK_EDIT_LOCAL_SITE("SiteStatusPanel.html.EditSiteProps", "edit.png", 3, "EDIT_SITE"),
        TASK_VIEW_LOCAL_SITE("SiteStatusPanel.html.ViewSiteProps", "edit.png", 3, "EDIT_SITE"),
        TASK_DELETE_REMOTE_SITE("SiteStatusPanel.html.DelRemoteSite", "delete.png", 2, "DEL_RMT_SITE"),
        TASK_CONFIG_EXT_LOGGING("SiteStatusPanel.html.ConfigExtLog", "config.png", 4, "CONFIG_EXT_LOG"),
        TASK_VIEW_EXT_LOGGING("SiteStatusPanel.html.ViewExtLog", "config.png", 4, "CONFIG_EXT_LOG"),
        TASK_DOWNLOAD_LU_CONTENT("SiteStatusPanel.html.RunLiveUpdate", "Policy_LiveUpdate_16b.png", 5, "RUN_LIVEUPDATE"),
        TASK_SHOW_LU_STATUS("SiteStatusPanel.html.ShowLiveUpdateStatus", "Policy_LiveUpdate_16b.png", 6, "SHOW_LIVEUPDATE_STATUS"),
        TASK_SHOW_LU_DOWNLOADS("SiteStatusPanel.html.ShowLiveUpdateLatestDownload", "Policy_LiveUpdate_16b.png", 8, "SHOW_LIVEUPDATE_LATEST");

        private transient TaskObject taskObject;
        private String titleResourceKey;
        private String iconFileName;
        private int index;
        private boolean isSiteCloudEnrolled;
        private String automationLabel;

        private SiteTask(String titleResourceKey, String iconFileName, int index, String automationLabel) {
            this.titleResourceKey = titleResourceKey;
            this.iconFileName = iconFileName;
            this.index = index;
            this.automationLabel = automationLabel;
            this.isSiteCloudEnrolled = false;
            if (index == 1) {
                this.isSiteCloudEnrolled = CloudUtil.isAnyDomainCloudEnrolled();
            }
            this.updateTaskObject();
        }

        private void updateTaskObject() {
            this.taskObject = !ScmProperties.isReplicationEnrollmentEnabled() && this.isSiteCloudEnrolled ? new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", this.titleResourceKey), this.index, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(this.iconFileName))), null, null, false, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.errMsgCloudEnrolledDomain"), this.automationLabel) : new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", this.titleResourceKey), this.index, (Icon)new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(this.iconFileName))), this.automationLabel);
        }

        TaskObject getTaskObject() {
            boolean isSiteCloudEnrolled;
            if (this.index == 1 && (isSiteCloudEnrolled = CloudUtil.isAnyDomainCloudEnrolled()) != this.isSiteCloudEnrolled) {
                this.isSiteCloudEnrolled = isSiteCloudEnrolled;
                this.updateTaskObject();
            }
            return this.taskObject;
        }
    }
}

